/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.hadoop.stream;

import cascading.CascadingException;
import cascading.flow.FlowProcess;
import cascading.flow.SliceCounters;
import cascading.flow.hadoop.HadoopCoGroupClosure;
import cascading.flow.hadoop.stream.HadoopGroupGate;
import cascading.flow.stream.Duct;
import cascading.flow.stream.DuctException;
import cascading.flow.stream.SpliceGate;
import cascading.flow.stream.StreamGraph;
import cascading.pipe.CoGroup;
import cascading.pipe.Splice;
import cascading.tuple.Tuple;
import cascading.tuple.TupleEntry;
import cascading.tuple.io.IndexTuple;
import cascading.tuple.io.TuplePair;
import java.util.IdentityHashMap;
import java.util.Map;

public class HadoopCoGroupGate
extends HadoopGroupGate {
    private final Map<Duct, Integer> posMap = new IdentityHashMap<Duct, Integer>();

    public HadoopCoGroupGate(FlowProcess flowProcess, CoGroup coGroup, SpliceGate.Role role) {
        super(flowProcess, (Splice)coGroup, role);
    }

    @Override
    public void bind(StreamGraph streamGraph) {
        super.bind(streamGraph);
        if (this.role == SpliceGate.Role.sink) {
            this.orderDucts(streamGraph);
        }
    }

    @Override
    public void prepare() {
        super.prepare();
        if (this.role != SpliceGate.Role.sink) {
            this.closure = new HadoopCoGroupClosure(this.flowProcess, this.splice.getNumSelfJoins(), this.keyFields, this.valuesFields);
        } else {
            this.makePosMap(this.posMap);
        }
    }

    public void receive(Duct previous, TupleEntry incomingEntry) {
        Integer pos = this.posMap.get(previous);
        Tuple groupTuple = this.keyBuilder[pos].makeResult(incomingEntry.getTuple(), null);
        Tuple sortTuple = this.sortFields == null ? null : this.sortBuilder[pos].makeResult(incomingEntry.getTuple(), null);
        Tuple valuesTuple = this.valuesBuilder[pos].makeResult(incomingEntry.getTuple(), null);
        Tuple groupKey = sortTuple == null ? groupTuple : new TuplePair(groupTuple, sortTuple);
        try {
            this.collector.collect((Object)new IndexTuple(pos.intValue(), groupKey), (Object)new IndexTuple(pos.intValue(), valuesTuple));
            this.flowProcess.increment((Enum)SliceCounters.Tuples_Written, 1L);
        }
        catch (OutOfMemoryError error) {
            this.handleReThrowableException("out of memory, try increasing task memory allocation", error);
        }
        catch (CascadingException exception) {
            this.handleException(exception, incomingEntry);
        }
        catch (Throwable throwable) {
            this.handleException((Throwable)new DuctException("internal error: " + incomingEntry.getTuple().print(), throwable), incomingEntry);
        }
    }

    @Override
    protected Tuple unwrapGrouping(Tuple key) {
        return ((IndexTuple)key).getTuple();
    }
}

