/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.hadoop.planner;

import cascading.flow.FlowStep;
import cascading.flow.hadoop.HadoopFlowStep;
import cascading.flow.planner.BaseFlowStep;
import cascading.flow.planner.FlowStepJob;
import cascading.management.state.ClientState;
import cascading.stats.FlowStepStats;
import cascading.stats.hadoop.HadoopStepStats;
import java.io.IOException;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.mapred.TaskCompletionEvent;

public class HadoopFlowStepJob
extends FlowStepJob<JobConf> {
    private final JobConf currentConf;
    private JobClient jobClient;
    private RunningJob runningJob;

    private static long getStoreInterval(JobConf jobConf) {
        return jobConf.getLong("cascading.stats.store.interval", 60000L);
    }

    public static long getJobPollingInterval(JobConf jobConf) {
        return jobConf.getLong("cascading.flow.job.pollinginterval", 5000L);
    }

    public HadoopFlowStepJob(ClientState clientState, BaseFlowStep flowStep, JobConf currentConf) {
        super(clientState, flowStep, HadoopFlowStepJob.getJobPollingInterval(currentConf), HadoopFlowStepJob.getStoreInterval(currentConf));
        this.currentConf = currentConf;
        if (flowStep.isDebugEnabled()) {
            flowStep.logDebug("using polling interval: " + this.pollingInterval);
        }
    }

    public JobConf getConfig() {
        return this.currentConf;
    }

    protected FlowStepStats createStepStats(ClientState clientState) {
        return new HadoopStepStats((FlowStep)this.flowStep, clientState){

            @Override
            public JobClient getJobClient() {
                return HadoopFlowStepJob.this.jobClient;
            }

            @Override
            public RunningJob getRunningJob() {
                return HadoopFlowStepJob.this.runningJob;
            }
        };
    }

    protected void internalBlockOnStop() throws IOException {
        if (this.runningJob != null) {
            this.runningJob.killJob();
        }
    }

    protected void internalNonBlockingStart() throws IOException {
        this.jobClient = new JobClient(this.currentConf);
        this.runningJob = this.jobClient.submitJob(this.currentConf);
        this.flowStep.logInfo("submitted hadoop job: " + this.runningJob.getID());
    }

    protected boolean internalNonBlockingIsSuccessful() throws IOException {
        return this.runningJob != null && this.runningJob.isSuccessful();
    }

    protected boolean isRemoteExecution() {
        return !((HadoopFlowStep)this.flowStep).isHadoopLocalMode(this.getConfig());
    }

    protected Throwable getThrowable() {
        return null;
    }

    protected String internalJobId() {
        return this.runningJob.getJobID();
    }

    protected boolean internalNonBlockingIsComplete() throws IOException {
        return this.runningJob.isComplete();
    }

    protected void dumpDebugInfo() {
        try {
            if (this.runningJob == null) {
                return;
            }
            TaskCompletionEvent[] events = this.runningJob.getTaskCompletionEvents(0);
            this.flowStep.logWarn("task completion events identify failed tasks");
            this.flowStep.logWarn("task completion events count: " + events.length);
            for (TaskCompletionEvent event : events) {
                this.flowStep.logWarn("event = " + event);
            }
        }
        catch (IOException exception) {
            this.flowStep.logError("failed reading task completion events", (Throwable)exception);
        }
    }

    protected boolean internalIsStarted() {
        if (this.runningJob == null) {
            return false;
        }
        try {
            return this.runningJob.mapProgress() > 0.0f;
        }
        catch (IOException exception) {
            this.flowStep.logWarn("unable to test for map progress", (Throwable)exception);
            return false;
        }
    }
}

