/*
 * Decompiled with CFR 0.152.
 */
package cascading.flow.hadoop;

import cascading.flow.hadoop.HadoopFlow;
import cascading.flow.hadoop.MapReduceFlowStep;
import cascading.flow.hadoop.planner.HadoopStepGraph;
import cascading.flow.hadoop.util.HadoopUtil;
import cascading.flow.planner.FlowStepGraph;
import cascading.scheme.NullScheme;
import cascading.scheme.Scheme;
import cascading.tap.Tap;
import cascading.tap.hadoop.Hfs;
import java.beans.ConstructorProperties;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileOutputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.RecordReader;

public class MapReduceFlow
extends HadoopFlow {
    protected boolean deleteSinkOnInit = false;

    @ConstructorProperties(value={"jobConf"})
    public MapReduceFlow(JobConf jobConf) {
        this(jobConf.getJobName(), jobConf, false);
    }

    @ConstructorProperties(value={"jobConf", "deleteSinkOnInit"})
    public MapReduceFlow(JobConf jobConf, boolean deleteSinkOnInit) {
        this(jobConf.getJobName(), jobConf, deleteSinkOnInit);
    }

    @ConstructorProperties(value={"name", "jobConf"})
    public MapReduceFlow(String name, JobConf jobConf) {
        this(name, jobConf, false);
    }

    @ConstructorProperties(value={"name", "jobConf", "deleteSinkOnInit"})
    public MapReduceFlow(String name, JobConf jobConf, boolean deleteSinkOnInit) {
        this(name, jobConf, deleteSinkOnInit, true);
    }

    @ConstructorProperties(value={"name", "jobConf", "deleteSinkOnInit", "stopJobsOnExit"})
    public MapReduceFlow(String name, JobConf jobConf, boolean deleteSinkOnInit, boolean stopJobsOnExit) {
        super(HadoopUtil.getPlatformInfo(), (Map<Object, Object>)new Properties(), jobConf, name);
        this.deleteSinkOnInit = deleteSinkOnInit;
        this.stopJobsOnExit = stopJobsOnExit;
        this.setSources(this.createSources(jobConf));
        this.setSinks(this.createSinks(jobConf));
        this.setTraps(this.createTraps(jobConf));
        this.setFlowStepGraph(this.makeStepGraph(jobConf));
        this.initSteps();
        this.initializeNewJobsMap();
    }

    private FlowStepGraph makeStepGraph(JobConf jobConf) {
        HadoopStepGraph flowStepGraph = new HadoopStepGraph();
        Tap sink = (Tap)this.getSinksCollection().iterator().next();
        MapReduceFlowStep step = new MapReduceFlowStep(this.getName(), sink.toString(), jobConf, sink);
        flowStepGraph.addVertex((Object)step);
        return flowStepGraph;
    }

    protected Map<String, Tap> createSources(JobConf jobConf) {
        Path[] paths = FileInputFormat.getInputPaths((JobConf)jobConf);
        HashMap<String, Tap> taps = new HashMap<String, Tap>();
        for (Path path : paths) {
            taps.put(path.toString(), new Hfs((Scheme<JobConf, RecordReader, OutputCollector, ?, ?>)new NullScheme(), path.toString()));
        }
        return taps;
    }

    protected Map<String, Tap> createSinks(JobConf jobConf) {
        HashMap<String, Tap> taps = new HashMap<String, Tap>();
        String path = FileOutputFormat.getOutputPath((JobConf)jobConf).toString();
        taps.put(path, new Hfs((Scheme<JobConf, RecordReader, OutputCollector, ?, ?>)new NullScheme(), path, this.deleteSinkOnInit));
        return taps;
    }

    protected Map<String, Tap> createTraps(JobConf jobConf) {
        return new HashMap<String, Tap>();
    }
}

