/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.encoders;

import java.util.List;
import org.apache.tapestry5.ValueEncoder;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.services.PropertyAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericValueEncoder<T>
implements ValueEncoder<T> {
    private List<T> _objectList;
    private final PropertyAccess _access;
    private String _valueFieldName = null;

    public GenericValueEncoder(List<T> objectList) {
        this(objectList, null, null);
    }

    public GenericValueEncoder(List<T> objectList, String valueFieldName, PropertyAccess propertyAccess) {
        assert (objectList != null);
        this._objectList = CollectionFactory.newList(objectList);
        this._valueFieldName = valueFieldName;
        this._access = propertyAccess;
    }

    public String toClient(T serverValue) {
        return this.getServerValueAsString(serverValue);
    }

    public T toValue(String clientValue) {
        T serverValue = null;
        for (T obj : this._objectList) {
            String value = this.getServerValueAsString(obj);
            if (!value.equals(clientValue)) continue;
            serverValue = obj;
            break;
        }
        return serverValue;
    }

    private String getServerValueAsString(T serverValue) {
        String clientValue = "";
        clientValue = this._valueFieldName != null && this._access != null ? String.valueOf(this._access.get(serverValue, this._valueFieldName)) : String.valueOf(serverValue);
        return clientValue;
    }
}

