/*
 * Decompiled with CFR 0.152.
 */
package org.chenillekit.tapestry.core.components;

import java.util.List;
import org.apache.tapestry5.ClientElement;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.annotations.AfterRender;
import org.apache.tapestry5.annotations.BeginRender;
import org.apache.tapestry5.annotations.Environmental;
import org.apache.tapestry5.annotations.Import;
import org.apache.tapestry5.annotations.Parameter;
import org.apache.tapestry5.annotations.SetupRender;
import org.apache.tapestry5.annotations.SupportsInformalParameters;
import org.apache.tapestry5.ioc.annotations.Inject;
import org.apache.tapestry5.json.JSONArray;
import org.apache.tapestry5.json.JSONObject;
import org.apache.tapestry5.services.javascript.JavaScriptSupport;
import org.chenillekit.tapestry.core.utils.XYDataItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SupportsInformalParameters
@Import(library={"../excanvas.js", "chart/flotr.debug-0.2.0-test.js", "Chart.js"})
public class Chart
implements ClientElement {
    @Parameter(value="prop:componentResources.id", defaultPrefix="literal")
    private String clientId;
    @Parameter(name="dataItems", required=false, defaultPrefix="prop")
    private List<List<XYDataItem>> dataItemsList;
    @Environmental
    private JavaScriptSupport javascriptSupport;
    @Inject
    private ComponentResources resources;
    private String assignedClientId;

    @SetupRender
    void setupRender() {
        this.assignedClientId = this.javascriptSupport.allocateClientId(this.clientId);
    }

    @BeginRender
    void beginRender(MarkupWriter writer) {
        writer.element("div", new Object[]{"id", this.getClientId()});
        this.resources.renderInformalParameters(writer);
        writer.end();
    }

    @AfterRender
    void afterRender() {
        JSONObject spec = new JSONObject();
        JSONObject config = new JSONObject();
        JSONArray dataArray = null;
        this.configure(config);
        if (this.dataItemsList != null && this.dataItemsList.size() > 0) {
            dataArray = new JSONArray();
            for (List<XYDataItem> dataItems : this.dataItemsList) {
                JSONArray data = Chart.buildDataValues(dataItems);
                dataArray.put((Object)data);
            }
        }
        if (dataArray != null) {
            spec.put("data", dataArray);
        } else if (config.has("data")) {
            spec.put("data", config.get("data"));
        } else {
            spec.put("data", (Object)new JSONArray(new Object[]{new JSONArray()}));
        }
        if (config.has("options")) {
            spec.put("options", config.get("options"));
        }
        spec.put("element", (Object)this.getClientId());
        this.javascriptSupport.addInitializerCall("ckflotrchart", spec);
    }

    private static JSONArray buildDataValues(List<XYDataItem> dataItems) {
        JSONArray data = new JSONArray();
        for (XYDataItem dataItem : dataItems) {
            data.put((Object)new JSONArray(new Object[]{dataItem.getXValue(), dataItem.getYValue()}));
        }
        return data;
    }

    protected void configure(JSONObject config) {
    }

    public String getClientId() {
        return this.assignedClientId;
    }
}

