/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.framework.test;

import java.io.File;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;
import org.checkerframework.framework.test.CompilationResult;
import org.checkerframework.framework.test.TestConfiguration;
import org.checkerframework.framework.test.TestUtilities;
import org.checkerframework.framework.test.TypecheckResult;
import org.checkerframework.framework.test.diagnostics.JavaDiagnosticReader;
import org.checkerframework.framework.test.diagnostics.TestDiagnostic;
import org.checkerframework.javacutil.PluginUtil;

public class TypecheckExecutor {
    public TypecheckResult runTest(TestConfiguration configuration) {
        CompilationResult result = this.compile(configuration);
        return this.interpretResults(configuration, result);
    }

    public CompilationResult compile(TestConfiguration configuration) {
        TestUtilities.ensureDirectoryExists(new File(configuration.getOptions().get("-d")));
        StringWriter javacOutput = new StringWriter();
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        JavaCompiler compiler = ToolProvider.getSystemJavaCompiler();
        StandardJavaFileManager fileManager = compiler.getStandardFileManager(null, null, null);
        Iterable<? extends JavaFileObject> javaFiles = fileManager.getJavaFileObjects(configuration.getTestSourceFiles().toArray(new File[0]));
        ArrayList<String> options = new ArrayList<String>();
        options.add("-processor");
        options.add(PluginUtil.join((String)",", configuration.getProcessors()));
        ArrayList<String> nonJvmOptions = new ArrayList<String>();
        for (String option : configuration.getFlatOptions()) {
            if (option.startsWith("-J-")) continue;
            nonJvmOptions.add(option);
        }
        nonJvmOptions.add("-Xmaxerrs");
        nonJvmOptions.add("100000");
        nonJvmOptions.add("-Xmaxwarns");
        nonJvmOptions.add("100000");
        options.addAll(nonJvmOptions);
        if (configuration.shouldEmitDebugInfo()) {
            System.out.println("Running test using the following invocation:");
            System.out.println("javac " + PluginUtil.join((String)" ", options) + " " + PluginUtil.join((String)" ", configuration.getTestSourceFiles()));
        }
        JavaCompiler.CompilationTask task = compiler.getTask(javacOutput, fileManager, diagnostics, options, new ArrayList<String>(), javaFiles);
        Boolean compiledWithoutError = task.call();
        javacOutput.flush();
        return new CompilationResult(compiledWithoutError, javacOutput.toString(), javaFiles, diagnostics.getDiagnostics());
    }

    public TypecheckResult interpretResults(TestConfiguration config, CompilationResult compilationResult) {
        List<TestDiagnostic> expectedDiagnostics = this.readDiagnostics(config, compilationResult);
        return TypecheckResult.fromCompilationResults(config, compilationResult, expectedDiagnostics);
    }

    protected List<TestDiagnostic> readDiagnostics(TestConfiguration config, CompilationResult compilationResult) {
        List<TestDiagnostic> expectedDiagnostics = config.getDiagnosticFiles() == null || config.getDiagnosticFiles().isEmpty() ? JavaDiagnosticReader.readExpectedDiagnosticsJfo(compilationResult.getJavaFileObjects(), true) : JavaDiagnosticReader.readDiagnosticFiles(config.getDiagnosticFiles(), true);
        return expectedDiagnostics;
    }
}

