/*
 * Decompiled with CFR 0.152.
 */
package com.github.javaparser.ast;

import com.github.javaparser.JavaParser;
import com.github.javaparser.ParseResult;
import com.github.javaparser.ParseStart;
import com.github.javaparser.Providers;
import com.github.javaparser.TokenRange;
import com.github.javaparser.ast.CompilationUnit;
import com.github.javaparser.ast.Node;
import com.github.javaparser.ast.NodeList;
import com.github.javaparser.ast.visitor.GenericVisitor;
import com.github.javaparser.ast.visitor.VoidVisitor;
import com.github.javaparser.metamodel.InternalProperty;
import com.github.javaparser.printer.PrettyPrinter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;

public class StubUnit
extends Node {
    private NodeList<CompilationUnit> compilationUnits;
    @InternalProperty
    private Storage storage;

    protected StubUnit(TokenRange tokenRange) {
        super(tokenRange);
    }

    public StubUnit(NodeList<CompilationUnit> compilationUnits) {
        super(null);
        this.compilationUnits = compilationUnits;
    }

    public List<CompilationUnit> getCompilationUnits() {
        return this.compilationUnits;
    }

    public void setCompilationUnits(NodeList<CompilationUnit> compilationUnits) {
        this.compilationUnits = compilationUnits;
    }

    public Optional<Storage> getStorage() {
        return Optional.ofNullable(this.storage);
    }

    public StubUnit setStorage(Path path) {
        this.storage = new Storage(this, path);
        return this;
    }

    @Override
    public <R, A> R accept(GenericVisitor<R, A> v, A arg) {
        return v.visit(this, arg);
    }

    @Override
    public <A> void accept(VoidVisitor<A> v, A arg) {
        v.visit(this, arg);
    }

    public static class Storage {
        private final StubUnit stubUnit;
        private final Path path;

        private Storage(StubUnit stubUnit, Path path) {
            this.stubUnit = stubUnit;
            this.path = path.toAbsolutePath();
        }

        public Path getPath() {
            return this.path;
        }

        public StubUnit getStubUnit() {
            return this.stubUnit;
        }

        public String getFileName() {
            return this.path.getFileName().toString();
        }

        public Path getDirectory() {
            return this.path.getParent();
        }

        public void save() {
            this.save(stubUnit -> new PrettyPrinter().print((Node)stubUnit));
        }

        public void save(Function<StubUnit, String> makeOutput) {
            try {
                Files.createDirectories(this.path.getParent(), new FileAttribute[0]);
                String code = makeOutput.apply(this.getStubUnit());
                Files.write(this.path, code.getBytes(Providers.UTF8), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        public ParseResult<StubUnit> reparse(JavaParser javaParser) {
            try {
                return javaParser.parse(ParseStart.STUB_UNIT, Providers.provider(this.getPath()));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }
}

