/*
 * Decompiled with CFR 0.152.
 */
package java.util.zip;

import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.SequenceInputStream;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import java.util.zip.ZipException;

public class GZIPInputStream
extends InflaterInputStream {
    protected CRC32 crc = new CRC32();
    protected boolean eos;
    private boolean closed = false;
    public static final int GZIP_MAGIC = 35615;
    private static final int FTEXT = 1;
    private static final int FHCRC = 2;
    private static final int FEXTRA = 4;
    private static final int FNAME = 8;
    private static final int FCOMMENT = 16;
    private byte[] tmpbuf = new byte[128];

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("Stream closed");
        }
    }

    public GZIPInputStream(InputStream inputStream, int n) throws IOException {
        super(inputStream, new Inflater(true), n);
        this.usesDefaultInflater = true;
        this.readHeader(inputStream);
    }

    public GZIPInputStream(InputStream inputStream) throws IOException {
        this(inputStream, 512);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int read(byte[] byArray, int n, int n2) throws IOException {
        this.ensureOpen();
        if (this.eos) {
            return -1;
        }
        int n3 = super.read(byArray, n, n2);
        if (n3 == -1) {
            if (!this.readTrailer()) return this.read(byArray, n, n2);
            this.eos = true;
            return n3;
        } else {
            this.crc.update(byArray, n, n3);
        }
        return n3;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            super.close();
            this.eos = true;
            this.closed = true;
        }
    }

    private int readHeader(InputStream inputStream) throws IOException {
        int n;
        CheckedInputStream checkedInputStream = new CheckedInputStream(inputStream, this.crc);
        this.crc.reset();
        if (this.readUShort(checkedInputStream) != 35615) {
            throw new ZipException("Not in GZIP format");
        }
        if (this.readUByte(checkedInputStream) != 8) {
            throw new ZipException("Unsupported compression method");
        }
        int n2 = this.readUByte(checkedInputStream);
        this.skipBytes(checkedInputStream, 6);
        int n3 = 10;
        if ((n2 & 4) == 4) {
            n = this.readUShort(checkedInputStream);
            this.skipBytes(checkedInputStream, n);
            n3 += n + 2;
        }
        if ((n2 & 8) == 8) {
            do {
                ++n3;
            } while (this.readUByte(checkedInputStream) != 0);
        }
        if ((n2 & 0x10) == 16) {
            do {
                ++n3;
            } while (this.readUByte(checkedInputStream) != 0);
        }
        if ((n2 & 2) == 2) {
            n = (int)this.crc.getValue() & 0xFFFF;
            if (this.readUShort(checkedInputStream) != n) {
                throw new ZipException("Corrupt GZIP header");
            }
            n3 += 2;
        }
        this.crc.reset();
        return n3;
    }

    private boolean readTrailer() throws IOException {
        InputStream inputStream = this.in;
        int n = this.inf.getRemaining();
        if (n > 0) {
            inputStream = new SequenceInputStream(new ByteArrayInputStream(this.buf, this.len - n, n), new FilterInputStream(this, inputStream){

                @Override
                public void close() throws IOException {
                }
            });
        }
        if (this.readUInt(inputStream) != this.crc.getValue() || this.readUInt(inputStream) != (this.inf.getBytesWritten() & 0xFFFFFFFFL)) {
            throw new ZipException("Corrupt GZIP trailer");
        }
        if (this.in.available() > 0 || n > 26) {
            int n2 = 8;
            try {
            }
            catch (IOException iOException) {
                return true;
            }
            this.inf.reset();
            if (n > (n2 += this.readHeader(inputStream))) {
                this.inf.setInput(this.buf, this.len - n + n2, n - n2);
            }
            return false;
        }
        return true;
    }

    private long readUInt(InputStream inputStream) throws IOException {
        long l = this.readUShort(inputStream);
        return (long)this.readUShort(inputStream) << 16 | l;
    }

    private int readUShort(InputStream inputStream) throws IOException {
        int n = this.readUByte(inputStream);
        return this.readUByte(inputStream) << 8 | n;
    }

    private int readUByte(InputStream inputStream) throws IOException {
        int n = inputStream.read();
        if (n == -1) {
            throw new EOFException();
        }
        if (n < -1 || n > 255) {
            throw new IOException(this.in.getClass().getName() + ".read() returned value out of range -1..255: " + n);
        }
        return n;
    }

    private void skipBytes(InputStream inputStream, int n) throws IOException {
        while (n > 0) {
            int n2 = inputStream.read(this.tmpbuf, 0, n < this.tmpbuf.length ? n : this.tmpbuf.length);
            if (n2 == -1) {
                throw new EOFException();
            }
            n -= n2;
        }
    }
}

