/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.Console;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.Flushable;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.Formatter;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.framework.qual.DefaultQualifier;
import sun.misc.JavaIOAccess;
import sun.misc.SharedSecrets;
import sun.nio.cs.StreamDecoder;
import sun.nio.cs.StreamEncoder;

@DefaultQualifier(value=NonNull.class)
public final class Console
implements Flushable {
    private Object readLock = new Object();
    private Object writeLock = new Object();
    private Reader reader;
    private Writer out;
    private PrintWriter pw;
    private Formatter formatter;
    private Charset cs;
    private char[] rcb;
    private static boolean echoOff;
    private static Console cons;

    public PrintWriter writer() {
        return this.pw;
    }

    public Reader reader() {
        return this.reader;
    }

    public Console format(String string, Object ... objectArray) {
        this.formatter.format(string, objectArray).flush();
        return this;
    }

    public Console printf(String string, Object ... objectArray) {
        return this.format(string, objectArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public @Nullable String readLine(String string, Object ... objectArray) {
        String string2 = null;
        Object object = this.writeLock;
        synchronized (object) {
            Object object2 = this.readLock;
            synchronized (object2) {
                if (string.length() != 0) {
                    this.pw.format(string, objectArray);
                }
                try {
                    char[] cArray = this.readline(false);
                    if (cArray != null) {
                        string2 = new String(cArray);
                    }
                }
                catch (IOException iOException) {
                    throw new IOError(iOException);
                }
            }
        }
        return string2;
    }

    public @Nullable String readLine() {
        return this.readLine("", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public char @Nullable [] readPassword(String string, Object ... objectArray) {
        char[] cArray = null;
        Object object = this.writeLock;
        synchronized (object) {
            Object object2 = this.readLock;
            synchronized (object2) {
                block21: {
                    try {
                        echoOff = Console.echo(false);
                    }
                    catch (IOException iOException) {
                        throw new IOError(iOException);
                    }
                    IOError iOError = null;
                    try {
                        if (string.length() != 0) {
                            this.pw.format(string, objectArray);
                        }
                        cArray = this.readline(true);
                    }
                    catch (IOException iOException) {
                        iOError = new IOError(iOException);
                        return iOError;
                    }
                    finally {
                        try {
                            echoOff = Console.echo(true);
                        }
                        catch (IOException iOException) {
                            if (iOError == null) {
                                iOError = new IOError(iOException);
                            }
                            iOError.addSuppressed(iOException);
                        }
                        if (iOError == null) break block21;
                        throw iOError;
                    }
                }
                this.pw.println();
            }
        }
        return cArray;
    }

    public char @Nullable [] readPassword() {
        return this.readPassword("", new Object[0]);
    }

    @Override
    public void flush() {
        this.pw.flush();
    }

    private static native String encoding();

    private static native boolean echo(boolean var0) throws IOException;

    private char[] readline(boolean bl) throws IOException {
        int n = this.reader.read(this.rcb, 0, this.rcb.length);
        if (n < 0) {
            return null;
        }
        if (this.rcb[n - 1] == '\r') {
            --n;
        } else if (this.rcb[n - 1] == '\n' && --n > 0 && this.rcb[n - 1] == '\r') {
            --n;
        }
        char[] cArray = new char[n];
        if (n > 0) {
            System.arraycopy(this.rcb, 0, cArray, 0, n);
            if (bl) {
                Arrays.fill(this.rcb, 0, n, ' ');
            }
        }
        return cArray;
    }

    private char[] grow() {
        assert (Thread.holdsLock(this.readLock));
        char[] cArray = new char[this.rcb.length * 2];
        System.arraycopy(this.rcb, 0, cArray, 0, this.rcb.length);
        this.rcb = cArray;
        return this.rcb;
    }

    private static native boolean istty();

    private Console() {
        String string = Console.encoding();
        if (string != null) {
            try {
                this.cs = Charset.forName(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.cs == null) {
            this.cs = Charset.defaultCharset();
        }
        this.out = StreamEncoder.forOutputStreamWriter((OutputStream)new FileOutputStream(FileDescriptor.out), this.writeLock, this.cs);
        this.pw = new /* Unavailable Anonymous Inner Class!! */;
        this.formatter = new Formatter(this.out);
        this.reader = new LineReader(this, (Reader)StreamDecoder.forInputStreamReader((InputStream)new FileInputStream(FileDescriptor.in), this.readLock, this.cs));
        this.rcb = new char[1024];
    }

    static /* synthetic */ Object access$000(Console console) {
        return console.readLock;
    }

    static /* synthetic */ char[] access$100(Console console) {
        return console.rcb;
    }

    static /* synthetic */ char[] access$200(Console console) {
        return console.grow();
    }

    static /* synthetic */ boolean access$300() {
        return echoOff;
    }

    static /* synthetic */ boolean access$400(boolean bl) throws IOException {
        return Console.echo(bl);
    }

    static /* synthetic */ boolean access$500() {
        return Console.istty();
    }

    static /* synthetic */ Console access$600() {
        return cons;
    }

    static /* synthetic */ Console access$602(Console console) {
        cons = console;
        return cons;
    }

    static /* synthetic */ Charset access$800(Console console) {
        return console.cs;
    }

    static {
        try {
            SharedSecrets.getJavaLangAccess().registerShutdownHook(0, false, (Runnable)((Object)new jdk.internal.access.JavaIOAccess(){

                @Override
                public Console console() {
                    return cons;
                }
            }));
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        SharedSecrets.setJavaIOAccess((JavaIOAccess)new /* Unavailable Anonymous Inner Class!! */);
    }
}

