/*
 * Decompiled with CFR 0.152.
 */
package java.util.concurrent.locks;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.AbstractQueuedSynchronizer;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.LockSupport;
import java.util.concurrent.locks.ReadWriteLock;
import jdk.internal.vm.annotation.ReservedStackAccess;
import org.checkerframework.checker.lock.qual.EnsuresLockHeld;
import org.checkerframework.checker.lock.qual.EnsuresLockHeldIf;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.checker.lock.qual.MayReleaseLocks;
import org.checkerframework.checker.lock.qual.ReleasesNoLocks;
import org.checkerframework.framework.qual.FromByteCode;

/*
 * Exception performing whole class analysis.
 */
public class ReentrantReadWriteLock
implements ReadWriteLock,
Serializable {
    private static final long serialVersionUID = -6992448646407690164L;
    private final ReadLock readerLock;
    private final WriteLock writerLock;
    final Sync sync;

    @FromByteCode
    public ReentrantReadWriteLock();

    public ReentrantReadWriteLock(boolean var1);

    @Override
    public WriteLock writeLock();

    @Override
    public ReadLock readLock();

    public final boolean isFair();

    protected Thread getOwner();

    public int getReadLockCount();

    public boolean isWriteLocked();

    public boolean isWriteLockedByCurrentThread();

    public int getWriteHoldCount();

    public int getReadHoldCount();

    protected Collection<Thread> getQueuedWriterThreads();

    protected Collection<Thread> getQueuedReaderThreads();

    public final boolean hasQueuedThreads();

    public final boolean hasQueuedThread(Thread var1);

    public final int getQueueLength();

    protected Collection<Thread> getQueuedThreads();

    public boolean hasWaiters(Condition var1);

    public int getWaitQueueLength(Condition var1);

    protected Collection<Thread> getWaitingThreads(Condition var1);

    public String toString();

    static abstract class Sync
    extends AbstractQueuedSynchronizer {
        private static final long serialVersionUID = 6317671515068378041L;
        static final int SHARED_SHIFT = 16;
        static final int SHARED_UNIT = 65536;
        static final int MAX_COUNT = 65535;
        static final int EXCLUSIVE_MASK = 65535;
        private transient ThreadLocalHoldCounter readHolds = new ThreadLocalHoldCounter();
        private transient HoldCounter cachedHoldCounter;
        private transient Thread firstReader;
        private transient int firstReaderHoldCount;

        static int sharedCount(int c) {
            return c >>> 16;
        }

        static int exclusiveCount(int c) {
            return c & 0xFFFF;
        }

        Sync() {
            this.setState(this.getState());
        }

        abstract boolean readerShouldBlock();

        abstract boolean writerShouldBlock();

        @Override
        @ReservedStackAccess
        protected final boolean tryRelease(int releases) {
            boolean free;
            if (!this.isHeldExclusively()) {
                throw new IllegalMonitorStateException();
            }
            int nextc = this.getState() - releases;
            boolean bl = free = Sync.exclusiveCount(nextc) == 0;
            if (free) {
                this.setExclusiveOwnerThread(null);
            }
            this.setState(nextc);
            return free;
        }

        @Override
        @ReservedStackAccess
        protected final boolean tryAcquire(int acquires) {
            Thread current = Thread.currentThread();
            int c = this.getState();
            int w = Sync.exclusiveCount(c);
            if (c != 0) {
                if (w == 0 || current != this.getExclusiveOwnerThread()) {
                    return false;
                }
                if (w + Sync.exclusiveCount(acquires) > 65535) {
                    throw new Error("Maximum lock count exceeded");
                }
                this.setState(c + acquires);
                return true;
            }
            if (this.writerShouldBlock() || !this.compareAndSetState(c, c + acquires)) {
                return false;
            }
            this.setExclusiveOwnerThread(current);
            return true;
        }

        @Override
        @ReservedStackAccess
        protected final boolean tryReleaseShared(int unused) {
            int nextc;
            int c;
            Thread current = Thread.currentThread();
            if (this.firstReader == current) {
                if (this.firstReaderHoldCount == 1) {
                    this.firstReader = null;
                } else {
                    --this.firstReaderHoldCount;
                }
            } else {
                int count;
                HoldCounter rh = this.cachedHoldCounter;
                if (rh == null || rh.tid != LockSupport.getThreadId(current)) {
                    rh = (HoldCounter)this.readHolds.get();
                }
                if ((count = rh.count) <= 1) {
                    this.readHolds.remove();
                    if (count <= 0) {
                        throw Sync.unmatchedUnlockException();
                    }
                }
                --rh.count;
            }
            while (!this.compareAndSetState(c = this.getState(), nextc = c - 65536)) {
            }
            return nextc == 0;
        }

        private static IllegalMonitorStateException unmatchedUnlockException() {
            return new IllegalMonitorStateException("attempt to unlock read lock, not locked by current thread");
        }

        @Override
        @ReservedStackAccess
        protected final int tryAcquireShared(int unused) {
            Thread current = Thread.currentThread();
            int c = this.getState();
            if (Sync.exclusiveCount(c) != 0 && this.getExclusiveOwnerThread() != current) {
                return -1;
            }
            int r = Sync.sharedCount(c);
            if (!this.readerShouldBlock() && r < 65535 && this.compareAndSetState(c, c + 65536)) {
                if (r == 0) {
                    this.firstReader = current;
                    this.firstReaderHoldCount = 1;
                } else if (this.firstReader == current) {
                    ++this.firstReaderHoldCount;
                } else {
                    HoldCounter rh = this.cachedHoldCounter;
                    if (rh == null || rh.tid != LockSupport.getThreadId(current)) {
                        this.cachedHoldCounter = rh = (HoldCounter)this.readHolds.get();
                    } else if (rh.count == 0) {
                        this.readHolds.set(rh);
                    }
                    ++rh.count;
                }
                return 1;
            }
            return this.fullTryAcquireShared(current);
        }

        final int fullTryAcquireShared(Thread current) {
            int c;
            HoldCounter rh = null;
            do {
                if (Sync.exclusiveCount(c = this.getState()) != 0) {
                    if (this.getExclusiveOwnerThread() != current) {
                        return -1;
                    }
                } else if (this.readerShouldBlock() && this.firstReader != current) {
                    if (rh == null && ((rh = this.cachedHoldCounter) == null || rh.tid != LockSupport.getThreadId(current))) {
                        rh = (HoldCounter)this.readHolds.get();
                        if (rh.count == 0) {
                            this.readHolds.remove();
                        }
                    }
                    if (rh.count == 0) {
                        return -1;
                    }
                }
                if (Sync.sharedCount(c) != 65535) continue;
                throw new Error("Maximum lock count exceeded");
            } while (!this.compareAndSetState(c, c + 65536));
            if (Sync.sharedCount(c) == 0) {
                this.firstReader = current;
                this.firstReaderHoldCount = 1;
            } else if (this.firstReader == current) {
                ++this.firstReaderHoldCount;
            } else {
                if (rh == null) {
                    rh = this.cachedHoldCounter;
                }
                if (rh == null || rh.tid != LockSupport.getThreadId(current)) {
                    rh = (HoldCounter)this.readHolds.get();
                } else if (rh.count == 0) {
                    this.readHolds.set(rh);
                }
                ++rh.count;
                this.cachedHoldCounter = rh;
            }
            return 1;
        }

        @ReservedStackAccess
        final boolean tryWriteLock() {
            Thread current = Thread.currentThread();
            int c = this.getState();
            if (c != 0) {
                int w = Sync.exclusiveCount(c);
                if (w == 0 || current != this.getExclusiveOwnerThread()) {
                    return false;
                }
                if (w == 65535) {
                    throw new Error("Maximum lock count exceeded");
                }
            }
            if (!this.compareAndSetState(c, c + 1)) {
                return false;
            }
            this.setExclusiveOwnerThread(current);
            return true;
        }

        @ReservedStackAccess
        final boolean tryReadLock() {
            int r;
            int c;
            Thread current = Thread.currentThread();
            do {
                if (Sync.exclusiveCount(c = this.getState()) != 0 && this.getExclusiveOwnerThread() != current) {
                    return false;
                }
                r = Sync.sharedCount(c);
                if (r != 65535) continue;
                throw new Error("Maximum lock count exceeded");
            } while (!this.compareAndSetState(c, c + 65536));
            if (r == 0) {
                this.firstReader = current;
                this.firstReaderHoldCount = 1;
            } else if (this.firstReader == current) {
                ++this.firstReaderHoldCount;
            } else {
                HoldCounter rh = this.cachedHoldCounter;
                if (rh == null || rh.tid != LockSupport.getThreadId(current)) {
                    this.cachedHoldCounter = rh = (HoldCounter)this.readHolds.get();
                } else if (rh.count == 0) {
                    this.readHolds.set(rh);
                }
                ++rh.count;
            }
            return true;
        }

        @Override
        protected final boolean isHeldExclusively() {
            return this.getExclusiveOwnerThread() == Thread.currentThread();
        }

        final AbstractQueuedSynchronizer.ConditionObject newCondition() {
            return new AbstractQueuedSynchronizer.ConditionObject(this);
        }

        final Thread getOwner() {
            return Sync.exclusiveCount(this.getState()) == 0 ? null : this.getExclusiveOwnerThread();
        }

        final int getReadLockCount() {
            return Sync.sharedCount(this.getState());
        }

        final boolean isWriteLocked() {
            return Sync.exclusiveCount(this.getState()) != 0;
        }

        final int getWriteHoldCount() {
            return this.isHeldExclusively() ? Sync.exclusiveCount(this.getState()) : 0;
        }

        final int getReadHoldCount() {
            if (this.getReadLockCount() == 0) {
                return 0;
            }
            Thread current = Thread.currentThread();
            if (this.firstReader == current) {
                return this.firstReaderHoldCount;
            }
            HoldCounter rh = this.cachedHoldCounter;
            if (rh != null && rh.tid == LockSupport.getThreadId(current)) {
                return rh.count;
            }
            int count = ((HoldCounter)this.readHolds.get()).count;
            if (count == 0) {
                this.readHolds.remove();
            }
            return count;
        }

        private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
            s.defaultReadObject();
            this.readHolds = new ThreadLocalHoldCounter();
            this.setState(0);
        }

        final int getCount() {
            return this.getState();
        }

        static final class ThreadLocalHoldCounter
        extends ThreadLocal<HoldCounter> {
            ThreadLocalHoldCounter() {
            }

            @Override
            public HoldCounter initialValue() {
                return new HoldCounter();
            }
        }

        static final class HoldCounter {
            int count;
            final long tid = LockSupport.getThreadId(Thread.currentThread());

            HoldCounter() {
            }
        }
    }

    static final class NonfairSync
    extends Sync {
        private static final long serialVersionUID = -8159625535654395037L;

        NonfairSync() {
        }

        @Override
        final boolean writerShouldBlock() {
            return false;
        }

        @Override
        final boolean readerShouldBlock() {
            return this.apparentlyFirstQueuedIsExclusive();
        }
    }

    static final class FairSync
    extends Sync {
        private static final long serialVersionUID = -2274990926593161451L;

        FairSync() {
        }

        @Override
        final boolean writerShouldBlock() {
            return this.hasQueuedPredecessors();
        }

        @Override
        final boolean readerShouldBlock() {
            return this.hasQueuedPredecessors();
        }
    }

    /*
     * Exception performing whole class analysis.
     * Exception performing whole class analysis ignored.
     */
    public static class ReadLock
    implements Lock,
    Serializable {
        private static final long serialVersionUID = -5992448646407690164L;
        private final Sync sync;

        protected ReadLock(ReentrantReadWriteLock var1);

        @Override
        @EnsuresLockHeld(value={"this"})
        @ReleasesNoLocks
        @FromByteCode
        public void lock();

        @Override
        @EnsuresLockHeld(value={"this"})
        @ReleasesNoLocks
        @FromByteCode
        public void lockInterruptibly() throws InterruptedException;

        @Override
        @EnsuresLockHeldIf(result=true, expression={"this"})
        @ReleasesNoLocks
        @FromByteCode
        public @LockPossiblyHeld @GuardedBy boolean tryLock();

        @Override
        @EnsuresLockHeldIf(result=true, expression={"this"})
        @ReleasesNoLocks
        @FromByteCode
        public @LockPossiblyHeld @GuardedBy boolean tryLock(@LockPossiblyHeld @GuardedBy long var1, @LockPossiblyHeld @GuardedBy TimeUnit var3) throws InterruptedException;

        @Override
        @MayReleaseLocks
        @FromByteCode
        public void unlock();

        @Override
        public Condition newCondition();

        public String toString();
    }

    /*
     * Exception performing whole class analysis.
     * Exception performing whole class analysis ignored.
     */
    public static class WriteLock
    implements Lock,
    Serializable {
        private static final long serialVersionUID = -4992448646407690164L;
        private final Sync sync;

        protected WriteLock(ReentrantReadWriteLock var1);

        @Override
        @EnsuresLockHeld(value={"this"})
        @ReleasesNoLocks
        @FromByteCode
        public void lock();

        @Override
        @EnsuresLockHeld(value={"this"})
        @ReleasesNoLocks
        @FromByteCode
        public void lockInterruptibly() throws InterruptedException;

        @Override
        @EnsuresLockHeldIf(expression={"this"}, result=true)
        @ReleasesNoLocks
        @FromByteCode
        public @LockPossiblyHeld @GuardedBy boolean tryLock();

        @Override
        @EnsuresLockHeldIf(expression={"this"}, result=true)
        @ReleasesNoLocks
        @FromByteCode
        public @LockPossiblyHeld @GuardedBy boolean tryLock(@LockPossiblyHeld @GuardedBy long var1, @LockPossiblyHeld @GuardedBy TimeUnit var3) throws InterruptedException;

        @Override
        @MayReleaseLocks
        @FromByteCode
        public void unlock();

        @Override
        public Condition newCondition();

        public String toString();

        @EnsuresLockHeldIf(expression={"this"}, result=true)
        @ReleasesNoLocks
        @FromByteCode
        public @LockPossiblyHeld @GuardedBy boolean isHeldByCurrentThread();

        public int getHoldCount();
    }
}

