/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Deque;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.lock.qual.GuardSatisfied;
import org.checkerframework.checker.lock.qual.GuardedBy;
import org.checkerframework.checker.lock.qual.GuardedByBottom;
import org.checkerframework.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.KeyForBottom;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.framework.qual.FromByteCode;

/*
 * Exception performing whole class analysis.
 * Exception performing whole class analysis ignored.
 */
public class ArrayDeque<@KeyForBottom E>
extends AbstractCollection<E>
implements Deque<E>,
Cloneable,
Serializable {
    private transient E[] elements;
    private transient int head;
    private transient int tail;
    private static final int MIN_INITIAL_CAPACITY = 8;
    private static final @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy long serialVersionUID = 2340985798034038923L;

    private void allocateElements(int var1);

    private void doubleCapacity();

    private <T> T[] copyElements(T[] var1);

    @FromByteCode
    @FromByteCode
    public ArrayDeque();

    @FromByteCode
    @FromByteCode
    public ArrayDeque(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int var1);

    @FromByteCode
    @FromByteCode
    public ArrayDeque(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy Collection<@KeyForBottom @NonNull @Initialized @LockPossiblyHeld @GuardedByBottom ? extends E> var1);

    @Override
    @FromByteCode
    @FromByteCode
    public void addFirst(E var1);

    @Override
    @FromByteCode
    @FromByteCode
    public void addLast(E var1);

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean offerFirst(E var1);

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean offerLast(E var1);

    @Override
    @FromByteCode
    @FromByteCode
    public E removeFirst();

    @Override
    @FromByteCode
    @FromByteCode
    public E removeLast();

    @Override
    @FromByteCode
    @FromByteCode
    public @Nullable E pollFirst();

    @Override
    @FromByteCode
    @FromByteCode
    public @Nullable E pollLast();

    @Override
    @FromByteCode
    @FromByteCode
    public E getFirst();

    @Override
    @FromByteCode
    @FromByteCode
    public E getLast();

    @Override
    @FromByteCode
    @FromByteCode
    public @Nullable E peekFirst();

    @Override
    @FromByteCode
    @FromByteCode
    public @Nullable E peekLast();

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean removeFirstOccurrence(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy Object var1);

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean removeLastOccurrence(@UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy Object var1);

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean add(E var1);

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean offer(E var1);

    @Override
    @FromByteCode
    @FromByteCode
    public E remove();

    @Override
    @FromByteCode
    @FromByteCode
    public @Nullable E poll();

    @Override
    @FromByteCode
    @FromByteCode
    public E element();

    @Override
    @FromByteCode
    @FromByteCode
    public @Nullable E peek();

    @Override
    @FromByteCode
    @FromByteCode
    public void push(E var1);

    @Override
    @FromByteCode
    @FromByteCode
    public E pop();

    private void checkInvariants();

    private boolean delete(int var1);

    @Override
    @Pure
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy int size(@GuardSatisfied ArrayDeque<E> this);

    @Override
    @EnsuresNonNullIf(result=false, expression={"peek()", "peekFirst()", "peekLast()", "poll()", "pollFirst()", "pollLast()"})
    @Pure
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean isEmpty(@GuardSatisfied ArrayDeque<E> this);

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy Iterator<E> iterator();

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy Iterator<E> descendingIterator();

    @Override
    @Pure
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean contains(@GuardSatisfied ArrayDeque<E> this, @Nullable @UnknownKeyFor @Initialized @GuardSatisfied @LockPossiblyHeld Object var1);

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy boolean remove(@Nullable @UnknownKeyFor @Initialized @LockPossiblyHeld @GuardedBy Object var1);

    @Override
    @FromByteCode
    @FromByteCode
    public void clear();

    @Override
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy Object @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy [] toArray();

    @Override
    @FromByteCode
    @FromByteCode
    public <T> @Nullable T @PolyNull @UnknownKeyFor @Initialized @LockPossiblyHeld @GuardedBy [] toArray(T @PolyNull @UnknownKeyFor @Initialized @LockPossiblyHeld @GuardedBy [] var1);

    @SideEffectFree
    @FromByteCode
    @FromByteCode
    public @UnknownKeyFor @NonNull @Initialized @LockPossiblyHeld @GuardedBy ArrayDeque<E> clone(@GuardSatisfied ArrayDeque<E> this);

    private void writeObject(ObjectOutputStream var1) throws IOException;

    private void readObject(ObjectInputStream var1) throws IOException, ClassNotFoundException;

    static;

    private class DeqIterator
    implements Iterator<E> {
        int cursor;
        int remaining;
        int lastRet;

        DeqIterator() {
            this.remaining = ArrayDeque.this.size();
            this.lastRet = -1;
            this.cursor = ArrayDeque.this.head;
        }

        @Override
        public final boolean hasNext() {
            return this.remaining > 0;
        }

        @Override
        public E next() {
            if (this.remaining <= 0) {
                throw new NoSuchElementException();
            }
            Object[] es = ArrayDeque.this.elements;
            Object e = ArrayDeque.nonNullElementAt((Object[])es, (int)this.cursor);
            this.lastRet = this.cursor;
            this.cursor = ArrayDeque.inc((int)this.lastRet, (int)es.length);
            --this.remaining;
            return e;
        }

        void postDelete(boolean leftShifted) {
            if (leftShifted) {
                this.cursor = ArrayDeque.dec((int)this.cursor, (int)ArrayDeque.this.elements.length);
            }
        }

        @Override
        public final void remove() {
            if (this.lastRet < 0) {
                throw new IllegalStateException();
            }
            this.postDelete(ArrayDeque.this.delete(this.lastRet));
            this.lastRet = -1;
        }

        public void forEachRemaining(Consumer<? super E> action) {
            int to;
            Objects.requireNonNull(action);
            int r = this.remaining;
            if (r <= 0) {
                return;
            }
            this.remaining = 0;
            Object[] es = ArrayDeque.this.elements;
            if (es[this.cursor] == null || ArrayDeque.sub((int)ArrayDeque.this.tail, (int)this.cursor, (int)es.length) != r) {
                throw new ConcurrentModificationException();
            }
            int i = this.cursor;
            int end = ArrayDeque.this.tail;
            int n = to = i <= end ? end : es.length;
            while (true) {
                if (i < to) {
                    action.accept(ArrayDeque.elementAt((Object[])es, (int)i));
                    ++i;
                    continue;
                }
                if (to == end) {
                    if (end != ArrayDeque.this.tail) {
                        throw new ConcurrentModificationException();
                    }
                    break;
                }
                i = 0;
                to = end;
            }
            this.lastRet = ArrayDeque.dec((int)end, (int)es.length);
        }
    }

    private class DescendingIterator
    extends DeqIterator {
        DescendingIterator() {
            this.cursor = ArrayDeque.dec((int)ArrayDeque.this.tail, (int)ArrayDeque.this.elements.length);
        }

        @Override
        public final E next() {
            if (this.remaining <= 0) {
                throw new NoSuchElementException();
            }
            Object[] es = ArrayDeque.this.elements;
            Object e = ArrayDeque.nonNullElementAt((Object[])es, (int)this.cursor);
            this.lastRet = this.cursor;
            this.cursor = ArrayDeque.dec((int)this.lastRet, (int)es.length);
            --this.remaining;
            return e;
        }

        @Override
        void postDelete(boolean leftShifted) {
            if (!leftShifted) {
                this.cursor = ArrayDeque.inc((int)this.cursor, (int)ArrayDeque.this.elements.length);
            }
        }

        @Override
        public final void forEachRemaining(Consumer<? super E> action) {
            int to;
            Objects.requireNonNull(action);
            int r = this.remaining;
            if (r <= 0) {
                return;
            }
            this.remaining = 0;
            Object[] es = ArrayDeque.this.elements;
            if (es[this.cursor] == null || ArrayDeque.sub((int)this.cursor, (int)ArrayDeque.this.head, (int)es.length) + 1 != r) {
                throw new ConcurrentModificationException();
            }
            int i = this.cursor;
            int end = ArrayDeque.this.head;
            int n = to = i >= end ? end : 0;
            while (true) {
                if (i > to - 1) {
                    action.accept(ArrayDeque.elementAt((Object[])es, (int)i));
                    --i;
                    continue;
                }
                if (to == end) {
                    if (end != ArrayDeque.this.head) {
                        throw new ConcurrentModificationException();
                    }
                    break;
                }
                i = es.length - 1;
                to = end;
            }
            this.lastRet = end;
        }
    }
}

