/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractQueue;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import org.checkerframework.checker.igj.qual.I;
import org.checkerframework.checker.igj.qual.Mutable;
import org.checkerframework.checker.javari.qual.PolyRead;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

/*
 * Exception performing whole class analysis.
 * Exception performing whole class analysis ignored.
 */
@I
public class PriorityQueue<E>
extends AbstractQueue<E>
implements Serializable {
    private static final long serialVersionUID = -7720805057305804111L;
    private static final int DEFAULT_INITIAL_CAPACITY = 11;
    private transient Object[] queue;
    private int size;
    private final Comparator<? super E> comparator;
    private transient int modCount;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;

    public PriorityQueue();

    public PriorityQueue(int var1);

    public PriorityQueue(int var1, @org.checkerframework.checker.igj.qual.ReadOnly Comparator<? super E> var2);

    public @PolyRead PriorityQueue(@org.checkerframework.checker.igj.qual.ReadOnly @PolyRead Collection<? extends E> var1);

    public @PolyRead PriorityQueue(@org.checkerframework.checker.igj.qual.ReadOnly @PolyRead PriorityQueue<? extends E> var1);

    public @PolyRead PriorityQueue(@org.checkerframework.checker.igj.qual.ReadOnly @PolyRead SortedSet<? extends E> var1);

    private void initFromPriorityQueue(PriorityQueue<? extends E> var1);

    private void initElementsFromCollection(Collection<? extends E> var1);

    private void initFromCollection(Collection<? extends E> var1);

    private void grow(int var1);

    private static int hugeCapacity(int var0);

    @Override
    public boolean add(@Mutable PriorityQueue<E> this, E var1);

    @Override
    public boolean offer(@Mutable PriorityQueue<E> this, E var1);

    @Override
    public @Nullable E peek(@org.checkerframework.checker.igj.qual.ReadOnly PriorityQueue<E> this);

    private int indexOf(Object var1);

    @Override
    public boolean remove(@Mutable PriorityQueue<E> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    boolean removeEq(Object var1);

    @Override
    @Pure
    public boolean contains(@org.checkerframework.checker.igj.qual.ReadOnly PriorityQueue<E> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    @Override
    public Object[] toArray(@org.checkerframework.checker.igj.qual.ReadOnly PriorityQueue<E> this);

    @Override
    public <T> @Nullable T @PolyNull [] toArray(@org.checkerframework.checker.igj.qual.ReadOnly PriorityQueue<E> this, T @PolyNull [] var1);

    @Override
    public @I @PolyRead Iterator<E> iterator(@org.checkerframework.checker.igj.qual.ReadOnly PriorityQueue<E> this);

    @Override
    @Pure
    public int size(@org.checkerframework.checker.igj.qual.ReadOnly PriorityQueue<E> this);

    @Override
    public void clear(@Mutable PriorityQueue<E> this);

    @Override
    public @Nullable E poll(@Mutable PriorityQueue<E> this);

    private E removeAt(int var1);

    private void siftUp(int var1, E var2);

    private void siftUpComparable(int var1, E var2);

    private void siftUpUsingComparator(int var1, E var2);

    private void siftDown(int var1, E var2);

    private void siftDownComparable(int var1, E var2);

    private void siftDownUsingComparator(int var1, E var2);

    private void heapify();

    @SideEffectFree
    public @org.checkerframework.checker.igj.qual.ReadOnly Comparator<? super E> comparator(@org.checkerframework.checker.igj.qual.ReadOnly PriorityQueue<E> this);

    private void writeObject(ObjectOutputStream var1) throws IOException;

    private void readObject(ObjectInputStream var1) throws IOException, ClassNotFoundException;

    static;

    private final class Itr
    implements Iterator<E> {
        private int cursor;
        private int lastRet = -1;
        private ArrayDeque<E> forgetMeNot;
        private E lastRetElt;
        private int expectedModCount;

        Itr() {
            this.expectedModCount = PriorityQueue.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor < PriorityQueue.this.size || this.forgetMeNot != null && !this.forgetMeNot.isEmpty();
        }

        @Override
        public E next() {
            if (this.expectedModCount != PriorityQueue.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.cursor < PriorityQueue.this.size) {
                this.lastRet = this.cursor++;
                return PriorityQueue.this.queue[this.lastRet];
            }
            if (this.forgetMeNot != null) {
                this.lastRet = -1;
                this.lastRetElt = this.forgetMeNot.poll();
                if (this.lastRetElt != null) {
                    return this.lastRetElt;
                }
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.expectedModCount != PriorityQueue.this.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.lastRet != -1) {
                Object moved = PriorityQueue.this.removeAt(this.lastRet);
                this.lastRet = -1;
                if (moved == null) {
                    --this.cursor;
                } else {
                    if (this.forgetMeNot == null) {
                        this.forgetMeNot = new ArrayDeque();
                    }
                    this.forgetMeNot.add(moved);
                }
            } else if (this.lastRetElt != null) {
                PriorityQueue.this.removeEq(this.lastRetElt);
                this.lastRetElt = null;
            } else {
                throw new IllegalStateException();
            }
            this.expectedModCount = PriorityQueue.this.modCount;
        }
    }
}

