/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import org.checkerframework.checker.igj.qual.I;
import org.checkerframework.checker.igj.qual.Mutable;
import org.checkerframework.checker.javari.qual.PolyRead;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.KeyFor;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

/*
 * Exception performing whole class analysis.
 */
@I
public class HashMap<K, V>
extends AbstractMap<K, V>
implements Map<K, V>,
Cloneable,
Serializable {
    static final int DEFAULT_INITIAL_CAPACITY = 16;
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final float DEFAULT_LOAD_FACTOR = 0.75f;
    transient Entry[] table;
    transient int size;
    int threshold;
    final float loadFactor;
    transient int modCount;
    private transient Set<Map.Entry<K, V>> entrySet;
    private static final long serialVersionUID = 362498820763181265L;

    public HashMap(int var1, float var2);

    public HashMap(int var1);

    public HashMap();

    public @PolyRead HashMap(@org.checkerframework.checker.igj.qual.ReadOnly @PolyRead Map<? extends K, ? extends V> var1);

    void init();

    static int hash(int var0);

    static int indexFor(int var0, int var1);

    @Override
    @Pure
    public int size(@org.checkerframework.checker.igj.qual.ReadOnly HashMap<K, V> this);

    @Override
    @Pure
    public boolean isEmpty(@org.checkerframework.checker.igj.qual.ReadOnly HashMap<K, V> this);

    @Override
    @Pure
    public @Nullable V get(@org.checkerframework.checker.igj.qual.ReadOnly HashMap<K, V> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    private V getForNullKey();

    @Override
    @Pure
    public boolean containsKey(@org.checkerframework.checker.igj.qual.ReadOnly HashMap<K, V> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    final Entry<K, V> getEntry(Object var1);

    @Override
    public @Nullable V put(@Mutable HashMap<K, V> this, K var1, V var2);

    private V putForNullKey(V var1);

    private void putForCreate(K var1, V var2);

    private void putAllForCreate(Map<? extends K, ? extends V> var1);

    void resize(int var1);

    void transfer(Entry[] var1);

    @Override
    public void putAll(@Mutable HashMap<K, V> this, @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Map<? extends K, ? extends V> var1);

    @Override
    public @Nullable V remove(@Mutable HashMap<K, V> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    final Entry<K, V> removeEntryForKey(Object var1);

    final Entry<K, V> removeMapping(Object var1);

    @Override
    public void clear(@Mutable HashMap<K, V> this);

    @Override
    @Pure
    public boolean containsValue(@org.checkerframework.checker.igj.qual.ReadOnly HashMap<K, V> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object var1);

    private boolean containsNullValue();

    @Override
    @SideEffectFree
    public @I(value="N") Object clone(@ReadOnly HashMap<K, V> this);

    void addEntry(int var1, K var2, V var3, int var4);

    void createEntry(int var1, K var2, V var3, int var4);

    Iterator<K> newKeyIterator();

    Iterator<V> newValueIterator();

    Iterator<Map.Entry<K, V>> newEntryIterator();

    @Override
    @SideEffectFree
    public @I @PolyRead Set<@KeyFor(value={"this"}) K> keySet(@org.checkerframework.checker.igj.qual.ReadOnly HashMap<K, V> this);

    @Override
    @SideEffectFree
    public @I @PolyRead Collection<V> values(@org.checkerframework.checker.igj.qual.ReadOnly HashMap<K, V> this);

    @Override
    @SideEffectFree
    public @I @PolyRead Set<@I @PolyRead Map.Entry<@KeyFor(value={"this"}) K, V>> entrySet(@org.checkerframework.checker.igj.qual.ReadOnly HashMap<K, V> this);

    private Set<Map.Entry<K, V>> entrySet0();

    private void writeObject(ObjectOutputStream var1) throws IOException;

    private void readObject(ObjectInputStream var1) throws IOException, ClassNotFoundException;

    int capacity();

    float loadFactor();

    abstract class HashIterator {
        Node<K, V> next;
        Node<K, V> current;
        int expectedModCount;
        int index;

        HashIterator() {
            this.expectedModCount = HashMap.this.modCount;
            Entry[] t = HashMap.this.table;
            this.next = null;
            this.current = null;
            this.index = 0;
            if (t != null && HashMap.this.size > 0) {
                while (this.index < t.length && (this.next = t[this.index++]) == null) {
                }
            }
        }

        public final boolean hasNext() {
            return this.next != null;
        }

        final Node<K, V> nextNode() {
            Node e = this.next;
            if (HashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (e == null) {
                throw new NoSuchElementException();
            }
            this.current = e;
            this.next = this.current.next;
            if (this.next == null) {
                Entry[] t = HashMap.this.table;
                if (HashMap.this.table != null) {
                    while (this.index < t.length && (this.next = t[this.index++]) == null) {
                    }
                }
            }
            return e;
        }

        public final void remove() {
            Node p = this.current;
            if (p == null) {
                throw new IllegalStateException();
            }
            if (HashMap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            this.current = null;
            HashMap.this.removeNode(p.hash, p.key, null, false, false);
            this.expectedModCount = HashMap.this.modCount;
        }
    }

    final class ValueIterator
    extends HashIterator
    implements Iterator<V> {
        ValueIterator(HashMap this$0) {
        }

        @Override
        public final V next() {
            return this.nextNode().value;
        }
    }

    final class KeyIterator
    extends HashIterator
    implements Iterator<K> {
        KeyIterator(HashMap this$0) {
        }

        @Override
        public final K next() {
            return this.nextNode().key;
        }
    }

    final class EntryIterator
    extends HashIterator
    implements Iterator<Map.Entry<K, V>> {
        EntryIterator(HashMap this$0) {
        }

        @Override
        public final Map.Entry<K, V> next() {
            return this.nextNode();
        }
    }

    final class KeySet
    extends AbstractSet<K> {
        KeySet() {
        }

        @Override
        public final int size() {
            return HashMap.this.size;
        }

        @Override
        public final void clear() {
            HashMap.this.clear();
        }

        @Override
        public final Iterator<K> iterator() {
            return new KeyIterator(HashMap.this);
        }

        @Override
        public final boolean contains(Object o) {
            return HashMap.this.containsKey(o);
        }

        @Override
        public final boolean remove(Object key) {
            return HashMap.this.removeNode(HashMap.hash((Object)key), key, null, false, true) != null;
        }

        public final Spliterator<K> spliterator() {
            return new KeySpliterator(HashMap.this, 0, -1, 0, 0);
        }

        @Override
        public Object[] toArray() {
            return HashMap.this.keysToArray(new Object[HashMap.this.size]);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return HashMap.this.keysToArray(HashMap.this.prepareArray(a));
        }

        public final void forEach(Consumer<? super K> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (HashMap.this.size > 0) {
                Entry[] tab = HashMap.this.table;
                if (HashMap.this.table != null) {
                    int mc = HashMap.this.modCount;
                    for (Object e : tab) {
                        while (e != null) {
                            action.accept(e.key);
                            e = e.next;
                        }
                    }
                    if (HashMap.this.modCount != mc) {
                        throw new ConcurrentModificationException();
                    }
                }
            }
        }
    }

    final class Values
    extends AbstractCollection<V> {
        Values() {
        }

        @Override
        public final int size() {
            return HashMap.this.size;
        }

        @Override
        public final void clear() {
            HashMap.this.clear();
        }

        @Override
        public final Iterator<V> iterator() {
            return new ValueIterator(HashMap.this);
        }

        @Override
        public final boolean contains(Object o) {
            return HashMap.this.containsValue(o);
        }

        public final Spliterator<V> spliterator() {
            return new ValueSpliterator(HashMap.this, 0, -1, 0, 0);
        }

        @Override
        public Object[] toArray() {
            return HashMap.this.valuesToArray(new Object[HashMap.this.size]);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return HashMap.this.valuesToArray(HashMap.this.prepareArray(a));
        }

        public final void forEach(Consumer<? super V> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (HashMap.this.size > 0) {
                Entry[] tab = HashMap.this.table;
                if (HashMap.this.table != null) {
                    int mc = HashMap.this.modCount;
                    for (Object e : tab) {
                        while (e != null) {
                            action.accept(e.value);
                            e = e.next;
                        }
                    }
                    if (HashMap.this.modCount != mc) {
                        throw new ConcurrentModificationException();
                    }
                }
            }
        }
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        @Override
        public final int size() {
            return HashMap.this.size;
        }

        @Override
        public final void clear() {
            HashMap.this.clear();
        }

        @Override
        public final Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(HashMap.this);
        }

        @Override
        public final boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            Node candidate = HashMap.this.getNode(key);
            return candidate != null && candidate.equals(e);
        }

        @Override
        public final boolean remove(Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                Object value = e.getValue();
                return HashMap.this.removeNode(HashMap.hash(key), key, value, true, true) != null;
            }
            return false;
        }

        public final Spliterator<Map.Entry<K, V>> spliterator() {
            return new EntrySpliterator(HashMap.this, 0, -1, 0, 0);
        }

        public final void forEach(Consumer<? super Map.Entry<K, V>> action) {
            if (action == null) {
                throw new NullPointerException();
            }
            if (HashMap.this.size > 0) {
                Entry[] tab = HashMap.this.table;
                if (HashMap.this.table != null) {
                    int mc = HashMap.this.modCount;
                    for (Object e : tab) {
                        while (e != null) {
                            action.accept((Map.Entry)e);
                            e = e.next;
                        }
                    }
                    if (HashMap.this.modCount != mc) {
                        throw new ConcurrentModificationException();
                    }
                }
            }
        }
    }
}

