/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FileFilter;
import java.io.FileSystem;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.security.SecureRandom;
import jdk.internal.util.StaticProperty;
import org.checkerframework.checker.javari.qual.PolyRead;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.framework.qual.DefaultQualifier;

/*
 * Exception performing whole class analysis.
 * Exception performing whole class analysis ignored.
 */
@DefaultQualifier(value=NonNull.class)
public class File
implements Serializable,
Comparable<File> {
    private static FileSystem fs;
    private String path;
    private transient int prefixLength;
    public static final char separatorChar;
    public static final String separator;
    public static final char pathSeparatorChar;
    public static final String pathSeparator;
    private static final long serialVersionUID = 301077366599181567L;
    private volatile transient Path filePath;

    int getPrefixLength();

    private File(String var1, int var2);

    private File(String var1, File var2);

    public File(String var1);

    public File(@Nullable String var1, String var2);

    public @PolyRead File(@Nullable @PolyRead File var1, String var2);

    public File(@ReadOnly URI var1);

    public String getName(@ReadOnly File this);

    @Pure
    public @Nullable String getParent(@ReadOnly File this);

    @Pure
    public @Nullable @PolyRead File getParentFile(@PolyRead File this);

    public String getPath(@ReadOnly File this);

    @Pure
    public boolean isAbsolute(@ReadOnly File this);

    public String getAbsolutePath(@ReadOnly File this);

    public @PolyRead File getAbsoluteFile(@PolyRead File this);

    public String getCanonicalPath(@ReadOnly File this) throws IOException;

    public @PolyRead File getCanonicalFile(@PolyRead File this) throws IOException;

    private static String slashify(String var0, boolean var1);

    @Deprecated
    @Deprecated
    public @PolyRead URL toURL(@PolyRead File this) throws MalformedURLException;

    public @PolyRead URI toURI(@PolyRead File this);

    public boolean canRead(@ReadOnly File this);

    public boolean canWrite(@ReadOnly File this);

    public boolean exists(@ReadOnly File this);

    @Pure
    public boolean isDirectory(@ReadOnly File this);

    @Pure
    public boolean isFile(@ReadOnly File this);

    @Pure
    public boolean isHidden(@ReadOnly File this);

    public long lastModified(@ReadOnly File this);

    public long length(@ReadOnly File this);

    public boolean createNewFile() throws IOException;

    public boolean delete();

    public void deleteOnExit();

    public String @Nullable [] list(@ReadOnly File this);

    public String @Nullable [] list(@ReadOnly File this, @Nullable FilenameFilter var1);

    public @PolyRead File @Nullable [] listFiles(@PolyRead File this);

    public @PolyRead File @Nullable [] listFiles(@PolyRead File this, @Nullable FilenameFilter var1);

    public @PolyRead File @Nullable [] listFiles(@PolyRead File this, @Nullable FileFilter var1);

    public boolean mkdir();

    public boolean mkdirs();

    public boolean renameTo(File var1);

    public boolean setLastModified(long var1);

    public boolean setReadOnly();

    public boolean setWritable(boolean var1, boolean var2);

    public boolean setWritable(boolean var1);

    public boolean setReadable(boolean var1, boolean var2);

    public boolean setReadable(boolean var1);

    public boolean setExecutable(boolean var1, boolean var2);

    public boolean setExecutable(boolean var1);

    public boolean canExecute(@ReadOnly File this);

    public static File @Nullable [] listRoots();

    public long getTotalSpace(@ReadOnly File this);

    public long getFreeSpace(@ReadOnly File this);

    public long getUsableSpace(@ReadOnly File this);

    public static File createTempFile(String var0, @Nullable String var1, @Nullable File var2) throws IOException;

    public static File createTempFile(String var0, @Nullable String var1) throws IOException;

    @Override
    @Pure
    public int compareTo(@ReadOnly File this, @ReadOnly File var1);

    @Pure
    public boolean equals(@ReadOnly File this, @Nullable @ReadOnly Object var1);

    @Pure
    public int hashCode(@ReadOnly File this);

    @SideEffectFree
    public String toString(@ReadOnly File this);

    private synchronized void writeObject(ObjectOutputStream var1) throws IOException;

    private synchronized void readObject(ObjectInputStream var1) throws IOException, ClassNotFoundException;

    public Path toPath();

    static;

    private static class TempDirectory {
        private static final File TMPDIR = new File(StaticProperty.javaIoTmpDir());
        private static final SecureRandom RANDOM = new SecureRandom();

        private TempDirectory() {
        }

        static File location() {
            return TMPDIR;
        }

        private static int shortenSubName(int subNameLength, int excess, int nameMin) {
            int newLength = Math.max(nameMin, subNameLength - excess);
            if (newLength < subNameLength) {
                return newLength;
            }
            return subNameLength;
        }

        static File generateFile(String prefix, String suffix, File dir) throws IOException {
            String name;
            int nameMax;
            int suffixLength;
            int nusLength;
            long n = RANDOM.nextLong();
            String nus = Long.toUnsignedString((long)n);
            int prefixLength = (prefix = new File(prefix).getName()).length();
            int excess = prefixLength + (nusLength = nus.length()) + (suffixLength = suffix.length()) - (nameMax = FS.getNameMax(dir.getPath()));
            if (excess <= 0) {
                name = prefix + nus + suffix;
            } else {
                if ((excess = (prefixLength = TempDirectory.shortenSubName(prefixLength, excess, 3)) + nusLength + suffixLength - nameMax) > 0) {
                    suffixLength = TempDirectory.shortenSubName(suffixLength, excess, suffix.indexOf(".") == 0 ? 4 : 0);
                    suffixLength = TempDirectory.shortenSubName(suffixLength, excess, 3);
                    excess = prefixLength + nusLength + suffixLength - nameMax;
                }
                if (excess > 0 && excess <= nusLength - 5) {
                    nusLength = TempDirectory.shortenSubName(nusLength, excess, 5);
                }
                StringBuilder sb = new StringBuilder(prefixLength + nusLength + suffixLength);
                sb.append(prefixLength < prefix.length() ? prefix.substring(0, prefixLength) : prefix);
                sb.append(nusLength < nus.length() ? nus.substring(0, nusLength) : nus);
                sb.append(suffixLength < suffix.length() ? suffix.substring(0, suffixLength) : suffix);
                name = sb.toString();
            }
            name = FS.normalize(name);
            File f = new File(dir, name);
            if (!name.equals(f.getName()) || f.isInvalid()) {
                if (System.getSecurityManager() != null) {
                    throw new IOException("Unable to create temporary file");
                }
                throw new IOException("Unable to create temporary file, " + name);
            }
            return f;
        }
    }
}

