/*
 * Decompiled with CFR 0.152.
 */
package javax.annotation.processing;

import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.processing.Completion;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import org.checkerframework.checker.javari.qual.PolyRead;
import org.checkerframework.checker.javari.qual.ReadOnly;

public abstract class AbstractProcessor
implements Processor {
    protected ProcessingEnvironment processingEnv;
    private boolean initialized = false;

    protected AbstractProcessor() {
    }

    @Override
    public @PolyRead Set<String> getSupportedOptions(@PolyRead AbstractProcessor this) {
        SupportedOptions supportedOptions = this.getClass().getAnnotation(SupportedOptions.class);
        if (supportedOptions == null) {
            return Collections.emptySet();
        }
        return AbstractProcessor.arrayToSet(supportedOptions.value());
    }

    @Override
    public @PolyRead Set<String> getSupportedAnnotationTypes(@PolyRead AbstractProcessor this) {
        SupportedAnnotationTypes supportedAnnotationTypes = this.getClass().getAnnotation(SupportedAnnotationTypes.class);
        if (supportedAnnotationTypes == null) {
            if (this.isInitialized()) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "No SupportedAnnotationTypes annotation found on " + this.getClass().getName() + ", returning an empty set.");
            }
            return Collections.emptySet();
        }
        return AbstractProcessor.arrayToSet(supportedAnnotationTypes.value());
    }

    @Override
    public @PolyRead SourceVersion getSupportedSourceVersion(@PolyRead AbstractProcessor this) {
        SupportedSourceVersion supportedSourceVersion = this.getClass().getAnnotation(SupportedSourceVersion.class);
        SourceVersion sourceVersion = null;
        if (supportedSourceVersion == null) {
            sourceVersion = SourceVersion.RELEASE_6;
            if (this.isInitialized()) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.WARNING, "No SupportedSourceVersion annotation found on " + this.getClass().getName() + ", returning " + (Object)((Object)sourceVersion) + ".");
            }
        } else {
            sourceVersion = supportedSourceVersion.value();
        }
        return sourceVersion;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        if (this.initialized) {
            throw new IllegalStateException("Cannot call init more than once.");
        }
        if (processingEnvironment == null) {
            throw new NullPointerException("Tool provided null ProcessingEnvironment");
        }
        this.processingEnv = processingEnvironment;
        this.initialized = true;
    }

    @Override
    public abstract boolean process(Set<? extends TypeElement> var1, RoundEnvironment var2);

    @Override
    public @PolyRead Iterable<? extends Completion> getCompletions(@PolyRead AbstractProcessor this, Element element, AnnotationMirror annotationMirror, ExecutableElement executableElement, String string) {
        return Collections.emptyList();
    }

    protected synchronized boolean isInitialized(@ReadOnly AbstractProcessor this) {
        return this.initialized;
    }

    private static Set<String> arrayToSet(String[] stringArray) {
        assert (stringArray != null);
        HashSet<String> hashSet = new HashSet<String>(stringArray.length);
        for (String string : stringArray) {
            hashSet.add(string);
        }
        return Collections.unmodifiableSet(hashSet);
    }
}

