/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.checkerframework.checker.igj.qual.AssignsFields;
import org.checkerframework.checker.igj.qual.I;
import org.checkerframework.checker.igj.qual.Immutable;
import org.checkerframework.checker.igj.qual.Mutable;
import org.checkerframework.checker.javari.qual.PolyRead;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.KeyFor;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;

@I
public abstract class AbstractMap<K, V>
implements Map<K, V> {
    volatile transient Set<K> keySet = null;
    volatile transient Collection<V> values = null;

    protected AbstractMap() {
    }

    @Override
    @Pure
    public int size(@org.checkerframework.checker.igj.qual.ReadOnly AbstractMap<K, V> this) {
        return this.entrySet().size();
    }

    @Override
    @Pure
    public boolean isEmpty(@org.checkerframework.checker.igj.qual.ReadOnly AbstractMap<K, V> this) {
        return this.size() == 0;
    }

    @Override
    @Pure
    public boolean containsValue(@org.checkerframework.checker.igj.qual.ReadOnly AbstractMap<K, V> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        Iterator<Map.Entry<K, V>> iterator = this.entrySet().iterator();
        if (object == null) {
            while (iterator.hasNext()) {
                Map.Entry<K, V> entry = iterator.next();
                if (entry.getValue() != null) continue;
                return true;
            }
        } else {
            while (iterator.hasNext()) {
                Map.Entry<K, V> entry = iterator.next();
                if (!object.equals(entry.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Pure
    public boolean containsKey(@org.checkerframework.checker.igj.qual.ReadOnly AbstractMap<K, V> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        Iterator<Map.Entry<K, V>> iterator = this.entrySet().iterator();
        if (object == null) {
            while (iterator.hasNext()) {
                Map.Entry<K, V> entry = iterator.next();
                if (entry.getKey() != null) continue;
                return true;
            }
        } else {
            while (iterator.hasNext()) {
                Map.Entry<K, V> entry = iterator.next();
                if (!object.equals(entry.getKey())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    @Pure
    public @Nullable V get(@org.checkerframework.checker.igj.qual.ReadOnly AbstractMap<K, V> this, @Nullable @ReadOnly Object object) {
        Iterator<Map.Entry<K, V>> iterator = this.entrySet().iterator();
        if (object == null) {
            while (iterator.hasNext()) {
                Map.Entry<K, V> entry = iterator.next();
                if (entry.getKey() != null) continue;
                return entry.getValue();
            }
        } else {
            while (iterator.hasNext()) {
                Map.Entry<K, V> entry = iterator.next();
                if (!object.equals(entry.getKey())) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    @Override
    public @Nullable V put(@Mutable AbstractMap<K, V> this, K k, V v) {
        throw new UnsupportedOperationException();
    }

    @Override
    public @Nullable V remove(@Mutable AbstractMap<K, V> this, @Nullable @ReadOnly Object object) {
        Map.Entry<K, V> entry;
        Iterator<Map.Entry<K, V>> iterator = this.entrySet().iterator();
        Map.Entry<K, V> entry2 = null;
        if (object == null) {
            while (entry2 == null && iterator.hasNext()) {
                entry = iterator.next();
                if (entry.getKey() != null) continue;
                entry2 = entry;
            }
        } else {
            while (entry2 == null && iterator.hasNext()) {
                entry = iterator.next();
                if (!object.equals(entry.getKey())) continue;
                entry2 = entry;
            }
        }
        entry = null;
        if (entry2 != null) {
            entry = entry2.getValue();
            iterator.remove();
        }
        return (V)entry;
    }

    @Override
    public void putAll(@Mutable AbstractMap<K, V> this, @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear(@Mutable AbstractMap<K, V> this) {
        this.entrySet().clear();
    }

    @Override
    @SideEffectFree
    public @I @PolyRead Set<@KeyFor(value={"this"}) K> keySet(@org.checkerframework.checker.igj.qual.ReadOnly AbstractMap<K, V> this) {
        if (this.keySet == null) {
            this.keySet = new AbstractSet<K>(){

                @Override
                public Iterator<K> iterator() {
                    return new Iterator<K>(){
                        private Iterator<Map.Entry<K, V>> i;
                        {
                            this.i = AbstractMap.this.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        @Override
                        public K next() {
                            return this.i.next().getKey();
                        }

                        @Override
                        public void remove() {
                            this.i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return AbstractMap.this.size();
                }

                @Override
                public boolean isEmpty() {
                    return AbstractMap.this.isEmpty();
                }

                @Override
                public void clear() {
                    AbstractMap.this.clear();
                }

                @Override
                public boolean contains(Object k) {
                    return AbstractMap.this.containsKey(k);
                }
            };
        }
        return this.keySet;
    }

    @Override
    @SideEffectFree
    public @I @PolyRead Collection<V> values(@org.checkerframework.checker.igj.qual.ReadOnly AbstractMap<K, V> this) {
        if (this.values == null) {
            this.values = new AbstractCollection<V>(){

                @Override
                public Iterator<V> iterator() {
                    return new Iterator<V>(){
                        private Iterator<Map.Entry<K, V>> i;
                        {
                            this.i = AbstractMap.this.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        @Override
                        public V next() {
                            return this.i.next().getValue();
                        }

                        @Override
                        public void remove() {
                            this.i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return AbstractMap.this.size();
                }

                @Override
                public boolean isEmpty() {
                    return AbstractMap.this.isEmpty();
                }

                @Override
                public void clear() {
                    AbstractMap.this.clear();
                }

                @Override
                public boolean contains(Object v) {
                    return AbstractMap.this.containsValue(v);
                }
            };
        }
        return this.values;
    }

    @Override
    @SideEffectFree
    public abstract @I @PolyRead Set<@I @PolyRead Map.Entry<@KeyFor(value={"this"}) K, V>> entrySet(@org.checkerframework.checker.igj.qual.ReadOnly AbstractMap<K, V> this);

    @Override
    @Pure
    public boolean equals(@org.checkerframework.checker.igj.qual.ReadOnly AbstractMap<K, V> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (map.size() != this.size()) {
            return false;
        }
        try {
            for (Map.Entry<K, V> entry : this.entrySet()) {
                K k = entry.getKey();
                V v = entry.getValue();
                if (!(v == null ? map.get(k) != null || !map.containsKey(k) : !v.equals(map.get(k)))) continue;
                return false;
            }
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
        return true;
    }

    @Override
    @Pure
    public int hashCode(@org.checkerframework.checker.igj.qual.ReadOnly AbstractMap<K, V> this) {
        int n = 0;
        Iterator<Map.Entry<K, V>> iterator = this.entrySet().iterator();
        while (iterator.hasNext()) {
            n += iterator.next().hashCode();
        }
        return n;
    }

    @SideEffectFree
    public String toString(@org.checkerframework.checker.igj.qual.ReadOnly AbstractMap<K, V> this) {
        Iterator<Map.Entry<K, V>> iterator = this.entrySet().iterator();
        if (!iterator.hasNext()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        while (true) {
            Map.Entry<K, V> entry = iterator.next();
            K k = entry.getKey();
            V v = entry.getValue();
            stringBuilder.append((Object)(k == this ? "(this Map)" : k));
            stringBuilder.append('=');
            stringBuilder.append((Object)(v == this ? "(this Map)" : v));
            if (!iterator.hasNext()) {
                return stringBuilder.append('}').toString();
            }
            stringBuilder.append(',').append(' ');
        }
    }

    protected Object clone(@ReadOnly AbstractMap<K, V> this) throws CloneNotSupportedException {
        AbstractMap abstractMap = (AbstractMap)super.clone();
        abstractMap.keySet = null;
        abstractMap.values = null;
        return abstractMap;
    }

    private static boolean eq(Object object, Object object2) {
        return object == null ? object2 == null : object.equals(object2);
    }

    @I
    public static class SimpleEntry<K, V>
    implements Map.Entry<K, V>,
    Serializable {
        private static final long serialVersionUID = -8499721149061103585L;
        private final K key;
        private V value;

        public SimpleEntry(K k, V v) {
            this.key = k;
            this.value = v;
        }

        public SimpleEntry(@I @ReadOnly Map.Entry<? extends K, ? extends V> entry) {
            this.key = entry.getKey();
            this.value = entry.getValue();
        }

        @Override
        @Pure
        public K getKey(@org.checkerframework.checker.igj.qual.ReadOnly SimpleEntry<K, V> this) {
            return this.key;
        }

        @Override
        @Pure
        public V getValue(@org.checkerframework.checker.igj.qual.ReadOnly SimpleEntry<K, V> this) {
            return this.value;
        }

        @Override
        public V setValue(@AssignsFields SimpleEntry<K, V> this, V v) {
            V v2 = this.value;
            this.value = v;
            return v2;
        }

        @Override
        @Pure
        public boolean equals(@org.checkerframework.checker.igj.qual.ReadOnly SimpleEntry<K, V> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return AbstractMap.eq(this.key, entry.getKey()) && AbstractMap.eq(this.value, entry.getValue());
        }

        @Override
        @Pure
        public int hashCode(@org.checkerframework.checker.igj.qual.ReadOnly SimpleEntry<K, V> this) {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        @SideEffectFree
        public String toString(@org.checkerframework.checker.igj.qual.ReadOnly SimpleEntry<K, V> this) {
            return this.key + "=" + this.value;
        }
    }

    @Immutable
    @ReadOnly
    public static class SimpleImmutableEntry<K, V>
    implements Map.Entry<K, V>,
    Serializable {
        private static final long serialVersionUID = 7138329143949025153L;
        private final K key;
        private final V value;

        public SimpleImmutableEntry(K k, V v) {
            this.key = k;
            this.value = v;
        }

        public SimpleImmutableEntry(@ReadOnly Map.Entry<? extends K, ? extends V> entry) {
            this.key = entry.getKey();
            this.value = entry.getValue();
        }

        @Override
        @Pure
        public K getKey(@org.checkerframework.checker.igj.qual.ReadOnly SimpleImmutableEntry<K, V> this) {
            return this.key;
        }

        @Override
        @Pure
        public V getValue(@org.checkerframework.checker.igj.qual.ReadOnly SimpleImmutableEntry<K, V> this) {
            return this.value;
        }

        @Override
        public V setValue(@AssignsFields SimpleImmutableEntry<K, V> this, V v) {
            throw new UnsupportedOperationException();
        }

        @Override
        @Pure
        public boolean equals(@org.checkerframework.checker.igj.qual.ReadOnly SimpleImmutableEntry<K, V> this, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return AbstractMap.eq(this.key, entry.getKey()) && AbstractMap.eq(this.value, entry.getValue());
        }

        @Override
        @Pure
        public int hashCode(@org.checkerframework.checker.igj.qual.ReadOnly SimpleImmutableEntry<K, V> this) {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        @SideEffectFree
        public String toString(@org.checkerframework.checker.igj.qual.ReadOnly SimpleImmutableEntry<K, V> this) {
            return this.key + "=" + this.value;
        }
    }
}

