/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.util.Enumeration;
import java.util.NoSuchElementException;
import org.checkerframework.checker.igj.qual.Immutable;
import org.checkerframework.checker.javari.qual.PolyRead;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.Nullable;

@Immutable
public class StringTokenizer
implements Enumeration<Object> {
    private int currentPosition = 0;
    private int newPosition = -1;
    private int maxPosition;
    private String str;
    private String delimiters;
    private boolean retDelims;
    private boolean delimsChanged = false;
    private int maxDelimCodePoint;
    private boolean hasSurrogates = false;
    private int[] delimiterCodePoints;

    private void setMaxDelimCodePoint() {
        int n;
        int n2;
        if (this.delimiters == null) {
            this.maxDelimCodePoint = 0;
            return;
        }
        int n3 = 0;
        int n4 = 0;
        for (n = 0; n < this.delimiters.length(); n += Character.charCount(n2)) {
            n2 = this.delimiters.charAt(n);
            if (n2 >= 55296 && n2 <= 57343) {
                n2 = this.delimiters.codePointAt(n);
                this.hasSurrogates = true;
            }
            if (n3 < n2) {
                n3 = n2;
            }
            ++n4;
        }
        this.maxDelimCodePoint = n3;
        if (this.hasSurrogates) {
            this.delimiterCodePoints = new int[n4];
            n = 0;
            int n5 = 0;
            while (n < n4) {
                this.delimiterCodePoints[n] = n2 = this.delimiters.codePointAt(n5);
                ++n;
                n5 += Character.charCount(n2);
            }
        }
    }

    public StringTokenizer(String string, @Nullable String string2, boolean bl) {
        this.str = string;
        this.maxPosition = string.length();
        this.delimiters = string2;
        this.retDelims = bl;
        this.setMaxDelimCodePoint();
    }

    public StringTokenizer(String string, @Nullable String string2) {
        this(string, string2, false);
    }

    public StringTokenizer(String string) {
        this(string, " \t\n\r\f", false);
    }

    private int skipDelimiters(int n) {
        if (this.delimiters == null) {
            throw new NullPointerException();
        }
        int n2 = n;
        while (!this.retDelims && n2 < this.maxPosition) {
            int n3;
            if (!this.hasSurrogates) {
                n3 = this.str.charAt(n2);
                if (n3 > this.maxDelimCodePoint || this.delimiters.indexOf(n3) < 0) break;
                ++n2;
                continue;
            }
            n3 = this.str.codePointAt(n2);
            if (n3 > this.maxDelimCodePoint || !this.isDelimiter(n3)) break;
            n2 += Character.charCount(n3);
        }
        return n2;
    }

    private int scanToken(int n) {
        int n2;
        int n3 = n;
        while (n3 < this.maxPosition) {
            if (!this.hasSurrogates) {
                n2 = this.str.charAt(n3);
                if (n2 <= this.maxDelimCodePoint && this.delimiters.indexOf(n2) >= 0) break;
                ++n3;
                continue;
            }
            n2 = this.str.codePointAt(n3);
            if (n2 <= this.maxDelimCodePoint && this.isDelimiter(n2)) break;
            n3 += Character.charCount(n2);
        }
        if (this.retDelims && n == n3) {
            if (!this.hasSurrogates) {
                n2 = this.str.charAt(n3);
                if (n2 <= this.maxDelimCodePoint && this.delimiters.indexOf(n2) >= 0) {
                    ++n3;
                }
            } else {
                n2 = this.str.codePointAt(n3);
                if (n2 <= this.maxDelimCodePoint && this.isDelimiter(n2)) {
                    n3 += Character.charCount(n2);
                }
            }
        }
        return n3;
    }

    private boolean isDelimiter(int n) {
        for (int i = 0; i < this.delimiterCodePoints.length; ++i) {
            if (this.delimiterCodePoints[i] != n) continue;
            return true;
        }
        return false;
    }

    public boolean hasMoreTokens(@ReadOnly StringTokenizer this) {
        this.newPosition = this.skipDelimiters(this.currentPosition);
        return this.newPosition < this.maxPosition;
    }

    public @PolyRead String nextToken(@PolyRead StringTokenizer this) {
        this.currentPosition = this.newPosition >= 0 && !this.delimsChanged ? this.newPosition : this.skipDelimiters(this.currentPosition);
        this.delimsChanged = false;
        this.newPosition = -1;
        if (this.currentPosition >= this.maxPosition) {
            throw new NoSuchElementException();
        }
        int n = this.currentPosition;
        this.currentPosition = this.scanToken(this.currentPosition);
        return this.str.substring(n, this.currentPosition);
    }

    public @PolyRead String nextToken(@PolyRead StringTokenizer this, String string) {
        this.delimiters = string;
        this.delimsChanged = true;
        this.setMaxDelimCodePoint();
        return this.nextToken();
    }

    @Override
    public boolean hasMoreElements(@ReadOnly StringTokenizer this) {
        return this.hasMoreTokens();
    }

    @Override
    public @PolyRead Object nextElement(@PolyRead StringTokenizer this) {
        return this.nextToken();
    }

    public int countTokens(@ReadOnly StringTokenizer this) {
        int n = 0;
        int n2 = this.currentPosition;
        while (n2 < this.maxPosition && (n2 = this.skipDelimiters(n2)) < this.maxPosition) {
            n2 = this.scanToken(n2);
            ++n;
        }
        return n;
    }
}

