/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.security.AccessController;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.ComparableTimSort;
import java.util.Comparator;
import java.util.DualPivotQuicksort;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.TimSort;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import org.checkerframework.checker.igj.qual.I;
import org.checkerframework.checker.igj.qual.Mutable;
import org.checkerframework.checker.javari.qual.ReadOnly;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.PolyNull;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import sun.security.action.GetBooleanAction;

public class Arrays {
    private static final int INSERTIONSORT_THRESHOLD = 7;

    private Arrays() {
    }

    public static void sort(int @Mutable [] nArray) {
        DualPivotQuicksort.sort((int[])nArray);
    }

    public static void sort(int @Mutable [] nArray, int n, int n2) {
        Arrays.rangeCheck(nArray.length, n, n2);
        DualPivotQuicksort.sort((int[])nArray, (int)n, (int)(n2 - 1));
    }

    public static void sort(long @Mutable [] lArray) {
        DualPivotQuicksort.sort((long[])lArray);
    }

    public static void sort(long @Mutable [] lArray, int n, int n2) {
        Arrays.rangeCheck(lArray.length, n, n2);
        DualPivotQuicksort.sort((long[])lArray, (int)n, (int)(n2 - 1));
    }

    public static void sort(short @Mutable [] sArray) {
        DualPivotQuicksort.sort((short[])sArray);
    }

    public static void sort(short @Mutable [] sArray, int n, int n2) {
        Arrays.rangeCheck(sArray.length, n, n2);
        DualPivotQuicksort.sort(sArray, n, n2 - 1);
    }

    public static void sort(char @Mutable [] cArray) {
        DualPivotQuicksort.sort((char[])cArray);
    }

    public static void sort(char @Mutable [] cArray, int n, int n2) {
        Arrays.rangeCheck(cArray.length, n, n2);
        DualPivotQuicksort.sort(cArray, n, n2 - 1);
    }

    public static void sort(byte @Mutable [] byArray) {
        DualPivotQuicksort.sort((byte[])byArray);
    }

    public static void sort(byte @Mutable [] byArray, int n, int n2) {
        Arrays.rangeCheck(byArray.length, n, n2);
        DualPivotQuicksort.sort(byArray, n, n2 - 1);
    }

    public static void sort(float @Mutable [] fArray) {
        DualPivotQuicksort.sort((float[])fArray);
    }

    public static void sort(float @Mutable [] fArray, int n, int n2) {
        Arrays.rangeCheck(fArray.length, n, n2);
        DualPivotQuicksort.sort((float[])fArray, (int)n, (int)(n2 - 1));
    }

    public static void sort(double @Mutable [] dArray) {
        DualPivotQuicksort.sort((double[])dArray);
    }

    public static void sort(double @Mutable [] dArray, int n, int n2) {
        Arrays.rangeCheck(dArray.length, n, n2);
        DualPivotQuicksort.sort((double[])dArray, (int)n, (int)(n2 - 1));
    }

    public static void sort(@org.checkerframework.checker.igj.qual.ReadOnly Object @Mutable [] objectArray) {
        if (LegacyMergeSort.access$000()) {
            Arrays.legacyMergeSort(objectArray);
        } else {
            ComparableTimSort.sort((Object[])objectArray);
        }
    }

    private static void legacyMergeSort(Object[] objectArray) {
        Object[] objectArray2 = (Object[])objectArray.clone();
        Arrays.mergeSort(objectArray2, objectArray, 0, objectArray.length, 0);
    }

    public static void sort(@org.checkerframework.checker.igj.qual.ReadOnly Object @Mutable [] objectArray, int n, int n2) {
        if (LegacyMergeSort.access$000()) {
            Arrays.legacyMergeSort(objectArray, n, n2);
        } else {
            ComparableTimSort.sort((Object[])objectArray, (int)n, (int)n2);
        }
    }

    private static void legacyMergeSort(Object[] objectArray, int n, int n2) {
        Arrays.rangeCheck(objectArray.length, n, n2);
        Object[] objectArray2 = Arrays.copyOfRange(objectArray, n, n2);
        Arrays.mergeSort(objectArray2, objectArray, n, n2, -n);
    }

    private static void mergeSort(Object[] objectArray, Object[] objectArray2, int n, int n2, int n3) {
        int n4 = n2 - n;
        if (n4 < 7) {
            for (int i = n; i < n2; ++i) {
                for (int j = i; j > n && ((Comparable)objectArray2[j - 1]).compareTo(objectArray2[j]) > 0; --j) {
                    Arrays.swap(objectArray2, j, j - 1);
                }
            }
            return;
        }
        int n5 = n;
        int n6 = n2;
        int n7 = (n += n3) + (n2 += n3) >>> 1;
        Arrays.mergeSort(objectArray2, objectArray, n, n7, -n3);
        Arrays.mergeSort(objectArray2, objectArray, n7, n2, -n3);
        if (((Comparable)objectArray[n7 - 1]).compareTo(objectArray[n7]) <= 0) {
            System.arraycopy(objectArray, n, objectArray2, n5, n4);
            return;
        }
        int n8 = n;
        int n9 = n7;
        for (int i = n5; i < n6; ++i) {
            objectArray2[i] = n9 >= n2 || n8 < n7 && ((Comparable)objectArray[n8]).compareTo(objectArray[n9]) <= 0 ? objectArray[n8++] : objectArray[n9++];
        }
    }

    private static void swap(Object[] objectArray, int n, int n2) {
        Object object = objectArray[n];
        objectArray[n] = objectArray[n2];
        objectArray[n2] = object;
    }

    public static <T> void sort(T @Mutable [] TArray, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly Comparator<? super T> comparator) {
        if (LegacyMergeSort.access$000()) {
            Arrays.legacyMergeSort(TArray, comparator);
        } else {
            TimSort.sort((Object[])TArray, comparator);
        }
    }

    private static <T> void legacyMergeSort(T[] TArray, Comparator<? super T> comparator) {
        Object[] objectArray = (Object[])TArray.clone();
        if (comparator == null) {
            Arrays.mergeSort(objectArray, TArray, 0, TArray.length, 0);
        } else {
            Arrays.mergeSort(objectArray, TArray, 0, TArray.length, 0, comparator);
        }
    }

    public static <T> void sort(T @Mutable [] TArray, int n, int n2, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly Comparator<? super T> comparator) {
        if (LegacyMergeSort.access$000()) {
            Arrays.legacyMergeSort(TArray, n, n2, comparator);
        } else {
            TimSort.sort((Object[])TArray, (int)n, (int)n2, comparator);
        }
    }

    private static <T> void legacyMergeSort(T[] TArray, int n, int n2, Comparator<? super T> comparator) {
        Arrays.rangeCheck(TArray.length, n, n2);
        Object[] objectArray = Arrays.copyOfRange(TArray, n, n2);
        if (comparator == null) {
            Arrays.mergeSort(objectArray, TArray, n, n2, -n);
        } else {
            Arrays.mergeSort(objectArray, TArray, n, n2, -n, comparator);
        }
    }

    private static void mergeSort(Object[] objectArray, Object[] objectArray2, int n, int n2, int n3, Comparator comparator) {
        int n4 = n2 - n;
        if (n4 < 7) {
            for (int i = n; i < n2; ++i) {
                for (int j = i; j > n && comparator.compare(objectArray2[j - 1], objectArray2[j]) > 0; --j) {
                    Arrays.swap(objectArray2, j, j - 1);
                }
            }
            return;
        }
        int n5 = n;
        int n6 = n2;
        int n7 = (n += n3) + (n2 += n3) >>> 1;
        Arrays.mergeSort(objectArray2, objectArray, n, n7, -n3, comparator);
        Arrays.mergeSort(objectArray2, objectArray, n7, n2, -n3, comparator);
        if (comparator.compare(objectArray[n7 - 1], objectArray[n7]) <= 0) {
            System.arraycopy(objectArray, n, objectArray2, n5, n4);
            return;
        }
        int n8 = n;
        int n9 = n7;
        for (int i = n5; i < n6; ++i) {
            objectArray2[i] = n9 >= n2 || n8 < n7 && comparator.compare(objectArray[n8], objectArray[n9]) <= 0 ? objectArray[n8++] : objectArray[n9++];
        }
    }

    private static void rangeCheck(int n, int n2, int n3) {
        if (n2 > n3) {
            throw new IllegalArgumentException("fromIndex(" + n2 + ") > toIndex(" + n3 + ")");
        }
        if (n2 < 0) {
            throw new ArrayIndexOutOfBoundsException(n2);
        }
        if (n3 > n) {
            throw new ArrayIndexOutOfBoundsException(n3);
        }
    }

    public static int binarySearch(long @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] lArray, long l) {
        return Arrays.binarySearch0(lArray, 0, lArray.length, l);
    }

    public static int binarySearch(long @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] lArray, int n, int n2, long l) {
        Arrays.rangeCheck(lArray.length, n, n2);
        return Arrays.binarySearch0(lArray, n, n2, l);
    }

    private static int binarySearch0(long[] lArray, int n, int n2, long l) {
        int n3 = n;
        int n4 = n2 - 1;
        while (n3 <= n4) {
            int n5 = n3 + n4 >>> 1;
            long l2 = lArray[n5];
            if (l2 < l) {
                n3 = n5 + 1;
                continue;
            }
            if (l2 > l) {
                n4 = n5 - 1;
                continue;
            }
            return n5;
        }
        return -(n3 + 1);
    }

    public static int binarySearch(int @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] nArray, int n) {
        return Arrays.binarySearch0(nArray, 0, nArray.length, n);
    }

    public static int binarySearch(int @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] nArray, int n, int n2, int n3) {
        Arrays.rangeCheck(nArray.length, n, n2);
        return Arrays.binarySearch0(nArray, n, n2, n3);
    }

    private static int binarySearch0(int[] nArray, int n, int n2, int n3) {
        int n4 = n;
        int n5 = n2 - 1;
        while (n4 <= n5) {
            int n6 = n4 + n5 >>> 1;
            int n7 = nArray[n6];
            if (n7 < n3) {
                n4 = n6 + 1;
                continue;
            }
            if (n7 > n3) {
                n5 = n6 - 1;
                continue;
            }
            return n6;
        }
        return -(n4 + 1);
    }

    public static int binarySearch(short @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] sArray, short s) {
        return Arrays.binarySearch0(sArray, 0, sArray.length, s);
    }

    public static int binarySearch(short @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] sArray, int n, int n2, short s) {
        Arrays.rangeCheck(sArray.length, n, n2);
        return Arrays.binarySearch0(sArray, n, n2, s);
    }

    private static int binarySearch0(short[] sArray, int n, int n2, short s) {
        int n3 = n;
        int n4 = n2 - 1;
        while (n3 <= n4) {
            int n5 = n3 + n4 >>> 1;
            short s2 = sArray[n5];
            if (s2 < s) {
                n3 = n5 + 1;
                continue;
            }
            if (s2 > s) {
                n4 = n5 - 1;
                continue;
            }
            return n5;
        }
        return -(n3 + 1);
    }

    public static int binarySearch(char @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] cArray, char c) {
        return Arrays.binarySearch0(cArray, 0, cArray.length, c);
    }

    public static int binarySearch(char @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] cArray, int n, int n2, char c) {
        Arrays.rangeCheck(cArray.length, n, n2);
        return Arrays.binarySearch0(cArray, n, n2, c);
    }

    private static int binarySearch0(char[] cArray, int n, int n2, char c) {
        int n3 = n;
        int n4 = n2 - 1;
        while (n3 <= n4) {
            int n5 = n3 + n4 >>> 1;
            char c2 = cArray[n5];
            if (c2 < c) {
                n3 = n5 + 1;
                continue;
            }
            if (c2 > c) {
                n4 = n5 - 1;
                continue;
            }
            return n5;
        }
        return -(n3 + 1);
    }

    public static int binarySearch(byte @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] byArray, byte by) {
        return Arrays.binarySearch0(byArray, 0, byArray.length, by);
    }

    public static int binarySearch(byte @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] byArray, int n, int n2, byte by) {
        Arrays.rangeCheck(byArray.length, n, n2);
        return Arrays.binarySearch0(byArray, n, n2, by);
    }

    private static int binarySearch0(byte[] byArray, int n, int n2, byte by) {
        int n3 = n;
        int n4 = n2 - 1;
        while (n3 <= n4) {
            int n5 = n3 + n4 >>> 1;
            byte by2 = byArray[n5];
            if (by2 < by) {
                n3 = n5 + 1;
                continue;
            }
            if (by2 > by) {
                n4 = n5 - 1;
                continue;
            }
            return n5;
        }
        return -(n3 + 1);
    }

    public static int binarySearch(double @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] dArray, double d) {
        return Arrays.binarySearch0(dArray, 0, dArray.length, d);
    }

    public static int binarySearch(double @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] dArray, int n, int n2, double d) {
        Arrays.rangeCheck(dArray.length, n, n2);
        return Arrays.binarySearch0(dArray, n, n2, d);
    }

    private static int binarySearch0(double[] dArray, int n, int n2, double d) {
        int n3 = n;
        int n4 = n2 - 1;
        while (n3 <= n4) {
            long l;
            int n5 = n3 + n4 >>> 1;
            double d2 = dArray[n5];
            if (d2 < d) {
                n3 = n5 + 1;
                continue;
            }
            if (d2 > d) {
                n4 = n5 - 1;
                continue;
            }
            long l2 = Double.doubleToLongBits(d2);
            if (l2 == (l = Double.doubleToLongBits(d))) {
                return n5;
            }
            if (l2 < l) {
                n3 = n5 + 1;
                continue;
            }
            n4 = n5 - 1;
        }
        return -(n3 + 1);
    }

    public static int binarySearch(float @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] fArray, float f) {
        return Arrays.binarySearch0(fArray, 0, fArray.length, f);
    }

    public static int binarySearch(float @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] fArray, int n, int n2, float f) {
        Arrays.rangeCheck(fArray.length, n, n2);
        return Arrays.binarySearch0(fArray, n, n2, f);
    }

    private static int binarySearch0(float[] fArray, int n, int n2, float f) {
        int n3 = n;
        int n4 = n2 - 1;
        while (n3 <= n4) {
            int n5;
            int n6 = n3 + n4 >>> 1;
            float f2 = fArray[n6];
            if (f2 < f) {
                n3 = n6 + 1;
                continue;
            }
            if (f2 > f) {
                n4 = n6 - 1;
                continue;
            }
            int n7 = Float.floatToIntBits(f2);
            if (n7 == (n5 = Float.floatToIntBits(f))) {
                return n6;
            }
            if (n7 < n5) {
                n3 = n6 + 1;
                continue;
            }
            n4 = n6 - 1;
        }
        return -(n3 + 1);
    }

    public static int binarySearch(@Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] objectArray, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        return Arrays.binarySearch0(objectArray, 0, objectArray.length, object);
    }

    public static int binarySearch(@Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] objectArray, int n, int n2, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object object) {
        Arrays.rangeCheck(objectArray.length, n, n2);
        return Arrays.binarySearch0(objectArray, n, n2, object);
    }

    private static int binarySearch0(Object[] objectArray, int n, int n2, Object object) {
        int n3 = n;
        int n4 = n2 - 1;
        while (n3 <= n4) {
            int n5 = n3 + n4 >>> 1;
            Comparable comparable = (Comparable)objectArray[n5];
            int n6 = comparable.compareTo(object);
            if (n6 < 0) {
                n3 = n5 + 1;
                continue;
            }
            if (n6 > 0) {
                n4 = n5 - 1;
                continue;
            }
            return n5;
        }
        return -(n3 + 1);
    }

    public static <T> int binarySearch(@org.checkerframework.checker.igj.qual.ReadOnly T @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] TArray, @ReadOnly T t, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly Comparator<? super T> comparator) {
        return Arrays.binarySearch0(TArray, 0, TArray.length, t, comparator);
    }

    public static <T> int binarySearch(@org.checkerframework.checker.igj.qual.ReadOnly T @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] TArray, int n, int n2, @ReadOnly T t, @Nullable @org.checkerframework.checker.igj.qual.ReadOnly Comparator<? super T> comparator) {
        Arrays.rangeCheck(TArray.length, n, n2);
        return Arrays.binarySearch0(TArray, n, n2, t, comparator);
    }

    private static <T> int binarySearch0(T[] TArray, int n, int n2, T t, Comparator<? super T> comparator) {
        if (comparator == null) {
            return Arrays.binarySearch0(TArray, n, n2, t);
        }
        int n3 = n;
        int n4 = n2 - 1;
        while (n3 <= n4) {
            int n5 = n3 + n4 >>> 1;
            T t2 = TArray[n5];
            int n6 = comparator.compare(t2, t);
            if (n6 < 0) {
                n3 = n5 + 1;
                continue;
            }
            if (n6 > 0) {
                n4 = n5 - 1;
                continue;
            }
            return n5;
        }
        return -(n3 + 1);
    }

    @Pure
    public static boolean equals(long @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] lArray, long @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] lArray2) {
        if (lArray == lArray2) {
            return true;
        }
        if (lArray == null || lArray2 == null) {
            return false;
        }
        int n = lArray.length;
        if (lArray2.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (lArray[i] == lArray2[i]) continue;
            return false;
        }
        return true;
    }

    @Pure
    public static boolean equals(int @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] nArray, int @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] nArray2) {
        if (nArray == nArray2) {
            return true;
        }
        if (nArray == null || nArray2 == null) {
            return false;
        }
        int n = nArray.length;
        if (nArray2.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    @Pure
    public static boolean equals(short @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] sArray, short @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] sArray2) {
        if (sArray == sArray2) {
            return true;
        }
        if (sArray == null || sArray2 == null) {
            return false;
        }
        int n = sArray.length;
        if (sArray2.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (sArray[i] == sArray2[i]) continue;
            return false;
        }
        return true;
    }

    @Pure
    public static boolean equals(char @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] cArray, char @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] cArray2) {
        if (cArray == cArray2) {
            return true;
        }
        if (cArray == null || cArray2 == null) {
            return false;
        }
        int n = cArray.length;
        if (cArray2.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (cArray[i] == cArray2[i]) continue;
            return false;
        }
        return true;
    }

    @Pure
    public static boolean equals(byte @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] byArray, byte @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        int n = byArray.length;
        if (byArray2.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    @Pure
    public static boolean equals(boolean @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] blArray, boolean @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] blArray2) {
        if (blArray == blArray2) {
            return true;
        }
        if (blArray == null || blArray2 == null) {
            return false;
        }
        int n = blArray.length;
        if (blArray2.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (blArray[i] == blArray2[i]) continue;
            return false;
        }
        return true;
    }

    @Pure
    public static boolean equals(double @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] dArray, double @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] dArray2) {
        if (dArray == dArray2) {
            return true;
        }
        if (dArray == null || dArray2 == null) {
            return false;
        }
        int n = dArray.length;
        if (dArray2.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (Double.doubleToLongBits(dArray[i]) == Double.doubleToLongBits(dArray2[i])) continue;
            return false;
        }
        return true;
    }

    @Pure
    public static boolean equals(float @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] fArray, float @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] fArray2) {
        if (fArray == fArray2) {
            return true;
        }
        if (fArray == null || fArray2 == null) {
            return false;
        }
        int n = fArray.length;
        if (fArray2.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (Float.floatToIntBits(fArray[i]) == Float.floatToIntBits(fArray2[i])) continue;
            return false;
        }
        return true;
    }

    @Pure
    public static boolean equals(@PolyNull @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] objectArray, @PolyNull @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] objectArray2) {
        if (objectArray == objectArray2) {
            return true;
        }
        if (objectArray == null || objectArray2 == null) {
            return false;
        }
        int n = objectArray.length;
        if (objectArray2.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            Object object2 = objectArray2[i];
            if (object != null ? object.equals(object2) : object2 == null) continue;
            return false;
        }
        return true;
    }

    public static void fill(long @Mutable [] lArray, long l) {
        int n = lArray.length;
        for (int i = 0; i < n; ++i) {
            lArray[i] = l;
        }
    }

    public static void fill(long @Mutable [] lArray, int n, int n2, long l) {
        Arrays.rangeCheck(lArray.length, n, n2);
        for (int i = n; i < n2; ++i) {
            lArray[i] = l;
        }
    }

    public static void fill(int @Mutable [] nArray, int n) {
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            nArray[i] = n;
        }
    }

    public static void fill(int @Mutable [] nArray, int n, int n2, int n3) {
        Arrays.rangeCheck(nArray.length, n, n2);
        for (int i = n; i < n2; ++i) {
            nArray[i] = n3;
        }
    }

    public static void fill(short @Mutable [] sArray, short s) {
        int n = sArray.length;
        for (int i = 0; i < n; ++i) {
            sArray[i] = s;
        }
    }

    public static void fill(short @Mutable [] sArray, int n, int n2, short s) {
        Arrays.rangeCheck(sArray.length, n, n2);
        for (int i = n; i < n2; ++i) {
            sArray[i] = s;
        }
    }

    public static void fill(char @Mutable [] cArray, char c) {
        int n = cArray.length;
        for (int i = 0; i < n; ++i) {
            cArray[i] = c;
        }
    }

    public static void fill(char @Mutable [] cArray, int n, int n2, char c) {
        Arrays.rangeCheck(cArray.length, n, n2);
        for (int i = n; i < n2; ++i) {
            cArray[i] = c;
        }
    }

    public static void fill(byte @Mutable [] byArray, byte by) {
        int n = byArray.length;
        for (int i = 0; i < n; ++i) {
            byArray[i] = by;
        }
    }

    public static void fill(byte @Mutable [] byArray, int n, int n2, byte by) {
        Arrays.rangeCheck(byArray.length, n, n2);
        for (int i = n; i < n2; ++i) {
            byArray[i] = by;
        }
    }

    public static void fill(boolean @Mutable [] blArray, boolean bl) {
        int n = blArray.length;
        for (int i = 0; i < n; ++i) {
            blArray[i] = bl;
        }
    }

    public static void fill(boolean @Mutable [] blArray, int n, int n2, boolean bl) {
        Arrays.rangeCheck(blArray.length, n, n2);
        for (int i = n; i < n2; ++i) {
            blArray[i] = bl;
        }
    }

    public static void fill(double @Mutable [] dArray, double d) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            dArray[i] = d;
        }
    }

    public static void fill(double @Mutable [] dArray, int n, int n2, double d) {
        Arrays.rangeCheck(dArray.length, n, n2);
        for (int i = n; i < n2; ++i) {
            dArray[i] = d;
        }
    }

    public static void fill(float @Mutable [] fArray, float f) {
        int n = fArray.length;
        for (int i = 0; i < n; ++i) {
            fArray[i] = f;
        }
    }

    public static void fill(float @Mutable [] fArray, int n, int n2, float f) {
        Arrays.rangeCheck(fArray.length, n, n2);
        for (int i = n; i < n2; ++i) {
            fArray[i] = f;
        }
    }

    public static void fill(@I Object @Mutable [] objectArray, @I Object object) {
        int n = objectArray.length;
        for (int i = 0; i < n; ++i) {
            objectArray[i] = object;
        }
    }

    public static void fill(@I Object @Mutable [] objectArray, int n, int n2, @I Object object) {
        Arrays.rangeCheck(objectArray.length, n, n2);
        for (int i = n; i < n2; ++i) {
            objectArray[i] = object;
        }
    }

    public static <T> @Nullable T[] copyOf(T @ReadOnly [] TArray, int n) {
        return Arrays.copyOf(TArray, n, TArray.getClass());
    }

    public static <T, U> @Nullable T[] copyOf(U @ReadOnly [] UArray, int n, Class<? extends T[]> clazz) {
        Object[] objectArray = clazz == Object[].class ? new Object[n] : (Object[])Array.newInstance(clazz.getComponentType(), n);
        System.arraycopy(UArray, 0, objectArray, 0, Math.min(UArray.length, n));
        return objectArray;
    }

    public static byte[] copyOf(byte @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] byArray, int n) {
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, 0, Math.min(byArray.length, n));
        return byArray2;
    }

    public static short[] copyOf(short @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] sArray, int n) {
        short[] sArray2 = new short[n];
        System.arraycopy(sArray, 0, sArray2, 0, Math.min(sArray.length, n));
        return sArray2;
    }

    public static int[] copyOf(int @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] nArray, int n) {
        int[] nArray2 = new int[n];
        System.arraycopy(nArray, 0, nArray2, 0, Math.min(nArray.length, n));
        return nArray2;
    }

    public static long[] copyOf(long @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] lArray, int n) {
        long[] lArray2 = new long[n];
        System.arraycopy(lArray, 0, lArray2, 0, Math.min(lArray.length, n));
        return lArray2;
    }

    public static char[] copyOf(char @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] cArray, int n) {
        char[] cArray2 = new char[n];
        System.arraycopy(cArray, 0, cArray2, 0, Math.min(cArray.length, n));
        return cArray2;
    }

    public static float[] copyOf(float @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] fArray, int n) {
        float[] fArray2 = new float[n];
        System.arraycopy(fArray, 0, fArray2, 0, Math.min(fArray.length, n));
        return fArray2;
    }

    public static double[] copyOf(double @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] dArray, int n) {
        double[] dArray2 = new double[n];
        System.arraycopy(dArray, 0, dArray2, 0, Math.min(dArray.length, n));
        return dArray2;
    }

    public static boolean[] copyOf(boolean @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] blArray, int n) {
        boolean[] blArray2 = new boolean[n];
        System.arraycopy(blArray, 0, blArray2, 0, Math.min(blArray.length, n));
        return blArray2;
    }

    public static <T> @Nullable T[] copyOfRange(T @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] TArray, int n, int n2) {
        return Arrays.copyOfRange(TArray, n, n2, TArray.getClass());
    }

    public static <T, U> @Nullable T[] copyOfRange(U @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] UArray, int n, int n2, Class<? extends T[]> clazz) {
        int n3 = n2 - n;
        if (n3 < 0) {
            throw new IllegalArgumentException(n + " > " + n2);
        }
        Object[] objectArray = clazz == Object[].class ? new Object[n3] : (Object[])Array.newInstance(clazz.getComponentType(), n3);
        System.arraycopy(UArray, n, objectArray, 0, Math.min(UArray.length - n, n3));
        return objectArray;
    }

    public static byte[] copyOfRange(byte @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] byArray, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 0) {
            throw new IllegalArgumentException(n + " > " + n2);
        }
        byte[] byArray2 = new byte[n3];
        System.arraycopy(byArray, n, byArray2, 0, Math.min(byArray.length - n, n3));
        return byArray2;
    }

    public static short[] copyOfRange(short @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] sArray, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 0) {
            throw new IllegalArgumentException(n + " > " + n2);
        }
        short[] sArray2 = new short[n3];
        System.arraycopy(sArray, n, sArray2, 0, Math.min(sArray.length - n, n3));
        return sArray2;
    }

    public static int[] copyOfRange(int @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] nArray, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 0) {
            throw new IllegalArgumentException(n + " > " + n2);
        }
        int[] nArray2 = new int[n3];
        System.arraycopy(nArray, n, nArray2, 0, Math.min(nArray.length - n, n3));
        return nArray2;
    }

    public static long[] copyOfRange(long @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] lArray, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 0) {
            throw new IllegalArgumentException(n + " > " + n2);
        }
        long[] lArray2 = new long[n3];
        System.arraycopy(lArray, n, lArray2, 0, Math.min(lArray.length - n, n3));
        return lArray2;
    }

    public static char[] copyOfRange(char @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] cArray, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 0) {
            throw new IllegalArgumentException(n + " > " + n2);
        }
        char[] cArray2 = new char[n3];
        System.arraycopy(cArray, n, cArray2, 0, Math.min(cArray.length - n, n3));
        return cArray2;
    }

    public static float[] copyOfRange(float @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] fArray, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 0) {
            throw new IllegalArgumentException(n + " > " + n2);
        }
        float[] fArray2 = new float[n3];
        System.arraycopy(fArray, n, fArray2, 0, Math.min(fArray.length - n, n3));
        return fArray2;
    }

    public static double[] copyOfRange(double @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] dArray, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 0) {
            throw new IllegalArgumentException(n + " > " + n2);
        }
        double[] dArray2 = new double[n3];
        System.arraycopy(dArray, n, dArray2, 0, Math.min(dArray.length - n, n3));
        return dArray2;
    }

    public static boolean[] copyOfRange(boolean @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] blArray, int n, int n2) {
        int n3 = n2 - n;
        if (n3 < 0) {
            throw new IllegalArgumentException(n + " > " + n2);
        }
        boolean[] blArray2 = new boolean[n3];
        System.arraycopy(blArray, n, blArray2, 0, Math.min(blArray.length - n, n3));
        return blArray2;
    }

    @SafeVarargs
    @SuppressWarnings(value={"varargs", "unchecked"})
    public static <T> @Mutable List<T> asList(T ... TArray) {
        return new ArrayList<T>(TArray);
    }

    @Pure
    public static int hashCode(@ReadOnly long @Nullable @org.checkerframework.checker.igj.qual.ReadOnly [] lArray) {
        if (lArray == null) {
            return 0;
        }
        int n = 1;
        for (long l : lArray) {
            int n2 = (int)(l ^ l >>> 32);
            n = 31 * n + n2;
        }
        return n;
    }

    @Pure
    public static int hashCode(@ReadOnly int @Nullable @org.checkerframework.checker.igj.qual.ReadOnly [] nArray) {
        if (nArray == null) {
            return 0;
        }
        int n = 1;
        for (int n2 : nArray) {
            n = 31 * n + n2;
        }
        return n;
    }

    @Pure
    public static int hashCode(@ReadOnly short @Nullable @org.checkerframework.checker.igj.qual.ReadOnly [] sArray) {
        if (sArray == null) {
            return 0;
        }
        int n = 1;
        for (short s : sArray) {
            n = 31 * n + s;
        }
        return n;
    }

    @Pure
    public static int hashCode(@ReadOnly char @Nullable @org.checkerframework.checker.igj.qual.ReadOnly [] cArray) {
        if (cArray == null) {
            return 0;
        }
        int n = 1;
        for (char c : cArray) {
            n = 31 * n + c;
        }
        return n;
    }

    @Pure
    public static int hashCode(@ReadOnly byte @Nullable @org.checkerframework.checker.igj.qual.ReadOnly [] byArray) {
        if (byArray == null) {
            return 0;
        }
        int n = 1;
        for (byte by : byArray) {
            n = 31 * n + by;
        }
        return n;
    }

    @Pure
    public static int hashCode(@ReadOnly boolean @Nullable @org.checkerframework.checker.igj.qual.ReadOnly [] blArray) {
        if (blArray == null) {
            return 0;
        }
        int n = 1;
        for (boolean bl : blArray) {
            n = 31 * n + (bl ? 1231 : 1237);
        }
        return n;
    }

    @Pure
    public static int hashCode(@ReadOnly float @Nullable @org.checkerframework.checker.igj.qual.ReadOnly [] fArray) {
        if (fArray == null) {
            return 0;
        }
        int n = 1;
        for (float f : fArray) {
            n = 31 * n + Float.floatToIntBits(f);
        }
        return n;
    }

    @Pure
    public static int hashCode(@ReadOnly double @Nullable @org.checkerframework.checker.igj.qual.ReadOnly [] dArray) {
        if (dArray == null) {
            return 0;
        }
        int n = 1;
        for (double d : dArray) {
            long l = Double.doubleToLongBits(d);
            n = 31 * n + (int)(l ^ l >>> 32);
        }
        return n;
    }

    @Pure
    public static int hashCode(@PolyNull @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] objectArray) {
        if (objectArray == null) {
            return 0;
        }
        int n = 1;
        for (Object object : objectArray) {
            n = 31 * n + (object == null ? 0 : object.hashCode());
        }
        return n;
    }

    @Pure
    public static int deepHashCode(@PolyNull @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] objectArray) {
        if (objectArray == null) {
            return 0;
        }
        int n = 1;
        for (Object object : objectArray) {
            int n2 = 0;
            if (object instanceof Object[]) {
                n2 = Arrays.deepHashCode((Object[])object);
            } else if (object instanceof byte[]) {
                n2 = Arrays.hashCode((byte[])object);
            } else if (object instanceof short[]) {
                n2 = Arrays.hashCode((short[])object);
            } else if (object instanceof int[]) {
                n2 = Arrays.hashCode((int[])object);
            } else if (object instanceof long[]) {
                n2 = Arrays.hashCode((long[])object);
            } else if (object instanceof char[]) {
                n2 = Arrays.hashCode((char[])object);
            } else if (object instanceof float[]) {
                n2 = Arrays.hashCode((float[])object);
            } else if (object instanceof double[]) {
                n2 = Arrays.hashCode((double[])object);
            } else if (object instanceof boolean[]) {
                n2 = Arrays.hashCode((boolean[])object);
            } else if (object != null) {
                n2 = object.hashCode();
            }
            n = 31 * n + n2;
        }
        return n;
    }

    @Pure
    public static boolean deepEquals(@PolyNull @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] objectArray, @PolyNull @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] objectArray2) {
        if (objectArray == objectArray2) {
            return true;
        }
        if (objectArray == null || objectArray2 == null) {
            return false;
        }
        int n = objectArray.length;
        if (objectArray2.length != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            Object object = objectArray[i];
            Object object2 = objectArray2[i];
            if (object == object2) continue;
            if (object == null) {
                return false;
            }
            boolean bl = Arrays.deepEquals0(object, object2);
            if (bl) continue;
            return false;
        }
        return true;
    }

    static boolean deepEquals0(Object object, Object object2) {
        assert (object != null);
        boolean bl = object instanceof Object[] && object2 instanceof Object[] ? Arrays.deepEquals((Object[])object, (Object[])object2) : (object instanceof byte[] && object2 instanceof byte[] ? Arrays.equals((byte[])object, (byte[])object2) : (object instanceof short[] && object2 instanceof short[] ? Arrays.equals((short[])object, (short[])object2) : (object instanceof int[] && object2 instanceof int[] ? Arrays.equals((int[])object, (int[])object2) : (object instanceof long[] && object2 instanceof long[] ? Arrays.equals((long[])object, (long[])object2) : (object instanceof char[] && object2 instanceof char[] ? Arrays.equals((char[])object, (char[])object2) : (object instanceof float[] && object2 instanceof float[] ? Arrays.equals((float[])object, (float[])object2) : (object instanceof double[] && object2 instanceof double[] ? Arrays.equals((double[])object, (double[])object2) : (object instanceof boolean[] && object2 instanceof boolean[] ? Arrays.equals((boolean[])object, (boolean[])object2) : object.equals(object2)))))))));
        return bl;
    }

    @SideEffectFree
    public static String toString(long @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] lArray) {
        if (lArray == null) {
            return "null";
        }
        int n = lArray.length - 1;
        if (n == -1) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n2 = 0;
        while (true) {
            stringBuilder.append(lArray[n2]);
            if (n2 == n) {
                return stringBuilder.append(']').toString();
            }
            stringBuilder.append(", ");
            ++n2;
        }
    }

    @SideEffectFree
    public static String toString(int @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] nArray) {
        if (nArray == null) {
            return "null";
        }
        int n = nArray.length - 1;
        if (n == -1) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n2 = 0;
        while (true) {
            stringBuilder.append(nArray[n2]);
            if (n2 == n) {
                return stringBuilder.append(']').toString();
            }
            stringBuilder.append(", ");
            ++n2;
        }
    }

    @SideEffectFree
    public static String toString(short @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] sArray) {
        if (sArray == null) {
            return "null";
        }
        int n = sArray.length - 1;
        if (n == -1) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n2 = 0;
        while (true) {
            stringBuilder.append(sArray[n2]);
            if (n2 == n) {
                return stringBuilder.append(']').toString();
            }
            stringBuilder.append(", ");
            ++n2;
        }
    }

    @SideEffectFree
    public static String toString(char @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] cArray) {
        if (cArray == null) {
            return "null";
        }
        int n = cArray.length - 1;
        if (n == -1) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n2 = 0;
        while (true) {
            stringBuilder.append(cArray[n2]);
            if (n2 == n) {
                return stringBuilder.append(']').toString();
            }
            stringBuilder.append(", ");
            ++n2;
        }
    }

    @SideEffectFree
    public static String toString(byte @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] byArray) {
        if (byArray == null) {
            return "null";
        }
        int n = byArray.length - 1;
        if (n == -1) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n2 = 0;
        while (true) {
            stringBuilder.append(byArray[n2]);
            if (n2 == n) {
                return stringBuilder.append(']').toString();
            }
            stringBuilder.append(", ");
            ++n2;
        }
    }

    @SideEffectFree
    public static String toString(boolean @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] blArray) {
        if (blArray == null) {
            return "null";
        }
        int n = blArray.length - 1;
        if (n == -1) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n2 = 0;
        while (true) {
            stringBuilder.append(blArray[n2]);
            if (n2 == n) {
                return stringBuilder.append(']').toString();
            }
            stringBuilder.append(", ");
            ++n2;
        }
    }

    @SideEffectFree
    public static String toString(float @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] fArray) {
        if (fArray == null) {
            return "null";
        }
        int n = fArray.length - 1;
        if (n == -1) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n2 = 0;
        while (true) {
            stringBuilder.append(fArray[n2]);
            if (n2 == n) {
                return stringBuilder.append(']').toString();
            }
            stringBuilder.append(", ");
            ++n2;
        }
    }

    @SideEffectFree
    public static String toString(double @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] dArray) {
        if (dArray == null) {
            return "null";
        }
        int n = dArray.length - 1;
        if (n == -1) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n2 = 0;
        while (true) {
            stringBuilder.append(dArray[n2]);
            if (n2 == n) {
                return stringBuilder.append(']').toString();
            }
            stringBuilder.append(", ");
            ++n2;
        }
    }

    @SideEffectFree
    public static String toString(@PolyNull @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] objectArray) {
        if (objectArray == null) {
            return "null";
        }
        int n = objectArray.length - 1;
        if (n == -1) {
            return "[]";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('[');
        int n2 = 0;
        while (true) {
            stringBuilder.append(String.valueOf(objectArray[n2]));
            if (n2 == n) {
                return stringBuilder.append(']').toString();
            }
            stringBuilder.append(", ");
            ++n2;
        }
    }

    @SideEffectFree
    public static String deepToString(@PolyNull @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly Object @Nullable @org.checkerframework.checker.igj.qual.ReadOnly @ReadOnly [] objectArray) {
        if (objectArray == null) {
            return "null";
        }
        int n = 20 * objectArray.length;
        if (objectArray.length != 0 && n <= 0) {
            n = Integer.MAX_VALUE;
        }
        StringBuilder stringBuilder = new StringBuilder(n);
        Arrays.deepToString(objectArray, stringBuilder, new HashSet<Object[]>());
        return stringBuilder.toString();
    }

    private static void deepToString(Object[] objectArray, StringBuilder stringBuilder, Set<Object[]> set) {
        if (objectArray == null) {
            stringBuilder.append("null");
            return;
        }
        int n = objectArray.length - 1;
        if (n == -1) {
            stringBuilder.append("[]");
            return;
        }
        set.add(objectArray);
        stringBuilder.append('[');
        int n2 = 0;
        while (true) {
            Object object;
            if ((object = objectArray[n2]) == null) {
                stringBuilder.append("null");
            } else {
                Class<?> clazz = object.getClass();
                if (clazz.isArray()) {
                    if (clazz == byte[].class) {
                        stringBuilder.append(Arrays.toString((byte[])object));
                    } else if (clazz == short[].class) {
                        stringBuilder.append(Arrays.toString((short[])object));
                    } else if (clazz == int[].class) {
                        stringBuilder.append(Arrays.toString((int[])object));
                    } else if (clazz == long[].class) {
                        stringBuilder.append(Arrays.toString((long[])object));
                    } else if (clazz == char[].class) {
                        stringBuilder.append(Arrays.toString((char[])object));
                    } else if (clazz == float[].class) {
                        stringBuilder.append(Arrays.toString((float[])object));
                    } else if (clazz == double[].class) {
                        stringBuilder.append(Arrays.toString((double[])object));
                    } else if (clazz == boolean[].class) {
                        stringBuilder.append(Arrays.toString((boolean[])object));
                    } else if (set.contains(object)) {
                        stringBuilder.append("[...]");
                    } else {
                        Arrays.deepToString((Object[])object, stringBuilder, set);
                    }
                } else {
                    stringBuilder.append(object.toString());
                }
            }
            if (n2 == n) break;
            stringBuilder.append(", ");
            ++n2;
        }
        stringBuilder.append(']');
        set.remove(objectArray);
    }

    private static class ArrayList<E>
    extends AbstractList<E>
    implements RandomAccess,
    Serializable {
        private static final long serialVersionUID = -2764017481108945198L;
        private final E[] a;

        ArrayList(E[] array) {
            this.a = Objects.requireNonNull(array);
        }

        @Override
        public int size() {
            return this.a.length;
        }

        @Override
        public Object[] toArray() {
            return Arrays.copyOf(this.a, this.a.length, Object[].class);
        }

        @Override
        public <T> T[] toArray(T[] a) {
            int size = this.size();
            if (a.length < size) {
                return Arrays.copyOf(this.a, size, a.getClass());
            }
            System.arraycopy(this.a, 0, a, 0, size);
            if (a.length > size) {
                a[size] = null;
            }
            return a;
        }

        @Override
        public E get(int index) {
            return this.a[index];
        }

        @Override
        public E set(int index, E element) {
            E oldValue = this.a[index];
            this.a[index] = element;
            return oldValue;
        }

        @Override
        public int indexOf(Object o) {
            E[] a = this.a;
            if (o == null) {
                for (int i = 0; i < a.length; ++i) {
                    if (a[i] != null) continue;
                    return i;
                }
            } else {
                for (int i = 0; i < a.length; ++i) {
                    if (!o.equals(a[i])) continue;
                    return i;
                }
            }
            return -1;
        }

        @Override
        public boolean contains(Object o) {
            return this.indexOf(o) >= 0;
        }

        public Spliterator<E> spliterator() {
            return Spliterators.spliterator(this.a, 16);
        }

        public void forEach(Consumer<? super E> action) {
            Objects.requireNonNull(action);
            for (E e : this.a) {
                action.accept(e);
            }
        }

        public void replaceAll(UnaryOperator<E> operator) {
            Objects.requireNonNull(operator);
            E[] a = this.a;
            for (int i = 0; i < a.length; ++i) {
                a[i] = operator.apply(a[i]);
            }
        }

        public void sort(Comparator<? super E> c) {
            Arrays.sort(this.a, c);
        }

        @Override
        public Iterator<E> iterator() {
            return new ArrayItr<E>(this.a);
        }
    }

    static final class LegacyMergeSort {
        private static final boolean userRequested = AccessController.doPrivileged(new GetBooleanAction("java.util.Arrays.useLegacyMergeSort"));

        LegacyMergeSort() {
        }
    }
}

