/*
 * Decompiled with CFR 0.152.
 */
package java.lang.reflect;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.lang.reflect.ReflectPermission;
import java.security.AccessController;
import java.security.Permission;
import org.checkerframework.checker.javari.qual.ReadOnly;
import sun.reflect.Reflection;
import sun.reflect.ReflectionFactory;

public class AccessibleObject
implements AnnotatedElement {
    private static final Permission ACCESS_PERMISSION = new ReflectPermission("suppressAccessChecks");
    boolean override;
    static final ReflectionFactory reflectionFactory = (ReflectionFactory)AccessController.doPrivileged(new ReflectionFactory.GetReflectionFactoryAction());
    volatile Object securityCheckCache;

    public static void setAccessible(AccessibleObject[] accessibleObjectArray, boolean bl) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(ACCESS_PERMISSION);
        }
        for (int i = 0; i < accessibleObjectArray.length; ++i) {
            AccessibleObject.setAccessible0(accessibleObjectArray[i], bl);
        }
    }

    public void setAccessible(boolean bl) throws SecurityException {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(ACCESS_PERMISSION);
        }
        AccessibleObject.setAccessible0(this, bl);
    }

    private static void setAccessible0(AccessibleObject accessibleObject, boolean bl) throws SecurityException {
        Constructor constructor;
        if (accessibleObject instanceof Constructor && bl && (constructor = (Constructor)accessibleObject).getDeclaringClass() == Class.class) {
            throw new SecurityException("Can not make a java.lang.Class constructor accessible");
        }
        accessibleObject.override = bl;
    }

    public boolean isAccessible(@ReadOnly AccessibleObject this) {
        return this.override;
    }

    protected AccessibleObject() {
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> clazz) {
        throw new AssertionError((Object)"All subclasses should override this method");
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> clazz) {
        return this.getAnnotation(clazz) != null;
    }

    @Override
    public Annotation[] getAnnotations() {
        return this.getDeclaredAnnotations();
    }

    @Override
    public Annotation[] getDeclaredAnnotations() {
        throw new AssertionError((Object)"All subclasses should override this method");
    }

    void checkAccess(Class<?> clazz, Class<?> clazz2, Object object, int n) throws IllegalAccessException {
        Class[] classArray;
        if (clazz == clazz2) {
            return;
        }
        Object object2 = this.securityCheckCache;
        Class<?> clazz3 = clazz2;
        if (object != null && Modifier.isProtected(n) && (clazz3 = object.getClass()) != clazz2 ? object2 instanceof Class[] && (classArray = (Class[])object2)[1] == clazz3 && classArray[0] == clazz : object2 == clazz) {
            return;
        }
        this.slowCheckMemberAccess(clazz, clazz2, object, n, clazz3);
    }

    void slowCheckMemberAccess(Class<?> classArray, Class<?> clazz, Object object, int n, Class<?> clazz2) throws IllegalAccessException {
        Class[] classArray2;
        Class[] classArray3;
        Reflection.ensureMemberAccess(classArray, clazz, (Object)object, (int)n);
        if (clazz2 == clazz) {
            classArray3 = classArray;
        } else {
            Class[] classArray4 = new Class[2];
            classArray4[0] = classArray;
            classArray3 = classArray4;
            classArray4[1] = clazz2;
        }
        this.securityCheckCache = classArray2 = classArray3;
    }
}

