/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FileCleanable;
import java.io.IOException;
import java.io.SyncFailedException;
import java.util.concurrent.atomic.AtomicInteger;
import jdk.internal.ref.PhantomCleanable;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.framework.qual.DefaultQualifier;
import sun.misc.JavaIOFileDescriptorAccess;
import sun.misc.SharedSecrets;

@DefaultQualifier(value=NonNull.class)
public final class FileDescriptor {
    private int fd;
    private AtomicInteger useCount;
    public static final FileDescriptor in = new FileDescriptor(0);
    public static final FileDescriptor out = new FileDescriptor(1);
    public static final FileDescriptor err = new FileDescriptor(2);

    public FileDescriptor() {
        this.fd = -1;
        this.useCount = new AtomicInteger();
    }

    private FileDescriptor(int n) {
        this.fd = n;
        this.useCount = new AtomicInteger();
    }

    public boolean valid() {
        return this.fd != -1;
    }

    public native void sync() throws SyncFailedException;

    private static native void initIDs();

    int incrementAndGetUseCount() {
        return this.useCount.incrementAndGet();
    }

    int decrementAndGetUseCount() {
        return this.useCount.decrementAndGet();
    }

    static /* synthetic */ int access$002(FileDescriptor fileDescriptor, int n) {
        fileDescriptor.fd = n;
        return fileDescriptor.fd;
    }

    static /* synthetic */ int access$000(FileDescriptor fileDescriptor) {
        return fileDescriptor.fd;
    }

    static {
        FileDescriptor.initIDs();
        SharedSecrets.setJavaIOFileDescriptorAccess((JavaIOFileDescriptorAccess)new jdk.internal.access.JavaIOFileDescriptorAccess(){

            @Override
            public void set(FileDescriptor fdo, int fd) {
                fdo.set(fd);
            }

            @Override
            public int get(FileDescriptor fdo) {
                return fdo.fd;
            }

            @Override
            public void setAppend(FileDescriptor fdo, boolean append) {
                fdo.append = append;
            }

            @Override
            public boolean getAppend(FileDescriptor fdo) {
                return fdo.append;
            }

            @Override
            public void close(FileDescriptor fdo) throws IOException {
                fdo.close();
            }

            @Override
            public void registerCleanup(FileDescriptor fdo) {
                FileCleanable.register(fdo);
            }

            @Override
            public void registerCleanup(FileDescriptor fdo, PhantomCleanable<FileDescriptor> cleanup) {
                fdo.registerCleanup(cleanup);
            }

            @Override
            public void unregisterCleanup(FileDescriptor fdo) {
                fdo.unregisterCleanup();
            }

            @Override
            public void setHandle(FileDescriptor fdo, long handle) {
                fdo.setHandle(handle);
            }

            @Override
            public long getHandle(FileDescriptor fdo) {
                return fdo.handle;
            }
        });
    }
}

