/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.livevariable;

import java.util.List;
import org.checkerframework.dataflow.analysis.BackwardTransferFunction;
import org.checkerframework.dataflow.analysis.RegularTransferResult;
import org.checkerframework.dataflow.analysis.TransferInput;
import org.checkerframework.dataflow.analysis.TransferResult;
import org.checkerframework.dataflow.analysis.UnusedAbstractValue;
import org.checkerframework.dataflow.cfg.UnderlyingAST;
import org.checkerframework.dataflow.cfg.node.AbstractNodeVisitor;
import org.checkerframework.dataflow.cfg.node.AssignmentNode;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.ObjectCreationNode;
import org.checkerframework.dataflow.cfg.node.ReturnNode;
import org.checkerframework.dataflow.livevariable.LiveVarNode;
import org.checkerframework.dataflow.livevariable.LiveVarStore;
import org.checkerframework.dataflow.qual.SideEffectFree;

public class LiveVarTransfer
extends AbstractNodeVisitor<TransferResult<UnusedAbstractValue, LiveVarStore>, TransferInput<UnusedAbstractValue, LiveVarStore>>
implements BackwardTransferFunction<UnusedAbstractValue, LiveVarStore> {
    @Override
    @SideEffectFree
    public LiveVarStore initialNormalExitStore(UnderlyingAST underlyingAST, List<ReturnNode> returnNodes) {
        return new LiveVarStore();
    }

    @Override
    public LiveVarStore initialExceptionalExitStore(UnderlyingAST underlyingAST) {
        return new LiveVarStore();
    }

    @Override
    public RegularTransferResult<UnusedAbstractValue, LiveVarStore> visitNode(Node n, TransferInput<UnusedAbstractValue, LiveVarStore> p) {
        return new RegularTransferResult<Object, LiveVarStore>(null, p.getRegularStore());
    }

    @Override
    public RegularTransferResult<UnusedAbstractValue, LiveVarStore> visitAssignment(AssignmentNode n, TransferInput<UnusedAbstractValue, LiveVarStore> p) {
        RegularTransferResult transferResult = (RegularTransferResult)super.visitAssignment(n, p);
        this.processLiveVarInAssignment(n.getTarget(), n.getExpression(), (LiveVarStore)transferResult.getRegularStore());
        return transferResult;
    }

    @Override
    public RegularTransferResult<UnusedAbstractValue, LiveVarStore> visitMethodInvocation(MethodInvocationNode n, TransferInput<UnusedAbstractValue, LiveVarStore> p) {
        RegularTransferResult transferResult = (RegularTransferResult)super.visitMethodInvocation(n, p);
        LiveVarStore store = (LiveVarStore)transferResult.getRegularStore();
        for (Node arg : n.getArguments()) {
            store.addUseInExpression(arg);
        }
        return transferResult;
    }

    @Override
    public RegularTransferResult<UnusedAbstractValue, LiveVarStore> visitObjectCreation(ObjectCreationNode n, TransferInput<UnusedAbstractValue, LiveVarStore> p) {
        RegularTransferResult transferResult = (RegularTransferResult)super.visitObjectCreation(n, p);
        LiveVarStore store = (LiveVarStore)transferResult.getRegularStore();
        for (Node arg : n.getArguments()) {
            store.addUseInExpression(arg);
        }
        return transferResult;
    }

    @Override
    public RegularTransferResult<UnusedAbstractValue, LiveVarStore> visitReturn(ReturnNode n, TransferInput<UnusedAbstractValue, LiveVarStore> p) {
        RegularTransferResult transferResult = (RegularTransferResult)super.visitReturn(n, p);
        Node result = n.getResult();
        if (result != null) {
            LiveVarStore store = (LiveVarStore)transferResult.getRegularStore();
            store.addUseInExpression(result);
        }
        return transferResult;
    }

    private void processLiveVarInAssignment(Node variable, Node expression, LiveVarStore store) {
        store.killLiveVar(new LiveVarNode(variable));
        store.addUseInExpression(expression);
    }
}

