/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.expression;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.analysis.Store;
import org.checkerframework.dataflow.expression.ClassName;
import org.checkerframework.dataflow.expression.JavaExpression;
import org.checkerframework.dataflow.expression.JavaExpressionVisitor;
import org.checkerframework.dataflow.expression.SuperReference;
import org.checkerframework.dataflow.expression.ThisReference;
import org.checkerframework.dataflow.util.PurityUtils;
import org.checkerframework.javacutil.AnnotationProvider;

public class MethodCall
extends JavaExpression {
    protected final ExecutableElement method;
    protected final JavaExpression receiver;
    protected final List<JavaExpression> arguments;

    public MethodCall(TypeMirror type, ExecutableElement method, JavaExpression receiver, List<JavaExpression> arguments) {
        super(type);
        this.receiver = receiver;
        this.arguments = arguments;
        this.method = method;
    }

    public ExecutableElement getElement() {
        return this.method;
    }

    public JavaExpression getReceiver() {
        return this.receiver;
    }

    public List<JavaExpression> getArguments() {
        return Collections.unmodifiableList(this.arguments);
    }

    @Override
    public <T extends JavaExpression> @Nullable T containedOfClass(Class<T> clazz) {
        if (this.getClass() == clazz) {
            return (T)this;
        }
        T result = this.receiver.containedOfClass(clazz);
        if (result != null) {
            return result;
        }
        for (JavaExpression p : this.arguments) {
            result = p.containedOfClass(clazz);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    @Override
    public boolean isDeterministic(AnnotationProvider provider) {
        return (PurityUtils.isDeterministic(provider, this.method) || provider.isDeterministic(this.method)) && MethodCall.listIsDeterministic(this.arguments, provider);
    }

    @Override
    public boolean isAssignableByOtherCode() {
        return this.receiver.isModifiableByOtherCode() || this.arguments.stream().anyMatch(JavaExpression::isModifiableByOtherCode);
    }

    @Override
    public boolean isModifiableByOtherCode() {
        return this.isAssignableByOtherCode();
    }

    @Override
    public boolean syntacticEquals(JavaExpression je) {
        if (!(je instanceof MethodCall)) {
            return false;
        }
        MethodCall other = (MethodCall)je;
        return this.method.equals(other.method) && this.receiver.syntacticEquals(other.receiver) && JavaExpression.syntacticEqualsList(this.arguments, other.arguments);
    }

    @Override
    public boolean containsSyntacticEqualJavaExpression(JavaExpression other) {
        return this.syntacticEquals(other) || this.receiver.containsSyntacticEqualJavaExpression(other) || JavaExpression.listContainsSyntacticEqualJavaExpression(this.arguments, other);
    }

    @Override
    public boolean containsModifiableAliasOf(Store<?> store, JavaExpression other) {
        if (this.receiver.containsModifiableAliasOf(store, other)) {
            return true;
        }
        for (JavaExpression p : this.arguments) {
            if (!p.containsModifiableAliasOf(store, other)) continue;
            return true;
        }
        return false;
    }

    public boolean equals(@Nullable Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof MethodCall)) {
            return false;
        }
        if (this.method.getKind() == ElementKind.CONSTRUCTOR) {
            return false;
        }
        MethodCall other = (MethodCall)obj;
        boolean isComparingSuperWithThis = this.receiver instanceof SuperReference && other.receiver instanceof ThisReference || this.receiver instanceof ThisReference && other.receiver instanceof SuperReference;
        return this.method.equals(other.method) && (this.receiver.equals(other.receiver) || isComparingSuperWithThis) && this.arguments.equals(other.arguments);
    }

    public int hashCode() {
        if (this.method.getKind() == ElementKind.CONSTRUCTOR) {
            return System.identityHashCode(this);
        }
        return Objects.hash(this.method, this.receiver, this.arguments);
    }

    public String toString() {
        StringBuilder preParen = new StringBuilder();
        if (this.receiver instanceof ClassName) {
            preParen.append(this.receiver.getType());
        } else {
            preParen.append(this.receiver);
        }
        preParen.append(".");
        String methodName = this.method.getSimpleName().toString();
        preParen.append(methodName);
        preParen.append("(");
        StringJoiner result = new StringJoiner(", ", preParen, ")");
        for (JavaExpression argument : this.arguments) {
            result.add(argument.toString());
        }
        return result.toString();
    }

    @Override
    public <R, P> R accept(JavaExpressionVisitor<R, P> visitor, P p) {
        return visitor.visitMethodCall(this, p);
    }
}

