/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.util;

import com.sun.source.tree.MethodTree;
import java.util.EnumSet;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import org.checkerframework.dataflow.qual.Deterministic;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.javacutil.AnnotationProvider;
import org.checkerframework.javacutil.BugInCF;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.TreeUtils;

public class PurityUtils {
    private static final EnumSet<Pure.Kind> detAndSeFree = EnumSet.of(Pure.Kind.DETERMINISTIC, Pure.Kind.SIDE_EFFECT_FREE);

    private PurityUtils() {
        throw new Error("Do not instantiate PurityUtils.");
    }

    public static boolean hasPurityAnnotation(AnnotationProvider provider, MethodTree methodTree) {
        return !PurityUtils.getPurityKinds(provider, methodTree).isEmpty();
    }

    public static boolean hasPurityAnnotation(AnnotationProvider provider, ExecutableElement methodElement) {
        return !PurityUtils.getPurityKinds(provider, methodElement).isEmpty();
    }

    public static boolean isDeterministic(AnnotationProvider provider, MethodTree methodTree) {
        ExecutableElement methodElement = TreeUtils.elementFromDeclaration((MethodTree)methodTree);
        if (methodElement == null) {
            throw new BugInCF("Could not find element for tree: " + methodTree);
        }
        return PurityUtils.isDeterministic(provider, methodElement);
    }

    public static boolean isDeterministic(AnnotationProvider provider, ExecutableElement methodElement) {
        EnumSet<Pure.Kind> kinds = PurityUtils.getPurityKinds(provider, methodElement);
        return kinds.contains(Pure.Kind.DETERMINISTIC);
    }

    @Deprecated
    public static boolean isSideEffectFree(AnnotationProvider provider, MethodTree methodTree) {
        ExecutableElement methodElement = TreeUtils.elementFromDeclaration((MethodTree)methodTree);
        if (methodElement == null) {
            throw new BugInCF("Could not find element for tree: " + methodTree);
        }
        return PurityUtils.isSideEffectFree(provider, methodElement);
    }

    public static boolean isSideEffectFree(AnnotationProvider provider, ExecutableElement methodElement) {
        EnumSet<Pure.Kind> kinds = PurityUtils.getPurityKinds(provider, methodElement);
        return kinds.contains(Pure.Kind.SIDE_EFFECT_FREE);
    }

    public static EnumSet<Pure.Kind> getPurityKinds(AnnotationProvider provider, MethodTree methodTree) {
        ExecutableElement methodElement = TreeUtils.elementFromDeclaration((MethodTree)methodTree);
        if (methodElement == null) {
            throw new BugInCF("Could not find element for tree: " + methodTree);
        }
        return PurityUtils.getPurityKinds(provider, methodElement);
    }

    public static EnumSet<Pure.Kind> getPurityKinds(AnnotationProvider provider, ExecutableElement methodElement) {
        if (ElementUtils.isRecordAccessor((ExecutableElement)methodElement) && ElementUtils.isAutoGeneratedRecordMember((Element)methodElement)) {
            return detAndSeFree;
        }
        AnnotationMirror pureAnnotation = provider.getDeclAnnotation((Element)methodElement, Pure.class);
        AnnotationMirror sefAnnotation = provider.getDeclAnnotation((Element)methodElement, SideEffectFree.class);
        AnnotationMirror detAnnotation = provider.getDeclAnnotation((Element)methodElement, Deterministic.class);
        if (pureAnnotation != null) {
            return detAndSeFree;
        }
        EnumSet<Pure.Kind> result = EnumSet.noneOf(Pure.Kind.class);
        if (sefAnnotation != null) {
            result.add(Pure.Kind.SIDE_EFFECT_FREE);
        }
        if (detAnnotation != null) {
            result.add(Pure.Kind.DETERMINISTIC);
        }
        return result;
    }
}

