/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.node;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.Tree;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.lang.model.element.Element;
import javax.lang.model.element.VariableElement;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.javacutil.BugInCF;
import org.checkerframework.javacutil.ElementUtils;
import org.checkerframework.javacutil.TreeUtils;

public class FieldAccessNode
extends Node {
    protected final Tree tree;
    protected final VariableElement element;
    protected final String field;
    protected final Node receiver;

    public FieldAccessNode(Tree tree, Node receiver) {
        super(TreeUtils.typeOf((Tree)tree));
        assert (TreeUtils.isFieldAccess((Tree)tree));
        this.tree = tree;
        this.receiver = receiver;
        this.field = TreeUtils.getFieldName((Tree)tree);
        if (tree instanceof MemberSelectTree) {
            MemberSelectTree mstree = (MemberSelectTree)tree;
            assert (TreeUtils.isUseOfElement((ExpressionTree)mstree)) : "@AssumeAssertion(nullness): tree kind";
            this.element = TreeUtils.variableElementFromUse((ExpressionTree)mstree);
        } else if (tree instanceof IdentifierTree) {
            IdentifierTree itree = (IdentifierTree)tree;
            assert (TreeUtils.isUseOfElement((ExpressionTree)itree)) : "@AssumeAssertion(nullness): tree kind";
            this.element = TreeUtils.variableElementFromUse((ExpressionTree)itree);
        } else {
            throw new BugInCF("unexpected tree %s [%s]", new Object[]{tree, tree.getClass()});
        }
    }

    public FieldAccessNode(Tree tree, VariableElement element, Node receiver) {
        super(element.asType());
        this.tree = tree;
        this.element = element;
        this.receiver = receiver;
        this.field = element.getSimpleName().toString();
    }

    public VariableElement getElement() {
        return this.element;
    }

    public Node getReceiver() {
        return this.receiver;
    }

    public String getFieldName() {
        return this.field;
    }

    @Override
    public Tree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitFieldAccess(this, p);
    }

    public String toString() {
        return this.getReceiver() + "." + this.field;
    }

    public boolean isStatic() {
        return ElementUtils.isStatic((Element)this.getElement());
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof FieldAccessNode)) {
            return false;
        }
        FieldAccessNode other = (FieldAccessNode)obj;
        return this.getReceiver().equals(other.getReceiver()) && this.getFieldName().equals(other.getFieldName());
    }

    public int hashCode() {
        return Objects.hash(this.getReceiver(), this.getFieldName());
    }

    @Override
    @SideEffectFree
    public Collection<Node> getOperands() {
        return Collections.singletonList(this.receiver);
    }
}

