/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.dataflow.cfg.node;

import com.sun.source.tree.BinaryTree;
import com.sun.source.tree.Tree;
import java.util.Objects;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.cfg.node.BinaryOperationNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.NodeVisitor;

public class BitwiseXorNode
extends BinaryOperationNode {
    public BitwiseXorNode(BinaryTree tree, Node left, Node right) {
        super(tree, left, right);
        assert (tree.getKind() == Tree.Kind.XOR);
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitBitwiseXor(this, p);
    }

    public String toString() {
        return "(" + this.getLeftOperand() + " ^ " + this.getRightOperand() + ")";
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof BitwiseXorNode)) {
            return false;
        }
        BitwiseXorNode other = (BitwiseXorNode)obj;
        return this.getLeftOperand().equals(other.getLeftOperand()) && this.getRightOperand().equals(other.getRightOperand());
    }

    public int hashCode() {
        return Objects.hash(this.getLeftOperand(), this.getRightOperand());
    }
}

