/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.javacutil;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompoundAssignmentTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import java.util.EnumSet;
import java.util.Set;
import java.util.StringJoiner;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import org.checkerframework.shaded.checker.nullness.qual.Nullable;
import org.checkerframework.shaded.javacutil.BugInCF;
import org.checkerframework.shaded.javacutil.TreeUtils;
import org.checkerframework.shaded.javacutil.TreeUtilsAfterJava11;
import org.checkerframework.shaded.org.plumelib.util.IPair;

public final class TreePathUtil {
    private TreePathUtil() {
        throw new BugInCF("Class TreeUtils cannot be instantiated.");
    }

    public static @Nullable TreePath pathTillOfKind(TreePath path, Tree.Kind kind) {
        return TreePathUtil.pathTillOfKind(path, EnumSet.of(kind));
    }

    public static @Nullable TreePath pathTillOfKind(TreePath path, Set<Tree.Kind> kinds) {
        for (TreePath p = path; p != null; p = p.getParentPath()) {
            if (!kinds.contains((Object)p.getLeaf().getKind())) continue;
            return p;
        }
        return null;
    }

    public static @Nullable TreePath pathTillClass(TreePath path) {
        return TreePathUtil.pathTillOfKind(path, TreeUtils.classTreeKinds());
    }

    public static @Nullable TreePath pathTillMethod(TreePath path) {
        return TreePathUtil.pathTillOfKind(path, Tree.Kind.METHOD);
    }

    public static @Nullable Tree enclosingOfKind(TreePath path, Tree.Kind kind) {
        return TreePathUtil.enclosingOfKind(path, EnumSet.of(kind));
    }

    public static @Nullable Tree enclosingOfKind(TreePath path, Set<Tree.Kind> kinds) {
        TreePath p = TreePathUtil.pathTillOfKind(path, kinds);
        return p == null ? null : p.getLeaf();
    }

    public static <T extends Tree> @Nullable T enclosingOfClass(TreePath path, Class<T> treeClass) {
        for (TreePath p = path; p != null; p = p.getParentPath()) {
            Tree leaf = p.getLeaf();
            if (!treeClass.isInstance(leaf)) continue;
            return (T)((Tree)treeClass.cast(leaf));
        }
        return null;
    }

    public static @Nullable TreePath enclosingDeclarationPath(TreePath path) {
        return TreePathUtil.pathTillOfKind(path, TreeUtils.declarationTreeKinds());
    }

    public static @Nullable ClassTree enclosingClass(TreePath path) {
        return (ClassTree)TreePathUtil.enclosingOfKind(path, TreeUtils.classTreeKinds());
    }

    public static @Nullable VariableTree enclosingVariable(TreePath path) {
        return (VariableTree)TreePathUtil.enclosingOfKind(path, Tree.Kind.VARIABLE);
    }

    public static @Nullable MethodTree enclosingMethod(TreePath path) {
        return (MethodTree)TreePathUtil.enclosingOfKind(path, Tree.Kind.METHOD);
    }

    public static @Nullable Tree enclosingMethodOrLambda(TreePath path) {
        return TreePathUtil.enclosingOfKind(path, EnumSet.of(Tree.Kind.METHOD, Tree.Kind.LAMBDA_EXPRESSION));
    }

    public static @Nullable BlockTree enclosingTopLevelBlock(TreePath path) {
        for (TreePath parentPath = path.getParentPath(); parentPath != null && !TreeUtils.classTreeKinds().contains((Object)parentPath.getLeaf().getKind()); parentPath = parentPath.getParentPath()) {
            path = parentPath;
        }
        if (path.getLeaf().getKind() == Tree.Kind.BLOCK) {
            return (BlockTree)path.getLeaf();
        }
        return null;
    }

    public static IPair<Tree, Tree> enclosingNonParen(TreePath path) {
        TreePath parentPath = path.getParentPath();
        Tree enclosing = parentPath.getLeaf();
        Tree enclosingChild = path.getLeaf();
        while (enclosing.getKind() == Tree.Kind.PARENTHESIZED) {
            parentPath = parentPath.getParentPath();
            enclosingChild = enclosing;
            enclosing = parentPath.getLeaf();
        }
        return IPair.of(enclosing, enclosingChild);
    }

    public static @Nullable Tree getContextForPolyExpression(TreePath treePath) {
        boolean isLambdaOrMethodRef = treePath.getLeaf().getKind() == Tree.Kind.LAMBDA_EXPRESSION || treePath.getLeaf().getKind() == Tree.Kind.MEMBER_REFERENCE;
        return TreePathUtil.getContextForPolyExpression(treePath, isLambdaOrMethodRef);
    }

    private static @Nullable Tree getContextForPolyExpression(TreePath treePath, boolean isLambdaOrMethodRef) {
        TreePath parentPath = treePath.getParentPath();
        if (parentPath == null) {
            return null;
        }
        Tree parent = parentPath.getLeaf();
        switch (parent.getKind()) {
            case ASSIGNMENT: 
            case LAMBDA_EXPRESSION: 
            case METHOD_INVOCATION: 
            case NEW_ARRAY: 
            case RETURN: {
                return parent;
            }
            case NEW_CLASS: {
                boolean enclosingExpr;
                boolean bl = enclosingExpr = ((NewClassTree)parent).getEnclosingExpression() == treePath.getLeaf();
                if (enclosingExpr) {
                    return null;
                }
                return parent;
            }
            case TYPE_CAST: {
                if (isLambdaOrMethodRef) {
                    return parent;
                }
                return null;
            }
            case VARIABLE: {
                if (TreeUtils.isVariableTreeDeclaredUsingVar((VariableTree)parent)) {
                    return null;
                }
                return parent;
            }
            case CONDITIONAL_EXPRESSION: {
                boolean conditionIsLeaf;
                ConditionalExpressionTree cet = (ConditionalExpressionTree)parent;
                boolean bl = conditionIsLeaf = cet.getCondition() == treePath.getLeaf();
                if (conditionIsLeaf) {
                    return null;
                }
                return TreePathUtil.getContextForPolyExpression(parentPath, isLambdaOrMethodRef);
            }
            case PARENTHESIZED: 
            case CASE: {
                return TreePathUtil.getContextForPolyExpression(parentPath, isLambdaOrMethodRef);
            }
        }
        if (TreeUtils.isYield(parent)) {
            TreePath pathToCase = TreePathUtil.pathTillOfKind(parentPath, Tree.Kind.CASE);
            assert (pathToCase != null) : "@AssumeAssertion(nullness): yield statements must be enclosed in a CaseTree";
            parentPath = pathToCase.getParentPath();
            parent = parentPath.getLeaf();
        }
        if (TreeUtils.isSwitchExpression(parent)) {
            boolean switchIsLeaf;
            boolean bl = switchIsLeaf = TreeUtilsAfterJava11.SwitchExpressionUtils.getExpression(parent) == treePath.getLeaf();
            if (switchIsLeaf) {
                return null;
            }
            return TreePathUtil.getContextForPolyExpression(parentPath, isLambdaOrMethodRef);
        }
        if (parent instanceof CompoundAssignmentTree) {
            return parent;
        }
        return null;
    }

    public static boolean inConstructor(TreePath path) {
        MethodTree method = TreePathUtil.enclosingMethod(path);
        return method == null || TreeUtils.isConstructor(method);
    }

    public static boolean isTreeInStaticScope(TreePath path) {
        MethodTree enclosingMethod = TreePathUtil.enclosingMethod(path);
        if (enclosingMethod != null) {
            return enclosingMethod.getModifiers().getFlags().contains((Object)Modifier.STATIC);
        }
        BlockTree block = TreePathUtil.enclosingTopLevelBlock(path);
        if (block != null) {
            return block.isStatic();
        }
        VariableTree t = TreePathUtil.enclosingVariable(path);
        if (t != null) {
            return t.getModifiers().getFlags().contains((Object)Modifier.STATIC);
        }
        ClassTree classTree = TreePathUtil.enclosingClass(path);
        if (classTree != null) {
            return classTree.getModifiers().getFlags().contains((Object)Modifier.STATIC);
        }
        return false;
    }

    public static boolean isTopLevelAssignmentInInitializerBlock(TreePath path) {
        TreePath origPath = path;
        if (path.getLeaf().getKind() != Tree.Kind.ASSIGNMENT) {
            return false;
        }
        if ((path = path.getParentPath()).getLeaf().getKind() != Tree.Kind.EXPRESSION_STATEMENT) {
            return false;
        }
        Tree prevLeaf = path.getLeaf();
        path = path.getParentPath();
        for (Tree leaf : path) {
            switch (leaf.getKind()) {
                case CLASS: 
                case ENUM: 
                case PARAMETERIZED_TYPE: {
                    return prevLeaf.getKind() == Tree.Kind.BLOCK;
                }
                case COMPILATION_UNIT: {
                    throw new BugInCF("found COMPILATION_UNIT in " + TreePathUtil.toString(origPath));
                }
                case LAMBDA_EXPRESSION: 
                case DO_WHILE_LOOP: 
                case ENHANCED_FOR_LOOP: 
                case FOR_LOOP: 
                case METHOD: {
                    return false;
                }
            }
            prevLeaf = leaf;
        }
        throw new BugInCF("path did not contain method or class: " + TreePathUtil.toString(origPath));
    }

    public static String toString(TreePath path) {
        StringJoiner result = new StringJoiner(System.lineSeparator() + "    ");
        result.add("TreePath:");
        for (Tree t : path) {
            result.add(TreeUtils.toStringTruncated(t, 65) + " " + (Object)((Object)t.getKind()));
        }
        return result.toString();
    }

    public static String leafToStringTruncated(@Nullable TreePath path, int length) {
        if (path == null) {
            return "null";
        }
        return TreeUtils.toStringTruncated(path.getLeaf(), length);
    }

    public static @Nullable Element findNearestEnclosingElement(TreePath path) {
        MethodTree enclosingMethodTree = TreePathUtil.enclosingMethod(path);
        if (enclosingMethodTree != null) {
            return TreeUtils.elementFromDeclaration(enclosingMethodTree);
        }
        ClassTree enclosingClassTree = TreePathUtil.enclosingClass(path);
        if (enclosingClassTree != null) {
            return TreeUtils.elementFromDeclaration(enclosingClassTree);
        }
        return null;
    }
}

