/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.org.plumelib.util;

import java.lang.reflect.Array;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.shaded.checker.calledmethods.qual.CalledMethods;
import org.checkerframework.shaded.checker.calledmethods.qual.CalledMethodsBottom;
import org.checkerframework.shaded.checker.formatter.qual.FormatBottom;
import org.checkerframework.shaded.checker.formatter.qual.UnknownFormat;
import org.checkerframework.shaded.checker.index.qual.GTENegativeOne;
import org.checkerframework.shaded.checker.index.qual.IndexOrHigh;
import org.checkerframework.shaded.checker.index.qual.LTEqLengthOf;
import org.checkerframework.shaded.checker.index.qual.LessThan;
import org.checkerframework.shaded.checker.index.qual.LessThanBottom;
import org.checkerframework.shaded.checker.index.qual.LessThanUnknown;
import org.checkerframework.shaded.checker.index.qual.LowerBoundBottom;
import org.checkerframework.shaded.checker.index.qual.LowerBoundUnknown;
import org.checkerframework.shaded.checker.index.qual.NonNegative;
import org.checkerframework.shaded.checker.index.qual.SameLen;
import org.checkerframework.shaded.checker.index.qual.SameLenBottom;
import org.checkerframework.shaded.checker.index.qual.SameLenUnknown;
import org.checkerframework.shaded.checker.index.qual.SearchIndexBottom;
import org.checkerframework.shaded.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.shaded.checker.index.qual.SubstringIndexBottom;
import org.checkerframework.shaded.checker.index.qual.SubstringIndexUnknown;
import org.checkerframework.shaded.checker.index.qual.UpperBoundBottom;
import org.checkerframework.shaded.checker.index.qual.UpperBoundUnknown;
import org.checkerframework.shaded.checker.initialization.qual.Initialized;
import org.checkerframework.shaded.checker.interning.qual.Interned;
import org.checkerframework.shaded.checker.interning.qual.InternedDistinct;
import org.checkerframework.shaded.checker.interning.qual.UnknownInterned;
import org.checkerframework.shaded.checker.lock.qual.GuardSatisfied;
import org.checkerframework.shaded.checker.lock.qual.GuardedBy;
import org.checkerframework.shaded.checker.lock.qual.GuardedByBottom;
import org.checkerframework.shaded.checker.lock.qual.LockPossiblyHeld;
import org.checkerframework.shaded.checker.lock.qual.ReleasesNoLocks;
import org.checkerframework.shaded.checker.mustcall.qual.MustCall;
import org.checkerframework.shaded.checker.nonempty.qual.EnsuresNonEmpty;
import org.checkerframework.shaded.checker.nonempty.qual.EnsuresNonEmptyIf;
import org.checkerframework.shaded.checker.nullness.qual.EnsuresKeyFor;
import org.checkerframework.shaded.checker.nullness.qual.EnsuresKeyForIf;
import org.checkerframework.shaded.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.shaded.checker.nullness.qual.KeyFor;
import org.checkerframework.shaded.checker.nullness.qual.KeyForBottom;
import org.checkerframework.shaded.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.shaded.checker.nullness.qual.NonNull;
import org.checkerframework.shaded.checker.nullness.qual.Nullable;
import org.checkerframework.shaded.checker.nullness.qual.PolyNull;
import org.checkerframework.shaded.checker.nullness.qual.UnknownKeyFor;
import org.checkerframework.shaded.checker.regex.qual.RegexBottom;
import org.checkerframework.shaded.checker.regex.qual.UnknownRegex;
import org.checkerframework.shaded.checker.signature.qual.SignatureBottom;
import org.checkerframework.shaded.checker.signature.qual.SignatureUnknown;
import org.checkerframework.shaded.checker.signedness.qual.PolySigned;
import org.checkerframework.shaded.checker.signedness.qual.Signed;
import org.checkerframework.shaded.checker.signedness.qual.SignednessBottom;
import org.checkerframework.shaded.checker.signedness.qual.UnknownSignedness;
import org.checkerframework.shaded.common.initializedfields.qual.InitializedFields;
import org.checkerframework.shaded.common.initializedfields.qual.InitializedFieldsBottom;
import org.checkerframework.shaded.common.returnsreceiver.qual.UnknownThis;
import org.checkerframework.shaded.common.value.qual.BottomVal;
import org.checkerframework.shaded.common.value.qual.UnknownVal;
import org.checkerframework.shaded.org.plumelib.util.CollectionsPlume;

public class ArrayMap<@FormatBottom K, @FormatBottom V>
extends AbstractMap<K, V> {
    private @Nullable K @SameLen(value={"values"}) @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLen(value={"this.values"}) @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) [] keys;
    private @Nullable V @SameLen(value={"keys"}) @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLen(value={"this.keys"}) @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) [] values;
    private @NonNegative @LessThan(value={"keys.length + 1"}) @IndexOrHigh(value={"keys", "values"}) @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThan(value={"this.keys.length + 1"}) @LTEqLengthOf(value={"this.keys", "this.values"}) @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) int size = 0;
    transient @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) int sizeModificationCount = 0;
    @MonotonicNonNull @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Set<@KeyFor(value={"this"}) K> keySet = null;
    @MonotonicNonNull @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Collection<V> valuesCollection = null;
    @MonotonicNonNull @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Set<@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Map.Entry<@KeyFor(value={"this"}) K, V>> entrySet = null;

    @SideEffectFree
    public ArrayMap(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal initial capacity: " + initialCapacity);
        }
        if (initialCapacity == 0) {
            this.keys = null;
            this.values = null;
        } else {
            this.keys = new Object[initialCapacity];
            this.values = new Object[initialCapacity];
        }
    }

    @SideEffectFree
    public ArrayMap() {
        this(4);
    }

    @SideEffectFree
    private ArrayMap(K @SameLen(value={"values"}) @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) [] keys, V @SameLen(value={"keys"}) @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) [] values, @LTEqLengthOf(value={"keys", "values"}) @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) int size) {
        this.keys = keys;
        this.values = values;
        this.size = size;
    }

    @SideEffectFree
    public ArrayMap(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Map<@FormatBottom @SubstringIndexBottom @BottomVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @InternedDistinct @LockPossiblyHeld @GuardedByBottom @KeyForBottom @NonNull @Initialized @RegexBottom @MustCall(value={}) @CalledMethodsBottom @SignatureBottom @SignednessBottom @UnknownThis @InitializedFieldsBottom ? extends K, @FormatBottom @SubstringIndexBottom @BottomVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @InternedDistinct @LockPossiblyHeld @GuardedByBottom @KeyForBottom @NonNull @Initialized @RegexBottom @MustCall(value={}) @CalledMethodsBottom @SignatureBottom @SignednessBottom @UnknownThis @InitializedFieldsBottom ? extends V> m) {
        this(m.size());
        this.putAll(m);
    }

    public static <K, V> @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Map<K, V> newArrayMapOrHashMap(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) int capacity) {
        if (capacity <= 4) {
            return new ArrayMap<K, V>(capacity);
        }
        return new HashMap(CollectionsPlume.mapCapacity(capacity));
    }

    public static <K, V> @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Map<K, V> newArrayMapOrHashMap(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Map<K, V> m) {
        if (m.size() <= 4) {
            return new ArrayMap<K, V>(m);
        }
        return new HashMap<K, V>(m);
    }

    public static <K, V> @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Map<K, V> newArrayMapOrLinkedHashMap(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) int capacity) {
        if (capacity <= 4) {
            return new ArrayMap<K, V>(capacity);
        }
        return new LinkedHashMap(CollectionsPlume.mapCapacity(capacity));
    }

    public static <K, V> @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Map<K, V> newArrayMapOrLinkedHashMap(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Map<K, V> m) {
        if (m.size() <= 4) {
            return new ArrayMap<K, V>(m);
        }
        return new LinkedHashMap<K, V>(m);
    }

    @EnsuresKeyFor(value={"#2"}, map={"this"})
    private void put(@GTENegativeOne @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) int index, K key, V value) {
        if (index == -1) {
            if (this.size == 0 && this.keys == null || this.size == this.keys.length) {
                this.grow();
            }
            this.keys[this.size] = key;
            this.values[this.size] = value;
            ++this.size;
            ++this.sizeModificationCount;
        } else {
            this.values[index] = value;
        }
    }

    private void grow() {
        if (this.keys == null) {
            this.keys = new Object[4];
            this.values = new Object[4];
        } else {
            int newCapacity = 2 * this.keys.length;
            this.keys = Arrays.copyOf(this.keys, newCapacity);
            this.values = Arrays.copyOf(this.values, newCapacity);
        }
    }

    private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean removeIndex(@GTENegativeOne @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) int index) {
        if (index == -1) {
            return false;
        }
        System.arraycopy(this.keys, index + 1, this.keys, index, this.size - index - 1);
        System.arraycopy(this.values, index + 1, this.values, index, this.size - index - 1);
        --this.size;
        ++this.sizeModificationCount;
        return true;
    }

    @Override
    @Pure
    public @NonNegative @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) int size() {
        return this.size;
    }

    @Override
    @Pure
    @EnsuresNonEmptyIf(result=false, expression={"this"})
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean isEmpty() {
        return this.size == 0;
    }

    @Pure
    private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) int indexOfKey(@GuardSatisfied @Nullable @UnknownSignedness @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @UnknownKeyFor @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownThis @InitializedFields(value={}) Object key) {
        if (this.keys == null) {
            return -1;
        }
        for (int i = 0; i < this.size; ++i) {
            if (!Objects.equals(key, this.keys[i])) continue;
            return i;
        }
        return -1;
    }

    @Pure
    private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) int indexOfValue(@GuardSatisfied @Nullable @UnknownSignedness @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @UnknownKeyFor @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownThis @InitializedFields(value={}) Object value) {
        if (this.keys == null) {
            return -1;
        }
        for (int i = 0; i < this.size; ++i) {
            if (!Objects.equals(value, this.values[i])) continue;
            return i;
        }
        return -1;
    }

    @Override
    @Pure
    @EnsuresNonEmptyIf(result=true, expression={"this"})
    @EnsuresKeyForIf(expression={"#1"}, result=true, map={"this"})
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean containsKey(@GuardSatisfied @Nullable @UnknownSignedness @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @UnknownKeyFor @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownThis @InitializedFields(value={}) Object key) {
        return this.indexOfKey(key) != -1;
    }

    @Override
    @Pure
    @EnsuresNonEmptyIf(result=true, expression={"this"})
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean containsValue(@GuardSatisfied @Nullable @UnknownSignedness @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @UnknownKeyFor @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownThis @InitializedFields(value={}) Object value) {
        return this.indexOfValue(value) != -1;
    }

    @Pure
    private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean containsEntry(@GuardSatisfied @Nullable @UnknownSignedness @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @UnknownKeyFor @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownThis @InitializedFields(value={}) Object key, @GuardSatisfied @Nullable @UnknownSignedness @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @UnknownKeyFor @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownThis @InitializedFields(value={}) Object value) {
        int index = this.indexOfKey(key);
        return index != -1 && Objects.equals(value, this.values[index]);
    }

    @Override
    @Pure
    public @Nullable V get(@GuardSatisfied @Nullable @UnknownSignedness @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @UnknownKeyFor @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownThis @InitializedFields(value={}) Object key) {
        int index = this.indexOfKey(key);
        return this.getOrNull(index);
    }

    @Pure
    private @Nullable V getOrNull(@GTENegativeOne @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) int index) {
        return index == -1 ? null : (V)this.values[index];
    }

    @Override
    @ReleasesNoLocks
    @EnsuresNonEmpty(value={"this"})
    @EnsuresKeyFor(value={"#1"}, map={"this"})
    public @Nullable V put(K key, V value) {
        int index = this.indexOfKey(key);
        V currentValue = this.getOrNull(index);
        this.put(index, key, value);
        return currentValue;
    }

    @Override
    public @Nullable V remove(@GuardSatisfied @Nullable @UnknownSignedness @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @UnknownKeyFor @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownThis @InitializedFields(value={}) Object key) {
        int index = this.indexOfKey(key);
        if (index == -1) {
            return null;
        }
        V currentValue = this.values[index];
        this.removeIndex(index);
        return currentValue;
    }

    @Override
    public void putAll(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Map<@FormatBottom @SubstringIndexBottom @BottomVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @InternedDistinct @LockPossiblyHeld @GuardedByBottom @KeyForBottom @NonNull @Initialized @RegexBottom @MustCall(value={}) @CalledMethodsBottom @SignatureBottom @SignednessBottom @UnknownThis @InitializedFieldsBottom ? extends K, @FormatBottom @SubstringIndexBottom @BottomVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @InternedDistinct @LockPossiblyHeld @GuardedByBottom @KeyForBottom @NonNull @Initialized @RegexBottom @MustCall(value={}) @CalledMethodsBottom @SignatureBottom @SignednessBottom @UnknownThis @InitializedFieldsBottom ? extends V> m) {
        if (m.isEmpty()) {
            return;
        }
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public void clear() {
        if (this.size != 0) {
            this.size = 0;
            ++this.sizeModificationCount;
        }
    }

    @Override
    @Pure
    @SideEffectFree
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Set<@KeyFor(value={"this"}) K> keySet() {
        if (this.keySet == null) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    @Override
    @Pure
    @SideEffectFree
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Collection<V> values() {
        if (this.valuesCollection == null) {
            this.valuesCollection = new Values();
        }
        return this.valuesCollection;
    }

    @Override
    @Pure
    @SideEffectFree
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Set<@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Map.Entry<@KeyFor(value={"this"}) K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    @Override
    @SideEffectFree
    @Pure
    public V getOrDefault(@GuardSatisfied @Nullable @UnknownSignedness @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @UnknownKeyFor @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownThis @InitializedFields(value={}) Object key, V defaultValue) {
        int index = this.indexOfKey(key);
        if (index != -1) {
            return this.values[index];
        }
        return defaultValue;
    }

    @Override
    public void forEach(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) BiConsumer<@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Nullable @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownSignedness @UnknownThis @InitializedFields(value={}) ? super K, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Nullable @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownSignedness @UnknownThis @InitializedFields(value={}) ? super V> action) {
        Objects.requireNonNull(action);
        if (this.keys == null) {
            return;
        }
        int oldSizeModificationCount = this.sizeModificationCount;
        for (int index = 0; index < this.size; ++index) {
            V v;
            K k;
            try {
                k = this.keys[index];
                v = this.values[index];
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException(e);
            }
            action.accept(k, v);
        }
        if (oldSizeModificationCount != this.sizeModificationCount) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    public void replaceAll(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) BiFunction<@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Nullable @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownSignedness @UnknownThis @InitializedFields(value={}) ? super K, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Nullable @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownSignedness @UnknownThis @InitializedFields(value={}) ? super V, @FormatBottom @SubstringIndexBottom @BottomVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @InternedDistinct @LockPossiblyHeld @GuardedByBottom @KeyForBottom @NonNull @Initialized @RegexBottom @MustCall(value={}) @CalledMethodsBottom @SignatureBottom @SignednessBottom @UnknownThis @InitializedFieldsBottom ? extends V> function) {
        Objects.requireNonNull(function);
        if (this.keys == null) {
            return;
        }
        int oldSizeModificationCount = this.sizeModificationCount;
        int size = this.size();
        for (int index = 0; index < size; ++index) {
            V v;
            K k;
            try {
                k = this.keys[index];
                v = this.values[index];
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException(e);
            }
            v = function.apply(k, v);
            try {
                this.values[index] = v;
                continue;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException(e);
            }
        }
        if (oldSizeModificationCount != this.sizeModificationCount) {
            throw new ConcurrentModificationException();
        }
    }

    @Override
    @EnsuresKeyFor(value={"#1"}, map={"this"})
    public @Nullable V putIfAbsent(K key, V value) {
        int index = this.indexOfKey(key);
        if (index == -1 || this.values[index] == null) {
            this.put(index, key, value);
            return null;
        }
        return this.values[index];
    }

    @Override
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean remove(@GuardSatisfied @Nullable @UnknownSignedness @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @UnknownKeyFor @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownThis @InitializedFields(value={}) Object key, @GuardSatisfied @Nullable @UnknownSignedness @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @UnknownKeyFor @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownThis @InitializedFields(value={}) Object value) {
        int index = this.indexOfKey(key);
        if (index == -1) {
            return false;
        }
        V curValue = this.values[index];
        if (!Objects.equals(curValue, value)) {
            return false;
        }
        this.removeIndex(index);
        return true;
    }

    @Override
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean replace(K key, V oldValue, V newValue) {
        int index = this.indexOfKey(key);
        if (index == -1) {
            return false;
        }
        V curValue = this.values[index];
        if (!Objects.equals(curValue, oldValue)) {
            return false;
        }
        this.values[index] = newValue;
        return true;
    }

    @Override
    public @Nullable V replace(K key, V value) {
        int index = this.indexOfKey(key);
        if (index == -1) {
            return null;
        }
        V currentValue = this.values[index];
        this.values[index] = value;
        return currentValue;
    }

    @Override
    public @PolyNull V computeIfAbsent(K key, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Function<@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Nullable @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownSignedness @UnknownThis @InitializedFields(value={}) ? super K, @FormatBottom @SubstringIndexBottom @BottomVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @InternedDistinct @LockPossiblyHeld @GuardedByBottom @KeyForBottom @NonNull @Initialized @RegexBottom @MustCall(value={}) @CalledMethodsBottom @SignatureBottom @SignednessBottom @UnknownThis @InitializedFieldsBottom ? extends @PolyNull V> mappingFunction) {
        V currentValue;
        Objects.requireNonNull(mappingFunction);
        int index = this.indexOfKey(key);
        if (index != -1 && (currentValue = this.values[index]) != null) {
            return currentValue;
        }
        int oldSizeModificationCount = this.sizeModificationCount;
        V newValue = mappingFunction.apply(key);
        if (oldSizeModificationCount != this.sizeModificationCount) {
            throw new ConcurrentModificationException();
        }
        if (newValue != null) {
            this.put(index, key, newValue);
        }
        return newValue;
    }

    @Override
    public @PolyNull V computeIfPresent(K key, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) BiFunction<@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Nullable @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownSignedness @UnknownThis @InitializedFields(value={}) ? super K, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Nullable @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownSignedness @UnknownThis @InitializedFields(value={}) ? super V, @FormatBottom @SubstringIndexBottom @BottomVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @InternedDistinct @LockPossiblyHeld @GuardedByBottom @KeyForBottom @NonNull @Initialized @RegexBottom @MustCall(value={}) @CalledMethodsBottom @SignatureBottom @SignednessBottom @UnknownThis @InitializedFieldsBottom ? extends @PolyNull V> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        int index = this.indexOfKey(key);
        if (index == -1) {
            V result = null;
            return result;
        }
        V oldValue = this.values[index];
        if (oldValue == null) {
            V result = null;
            return result;
        }
        int oldSizeModificationCount = this.sizeModificationCount;
        V newValue = remappingFunction.apply(key, oldValue);
        if (oldSizeModificationCount != this.sizeModificationCount) {
            throw new ConcurrentModificationException();
        }
        if (newValue != null) {
            this.values[index] = newValue;
            return newValue;
        }
        this.removeIndex(index);
        return null;
    }

    @Override
    public @PolyNull V compute(K key, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) BiFunction<@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Nullable @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownSignedness @UnknownThis @InitializedFields(value={}) ? super K, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Nullable @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownSignedness @UnknownThis @InitializedFields(value={}) ? super @Nullable V, @FormatBottom @SubstringIndexBottom @BottomVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @InternedDistinct @LockPossiblyHeld @GuardedByBottom @KeyForBottom @NonNull @Initialized @RegexBottom @MustCall(value={}) @CalledMethodsBottom @SignatureBottom @SignednessBottom @UnknownThis @InitializedFieldsBottom ? extends @PolyNull V> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        int index = this.indexOfKey(key);
        V oldValue = this.getOrNull(index);
        int oldSizeModificationCount = this.sizeModificationCount;
        V newValue = remappingFunction.apply(key, oldValue);
        if (oldSizeModificationCount != this.sizeModificationCount) {
            throw new ConcurrentModificationException();
        }
        if (newValue == null) {
            this.removeIndex(index);
            return null;
        }
        this.put(index, key, newValue);
        return newValue;
    }

    @Override
    public @PolyNull V merge(K key, @NonNull V value, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) BiFunction<@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Nullable @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownSignedness @UnknownThis @InitializedFields(value={}) ? super V, @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Nullable @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownSignedness @UnknownThis @InitializedFields(value={}) ? super V, @FormatBottom @SubstringIndexBottom @BottomVal @SearchIndexBottom @SameLenBottom @LessThanBottom @LowerBoundBottom @UpperBoundBottom @InternedDistinct @LockPossiblyHeld @GuardedByBottom @KeyForBottom @NonNull @Initialized @RegexBottom @MustCall(value={}) @CalledMethodsBottom @SignatureBottom @SignednessBottom @UnknownThis @InitializedFieldsBottom ? extends @PolyNull V> remappingFunction) {
        Objects.requireNonNull(remappingFunction);
        Objects.requireNonNull(value);
        int index = this.indexOfKey(key);
        V oldValue = this.getOrNull(index);
        int oldSizeModificationCount = this.sizeModificationCount;
        V newValue = oldValue == null ? value : remappingFunction.apply(oldValue, value);
        if (oldSizeModificationCount != this.sizeModificationCount) {
            throw new ConcurrentModificationException();
        }
        if (newValue == null) {
            this.removeIndex(index);
        } else {
            this.put(index, key, newValue);
        }
        return newValue;
    }

    @Override
    @SideEffectFree
    public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) ArrayMap<K, V> clone() {
        return new ArrayMap<K, V>(Arrays.copyOf(this.keys, this.size), Arrays.copyOf(this.values, this.size), this.size);
    }

    @SideEffectFree
    @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) String repr() {
        return String.format("size=%d capacity=%d %s %s", this.size, this.keys == null ? 0 : this.keys.length, Arrays.toString(this.keys), Arrays.toString(this.values));
    }

    final class KeySet
    extends AbstractSet<K> {
        @Override
        @Pure
        public final @NonNegative @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) int size() {
            return ArrayMap.this.size();
        }

        @Override
        public final void clear() {
            ArrayMap.this.clear();
        }

        @Override
        @SideEffectFree
        public final @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Iterator<@KeyFor(value={"this"}) K> iterator() {
            return new KeyIterator();
        }

        @Override
        @Pure
        @EnsuresNonEmptyIf(result=true, expression={"this"})
        public final @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean contains(@GuardSatisfied @Nullable @UnknownSignedness @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @UnknownKeyFor @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownThis @InitializedFields(value={}) Object o) {
            return ArrayMap.this.containsKey(o);
        }

        @Override
        public final @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean remove(@GuardSatisfied @Nullable @UnknownSignedness @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @UnknownKeyFor @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownThis @InitializedFields(value={}) Object o) {
            int index = ArrayMap.this.indexOfKey(o);
            return ArrayMap.this.removeIndex(index);
        }

        @Override
        @SideEffectFree
        public @PolySigned @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownThis @InitializedFields(value={}) Object @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) [] toArray() {
            return Arrays.copyOf(ArrayMap.this.keys, ArrayMap.this.size);
        }

        @Override
        @SideEffectFree
        public <T> @Nullable T @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) [] toArray(@PolyNull T @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) [] a) {
            Object[] result = a.length >= ArrayMap.this.size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), ArrayMap.this.size);
            System.arraycopy(ArrayMap.this.keys, 0, result, 0, ArrayMap.this.size);
            return result;
        }

        @Override
        public final void forEach(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Consumer<@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Nullable @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownSignedness @UnknownThis @InitializedFields(value={}) ? super K> action) {
            if (ArrayMap.this.keys == null) {
                return;
            }
            int oldSizeModificationCount = ArrayMap.this.sizeModificationCount;
            for (int i = 0; i < ArrayMap.this.size; ++i) {
                Object key = ArrayMap.this.keys[i];
                action.accept(key);
            }
            if (oldSizeModificationCount != ArrayMap.this.sizeModificationCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    final class Values
    extends AbstractCollection<V> {
        @Override
        @Pure
        public final @NonNegative @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) int size() {
            return ArrayMap.this.size();
        }

        @Override
        public final void clear() {
            ArrayMap.this.clear();
        }

        @Override
        @SideEffectFree
        public final @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Iterator<V> iterator() {
            return new ValueIterator();
        }

        @Override
        @Pure
        @EnsuresNonEmptyIf(result=true, expression={"this"})
        public final @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean contains(@GuardSatisfied @Nullable @UnknownSignedness @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @UnknownKeyFor @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownThis @InitializedFields(value={}) Object o) {
            return ArrayMap.this.containsValue(o);
        }

        @Override
        @SideEffectFree
        public @Nullable @PolySigned @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownThis @InitializedFields(value={}) Object @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) [] toArray() {
            return Arrays.copyOf(ArrayMap.this.values, ArrayMap.this.size);
        }

        @Override
        @SideEffectFree
        public <T> @Nullable T @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) [] toArray(@PolyNull T @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) [] a) {
            Object[] result = a.length >= ArrayMap.this.size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), ArrayMap.this.size);
            System.arraycopy(ArrayMap.this.values, 0, result, 0, ArrayMap.this.size);
            return result;
        }

        @Override
        public final void forEach(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Consumer<@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Nullable @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownSignedness @UnknownThis @InitializedFields(value={}) ? super V> action) {
            if (ArrayMap.this.keys == null) {
                return;
            }
            int oldSizeModificationCount = ArrayMap.this.sizeModificationCount;
            for (int i = 0; i < ArrayMap.this.size; ++i) {
                action.accept(ArrayMap.this.values[i]);
            }
            if (oldSizeModificationCount != ArrayMap.this.sizeModificationCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    final class EntrySet
    extends AbstractSet<Map.Entry<K, V>> {
        @Override
        @Pure
        public final @NonNegative @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) int size() {
            return ArrayMap.this.size();
        }

        @Override
        public final void clear() {
            ArrayMap.this.clear();
        }

        @Override
        @SideEffectFree
        public final @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Iterator<@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Map.Entry<@KeyFor(value={"ArrayMap.this"}) K, V>> iterator() {
            return new EntryIterator();
        }

        @Override
        @Pure
        @EnsuresNonEmptyIf(result=true, expression={"this"})
        public final @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean contains(@GuardSatisfied @Nullable @UnknownSignedness @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @UnknownKeyFor @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownThis @InitializedFields(value={}) Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            Object value = e.getValue();
            return ArrayMap.this.containsEntry(key, value);
        }

        @Override
        public final @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean remove(@GuardSatisfied @Nullable @UnknownSignedness @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @UnknownKeyFor @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownThis @InitializedFields(value={}) Object o) {
            if (o instanceof Map.Entry) {
                Map.Entry e = (Map.Entry)o;
                Object key = e.getKey();
                Object value = e.getValue();
                return ArrayMap.this.remove(key, value);
            }
            return false;
        }

        @Override
        public final void forEach(@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Consumer<@UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @Nullable @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownSignedness @UnknownThis @InitializedFields(value={}) ? super @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @InternedDistinct @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureBottom @Signed @UnknownThis @InitializedFields(value={}) Map.Entry<@KeyFor(value={"ArrayMap.this"}) K, V>> action) {
            int oldSizeModificationCount = ArrayMap.this.sizeModificationCount;
            for (int index = 0; index < this.size(); ++index) {
                action.accept(new Entry(index));
            }
            if (oldSizeModificationCount != ArrayMap.this.sizeModificationCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    final class Entry
    implements Map.Entry<K, V> {
        @NonNegative @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) int index;

        @Pure
        public Entry(int index) {
            this.index = index;
        }

        @Override
        @Pure
        public K getKey() {
            return ArrayMap.this.keys[this.index];
        }

        @Override
        @Pure
        public V getValue() {
            return ArrayMap.this.values[this.index];
        }

        @Override
        public V setValue(V value) {
            Object v = value;
            ((ArrayMap)ArrayMap.this).values[this.index] = v;
            return v;
        }

        @Pure
        private @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) ArrayMap<K, V> theArrayMap() {
            return ArrayMap.this;
        }

        @Override
        @Pure
        @EnsuresNonNullIf(expression={"#1"}, result=true)
        public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean equals(@GuardSatisfied @Nullable @UnknownSignedness @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @UnknownKeyFor @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @UnknownThis @InitializedFields(value={}) Object o) {
            Map.Entry otherEntry;
            if (this == o) {
                return true;
            }
            if (o instanceof Entry) {
                boolean result;
                otherEntry = (Entry)o;
                boolean bl = result = this.index == ((Entry)otherEntry).index && this.theArrayMap() == super.theArrayMap();
                if (result) {
                    return true;
                }
            }
            if (o instanceof Map.Entry) {
                otherEntry = (Map.Entry)o;
                return Objects.equals(this.getKey(), otherEntry.getKey()) && Objects.equals(this.getValue(), otherEntry.getValue());
            }
            return false;
        }

        @Override
        @Pure
        public @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) int hashCode(@UnknownFormat @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Entry this) {
            return Objects.hash(this.getKey(), this.getValue());
        }
    }

    final class EntryIterator
    extends ArrayMapIterator
    implements Iterator<Map.Entry<K, V>> {
        @SideEffectFree
        EntryIterator() {
        }

        @Override
        public final @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @UnknownInterned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) Map.Entry<K, V> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.removed = false;
            return new Entry(this.index++);
        }
    }

    final class ValueIterator
    extends ArrayMapIterator
    implements Iterator<V> {
        @SideEffectFree
        ValueIterator() {
        }

        @Override
        public final V next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.removed = false;
            return ArrayMap.this.values[this.index++];
        }
    }

    final class KeyIterator
    extends ArrayMapIterator
    implements Iterator<K> {
        @SideEffectFree
        KeyIterator() {
        }

        @Override
        public final @KeyFor(value={"ArrayMap.this"}) K next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.removed = false;
            return ArrayMap.this.keys[this.index++];
        }
    }

    abstract class ArrayMapIterator {
        @NonNegative @UnknownFormat @SubstringIndexUnknown @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) int index = 0;
        @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean removed = true;
        @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) int initialSizeModificationCount;

        @SideEffectFree
        ArrayMapIterator() {
            this.initialSizeModificationCount = ArrayMap.this.sizeModificationCount;
        }

        @Pure
        public final @UnknownFormat @SubstringIndexUnknown @UnknownVal @SearchIndexUnknown @SameLenUnknown @LessThanUnknown @LowerBoundUnknown @UpperBoundUnknown @Interned @LockPossiblyHeld @GuardedBy(value={}) @UnknownKeyFor @NonNull @Initialized @UnknownRegex @MustCall(value={}) @CalledMethods(value={}) @SignatureUnknown @Signed @UnknownThis @InitializedFields(value={}) boolean hasNext() {
            return this.index < ArrayMap.this.size();
        }

        public final void remove() {
            int newIndex;
            if (this.removed) {
                throw new IllegalStateException("Called remove() on ArrayMapIterator without calling next() first.");
            }
            if (this.initialSizeModificationCount != ArrayMap.this.sizeModificationCount) {
                throw new ConcurrentModificationException();
            }
            this.index = newIndex = this.index - 1;
            ArrayMap.this.removeIndex(this.index);
            this.initialSizeModificationCount = ArrayMap.this.sizeModificationCount;
            this.removed = true;
        }
    }
}

