/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.shaded.javacutil.javacparse;

import com.sun.source.tree.Tree;
import java.util.List;
import java.util.StringJoiner;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.checkerframework.shaded.checker.lock.qual.GuardSatisfied;

public final class JavacParseResult<T extends Tree> {
    private final T tree;
    private final List<Diagnostic<? extends JavaFileObject>> diagnostics;

    public JavacParseResult(T tree, List<Diagnostic<? extends JavaFileObject>> diagnostics) {
        this.tree = tree;
        this.diagnostics = diagnostics;
    }

    public final T getTree() {
        return this.tree;
    }

    public final List<Diagnostic<? extends JavaFileObject>> getDiagnostics() {
        return this.diagnostics;
    }

    public final boolean hasParseError() {
        return this.diagnostics.stream().anyMatch(d -> d.getKind() == Diagnostic.Kind.ERROR);
    }

    public final String getParseErrorMessages() {
        StringJoiner sj = new StringJoiner("; ");
        for (Diagnostic<? extends JavaFileObject> d : this.diagnostics) {
            if (d.getKind() != Diagnostic.Kind.ERROR) continue;
            String msg = d.getMessage(null);
            sj.add(msg);
        }
        return sj.toString();
    }

    public String toString(@GuardSatisfied JavacParseResult<T> this) {
        String prefix = "JPR{" + this.tree + " [" + this.tree.getClass().getSimpleName() + "] [" + (Object)((Object)this.tree.getKind()) + "]";
        if (this.diagnostics.isEmpty()) {
            return prefix + "}";
        }
        StringJoiner sj = new StringJoiner(System.lineSeparator());
        sj.add(prefix);
        for (Diagnostic<? extends JavaFileObject> d : this.diagnostics) {
            sj.add("  " + d);
        }
        sj.add("}");
        return sj.toString();
    }
}

