/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.nullaway.dataflow.busyexpr;

import java.util.List;
import org.checkerframework.nullaway.dataflow.analysis.BackwardTransferFunction;
import org.checkerframework.nullaway.dataflow.analysis.RegularTransferResult;
import org.checkerframework.nullaway.dataflow.analysis.TransferInput;
import org.checkerframework.nullaway.dataflow.analysis.TransferResult;
import org.checkerframework.nullaway.dataflow.analysis.UnusedAbstractValue;
import org.checkerframework.nullaway.dataflow.busyexpr.BusyExprStore;
import org.checkerframework.nullaway.dataflow.cfg.UnderlyingAST;
import org.checkerframework.nullaway.dataflow.cfg.node.AbstractNodeVisitor;
import org.checkerframework.nullaway.dataflow.cfg.node.AssignmentNode;
import org.checkerframework.nullaway.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.nullaway.dataflow.cfg.node.Node;
import org.checkerframework.nullaway.dataflow.cfg.node.ObjectCreationNode;
import org.checkerframework.nullaway.dataflow.cfg.node.ReturnNode;

public class BusyExprTransfer
extends AbstractNodeVisitor<TransferResult<UnusedAbstractValue, BusyExprStore>, TransferInput<UnusedAbstractValue, BusyExprStore>>
implements BackwardTransferFunction<UnusedAbstractValue, BusyExprStore> {
    @Override
    public BusyExprStore initialNormalExitStore(UnderlyingAST underlyingAST, List<ReturnNode> returnNodes) {
        return new BusyExprStore();
    }

    @Override
    public BusyExprStore initialExceptionalExitStore(UnderlyingAST underlyingAST) {
        return new BusyExprStore();
    }

    @Override
    public RegularTransferResult<UnusedAbstractValue, BusyExprStore> visitNode(Node n, TransferInput<UnusedAbstractValue, BusyExprStore> p) {
        return new RegularTransferResult<Object, BusyExprStore>(null, p.getRegularStore());
    }

    @Override
    public RegularTransferResult<UnusedAbstractValue, BusyExprStore> visitAssignment(AssignmentNode n, TransferInput<UnusedAbstractValue, BusyExprStore> p) {
        RegularTransferResult transferResult = (RegularTransferResult)super.visitAssignment(n, p);
        BusyExprStore store = (BusyExprStore)transferResult.getRegularStore();
        store.killBusyExpr(n.getTarget());
        store.addUseInExpression(n.getExpression());
        return transferResult;
    }

    @Override
    public RegularTransferResult<UnusedAbstractValue, BusyExprStore> visitMethodInvocation(MethodInvocationNode n, TransferInput<UnusedAbstractValue, BusyExprStore> p) {
        RegularTransferResult transferResult = (RegularTransferResult)super.visitMethodInvocation(n, p);
        BusyExprStore store = (BusyExprStore)transferResult.getRegularStore();
        for (Node arg : n.getArguments()) {
            store.addUseInExpression(arg);
        }
        return transferResult;
    }

    @Override
    public RegularTransferResult<UnusedAbstractValue, BusyExprStore> visitObjectCreation(ObjectCreationNode n, TransferInput<UnusedAbstractValue, BusyExprStore> p) {
        RegularTransferResult transferResult = (RegularTransferResult)super.visitObjectCreation(n, p);
        BusyExprStore store = (BusyExprStore)transferResult.getRegularStore();
        for (Node arg : n.getArguments()) {
            store.addUseInExpression(arg);
        }
        return transferResult;
    }

    @Override
    public RegularTransferResult<UnusedAbstractValue, BusyExprStore> visitReturn(ReturnNode n, TransferInput<UnusedAbstractValue, BusyExprStore> p) {
        RegularTransferResult transferResult = (RegularTransferResult)super.visitReturn(n, p);
        Node result = n.getResult();
        if (result != null) {
            BusyExprStore store = (BusyExprStore)transferResult.getRegularStore();
            store.addUseInExpression(result);
        }
        return transferResult;
    }
}

