/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.dataflow.constantpropagation;

import java.util.List;
import org.checkerframework.errorprone.dataflow.analysis.ConditionalTransferResult;
import org.checkerframework.errorprone.dataflow.analysis.ForwardTransferFunction;
import org.checkerframework.errorprone.dataflow.analysis.RegularTransferResult;
import org.checkerframework.errorprone.dataflow.analysis.TransferInput;
import org.checkerframework.errorprone.dataflow.analysis.TransferResult;
import org.checkerframework.errorprone.dataflow.cfg.UnderlyingAST;
import org.checkerframework.errorprone.dataflow.cfg.node.AbstractNodeVisitor;
import org.checkerframework.errorprone.dataflow.cfg.node.AssignmentNode;
import org.checkerframework.errorprone.dataflow.cfg.node.EqualToNode;
import org.checkerframework.errorprone.dataflow.cfg.node.IntegerLiteralNode;
import org.checkerframework.errorprone.dataflow.cfg.node.LocalVariableNode;
import org.checkerframework.errorprone.dataflow.cfg.node.Node;
import org.checkerframework.errorprone.dataflow.constantpropagation.Constant;
import org.checkerframework.errorprone.dataflow.constantpropagation.ConstantPropagationStore;

public class ConstantPropagationTransfer
extends AbstractNodeVisitor<TransferResult<Constant, ConstantPropagationStore>, TransferInput<Constant, ConstantPropagationStore>>
implements ForwardTransferFunction<Constant, ConstantPropagationStore> {
    @Override
    public ConstantPropagationStore initialStore(UnderlyingAST underlyingAST, List<LocalVariableNode> parameters) {
        ConstantPropagationStore store = new ConstantPropagationStore();
        return store;
    }

    @Override
    public TransferResult<Constant, ConstantPropagationStore> visitLocalVariable(LocalVariableNode node, TransferInput<Constant, ConstantPropagationStore> before) {
        ConstantPropagationStore store = before.getRegularStore();
        Constant value = store.getInformation(node);
        return new RegularTransferResult<Constant, ConstantPropagationStore>(value, store);
    }

    @Override
    public TransferResult<Constant, ConstantPropagationStore> visitNode(Node n, TransferInput<Constant, ConstantPropagationStore> p) {
        return new RegularTransferResult<Object, ConstantPropagationStore>(null, p.getRegularStore());
    }

    @Override
    public TransferResult<Constant, ConstantPropagationStore> visitAssignment(AssignmentNode n, TransferInput<Constant, ConstantPropagationStore> pi) {
        ConstantPropagationStore p = pi.getRegularStore();
        Node target = n.getTarget();
        Constant info = null;
        if (target instanceof LocalVariableNode) {
            LocalVariableNode lvn = (LocalVariableNode)target;
            info = p.getInformation(n.getExpression());
            p.setInformation(lvn, info);
        }
        return new RegularTransferResult<Object, ConstantPropagationStore>(info, p);
    }

    @Override
    public TransferResult<Constant, ConstantPropagationStore> visitIntegerLiteral(IntegerLiteralNode n, TransferInput<Constant, ConstantPropagationStore> pi) {
        ConstantPropagationStore p = pi.getRegularStore();
        Constant c = new Constant(n.getValue());
        p.setInformation(n, c);
        return new RegularTransferResult<Constant, ConstantPropagationStore>(c, p);
    }

    @Override
    public TransferResult<Constant, ConstantPropagationStore> visitEqualTo(EqualToNode n, TransferInput<Constant, ConstantPropagationStore> pi) {
        ConstantPropagationStore p = pi.getRegularStore();
        ConstantPropagationStore old = p.copy();
        Node left = n.getLeftOperand();
        Node right = n.getRightOperand();
        this.process(p, left, right);
        this.process(p, right, left);
        return new ConditionalTransferResult<Object, ConstantPropagationStore>(null, p, old);
    }

    protected void process(ConstantPropagationStore p, Node a, Node b) {
        Constant val = p.getInformation(a);
        if (b instanceof LocalVariableNode && val.isConstant()) {
            p.setInformation(b, val);
        }
    }
}

