/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.dataflow.expression;

import java.util.Objects;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.errorprone.checker.nullness.qual.Nullable;
import org.checkerframework.errorprone.dataflow.analysis.Store;
import org.checkerframework.errorprone.dataflow.expression.JavaExpression;
import org.checkerframework.errorprone.dataflow.expression.JavaExpressionVisitor;
import org.checkerframework.errorprone.javacutil.AnnotationProvider;

public class ClassName
extends JavaExpression {
    private final String typeString;

    public ClassName(TypeMirror type) {
        super(type);
        String typeString = type.toString();
        if (typeString.endsWith(">")) {
            typeString = typeString.substring(0, typeString.indexOf(60));
        }
        this.typeString = typeString;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof ClassName)) {
            return false;
        }
        ClassName other = (ClassName)obj;
        return this.typeString.equals(other.typeString);
    }

    public int hashCode() {
        return Objects.hash(this.typeString);
    }

    public String toString() {
        return this.typeString + ".class";
    }

    @Override
    public <T extends JavaExpression> @Nullable T containedOfClass(Class<T> clazz) {
        return (T)(this.getClass() == clazz ? this : null);
    }

    @Override
    public boolean isDeterministic(AnnotationProvider provider) {
        return true;
    }

    @Override
    public boolean isAssignableByOtherCode() {
        return false;
    }

    @Override
    public boolean isModifiableByOtherCode() {
        return false;
    }

    @Override
    public boolean syntacticEquals(JavaExpression je) {
        if (!(je instanceof ClassName)) {
            return false;
        }
        ClassName other = (ClassName)je;
        return this.typeString.equals(other.typeString);
    }

    @Override
    public boolean containsSyntacticEqualJavaExpression(JavaExpression other) {
        return this.syntacticEquals(other);
    }

    @Override
    public boolean containsModifiableAliasOf(Store<?> store, JavaExpression other) {
        return false;
    }

    @Override
    public <R, P> R accept(JavaExpressionVisitor<R, P> visitor, P p) {
        return visitor.visitClassName(this, p);
    }
}

