/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.errorprone.dataflow.cfg.node;

import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import org.checkerframework.dataflow.qual.SideEffectFree;
import org.checkerframework.errorprone.checker.nullness.qual.Nullable;
import org.checkerframework.errorprone.dataflow.cfg.node.Node;
import org.checkerframework.errorprone.dataflow.cfg.node.NodeVisitor;
import org.checkerframework.errorprone.javacutil.TreeUtils;

public class ArrayAccessNode
extends Node {
    protected final ArrayAccessTree tree;
    protected final Node array;
    protected final Node index;
    protected @Nullable ExpressionTree arrayExpression;
    protected @Nullable EnhancedForLoopTree enhancedForLoop;

    public ArrayAccessNode(ArrayAccessTree t, Node array, Node index) {
        super(TreeUtils.typeOf(t));
        this.tree = t;
        this.array = array;
        this.index = index;
    }

    public @Nullable ExpressionTree getArrayExpression() {
        return this.arrayExpression;
    }

    public void setArrayExpression(@Nullable ExpressionTree arrayExpression) {
        this.arrayExpression = arrayExpression;
    }

    public @Nullable EnhancedForLoopTree getEnhancedForLoop() {
        return this.enhancedForLoop;
    }

    public void setEnhancedForLoop(@Nullable EnhancedForLoopTree enhancedForLoop) {
        this.enhancedForLoop = enhancedForLoop;
    }

    public Node getArray() {
        return this.array;
    }

    public Node getIndex() {
        return this.index;
    }

    @Override
    public ArrayAccessTree getTree() {
        return this.tree;
    }

    @Override
    public <R, P> R accept(NodeVisitor<R, P> visitor, P p) {
        return visitor.visitArrayAccess(this, p);
    }

    public String toString() {
        String base = this.getArray().toString() + "[" + this.getIndex() + "]";
        return base;
    }

    public boolean equals(@Nullable Object obj) {
        if (!(obj instanceof ArrayAccessNode)) {
            return false;
        }
        ArrayAccessNode other = (ArrayAccessNode)obj;
        return this.getArray().equals(other.getArray()) && this.getIndex().equals(other.getIndex());
    }

    public int hashCode() {
        return Objects.hash(this.getArray(), this.getIndex());
    }

    @Override
    @SideEffectFree
    public Collection<Node> getOperands() {
        return Arrays.asList(this.getArray(), this.getIndex());
    }
}

