/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.DeferredAttr;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Filter;
import com.sun.tools.javac.util.GraphUtils;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Pair;
import com.sun.tools.javac.util.Warner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class Infer {
    protected static final Context.Key<Infer> inferKey = new Context.Key();
    Resolve rs;
    Check chk;
    Symtab syms;
    Types types;
    JCDiagnostic.Factory diags;
    Log log;
    boolean allowGraphInference;
    public static final Type anyPoly = new Type.JCNoType();
    protected final InferenceException inferenceException;
    static final int MAX_INCORPORATION_STEPS = 100;
    EnumSet<IncorporationStep> incorporationStepsLegacy = EnumSet.of(IncorporationStep.EQ_CHECK_LEGACY);
    EnumSet<IncorporationStep> incorporationStepsGraph = EnumSet.complementOf(EnumSet.of(IncorporationStep.EQ_CHECK_LEGACY));
    Map<IncorporationBinaryOp, Boolean> incorporationCache = new HashMap<IncorporationBinaryOp, Boolean>();
    final InferenceContext emptyContext = new InferenceContext(List.nil());

    public static Infer instance(Context context) {
        Infer instance = context.get(inferKey);
        if (instance == null) {
            instance = new Infer(context);
        }
        return instance;
    }

    protected Infer(Context context) {
        context.put(inferKey, this);
        this.rs = Resolve.instance(context);
        this.chk = Check.instance(context);
        this.syms = Symtab.instance(context);
        this.types = Types.instance(context);
        this.diags = JCDiagnostic.Factory.instance(context);
        this.log = Log.instance(context);
        this.inferenceException = new InferenceException(this.diags);
        Options options = Options.instance(context);
        this.allowGraphInference = Source.instance(context).allowGraphInference() && options.isUnset("useLegacyInference");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Type instantiateMethod(Env<AttrContext> env, List<Type> tvars, Type.MethodType mt, Attr.ResultInfo resultInfo, Symbol.MethodSymbol msym, List<Type> argtypes, boolean allowBoxing, boolean useVarargs, Resolve.MethodResolutionContext resolveContext, Warner warn) throws InferenceException {
        InferenceContext inferenceContext = new InferenceContext(tvars);
        this.inferenceException.clear();
        try {
            DeferredAttr.DeferredAttrContext deferredAttrContext = resolveContext.deferredAttrContext(msym, inferenceContext, resultInfo, warn);
            resolveContext.methodCheck.argumentsAcceptable(env, deferredAttrContext, argtypes, (List<Type>)mt.getParameterTypes(), warn);
            if (this.allowGraphInference && resultInfo != null && !warn.hasNonSilentLint(Lint.LintCategory.UNCHECKED)) {
                this.checkWithinBounds(inferenceContext, warn);
                Type newRestype = this.generateReturnConstraints(env.tree, resultInfo, mt, inferenceContext);
                mt = (Type.MethodType)this.types.createMethodTypeWithReturn(mt, newRestype);
                if (resultInfo.checkContext.inferenceContext().free(resultInfo.pt)) {
                    inferenceContext.dupTo(resultInfo.checkContext.inferenceContext());
                    deferredAttrContext.complete();
                    Type.MethodType methodType = mt;
                    return methodType;
                }
            }
            deferredAttrContext.complete();
            if (this.allowGraphInference) {
                inferenceContext.solve(warn);
            } else {
                inferenceContext.solveLegacy(true, warn, LegacyInferenceSteps.EQ_LOWER.steps);
            }
            mt = (Type.MethodType)inferenceContext.asInstType(mt);
            if (!this.allowGraphInference && inferenceContext.restvars().nonEmpty() && resultInfo != null && !warn.hasNonSilentLint(Lint.LintCategory.UNCHECKED)) {
                this.generateReturnConstraints(env.tree, resultInfo, mt, inferenceContext);
                inferenceContext.solveLegacy(false, warn, LegacyInferenceSteps.EQ_UPPER.steps);
                mt = (Type.MethodType)inferenceContext.asInstType(mt);
            }
            if (resultInfo != null && this.rs.verboseResolutionMode.contains((Object)Resolve.VerboseResolutionMode.DEFERRED_INST)) {
                this.log.note(env.tree.pos, "deferred.method.inst", msym, mt, resultInfo.pt);
            }
            Type.MethodType methodType = mt;
            return methodType;
        }
        finally {
            if (resultInfo != null || !this.allowGraphInference) {
                inferenceContext.notifyChange();
            } else {
                inferenceContext.notifyChange(inferenceContext.boundedVars());
            }
            if (resultInfo == null) {
                inferenceContext.captureTypeCache.clear();
            }
        }
    }

    Type generateReturnConstraints(JCTree tree, Attr.ResultInfo resultInfo, Type.MethodType mt, InferenceContext inferenceContext) {
        InferenceContext rsInfoInfContext = resultInfo.checkContext.inferenceContext();
        Type from = mt.getReturnType();
        if (mt.getReturnType().containsAny(inferenceContext.inferencevars) && rsInfoInfContext != this.emptyContext) {
            from = this.types.capture(from);
            for (Type t : from.getTypeArguments()) {
                if (!t.hasTag(TypeTag.TYPEVAR) || !((Type.TypeVar)t).isCaptured()) continue;
                inferenceContext.addVar((Type.TypeVar)t);
            }
        }
        Type qtype = inferenceContext.asUndetVar(from);
        Type to = resultInfo.pt;
        if (qtype.hasTag(TypeTag.VOID)) {
            to = this.syms.voidType;
        } else if (to.hasTag(TypeTag.NONE)) {
            to = from.isPrimitive() ? from : this.syms.objectType;
        } else if (qtype.hasTag(TypeTag.UNDETVAR)) {
            if (resultInfo.pt.isReference()) {
                to = this.generateReturnConstraintsUndetVarToReference(tree, (Type.UndetVar)qtype, to, resultInfo, inferenceContext);
            } else if (to.isPrimitive()) {
                to = this.generateReturnConstraintsPrimitive(tree, (Type.UndetVar)qtype, to, resultInfo, inferenceContext);
            }
        }
        Assert.check(this.allowGraphInference || !rsInfoInfContext.free(to), "legacy inference engine cannot handle constraints on both sides of a subtyping assertion");
        Warner retWarn = new Warner();
        if (!resultInfo.checkContext.compatible(qtype, rsInfoInfContext.asUndetVar(to), retWarn) || !this.allowGraphInference && retWarn.hasLint(Lint.LintCategory.UNCHECKED)) {
            throw this.inferenceException.setMessage("infer.no.conforming.instance.exists", inferenceContext.restvars(), mt.getReturnType(), to);
        }
        return from;
    }

    private Type generateReturnConstraintsPrimitive(JCTree tree, Type.UndetVar from, Type to, Attr.ResultInfo resultInfo, InferenceContext inferenceContext) {
        if (!this.allowGraphInference) {
            return this.types.boxedClass((Type)to).type;
        }
        for (Type t : from.getBounds(Type.UndetVar.InferenceBound.EQ, Type.UndetVar.InferenceBound.UPPER, Type.UndetVar.InferenceBound.LOWER)) {
            Type boundAsPrimitive = this.types.unboxedType(t);
            if (boundAsPrimitive == null || boundAsPrimitive.hasTag(TypeTag.NONE)) continue;
            return this.generateReferenceToTargetConstraint(tree, from, to, resultInfo, inferenceContext);
        }
        return this.types.boxedClass((Type)to).type;
    }

    private Type generateReturnConstraintsUndetVarToReference(JCTree tree, Type.UndetVar from, Type to, Attr.ResultInfo resultInfo, InferenceContext inferenceContext) {
        Type captureOfTo = this.types.capture(to);
        if (captureOfTo == to) {
            for (Type t : from.getBounds(Type.UndetVar.InferenceBound.EQ, Type.UndetVar.InferenceBound.LOWER)) {
                Type captureOfBound = this.types.capture(t);
                if (captureOfBound == t) continue;
                return this.generateReferenceToTargetConstraint(tree, from, to, resultInfo, inferenceContext);
            }
            for (Type aLowerBound : from.getBounds(Type.UndetVar.InferenceBound.LOWER)) {
                for (Type anotherLowerBound : from.getBounds(Type.UndetVar.InferenceBound.LOWER)) {
                    if (aLowerBound == anotherLowerBound || inferenceContext.free(aLowerBound) || inferenceContext.free(anotherLowerBound) || !this.commonSuperWithDiffParameterization(aLowerBound, anotherLowerBound)) continue;
                    return this.generateReferenceToTargetConstraint(tree, from, to, resultInfo, inferenceContext);
                }
            }
        }
        if (to.isParameterized()) {
            for (Type t : from.getBounds(Type.UndetVar.InferenceBound.EQ, Type.UndetVar.InferenceBound.LOWER)) {
                Type sup = this.types.asSuper(t, to.tsym);
                if (sup == null || !sup.isRaw()) continue;
                return this.generateReferenceToTargetConstraint(tree, from, to, resultInfo, inferenceContext);
            }
        }
        return to;
    }

    private boolean commonSuperWithDiffParameterization(Type t, Type s) {
        Pair<Type, Type> supers = this.getParameterizedSupers(t, s);
        return supers != null && !this.types.isSameType((Type)supers.fst, (Type)supers.snd);
    }

    private Type generateReferenceToTargetConstraint(JCTree tree, Type.UndetVar from, Type to, Attr.ResultInfo resultInfo, InferenceContext inferenceContext) {
        inferenceContext.solve(List.of(from.qtype), new Warner());
        inferenceContext.notifyChange();
        Type capturedType = resultInfo.checkContext.inferenceContext().cachedCapture(tree, from.inst, false);
        if (this.types.isConvertible(capturedType, resultInfo.checkContext.inferenceContext().asUndetVar(to))) {
            return this.syms.objectType;
        }
        return to;
    }

    private void instantiateAsUninferredVars(List<Type> vars, InferenceContext inferenceContext) {
        ListBuffer<Type.UndetVar> todo = new ListBuffer<Type.UndetVar>();
        for (Type t : vars) {
            Type.UndetVar undetVar = (Type.UndetVar)inferenceContext.asUndetVar(t);
            List<Type> upperBounds = undetVar.getBounds(Type.UndetVar.InferenceBound.UPPER);
            if (Type.containsAny(upperBounds, vars)) {
                Symbol.TypeVariableSymbol fresh_tvar = new Symbol.TypeVariableSymbol(4096L, undetVar.qtype.tsym.name, null, undetVar.qtype.tsym.owner);
                fresh_tvar.type = new Type.TypeVar(fresh_tvar, this.types.makeCompoundType(undetVar.getBounds(Type.UndetVar.InferenceBound.UPPER)), null);
                todo.append(undetVar);
                undetVar.inst = fresh_tvar.type;
                continue;
            }
            if (upperBounds.nonEmpty()) {
                undetVar.inst = this.types.glb(upperBounds);
                continue;
            }
            undetVar.inst = this.syms.objectType;
        }
        List<Type> formals = vars;
        for (Type type : todo) {
            Type.UndetVar uv = (Type.UndetVar)type;
            Type.TypeVar ct = (Type.TypeVar)uv.inst;
            ct.bound = this.types.glb(inferenceContext.asInstTypes(this.types.getBounds(ct)));
            if (ct.bound.isErroneous()) {
                this.reportBoundError(uv, BoundErrorKind.BAD_UPPER);
            }
            formals = formals.tail;
        }
    }

    Type instantiatePolymorphicSignatureInstance(Env<AttrContext> env, Symbol.MethodSymbol spMethod, Resolve.MethodResolutionContext resolveContext, List<Type> argtypes) {
        Type restype;
        switch (env.next.tree.getTag()) {
            case TYPECAST: {
                JCTree.JCTypeCast castTree = (JCTree.JCTypeCast)env.next.tree;
                restype = TreeInfo.skipParens(castTree.expr) == env.tree ? castTree.clazz.type : this.syms.objectType;
                break;
            }
            case EXEC: {
                JCTree.JCExpressionStatement execTree = (JCTree.JCExpressionStatement)env.next.tree;
                restype = TreeInfo.skipParens(execTree.expr) == env.tree ? this.syms.voidType : this.syms.objectType;
                break;
            }
            default: {
                restype = this.syms.objectType;
            }
        }
        List<Type> paramtypes = Type.map(argtypes, new ImplicitArgType(spMethod, resolveContext.step));
        List<Type> exType = spMethod != null ? spMethod.getThrownTypes() : List.of(this.syms.throwableType);
        Type.MethodType mtype = new Type.MethodType(paramtypes, restype, exType, this.syms.methodClass);
        return mtype;
    }

    public Type instantiateFunctionalInterface(JCDiagnostic.DiagnosticPosition pos, Type funcInterface, List<Type> paramTypes, Check.CheckContext checkContext) {
        if (this.types.capture(funcInterface) == funcInterface) {
            return funcInterface;
        }
        Type formalInterface = funcInterface.tsym.type;
        InferenceContext funcInterfaceContext = new InferenceContext(funcInterface.tsym.type.getTypeArguments());
        Assert.check(paramTypes != null);
        List<Type> descParameterTypes = this.types.findDescriptorType(formalInterface).getParameterTypes();
        if (descParameterTypes.size() != paramTypes.size()) {
            checkContext.report(pos, this.diags.fragment("incompatible.arg.types.in.lambda", new Object[0]));
            return this.types.createErrorType(funcInterface);
        }
        for (Type type : descParameterTypes) {
            if (!this.types.isSameType(funcInterfaceContext.asUndetVar(type), (Type)paramTypes.head)) {
                checkContext.report(pos, this.diags.fragment("no.suitable.functional.intf.inst", funcInterface));
                return this.types.createErrorType(funcInterface);
            }
            paramTypes = paramTypes.tail;
        }
        try {
            funcInterfaceContext.solve(funcInterfaceContext.boundedVars(), this.types.noWarnings);
        }
        catch (InferenceException ex) {
            checkContext.report(pos, this.diags.fragment("no.suitable.functional.intf.inst", funcInterface));
        }
        List<Type> actualTypeargs = funcInterface.getTypeArguments();
        for (Type t : funcInterfaceContext.undetvars) {
            Type.UndetVar uv = (Type.UndetVar)t;
            if (uv.inst == null) {
                uv.inst = (Type)actualTypeargs.head;
            }
            actualTypeargs = actualTypeargs.tail;
        }
        Type type = funcInterfaceContext.asInstType(formalInterface);
        if (!this.chk.checkValidGenericType(type)) {
            checkContext.report(pos, this.diags.fragment("no.suitable.functional.intf.inst", funcInterface));
        }
        checkContext.compatible(type, funcInterface, this.types.noWarnings);
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkWithinBounds(InferenceContext inferenceContext, Warner warn) throws InferenceException {
        MultiUndetVarListener mlistener = new MultiUndetVarListener(inferenceContext.undetvars);
        List<Type> saved_undet = inferenceContext.save();
        try {
            do {
                Type.UndetVar uv;
                mlistener.reset();
                if (!this.allowGraphInference) {
                    for (Type t : inferenceContext.undetvars) {
                        uv = (Type.UndetVar)t;
                        IncorporationStep.CHECK_BOUNDS.apply(uv, inferenceContext, warn);
                    }
                }
                for (Type t : inferenceContext.undetvars) {
                    uv = (Type.UndetVar)t;
                    EnumSet<IncorporationStep> incorporationSteps = this.allowGraphInference ? this.incorporationStepsGraph : this.incorporationStepsLegacy;
                    for (IncorporationStep is : incorporationSteps) {
                        if (!is.accepts(uv, inferenceContext)) continue;
                        is.apply(uv, inferenceContext, warn);
                    }
                }
            } while (mlistener.changed && this.allowGraphInference);
        }
        finally {
            mlistener.detach();
            if (this.incorporationCache.size() == 100) {
                inferenceContext.rollback(saved_undet);
            }
            this.incorporationCache.clear();
        }
    }

    private Pair<Type, Type> getParameterizedSupers(Type t, Type s) {
        Type lubResult = this.types.lub(t, s);
        if (lubResult == this.syms.errType || lubResult == this.syms.botType || !lubResult.isParameterized()) {
            return null;
        }
        Type asSuperOfT = this.types.asSuper(t, lubResult.tsym);
        Type asSuperOfS = this.types.asSuper(s, lubResult.tsym);
        return new Pair<Type, Type>(asSuperOfT, asSuperOfS);
    }

    void checkCompatibleUpperBounds(Type.UndetVar uv, InferenceContext inferenceContext) {
        List<Type> hibounds = Type.filter(uv.getBounds(Type.UndetVar.InferenceBound.UPPER), new BoundFilter(inferenceContext));
        Type hb = null;
        hb = hibounds.isEmpty() ? this.syms.objectType : (hibounds.tail.isEmpty() ? (Type)hibounds.head : this.types.glb(hibounds));
        if (hb == null || hb.isErroneous()) {
            this.reportBoundError(uv, BoundErrorKind.BAD_UPPER);
        }
    }

    void reportBoundError(Type.UndetVar uv, BoundErrorKind bk) {
        throw bk.setMessage(this.inferenceException, uv);
    }

    class InferenceContext {
        List<Type> undetvars;
        List<Type> inferencevars;
        Map<FreeTypeListener, List<Type>> freeTypeListeners = new HashMap<FreeTypeListener, List<Type>>();
        List<FreeTypeListener> freetypeListeners = List.nil();
        Type.Mapping fromTypeVarFun = new Type.Mapping("fromTypeVarFunWithBounds"){

            @Override
            public Type apply(Type t) {
                if (t.hasTag(TypeTag.TYPEVAR)) {
                    Type.TypeVar tv = (Type.TypeVar)t;
                    if (tv.isCaptured()) {
                        return new Type.CapturedUndetVar((Type.CapturedType)tv, Infer.this.types);
                    }
                    return new Type.UndetVar(tv, Infer.this.types);
                }
                return t.map(this);
            }
        };
        Map<JCTree, Type> captureTypeCache = new HashMap<JCTree, Type>();

        public InferenceContext(List<Type> inferencevars) {
            this.undetvars = Type.map(inferencevars, this.fromTypeVarFun);
            this.inferencevars = inferencevars;
        }

        void addVar(Type.TypeVar t) {
            this.undetvars = this.undetvars.prepend(this.fromTypeVarFun.apply(t));
            this.inferencevars = this.inferencevars.prepend(t);
        }

        List<Type> inferenceVars() {
            return this.inferencevars;
        }

        List<Type> restvars() {
            return this.filterVars(new Filter<Type.UndetVar>(){

                @Override
                public boolean accepts(Type.UndetVar uv) {
                    return uv.inst == null;
                }
            });
        }

        List<Type> instvars() {
            return this.filterVars(new Filter<Type.UndetVar>(){

                @Override
                public boolean accepts(Type.UndetVar uv) {
                    return uv.inst != null;
                }
            });
        }

        final List<Type> boundedVars() {
            return this.filterVars(new Filter<Type.UndetVar>(){

                @Override
                public boolean accepts(Type.UndetVar uv) {
                    return uv.getBounds(Type.UndetVar.InferenceBound.UPPER).diff(uv.getDeclaredBounds()).appendList(uv.getBounds(Type.UndetVar.InferenceBound.EQ, Type.UndetVar.InferenceBound.LOWER)).nonEmpty();
                }
            });
        }

        private List<Type> filterVars(Filter<Type.UndetVar> fu) {
            ListBuffer<Type> res = new ListBuffer<Type>();
            for (Type t : this.undetvars) {
                Type.UndetVar uv = (Type.UndetVar)t;
                if (!fu.accepts(uv)) continue;
                res.append(uv.qtype);
            }
            return res.toList();
        }

        final boolean free(Type t) {
            return t.containsAny(this.inferencevars);
        }

        final boolean free(List<Type> ts) {
            for (Type t : ts) {
                if (!this.free(t)) continue;
                return true;
            }
            return false;
        }

        final List<Type> freeVarsIn(Type t) {
            ListBuffer<Type> buf = new ListBuffer<Type>();
            for (Type iv : this.inferenceVars()) {
                if (!t.contains(iv)) continue;
                buf.add(iv);
            }
            return buf.toList();
        }

        final List<Type> freeVarsIn(List<Type> ts) {
            ListBuffer<Type> buf = new ListBuffer<Type>();
            for (Type t : ts) {
                buf.appendList(this.freeVarsIn(t));
            }
            ListBuffer<Type> buf2 = new ListBuffer<Type>();
            for (Type t : buf) {
                if (buf2.contains(t)) continue;
                buf2.add(t);
            }
            return buf2.toList();
        }

        final Type asUndetVar(Type t) {
            return Infer.this.types.subst(t, this.inferencevars, this.undetvars);
        }

        final List<Type> asUndetVars(List<Type> ts) {
            ListBuffer<Type> buf = new ListBuffer<Type>();
            for (Type t : ts) {
                buf.append(this.asUndetVar(t));
            }
            return buf.toList();
        }

        List<Type> instTypes() {
            ListBuffer<Type> buf = new ListBuffer<Type>();
            for (Type t : this.undetvars) {
                Type.UndetVar uv = (Type.UndetVar)t;
                buf.append(uv.inst != null ? uv.inst : uv.qtype);
            }
            return buf.toList();
        }

        Type asInstType(Type t) {
            return Infer.this.types.subst(t, this.inferencevars, this.instTypes());
        }

        List<Type> asInstTypes(List<Type> ts) {
            ListBuffer<Type> buf = new ListBuffer<Type>();
            for (Type t : ts) {
                buf.append(this.asInstType(t));
            }
            return buf.toList();
        }

        void addFreeTypeListener(List<Type> types, FreeTypeListener ftl) {
            this.freeTypeListeners.put(ftl, this.freeVarsIn(types));
        }

        void notifyChange() {
            this.notifyChange(this.inferencevars.diff(this.restvars()));
        }

        void notifyChange(List<Type> inferredVars) {
            InferenceException thrownEx = null;
            for (Map.Entry<FreeTypeListener, List<Type>> entry : new HashMap<FreeTypeListener, List<Type>>(this.freeTypeListeners).entrySet()) {
                if (Type.containsAny(entry.getValue(), this.inferencevars.diff(inferredVars))) continue;
                try {
                    entry.getKey().typesInferred(this);
                    this.freeTypeListeners.remove(entry.getKey());
                }
                catch (InferenceException ex) {
                    if (thrownEx != null) continue;
                    thrownEx = ex;
                }
            }
            if (thrownEx != null) {
                throw thrownEx;
            }
        }

        List<Type> save() {
            ListBuffer<Type.UndetVar> buf = new ListBuffer<Type.UndetVar>();
            for (Type t : this.undetvars) {
                Type.UndetVar uv = (Type.UndetVar)t;
                Type.UndetVar uv2 = new Type.UndetVar((Type.TypeVar)uv.qtype, Infer.this.types);
                for (Type.UndetVar.InferenceBound ib : Type.UndetVar.InferenceBound.values()) {
                    for (Type b : uv.getBounds(ib)) {
                        uv2.addBound(ib, b, Infer.this.types);
                    }
                }
                uv2.inst = uv.inst;
                buf.add(uv2);
            }
            return buf.toList();
        }

        void rollback(List<Type> saved_undet) {
            Assert.check(saved_undet != null && saved_undet.length() == this.undetvars.length());
            for (Type t : this.undetvars) {
                Type.UndetVar uv = (Type.UndetVar)t;
                Type.UndetVar uv_saved = (Type.UndetVar)saved_undet.head;
                for (Type.UndetVar.InferenceBound ib : Type.UndetVar.InferenceBound.values()) {
                    uv.setBounds(ib, uv_saved.getBounds(ib));
                }
                uv.inst = uv_saved.inst;
                saved_undet = saved_undet.tail;
            }
        }

        void dupTo(InferenceContext that) {
            that.inferencevars = that.inferencevars.appendList(this.inferencevars.diff(that.inferencevars));
            that.undetvars = that.undetvars.appendList(this.undetvars.diff(that.undetvars));
            for (Type t : this.inferencevars) {
                that.freeTypeListeners.put(new FreeTypeListener(){

                    @Override
                    public void typesInferred(InferenceContext inferenceContext) {
                        InferenceContext.this.notifyChange();
                    }
                }, List.of(t));
            }
        }

        private void solve(GraphStrategy ss, Warner warn) {
            this.solve(ss, new HashMap<Type, Set<Type>>(), warn);
        }

        private void solve(GraphStrategy ss, Map<Type, Set<Type>> stuckDeps, Warner warn) {
            GraphSolver s = new GraphSolver(this, stuckDeps, warn);
            s.solve(ss);
        }

        public void solve(Warner warn) {
            this.solve(new LeafSolver(){

                @Override
                public boolean done() {
                    return InferenceContext.this.restvars().isEmpty();
                }
            }, warn);
        }

        public void solve(final List<Type> vars, Warner warn) {
            this.solve(new BestLeafSolver(vars){

                @Override
                public boolean done() {
                    return !InferenceContext.this.free(InferenceContext.this.asInstTypes(vars));
                }
            }, warn);
        }

        public void solveAny(List<Type> varsToSolve, Map<Type, Set<Type>> optDeps, Warner warn) {
            this.solve(new BestLeafSolver(varsToSolve.intersect(this.restvars())){

                @Override
                public boolean done() {
                    return InferenceContext.this.instvars().intersect(this.varsToSolve).nonEmpty();
                }
            }, optDeps, warn);
        }

        private boolean solveBasic(EnumSet<InferenceStep> steps) {
            return this.solveBasic(this.inferencevars, steps);
        }

        private boolean solveBasic(List<Type> varsToSolve, EnumSet<InferenceStep> steps) {
            boolean changed = false;
            block0: for (Type t : varsToSolve.intersect(this.restvars())) {
                Type.UndetVar uv = (Type.UndetVar)this.asUndetVar(t);
                for (InferenceStep step : steps) {
                    if (!step.accepts(uv, this)) continue;
                    uv.inst = step.solve(uv, this);
                    changed = true;
                    continue block0;
                }
            }
            return changed;
        }

        public void solveLegacy(boolean partial, Warner warn, EnumSet<InferenceStep> steps) {
            block0: while (true) {
                boolean stuck;
                boolean bl = stuck = !this.solveBasic(steps);
                if (this.restvars().isEmpty() || partial) break;
                if (stuck) {
                    Infer.this.instantiateAsUninferredVars(this.restvars(), this);
                    break;
                }
                Iterator<Type> iterator = this.undetvars.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block0;
                    Type t = iterator.next();
                    Type.UndetVar uv = (Type.UndetVar)t;
                    uv.substBounds(this.inferenceVars(), this.instTypes(), Infer.this.types);
                }
                break;
            }
            Infer.this.checkWithinBounds(this, warn);
        }

        private Infer infer() {
            return Infer.this;
        }

        public String toString() {
            return "Inference vars: " + this.inferencevars + '\n' + "Undet vars: " + this.undetvars;
        }

        Type cachedCapture(JCTree tree, Type t, boolean readOnly) {
            Type captured = this.captureTypeCache.get(tree);
            if (captured != null) {
                return captured;
            }
            Type result = Infer.this.types.capture(t);
            if (result != t && !readOnly) {
                this.captureTypeCache.put(tree, result);
            }
            return result;
        }
    }

    static interface FreeTypeListener {
        public void typesInferred(InferenceContext var1);
    }

    class GraphSolver {
        InferenceContext inferenceContext;
        Map<Type, Set<Type>> stuckDeps;
        Warner warn;

        GraphSolver(InferenceContext inferenceContext, Map<Type, Set<Type>> stuckDeps, Warner warn) {
            this.inferenceContext = inferenceContext;
            this.stuckDeps = stuckDeps;
            this.warn = warn;
        }

        void solve(GraphStrategy sstrategy) {
            Infer.this.checkWithinBounds(this.inferenceContext, this.warn);
            InferenceGraph inferenceGraph = new InferenceGraph(this.stuckDeps);
            while (!sstrategy.done()) {
                InferenceGraph.Node nodeToSolve = sstrategy.pickNode(inferenceGraph);
                List<Type> varsToSolve = List.from((Iterable)nodeToSolve.data);
                List<Type> saved_undet = this.inferenceContext.save();
                try {
                    block3: while (Type.containsAny(this.inferenceContext.restvars(), varsToSolve)) {
                        for (GraphInferenceSteps step : GraphInferenceSteps.values()) {
                            if (!this.inferenceContext.solveBasic(varsToSolve, step.steps)) continue;
                            Infer.this.checkWithinBounds(this.inferenceContext, this.warn);
                            continue block3;
                        }
                        throw Infer.this.inferenceException.setMessage();
                    }
                }
                catch (InferenceException ex) {
                    this.inferenceContext.rollback(saved_undet);
                    Infer.this.instantiateAsUninferredVars(varsToSolve, this.inferenceContext);
                    Infer.this.checkWithinBounds(this.inferenceContext, this.warn);
                }
                inferenceGraph.deleteNode(nodeToSolve);
            }
        }

        class InferenceGraph {
            ArrayList<Node> nodes;

            InferenceGraph(Map<Type, Set<Type>> optDeps) {
                this.initNodes(optDeps);
            }

            public Node findNode(Type t) {
                for (Node n : this.nodes) {
                    if (!((ListBuffer)n.data).contains(t)) continue;
                    return n;
                }
                return null;
            }

            public void deleteNode(Node n) {
                Assert.check(this.nodes.contains(n));
                this.nodes.remove(n);
                this.notifyUpdate(n, null);
            }

            void notifyUpdate(Node from, Node to) {
                for (Node n : this.nodes) {
                    n.graphChanged(from, to);
                }
            }

            void initNodes(Map<Type, Set<Type>> stuckDeps) {
                this.nodes = new ArrayList();
                for (Type t : GraphSolver.this.inferenceContext.restvars()) {
                    this.nodes.add(new Node(t));
                }
                for (Node n_i : this.nodes) {
                    Type i = (Type)((ListBuffer)n_i.data).first();
                    Set<Type> optDepsByNode = stuckDeps.get(i);
                    for (Node n_j : this.nodes) {
                        Type j = (Type)((ListBuffer)n_j.data).first();
                        Type.UndetVar uv_i = (Type.UndetVar)GraphSolver.this.inferenceContext.asUndetVar(i);
                        if (Type.containsAny(uv_i.getBounds(Type.UndetVar.InferenceBound.values()), List.of(j))) {
                            n_i.addDependency(DependencyKind.BOUND, n_j);
                        }
                        if (optDepsByNode == null || !optDepsByNode.contains(j)) continue;
                        n_i.addDependency(DependencyKind.STUCK, n_j);
                    }
                }
                ArrayList acyclicNodes = new ArrayList();
                for (List<Node> conSubGraph : GraphUtils.tarjan(this.nodes)) {
                    if (conSubGraph.length() > 1) {
                        Node root = (Node)conSubGraph.head;
                        root.mergeWith(conSubGraph.tail);
                        for (Node n : conSubGraph) {
                            this.notifyUpdate(n, root);
                        }
                    }
                    acyclicNodes.add(conSubGraph.head);
                }
                this.nodes = acyclicNodes;
            }

            String toDot() {
                StringBuilder buf = new StringBuilder();
                for (Type t : GraphSolver.this.inferenceContext.undetvars) {
                    Type.UndetVar uv = (Type.UndetVar)t;
                    buf.append(String.format("var %s - upper bounds = %s, lower bounds = %s, eq bounds = %s\\n", uv.qtype, uv.getBounds(Type.UndetVar.InferenceBound.UPPER), uv.getBounds(Type.UndetVar.InferenceBound.LOWER), uv.getBounds(Type.UndetVar.InferenceBound.EQ)));
                }
                return GraphUtils.toDot(this.nodes, "inferenceGraph" + this.hashCode(), buf.toString());
            }

            class Node
            extends GraphUtils.TarjanNode<ListBuffer<Type>> {
                EnumMap<DependencyKind, Set<Node>> deps;

                Node(Type ivar) {
                    super(ListBuffer.of(ivar));
                    this.deps = new EnumMap(DependencyKind.class);
                }

                @Override
                public GraphUtils.DependencyKind[] getSupportedDependencyKinds() {
                    return DependencyKind.values();
                }

                @Override
                public String getDependencyName(GraphUtils.Node<ListBuffer<Type>> to, GraphUtils.DependencyKind dk) {
                    if (dk == DependencyKind.STUCK) {
                        return "";
                    }
                    StringBuilder buf = new StringBuilder();
                    String sep = "";
                    for (Type from : (ListBuffer)this.data) {
                        Type.UndetVar uv = (Type.UndetVar)GraphSolver.this.inferenceContext.asUndetVar(from);
                        for (Type bound : uv.getBounds(Type.UndetVar.InferenceBound.values())) {
                            if (!bound.containsAny(List.from((Iterable)to.data))) continue;
                            buf.append(sep);
                            buf.append(bound);
                            sep = ",";
                        }
                    }
                    return buf.toString();
                }

                @Override
                public Iterable<? extends Node> getAllDependencies() {
                    return this.getDependencies(DependencyKind.values());
                }

                @Override
                public Iterable<? extends GraphUtils.TarjanNode<ListBuffer<Type>>> getDependenciesByKind(GraphUtils.DependencyKind dk) {
                    return this.getDependencies((DependencyKind)dk);
                }

                protected Set<Node> getDependencies(DependencyKind ... depKinds) {
                    LinkedHashSet<Node> buf = new LinkedHashSet<Node>();
                    for (DependencyKind dk : depKinds) {
                        Set<Node> depsByKind = this.deps.get(dk);
                        if (depsByKind == null) continue;
                        buf.addAll(depsByKind);
                    }
                    return buf;
                }

                protected void addDependency(DependencyKind dk, Node depToAdd) {
                    Set<Node> depsByKind = this.deps.get(dk);
                    if (depsByKind == null) {
                        depsByKind = new LinkedHashSet<Node>();
                        this.deps.put(dk, depsByKind);
                    }
                    depsByKind.add(depToAdd);
                }

                protected void addDependencies(DependencyKind dk, Set<Node> depsToAdd) {
                    for (Node n : depsToAdd) {
                        this.addDependency(dk, n);
                    }
                }

                protected Set<DependencyKind> removeDependency(Node n) {
                    HashSet<DependencyKind> removedKinds = new HashSet<DependencyKind>();
                    for (DependencyKind dk : DependencyKind.values()) {
                        Set<Node> depsByKind = this.deps.get(dk);
                        if (depsByKind == null || !depsByKind.remove(n)) continue;
                        removedKinds.add(dk);
                    }
                    return removedKinds;
                }

                protected Set<Node> closure(DependencyKind ... depKinds) {
                    boolean progress = true;
                    HashSet<Node> closure = new HashSet<Node>();
                    closure.add(this);
                    while (progress) {
                        progress = false;
                        for (Node n1 : new HashSet<Node>(closure)) {
                            progress = closure.addAll(n1.getDependencies(depKinds));
                        }
                    }
                    return closure;
                }

                protected boolean isLeaf() {
                    Set<Node> allDeps = this.getDependencies(DependencyKind.BOUND, DependencyKind.STUCK);
                    if (allDeps.isEmpty()) {
                        return true;
                    }
                    for (Node n : allDeps) {
                        if (n == this) continue;
                        return false;
                    }
                    return true;
                }

                protected void mergeWith(List<? extends Node> nodes) {
                    for (Node node : nodes) {
                        Assert.check(((ListBuffer)node.data).length() == 1, "Attempt to merge a compound node!");
                        ((ListBuffer)this.data).appendList((ListBuffer)node.data);
                        DependencyKind[] dependencyKindArray = DependencyKind.values();
                        int n = dependencyKindArray.length;
                        for (int i = 0; i < n; ++i) {
                            DependencyKind dk = dependencyKindArray[i];
                            this.addDependencies(dk, node.getDependencies(dk));
                        }
                    }
                    EnumMap deps2 = new EnumMap(DependencyKind.class);
                    for (DependencyKind dk : DependencyKind.values()) {
                        for (Node d : this.getDependencies(dk)) {
                            LinkedHashSet<Node> depsByKind = (LinkedHashSet<Node>)deps2.get(dk);
                            if (depsByKind == null) {
                                depsByKind = new LinkedHashSet<Node>();
                                deps2.put(dk, depsByKind);
                            }
                            if (((ListBuffer)this.data).contains(((ListBuffer)d.data).first())) {
                                depsByKind.add(this);
                                continue;
                            }
                            depsByKind.add(d);
                        }
                    }
                    this.deps = deps2;
                }

                private void graphChanged(Node from, Node to) {
                    for (DependencyKind dk : this.removeDependency(from)) {
                        if (to == null) continue;
                        this.addDependency(dk, to);
                    }
                }
            }
        }
    }

    static enum DependencyKind implements GraphUtils.DependencyKind
    {
        BOUND("dotted"),
        STUCK("dashed");

        final String dotSyle;

        private DependencyKind(String dotSyle) {
            this.dotSyle = dotSyle;
        }

        @Override
        public String getDotStyle() {
            return this.dotSyle;
        }
    }

    static enum GraphInferenceSteps {
        EQ(EnumSet.of(InferenceStep.EQ)),
        EQ_LOWER(EnumSet.of(InferenceStep.EQ, InferenceStep.LOWER)),
        EQ_LOWER_THROWS_UPPER_CAPTURED(EnumSet.of(InferenceStep.EQ, InferenceStep.LOWER, InferenceStep.UPPER, InferenceStep.THROWS, InferenceStep.CAPTURED));

        final EnumSet<InferenceStep> steps;

        private GraphInferenceSteps(EnumSet<InferenceStep> steps) {
            this.steps = steps;
        }
    }

    static enum LegacyInferenceSteps {
        EQ_LOWER(EnumSet.of(InferenceStep.EQ, InferenceStep.LOWER)),
        EQ_UPPER(EnumSet.of(InferenceStep.EQ, InferenceStep.UPPER_LEGACY));

        final EnumSet<InferenceStep> steps;

        private LegacyInferenceSteps(EnumSet<InferenceStep> steps) {
            this.steps = steps;
        }
    }

    static enum InferenceStep {
        EQ(Type.UndetVar.InferenceBound.EQ){

            @Override
            Type solve(Type.UndetVar uv, InferenceContext inferenceContext) {
                return (Type)this.filterBounds((Type.UndetVar)uv, (InferenceContext)inferenceContext).head;
            }
        }
        ,
        LOWER(Type.UndetVar.InferenceBound.LOWER){

            @Override
            Type solve(Type.UndetVar uv, InferenceContext inferenceContext) {
                Type owntype;
                Infer infer = inferenceContext.infer();
                List<Type> lobounds = this.filterBounds(uv, inferenceContext);
                Type type = owntype = lobounds.tail.tail == null ? (Type)lobounds.head : infer.types.lub(lobounds);
                if (owntype.isPrimitive() || owntype.hasTag(TypeTag.ERROR)) {
                    throw infer.inferenceException.setMessage("no.unique.minimal.instance.exists", uv.qtype, lobounds);
                }
                return owntype;
            }
        }
        ,
        THROWS(Type.UndetVar.InferenceBound.UPPER){

            @Override
            public boolean accepts(Type.UndetVar t, InferenceContext inferenceContext) {
                if ((t.qtype.tsym.flags() & 0x800000000000L) == 0L) {
                    return false;
                }
                if (t.getBounds(Type.UndetVar.InferenceBound.EQ, Type.UndetVar.InferenceBound.LOWER, Type.UndetVar.InferenceBound.UPPER).diff(t.getDeclaredBounds()).nonEmpty()) {
                    return false;
                }
                Infer infer = inferenceContext.infer();
                for (Type db : t.getDeclaredBounds()) {
                    if (t.isInterface() || infer.types.asSuper(infer.syms.runtimeExceptionType, db.tsym) == null) continue;
                    return true;
                }
                return false;
            }

            @Override
            Type solve(Type.UndetVar uv, InferenceContext inferenceContext) {
                return ((InferenceContext)inferenceContext).infer().syms.runtimeExceptionType;
            }
        }
        ,
        UPPER(Type.UndetVar.InferenceBound.UPPER){

            @Override
            Type solve(Type.UndetVar uv, InferenceContext inferenceContext) {
                Type owntype;
                Infer infer = inferenceContext.infer();
                List<Type> hibounds = this.filterBounds(uv, inferenceContext);
                Type type = owntype = hibounds.tail.tail == null ? (Type)hibounds.head : infer.types.glb(hibounds);
                if (owntype.isPrimitive() || owntype.hasTag(TypeTag.ERROR)) {
                    throw infer.inferenceException.setMessage("no.unique.maximal.instance.exists", uv.qtype, hibounds);
                }
                return owntype;
            }
        }
        ,
        UPPER_LEGACY(Type.UndetVar.InferenceBound.UPPER){

            @Override
            public boolean accepts(Type.UndetVar t, InferenceContext inferenceContext) {
                return !inferenceContext.free(t.getBounds(this.ib)) && !t.isCaptured();
            }

            @Override
            Type solve(Type.UndetVar uv, InferenceContext inferenceContext) {
                return UPPER.solve(uv, inferenceContext);
            }
        }
        ,
        CAPTURED(Type.UndetVar.InferenceBound.UPPER){

            @Override
            public boolean accepts(Type.UndetVar t, InferenceContext inferenceContext) {
                return t.isCaptured() && !inferenceContext.free(t.getBounds(Type.UndetVar.InferenceBound.UPPER, Type.UndetVar.InferenceBound.LOWER));
            }

            @Override
            Type solve(Type.UndetVar uv, InferenceContext inferenceContext) {
                Infer infer = inferenceContext.infer();
                Type upper = UPPER.filterBounds(uv, inferenceContext).nonEmpty() ? UPPER.solve(uv, inferenceContext) : infer.syms.objectType;
                Type lower = LOWER.filterBounds(uv, inferenceContext).nonEmpty() ? LOWER.solve(uv, inferenceContext) : infer.syms.botType;
                Type.CapturedType prevCaptured = (Type.CapturedType)uv.qtype;
                return new Type.CapturedType(prevCaptured.tsym.name, prevCaptured.tsym.owner, upper, lower, prevCaptured.wildcard);
            }
        };

        final Type.UndetVar.InferenceBound ib;

        private InferenceStep(Type.UndetVar.InferenceBound ib) {
            this.ib = ib;
        }

        abstract Type solve(Type.UndetVar var1, InferenceContext var2);

        public boolean accepts(Type.UndetVar t, InferenceContext inferenceContext) {
            return this.filterBounds(t, inferenceContext).nonEmpty() && !t.isCaptured();
        }

        List<Type> filterBounds(Type.UndetVar uv, InferenceContext inferenceContext) {
            return Type.filter(uv.getBounds(this.ib), new BoundFilter(inferenceContext));
        }
    }

    abstract class BestLeafSolver
    extends LeafSolver {
        List<Type> varsToSolve;
        final Map<GraphSolver.InferenceGraph.Node, Pair<List<GraphSolver.InferenceGraph.Node>, Integer>> treeCache;
        final Pair<List<GraphSolver.InferenceGraph.Node>, Integer> noPath;

        BestLeafSolver(List<Type> varsToSolve) {
            this.treeCache = new HashMap<GraphSolver.InferenceGraph.Node, Pair<List<GraphSolver.InferenceGraph.Node>, Integer>>();
            this.noPath = new Pair<Object, Integer>(null, Integer.MAX_VALUE);
            this.varsToSolve = varsToSolve;
        }

        Pair<List<GraphSolver.InferenceGraph.Node>, Integer> computeTreeToLeafs(GraphSolver.InferenceGraph.Node n) {
            Pair<List<GraphSolver.InferenceGraph.Node>, Integer> cachedPath = this.treeCache.get(n);
            if (cachedPath == null) {
                if (n.isLeaf()) {
                    cachedPath = new Pair<List<GraphSolver.InferenceGraph.Node>, Integer>(List.of(n), ((ListBuffer)n.data).length());
                } else {
                    Pair<List<GraphSolver.InferenceGraph.Node>, Integer> path = new Pair<List<GraphSolver.InferenceGraph.Node>, Integer>(List.of(n), ((ListBuffer)n.data).length());
                    for (GraphSolver.InferenceGraph.Node node : n.getAllDependencies()) {
                        if (node == n) continue;
                        Pair<List<GraphSolver.InferenceGraph.Node>, Integer> subpath = this.computeTreeToLeafs(node);
                        path = new Pair(((List)path.fst).prependList((List)subpath.fst), (Integer)path.snd + (Integer)subpath.snd);
                    }
                    cachedPath = path;
                }
                this.treeCache.put(n, cachedPath);
            }
            return cachedPath;
        }

        @Override
        public GraphSolver.InferenceGraph.Node pickNode(GraphSolver.InferenceGraph g) {
            this.treeCache.clear();
            Pair<List<GraphSolver.InferenceGraph.Node>, Integer> bestPath = this.noPath;
            for (GraphSolver.InferenceGraph.Node n : g.nodes) {
                if (Collections.disjoint((Collection)n.data, this.varsToSolve)) continue;
                Pair<List<GraphSolver.InferenceGraph.Node>, Integer> path = this.computeTreeToLeafs(n);
                if ((Integer)path.snd >= (Integer)bestPath.snd) continue;
                bestPath = path;
            }
            if (bestPath == this.noPath) {
                throw new GraphStrategy.NodeNotFoundException(g);
            }
            return (GraphSolver.InferenceGraph.Node)((List)bestPath.fst).head;
        }
    }

    abstract class LeafSolver
    implements GraphStrategy {
        LeafSolver() {
        }

        @Override
        public GraphSolver.InferenceGraph.Node pickNode(GraphSolver.InferenceGraph g) {
            if (g.nodes.isEmpty()) {
                throw new GraphStrategy.NodeNotFoundException(g);
            }
            return g.nodes.get(0);
        }

        boolean isSubtype(Type s, Type t, Warner warn, Infer infer) {
            return this.doIncorporationOp(IncorporationBinaryOpKind.IS_SUBTYPE, s, t, warn, infer);
        }

        boolean isSameType(Type s, Type t, Infer infer) {
            return this.doIncorporationOp(IncorporationBinaryOpKind.IS_SAME_TYPE, s, t, null, infer);
        }

        void addBound(Type.UndetVar.InferenceBound ib, Type.UndetVar uv, Type b, Infer infer) {
            this.doIncorporationOp(this.opFor(ib), uv, b, null, infer);
        }

        IncorporationBinaryOpKind opFor(Type.UndetVar.InferenceBound boundKind) {
            switch (boundKind) {
                case EQ: {
                    return IncorporationBinaryOpKind.ADD_EQ_BOUND;
                }
                case LOWER: {
                    return IncorporationBinaryOpKind.ADD_LOWER_BOUND;
                }
                case UPPER: {
                    return IncorporationBinaryOpKind.ADD_UPPER_BOUND;
                }
            }
            Assert.error("Can't get here!");
            return null;
        }

        boolean doIncorporationOp(IncorporationBinaryOpKind opKind, Type op1, Type op2, Warner warn, Infer infer) {
            Infer infer2 = infer;
            infer2.getClass();
            IncorporationBinaryOp newOp = infer2.new IncorporationBinaryOp(opKind, op1, op2);
            Boolean res = infer.incorporationCache.get(newOp);
            if (res == null) {
                res = newOp.apply(warn);
                infer.incorporationCache.put(newOp, res);
            }
            return res;
        }
    }

    static interface GraphStrategy {
        public GraphSolver.InferenceGraph.Node pickNode(GraphSolver.InferenceGraph var1) throws NodeNotFoundException;

        public boolean done();

        public static class NodeNotFoundException
        extends RuntimeException {
            private static final long serialVersionUID = 0L;
            GraphSolver.InferenceGraph graph;

            public NodeNotFoundException(GraphSolver.InferenceGraph graph) {
                this.graph = graph;
            }
        }
    }

    static enum BoundErrorKind {
        BAD_UPPER{

            @Override
            Resolve.InapplicableMethodException setMessage(InferenceException ex, Type.UndetVar uv) {
                return ex.setMessage("incompatible.upper.bounds", uv.qtype, uv.getBounds(Type.UndetVar.InferenceBound.UPPER));
            }
        }
        ,
        BAD_EQ_UPPER{

            @Override
            Resolve.InapplicableMethodException setMessage(InferenceException ex, Type.UndetVar uv) {
                return ex.setMessage("incompatible.eq.upper.bounds", uv.qtype, uv.getBounds(Type.UndetVar.InferenceBound.EQ), uv.getBounds(Type.UndetVar.InferenceBound.UPPER));
            }
        }
        ,
        BAD_EQ_LOWER{

            @Override
            Resolve.InapplicableMethodException setMessage(InferenceException ex, Type.UndetVar uv) {
                return ex.setMessage("incompatible.eq.lower.bounds", uv.qtype, uv.getBounds(Type.UndetVar.InferenceBound.EQ), uv.getBounds(Type.UndetVar.InferenceBound.LOWER));
            }
        }
        ,
        UPPER{

            @Override
            Resolve.InapplicableMethodException setMessage(InferenceException ex, Type.UndetVar uv) {
                return ex.setMessage("inferred.do.not.conform.to.upper.bounds", uv.inst, uv.getBounds(Type.UndetVar.InferenceBound.UPPER));
            }
        }
        ,
        LOWER{

            @Override
            Resolve.InapplicableMethodException setMessage(InferenceException ex, Type.UndetVar uv) {
                return ex.setMessage("inferred.do.not.conform.to.lower.bounds", uv.inst, uv.getBounds(Type.UndetVar.InferenceBound.LOWER));
            }
        }
        ,
        EQ{

            @Override
            Resolve.InapplicableMethodException setMessage(InferenceException ex, Type.UndetVar uv) {
                return ex.setMessage("inferred.do.not.conform.to.eq.bounds", uv.inst, uv.getBounds(Type.UndetVar.InferenceBound.EQ));
            }
        };


        abstract Resolve.InapplicableMethodException setMessage(InferenceException var1, Type.UndetVar var2);
    }

    protected static class BoundFilter
    implements Filter<Type> {
        InferenceContext inferenceContext;

        public BoundFilter(InferenceContext inferenceContext) {
            this.inferenceContext = inferenceContext;
        }

        @Override
        public boolean accepts(Type t) {
            return !t.isErroneous() && !this.inferenceContext.free(t) && !t.hasTag(TypeTag.BOT);
        }
    }

    class IncorporationBinaryOp {
        IncorporationBinaryOpKind opKind;
        Type op1;
        Type op2;

        IncorporationBinaryOp(IncorporationBinaryOpKind opKind, Type op1, Type op2) {
            this.opKind = opKind;
            this.op1 = op1;
            this.op2 = op2;
        }

        public boolean equals(Object o) {
            if (!(o instanceof IncorporationBinaryOp)) {
                return false;
            }
            IncorporationBinaryOp that = (IncorporationBinaryOp)o;
            return this.opKind == that.opKind && Infer.this.types.isSameType(this.op1, that.op1, true) && Infer.this.types.isSameType(this.op2, that.op2, true);
        }

        public int hashCode() {
            int result = this.opKind.hashCode();
            result *= 127;
            result += Infer.this.types.hashCode(this.op1);
            result *= 127;
            return result += Infer.this.types.hashCode(this.op2);
        }

        boolean apply(Warner warn) {
            return this.opKind.apply(this.op1, this.op2, warn, Infer.this.types);
        }
    }

    static enum IncorporationBinaryOpKind {
        IS_SUBTYPE{

            @Override
            boolean apply(Type op1, Type op2, Warner warn, Types types) {
                return types.isSubtypeUnchecked(op1, op2, warn);
            }
        }
        ,
        IS_SAME_TYPE{

            @Override
            boolean apply(Type op1, Type op2, Warner warn, Types types) {
                return types.isSameType(op1, op2);
            }
        }
        ,
        ADD_UPPER_BOUND{

            @Override
            boolean apply(Type op1, Type op2, Warner warn, Types types) {
                Type.UndetVar uv = (Type.UndetVar)op1;
                uv.addBound(Type.UndetVar.InferenceBound.UPPER, op2, types);
                return true;
            }
        }
        ,
        ADD_LOWER_BOUND{

            @Override
            boolean apply(Type op1, Type op2, Warner warn, Types types) {
                Type.UndetVar uv = (Type.UndetVar)op1;
                uv.addBound(Type.UndetVar.InferenceBound.LOWER, op2, types);
                return true;
            }
        }
        ,
        ADD_EQ_BOUND{

            @Override
            boolean apply(Type op1, Type op2, Warner warn, Types types) {
                Type.UndetVar uv = (Type.UndetVar)op1;
                uv.addBound(Type.UndetVar.InferenceBound.EQ, op2, types);
                return true;
            }
        };


        abstract boolean apply(Type var1, Type var2, Warner var3, Types var4);
    }

    static enum IncorporationStep {
        CHECK_BOUNDS{

            @Override
            public void apply(Type.UndetVar uv, InferenceContext inferenceContext, Warner warn) {
                Infer infer = inferenceContext.infer();
                uv.substBounds(inferenceContext.inferenceVars(), inferenceContext.instTypes(), infer.types);
                infer.checkCompatibleUpperBounds(uv, inferenceContext);
                if (uv.inst != null) {
                    Type inst = uv.inst;
                    for (Type u : uv.getBounds(Type.UndetVar.InferenceBound.UPPER)) {
                        if (this.isSubtype(inst, inferenceContext.asUndetVar(u), warn, infer)) continue;
                        infer.reportBoundError(uv, BoundErrorKind.UPPER);
                    }
                    for (Type l : uv.getBounds(Type.UndetVar.InferenceBound.LOWER)) {
                        if (this.isSubtype(inferenceContext.asUndetVar(l), inst, warn, infer)) continue;
                        infer.reportBoundError(uv, BoundErrorKind.LOWER);
                    }
                    for (Type e : uv.getBounds(Type.UndetVar.InferenceBound.EQ)) {
                        if (this.isSameType(inst, inferenceContext.asUndetVar(e), infer)) continue;
                        infer.reportBoundError(uv, BoundErrorKind.EQ);
                    }
                }
            }

            @Override
            boolean accepts(Type.UndetVar uv, InferenceContext inferenceContext) {
                return true;
            }
        }
        ,
        EQ_CHECK_LEGACY{

            @Override
            public void apply(Type.UndetVar uv, InferenceContext inferenceContext, Warner warn) {
                Infer infer = inferenceContext.infer();
                Type eq = null;
                for (Type e : uv.getBounds(Type.UndetVar.InferenceBound.EQ)) {
                    Assert.check(!inferenceContext.free(e));
                    if (eq != null && !this.isSameType(e, eq, infer)) {
                        infer.reportBoundError(uv, BoundErrorKind.EQ);
                    }
                    eq = e;
                    for (Type l : uv.getBounds(Type.UndetVar.InferenceBound.LOWER)) {
                        Assert.check(!inferenceContext.free(l));
                        if (this.isSubtype(l, e, warn, infer)) continue;
                        infer.reportBoundError(uv, BoundErrorKind.BAD_EQ_LOWER);
                    }
                    for (Type u : uv.getBounds(Type.UndetVar.InferenceBound.UPPER)) {
                        if (inferenceContext.free(u) || this.isSubtype(e, u, warn, infer)) continue;
                        infer.reportBoundError(uv, BoundErrorKind.BAD_EQ_UPPER);
                    }
                }
            }
        }
        ,
        EQ_CHECK{

            @Override
            public void apply(Type.UndetVar uv, InferenceContext inferenceContext, Warner warn) {
                Infer infer = inferenceContext.infer();
                for (Type e : uv.getBounds(Type.UndetVar.InferenceBound.EQ)) {
                    if (e.containsAny(inferenceContext.inferenceVars())) continue;
                    for (Type u : uv.getBounds(Type.UndetVar.InferenceBound.UPPER)) {
                        if (this.isSubtype(e, inferenceContext.asUndetVar(u), warn, infer)) continue;
                        infer.reportBoundError(uv, BoundErrorKind.BAD_EQ_UPPER);
                    }
                    for (Type l : uv.getBounds(Type.UndetVar.InferenceBound.LOWER)) {
                        if (this.isSubtype(inferenceContext.asUndetVar(l), e, warn, infer)) continue;
                        infer.reportBoundError(uv, BoundErrorKind.BAD_EQ_LOWER);
                    }
                }
            }
        }
        ,
        CROSS_UPPER_LOWER{

            @Override
            public void apply(Type.UndetVar uv, InferenceContext inferenceContext, Warner warn) {
                Infer infer = inferenceContext.infer();
                for (Type b1 : uv.getBounds(Type.UndetVar.InferenceBound.UPPER)) {
                    for (Type b2 : uv.getBounds(Type.UndetVar.InferenceBound.LOWER)) {
                        this.isSubtype(inferenceContext.asUndetVar(b2), inferenceContext.asUndetVar(b1), warn, infer);
                    }
                }
            }
        }
        ,
        CROSS_UPPER_EQ{

            @Override
            public void apply(Type.UndetVar uv, InferenceContext inferenceContext, Warner warn) {
                Infer infer = inferenceContext.infer();
                for (Type b1 : uv.getBounds(Type.UndetVar.InferenceBound.UPPER)) {
                    for (Type b2 : uv.getBounds(Type.UndetVar.InferenceBound.EQ)) {
                        this.isSubtype(inferenceContext.asUndetVar(b2), inferenceContext.asUndetVar(b1), warn, infer);
                    }
                }
            }
        }
        ,
        CROSS_EQ_LOWER{

            @Override
            public void apply(Type.UndetVar uv, InferenceContext inferenceContext, Warner warn) {
                Infer infer = inferenceContext.infer();
                for (Type b1 : uv.getBounds(Type.UndetVar.InferenceBound.EQ)) {
                    for (Type b2 : uv.getBounds(Type.UndetVar.InferenceBound.LOWER)) {
                        this.isSubtype(inferenceContext.asUndetVar(b2), inferenceContext.asUndetVar(b1), warn, infer);
                    }
                }
            }
        }
        ,
        CROSS_UPPER_UPPER{

            @Override
            public void apply(Type.UndetVar uv, InferenceContext inferenceContext, Warner warn) {
                Infer infer = inferenceContext.infer();
                List<Type> boundList = uv.getBounds(Type.UndetVar.InferenceBound.UPPER);
                List boundListTail = boundList.tail;
                while (boundList.nonEmpty()) {
                    List tmpTail = boundListTail;
                    while (tmpTail.nonEmpty()) {
                        Pair commonSupers;
                        Type b1 = (Type)boundList.head;
                        Type b2 = (Type)tmpTail.head;
                        if (b1 != b2 && !b1.hasTag(TypeTag.WILDCARD) && !b2.hasTag(TypeTag.WILDCARD) && (commonSupers = infer.getParameterizedSupers(b1, b2)) != null) {
                            List<Type> allParamsSuperBound1 = ((Type)commonSupers.fst).allparams();
                            List<Type> allParamsSuperBound2 = ((Type)commonSupers.snd).allparams();
                            while (allParamsSuperBound1.nonEmpty() && allParamsSuperBound2.nonEmpty()) {
                                if (!((Type)allParamsSuperBound1.head).hasTag(TypeTag.WILDCARD) && !((Type)allParamsSuperBound2.head).hasTag(TypeTag.WILDCARD)) {
                                    this.isSameType(inferenceContext.asUndetVar((Type)allParamsSuperBound1.head), inferenceContext.asUndetVar((Type)allParamsSuperBound2.head), infer);
                                }
                                allParamsSuperBound1 = allParamsSuperBound1.tail;
                                allParamsSuperBound2 = allParamsSuperBound2.tail;
                            }
                            Assert.check(allParamsSuperBound1.isEmpty() && allParamsSuperBound2.isEmpty());
                        }
                        tmpTail = tmpTail.tail;
                    }
                    boundList = boundList.tail;
                    boundListTail = boundList.tail;
                }
            }

            @Override
            boolean accepts(Type.UndetVar uv, InferenceContext inferenceContext) {
                return !uv.isCaptured() && uv.getBounds(Type.UndetVar.InferenceBound.UPPER).nonEmpty();
            }
        }
        ,
        CROSS_EQ_EQ{

            @Override
            public void apply(Type.UndetVar uv, InferenceContext inferenceContext, Warner warn) {
                Infer infer = inferenceContext.infer();
                for (Type b1 : uv.getBounds(Type.UndetVar.InferenceBound.EQ)) {
                    for (Type b2 : uv.getBounds(Type.UndetVar.InferenceBound.EQ)) {
                        if (b1 == b2) continue;
                        this.isSameType(inferenceContext.asUndetVar(b2), inferenceContext.asUndetVar(b1), infer);
                    }
                }
            }
        }
        ,
        PROP_UPPER{

            @Override
            public void apply(Type.UndetVar uv, InferenceContext inferenceContext, Warner warn) {
                Infer infer = inferenceContext.infer();
                for (Type b : uv.getBounds(Type.UndetVar.InferenceBound.UPPER)) {
                    Type.UndetVar uv2;
                    if (!inferenceContext.inferenceVars().contains(b) || (uv2 = (Type.UndetVar)inferenceContext.asUndetVar(b)).isCaptured()) continue;
                    this.addBound(Type.UndetVar.InferenceBound.LOWER, uv2, inferenceContext.asInstType(uv.qtype), infer);
                    for (Type l : uv.getBounds(Type.UndetVar.InferenceBound.LOWER)) {
                        this.addBound(Type.UndetVar.InferenceBound.LOWER, uv2, inferenceContext.asInstType(l), infer);
                    }
                    for (Type u : uv2.getBounds(Type.UndetVar.InferenceBound.UPPER)) {
                        this.addBound(Type.UndetVar.InferenceBound.UPPER, uv, inferenceContext.asInstType(u), infer);
                    }
                }
            }
        }
        ,
        PROP_LOWER{

            @Override
            public void apply(Type.UndetVar uv, InferenceContext inferenceContext, Warner warn) {
                Infer infer = inferenceContext.infer();
                for (Type b : uv.getBounds(Type.UndetVar.InferenceBound.LOWER)) {
                    Type.UndetVar uv2;
                    if (!inferenceContext.inferenceVars().contains(b) || (uv2 = (Type.UndetVar)inferenceContext.asUndetVar(b)).isCaptured()) continue;
                    this.addBound(Type.UndetVar.InferenceBound.UPPER, uv2, inferenceContext.asInstType(uv.qtype), infer);
                    for (Type u : uv.getBounds(Type.UndetVar.InferenceBound.UPPER)) {
                        this.addBound(Type.UndetVar.InferenceBound.UPPER, uv2, inferenceContext.asInstType(u), infer);
                    }
                    for (Type l : uv2.getBounds(Type.UndetVar.InferenceBound.LOWER)) {
                        this.addBound(Type.UndetVar.InferenceBound.LOWER, uv, inferenceContext.asInstType(l), infer);
                    }
                }
            }
        }
        ,
        PROP_EQ{

            @Override
            public void apply(Type.UndetVar uv, InferenceContext inferenceContext, Warner warn) {
                Infer infer = inferenceContext.infer();
                for (Type b : uv.getBounds(Type.UndetVar.InferenceBound.EQ)) {
                    Type.UndetVar uv2;
                    if (!inferenceContext.inferenceVars().contains(b) || (uv2 = (Type.UndetVar)inferenceContext.asUndetVar(b)).isCaptured()) continue;
                    this.addBound(Type.UndetVar.InferenceBound.EQ, uv2, inferenceContext.asInstType(uv.qtype), infer);
                    for (Type.UndetVar.InferenceBound ib : Type.UndetVar.InferenceBound.values()) {
                        for (Type b2 : uv.getBounds(ib)) {
                            if (b2 == uv2) continue;
                            this.addBound(ib, uv2, inferenceContext.asInstType(b2), infer);
                        }
                    }
                    for (Type.UndetVar.InferenceBound ib : Type.UndetVar.InferenceBound.values()) {
                        for (Type b2 : uv2.getBounds(ib)) {
                            if (b2 == uv) continue;
                            this.addBound(ib, uv, inferenceContext.asInstType(b2), infer);
                        }
                    }
                }
            }
        };


        abstract void apply(Type.UndetVar var1, InferenceContext var2, Warner var3);

        boolean accepts(Type.UndetVar uv, InferenceContext inferenceContext) {
            return !uv.isCaptured();
        }

        boolean isSubtype(Type s, Type t, Warner warn, Infer infer) {
            return this.doIncorporationOp(IncorporationBinaryOpKind.IS_SUBTYPE, s, t, warn, infer);
        }

        boolean isSameType(Type s, Type t, Infer infer) {
            return this.doIncorporationOp(IncorporationBinaryOpKind.IS_SAME_TYPE, s, t, null, infer);
        }

        void addBound(Type.UndetVar.InferenceBound ib, Type.UndetVar uv, Type b, Infer infer) {
            this.doIncorporationOp(this.opFor(ib), uv, b, null, infer);
        }

        IncorporationBinaryOpKind opFor(Type.UndetVar.InferenceBound boundKind) {
            switch (boundKind) {
                case EQ: {
                    return IncorporationBinaryOpKind.ADD_EQ_BOUND;
                }
                case LOWER: {
                    return IncorporationBinaryOpKind.ADD_LOWER_BOUND;
                }
                case UPPER: {
                    return IncorporationBinaryOpKind.ADD_UPPER_BOUND;
                }
            }
            Assert.error("Can't get here!");
            return null;
        }

        boolean doIncorporationOp(IncorporationBinaryOpKind opKind, Type op1, Type op2, Warner warn, Infer infer) {
            Infer infer2 = infer;
            infer2.getClass();
            IncorporationBinaryOp newOp = infer2.new IncorporationBinaryOp(opKind, op1, op2);
            Boolean res = infer.incorporationCache.get(newOp);
            if (res == null) {
                res = newOp.apply(warn);
                infer.incorporationCache.put(newOp, res);
            }
            return res;
        }
    }

    class MultiUndetVarListener
    implements Type.UndetVar.UndetVarListener {
        boolean changed;
        List<Type> undetvars;

        public MultiUndetVarListener(List<Type> undetvars) {
            this.undetvars = undetvars;
            for (Type t : undetvars) {
                Type.UndetVar uv = (Type.UndetVar)t;
                uv.listener = this;
            }
        }

        @Override
        public void varChanged(Type.UndetVar uv, Set<Type.UndetVar.InferenceBound> ibs) {
            if (Infer.this.incorporationCache.size() < 100) {
                this.changed = true;
            }
        }

        void reset() {
            this.changed = false;
        }

        void detach() {
            for (Type t : this.undetvars) {
                Type.UndetVar uv = (Type.UndetVar)t;
                uv.listener = null;
            }
        }
    }

    class ImplicitArgType
    extends DeferredAttr.DeferredTypeMap {
        public ImplicitArgType(Symbol msym, Resolve.MethodResolutionPhase phase) {
            DeferredAttr deferredAttr = Infer.this.rs.deferredAttr;
            deferredAttr.getClass();
            super(DeferredAttr.AttrMode.SPECULATIVE, msym, phase);
        }

        @Override
        public Type apply(Type t) {
            if ((t = Infer.this.types.erasure(super.apply(t))).hasTag(TypeTag.BOT)) {
                t = Infer.this.types.boxedClass((Type)Infer.this.syms.voidType).type;
            }
            return t;
        }
    }

    public static class InferenceException
    extends Resolve.InapplicableMethodException {
        private static final long serialVersionUID = 0L;
        List<JCDiagnostic> messages = List.nil();

        InferenceException(JCDiagnostic.Factory diags) {
            super(diags);
        }

        @Override
        Resolve.InapplicableMethodException setMessage() {
            return this;
        }

        @Override
        Resolve.InapplicableMethodException setMessage(JCDiagnostic diag) {
            this.messages = this.messages.append(diag);
            return this;
        }

        @Override
        public JCDiagnostic getDiagnostic() {
            return (JCDiagnostic)this.messages.head;
        }

        void clear() {
            this.messages = List.nil();
        }
    }
}

