/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.AnnoConstruct;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Flags;
import com.sun.tools.javac.code.Scope;
import com.sun.tools.javac.code.SymbolMetadata;
import com.sun.tools.javac.code.TargetType;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.jvm.Code;
import com.sun.tools.javac.jvm.Pool;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Constants;
import com.sun.tools.javac.util.Filter;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import java.lang.annotation.Annotation;
import java.lang.annotation.Inherited;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ElementVisitor;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.NestingKind;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.element.VariableElement;
import javax.tools.JavaFileObject;

public abstract class Symbol
extends AnnoConstruct
implements Element {
    public int kind;
    public long flags_field;
    public Name name;
    public Type type;
    public Symbol owner;
    public Completer completer;
    public Type erasure_field;
    protected SymbolMetadata metadata;

    public long flags() {
        return this.flags_field;
    }

    public List<Attribute.Compound> getRawAttributes() {
        return this.metadata == null ? List.nil() : this.metadata.getDeclarationAttributes();
    }

    public List<Attribute.TypeCompound> getRawTypeAttributes() {
        return this.metadata == null ? List.nil() : this.metadata.getTypeAttributes();
    }

    public Attribute.Compound attribute(Symbol anno) {
        for (Attribute.Compound a : this.getRawAttributes()) {
            if (a.type.tsym != anno) continue;
            return a;
        }
        return null;
    }

    public boolean annotationsPendingCompletion() {
        return this.metadata == null ? false : this.metadata.pendingCompletion();
    }

    public void appendAttributes(List<Attribute.Compound> l) {
        if (l.nonEmpty()) {
            this.initedMetadata().append(l);
        }
    }

    public void appendClassInitTypeAttributes(List<Attribute.TypeCompound> l) {
        if (l.nonEmpty()) {
            this.initedMetadata().appendClassInitTypeAttributes(l);
        }
    }

    public void appendInitTypeAttributes(List<Attribute.TypeCompound> l) {
        if (l.nonEmpty()) {
            this.initedMetadata().appendInitTypeAttributes(l);
        }
    }

    public void appendTypeAttributesWithCompletion(Annotate.AnnotateRepeatedContext<Attribute.TypeCompound> ctx) {
        this.initedMetadata().appendTypeAttributesWithCompletion(ctx);
    }

    public void appendUniqueTypeAttributes(List<Attribute.TypeCompound> l) {
        if (l.nonEmpty()) {
            this.initedMetadata().appendUniqueTypes(l);
        }
    }

    public List<Attribute.TypeCompound> getClassInitTypeAttributes() {
        return this.metadata == null ? List.nil() : this.metadata.getClassInitTypeAttributes();
    }

    public List<Attribute.TypeCompound> getInitTypeAttributes() {
        return this.metadata == null ? List.nil() : this.metadata.getInitTypeAttributes();
    }

    public List<Attribute.Compound> getDeclarationAttributes() {
        return this.metadata == null ? List.nil() : this.metadata.getDeclarationAttributes();
    }

    public boolean hasAnnotations() {
        return this.metadata != null && !this.metadata.isEmpty();
    }

    public boolean hasTypeAnnotations() {
        return this.metadata != null && !this.metadata.isTypesEmpty();
    }

    public void prependAttributes(List<Attribute.Compound> l) {
        if (l.nonEmpty()) {
            this.initedMetadata().prepend(l);
        }
    }

    public void resetAnnotations() {
        this.initedMetadata().reset();
    }

    public void setAttributes(Symbol other) {
        if (this.metadata != null || other.metadata != null) {
            this.initedMetadata().setAttributes(other.metadata);
        }
    }

    public void setDeclarationAttributes(List<Attribute.Compound> a) {
        if (this.metadata != null || a.nonEmpty()) {
            this.initedMetadata().setDeclarationAttributes(a);
        }
    }

    public void setDeclarationAttributesWithCompletion(Annotate.AnnotateRepeatedContext<Attribute.Compound> ctx) {
        this.initedMetadata().setDeclarationAttributesWithCompletion(ctx);
    }

    public void setTypeAttributes(List<Attribute.TypeCompound> a) {
        if (this.metadata != null || a.nonEmpty()) {
            if (this.metadata == null) {
                this.metadata = new SymbolMetadata(this);
            }
            this.metadata.setTypeAttributes(a);
        }
    }

    private SymbolMetadata initedMetadata() {
        if (this.metadata == null) {
            this.metadata = new SymbolMetadata(this);
        }
        return this.metadata;
    }

    public SymbolMetadata getMetadata() {
        return this.metadata;
    }

    public Symbol(int kind, long flags, Name name, Type type, Symbol owner) {
        this.kind = kind;
        this.flags_field = flags;
        this.type = type;
        this.owner = owner;
        this.completer = null;
        this.erasure_field = null;
        this.name = name;
    }

    public Symbol clone(Symbol newOwner) {
        throw new AssertionError();
    }

    public <R, P> R accept(Visitor<R, P> v, P p) {
        return v.visitSymbol(this, p);
    }

    public String toString() {
        return this.name.toString();
    }

    public Symbol location() {
        if (this.owner.name == null || this.owner.name.isEmpty() && (this.owner.flags() & 0x100000L) == 0L && this.owner.kind != 1 && this.owner.kind != 2) {
            return null;
        }
        return this.owner;
    }

    public Symbol location(Type site, Types types) {
        Type ownertype;
        if (this.owner.name == null || this.owner.name.isEmpty()) {
            return this.location();
        }
        if (this.owner.type.hasTag(TypeTag.CLASS) && (ownertype = types.asOuterSuper(site, this.owner)) != null) {
            return ownertype.tsym;
        }
        return this.owner;
    }

    public Symbol baseSymbol() {
        return this;
    }

    public Type erasure(Types types) {
        if (this.erasure_field == null) {
            this.erasure_field = types.erasure(this.type);
        }
        return this.erasure_field;
    }

    public Type externalType(Types types) {
        Type t = this.erasure(types);
        if (this.name == this.name.table.names.init && this.owner.hasOuterInstance()) {
            Type outerThisType = types.erasure(this.owner.type.getEnclosingType());
            return new Type.MethodType(t.getParameterTypes().prepend(outerThisType), t.getReturnType(), t.getThrownTypes(), t.tsym);
        }
        return t;
    }

    public boolean isDeprecated() {
        return (this.flags_field & 0x20000L) != 0L;
    }

    public boolean isStatic() {
        return (this.flags() & 8L) != 0L || (this.owner.flags() & 0x200L) != 0L && this.kind != 16 && this.name != this.name.table.names._this;
    }

    public boolean isInterface() {
        return (this.flags() & 0x200L) != 0L;
    }

    public boolean isPrivate() {
        return (this.flags_field & 7L) == 2L;
    }

    public boolean isEnum() {
        return (this.flags() & 0x4000L) != 0L;
    }

    public boolean isLocal() {
        return (this.owner.kind & 0x14) != 0 || this.owner.kind == 2 && this.owner.isLocal();
    }

    public boolean isAnonymous() {
        return this.name.isEmpty();
    }

    public boolean isConstructor() {
        return this.name == this.name.table.names.init;
    }

    public Name getQualifiedName() {
        return this.name;
    }

    public Name flatName() {
        return this.getQualifiedName();
    }

    public Scope members() {
        return null;
    }

    public boolean isInner() {
        return this.kind == 2 && this.type.getEnclosingType().hasTag(TypeTag.CLASS);
    }

    public boolean hasOuterInstance() {
        return this.type.getEnclosingType().hasTag(TypeTag.CLASS) && (this.flags() & 0x400200L) == 0L;
    }

    public ClassSymbol enclClass() {
        Symbol c = this;
        while (!(c == null || (c.kind & 2) != 0 && c.type.hasTag(TypeTag.CLASS))) {
            c = c.owner;
        }
        return (ClassSymbol)c;
    }

    public ClassSymbol outermostClass() {
        Symbol sym = this;
        Symbol prev = null;
        while (sym.kind != 1) {
            prev = sym;
            sym = sym.owner;
        }
        return (ClassSymbol)prev;
    }

    public PackageSymbol packge() {
        Symbol sym = this;
        while (sym.kind != 1) {
            sym = sym.owner;
        }
        return (PackageSymbol)sym;
    }

    public boolean isSubClass(Symbol base, Types types) {
        throw new AssertionError((Object)("isSubClass " + this));
    }

    public boolean isMemberOf(TypeSymbol clazz, Types types) {
        return this.owner == clazz || clazz.isSubClass(this.owner, types) && this.isInheritedIn(clazz, types) && !this.hiddenIn((ClassSymbol)clazz, types);
    }

    public boolean isEnclosedBy(ClassSymbol clazz) {
        Symbol sym = this;
        while (sym.kind != 1) {
            if (sym == clazz) {
                return true;
            }
            sym = sym.owner;
        }
        return false;
    }

    private boolean hiddenIn(ClassSymbol clazz, Types types) {
        Symbol sym = this.hiddenInInternal(clazz, types);
        Assert.check(sym != null, "the result of hiddenInInternal() can't be null");
        return sym != this;
    }

    private Symbol hiddenInInternal(ClassSymbol currentClass, Types types) {
        if (currentClass == this.owner) {
            return this;
        }
        Scope.Entry e = currentClass.members().lookup(this.name);
        while (e.scope != null) {
            if (e.sym.kind == this.kind && (this.kind != 16 || (e.sym.flags() & 8L) != 0L && types.isSubSignature(e.sym.type, this.type))) {
                return e.sym;
            }
            e = e.next();
        }
        Symbol hiddenSym = null;
        for (Type st : types.interfaces(currentClass.type).prepend(types.supertype(currentClass.type))) {
            if (st == null || !st.hasTag(TypeTag.CLASS)) continue;
            Symbol sym = this.hiddenInInternal((ClassSymbol)st.tsym, types);
            if (sym == this) {
                return this;
            }
            if (sym == null) continue;
            hiddenSym = sym;
        }
        return hiddenSym;
    }

    public boolean isInheritedIn(Symbol clazz, Types types) {
        switch ((int)(this.flags_field & 7L)) {
            default: {
                return true;
            }
            case 2: {
                return this.owner == clazz;
            }
            case 4: {
                return (clazz.flags() & 0x200L) == 0L;
            }
            case 0: 
        }
        PackageSymbol thisPackage = this.packge();
        Symbol sup = clazz;
        while (sup != null && sup != this.owner) {
            while (sup.type.hasTag(TypeTag.TYPEVAR)) {
                sup = sup.type.getUpperBound().tsym;
            }
            if (sup.type.isErroneous()) {
                return true;
            }
            if ((sup.flags() & 0x1000000L) == 0L && sup.packge() != thisPackage) {
                return false;
            }
            sup = types.supertype((Type)sup.type).tsym;
        }
        return (clazz.flags() & 0x200L) == 0L;
    }

    public Symbol asMemberOf(Type site, Types types) {
        throw new AssertionError();
    }

    public boolean overrides(Symbol _other, TypeSymbol origin, Types types, boolean checkResult) {
        return false;
    }

    public void complete() throws CompletionFailure {
        if (this.completer != null) {
            Completer c = this.completer;
            this.completer = null;
            c.complete(this);
        }
    }

    public boolean exists() {
        return true;
    }

    @Override
    public Type asType() {
        return this.type;
    }

    @Override
    public Symbol getEnclosingElement() {
        return this.owner;
    }

    @Override
    public ElementKind getKind() {
        return ElementKind.OTHER;
    }

    @Override
    public Set<Modifier> getModifiers() {
        return Flags.asModifierSet(this.flags());
    }

    @Override
    public Name getSimpleName() {
        return this.name;
    }

    @Override
    public List<Attribute.Compound> getAnnotationMirrors() {
        return this.getRawAttributes();
    }

    public java.util.List<Symbol> getEnclosedElements() {
        return List.nil();
    }

    public List<TypeVariableSymbol> getTypeParameters() {
        ListBuffer<TypeVariableSymbol> l = new ListBuffer<TypeVariableSymbol>();
        for (Type t : this.type.getTypeArguments()) {
            Assert.check(t.tsym.getKind() == ElementKind.TYPE_PARAMETER);
            l.append((TypeVariableSymbol)t.tsym);
        }
        return l.toList();
    }

    public static interface Visitor<R, P> {
        public R visitClassSymbol(ClassSymbol var1, P var2);

        public R visitMethodSymbol(MethodSymbol var1, P var2);

        public R visitPackageSymbol(PackageSymbol var1, P var2);

        public R visitOperatorSymbol(OperatorSymbol var1, P var2);

        public R visitVarSymbol(VarSymbol var1, P var2);

        public R visitTypeSymbol(TypeSymbol var1, P var2);

        public R visitSymbol(Symbol var1, P var2);
    }

    public static class CompletionFailure
    extends RuntimeException {
        private static final long serialVersionUID = 0L;
        public Symbol sym;
        public JCDiagnostic diag;
        @Deprecated
        public String errmsg;

        public CompletionFailure(Symbol sym, String errmsg) {
            this.sym = sym;
            this.errmsg = errmsg;
        }

        public CompletionFailure(Symbol sym, JCDiagnostic diag) {
            this.sym = sym;
            this.diag = diag;
        }

        public JCDiagnostic getDiagnostic() {
            return this.diag;
        }

        @Override
        public String getMessage() {
            if (this.diag != null) {
                return this.diag.getMessage(null);
            }
            return this.errmsg;
        }

        public Object getDetailValue() {
            return this.diag != null ? this.diag : this.errmsg;
        }

        @Override
        public CompletionFailure initCause(Throwable cause) {
            super.initCause(cause);
            return this;
        }
    }

    public static interface Completer {
        public void complete(Symbol var1) throws CompletionFailure;
    }

    public static class OperatorSymbol
    extends MethodSymbol {
        public int opcode;

        public OperatorSymbol(Name name, Type type, int opcode, Symbol owner) {
            super(9L, name, type, owner);
            this.opcode = opcode;
        }

        @Override
        public <R, P> R accept(Visitor<R, P> v, P p) {
            return v.visitOperatorSymbol(this, p);
        }
    }

    public static class DynamicMethodSymbol
    extends MethodSymbol {
        public Object[] staticArgs;
        public Symbol bsm;
        public int bsmKind;

        public DynamicMethodSymbol(Name name, Symbol owner, int bsmKind, MethodSymbol bsm, Type type, Object[] staticArgs) {
            super(0L, name, type, owner);
            this.bsm = bsm;
            this.bsmKind = bsmKind;
            this.staticArgs = staticArgs;
        }

        @Override
        public boolean isDynamic() {
            return true;
        }
    }

    public static class MethodSymbol
    extends Symbol
    implements ExecutableElement {
        public Code code = null;
        public List<VarSymbol> extraParams = List.nil();
        public List<VarSymbol> capturedLocals = List.nil();
        public List<VarSymbol> params = null;
        public List<Name> savedParameterNames;
        public Attribute defaultValue = null;
        public static final Filter<Symbol> implementation_filter = new Filter<Symbol>(){

            @Override
            public boolean accepts(Symbol s) {
                return s.kind == 16 && (s.flags() & 0x1000L) == 0L;
            }
        };

        public MethodSymbol(long flags, Name name, Type type, Symbol owner) {
            super(16, flags, name, type, owner);
            if (owner.type.hasTag(TypeTag.TYPEVAR)) {
                Assert.error(owner + "." + name);
            }
        }

        @Override
        public MethodSymbol clone(Symbol newOwner) {
            MethodSymbol m = new MethodSymbol(this.flags_field, this.name, this.type, newOwner){

                @Override
                public Symbol baseSymbol() {
                    return MethodSymbol.this;
                }
            };
            m.code = this.code;
            return m;
        }

        @Override
        public Set<Modifier> getModifiers() {
            long flags = this.flags();
            return Flags.asModifierSet((flags & 0x80000000000L) != 0L ? flags & 0xFFFFFFFFFFFFFBFFL : flags);
        }

        @Override
        public String toString() {
            String s;
            if ((this.flags() & 0x100000L) != 0L) {
                return this.owner.name.toString();
            }
            String string = s = this.name == this.name.table.names.init ? this.owner.name.toString() : this.name.toString();
            if (this.type != null) {
                if (this.type.hasTag(TypeTag.FORALL)) {
                    s = "<" + ((Type.ForAll)this.type).getTypeArguments() + ">" + s;
                }
                s = s + "(" + this.type.argtypes((this.flags() & 0x400000000L) != 0L) + ")";
            }
            return s;
        }

        public boolean isDynamic() {
            return false;
        }

        public Symbol implemented(TypeSymbol c, Types types) {
            Symbol impl = null;
            List<Type> is = types.interfaces(c.type);
            while (impl == null && is.nonEmpty()) {
                TypeSymbol i = ((Type)is.head).tsym;
                impl = this.implementedIn(i, types);
                if (impl == null) {
                    impl = this.implemented(i, types);
                }
                is = is.tail;
            }
            return impl;
        }

        public Symbol implementedIn(TypeSymbol c, Types types) {
            Symbol impl = null;
            Scope.Entry e = c.members().lookup(this.name);
            while (impl == null && e.scope != null) {
                if (this.overrides(e.sym, (TypeSymbol)this.owner, types, true) && types.isSameType(this.type.getReturnType(), types.memberType(this.owner.type, e.sym).getReturnType())) {
                    impl = e.sym;
                }
                e = e.next();
            }
            return impl;
        }

        public boolean binaryOverrides(Symbol _other, TypeSymbol origin, Types types) {
            if (this.isConstructor() || _other.kind != 16) {
                return false;
            }
            if (this == _other) {
                return true;
            }
            MethodSymbol other = (MethodSymbol)_other;
            if (other.isOverridableIn((TypeSymbol)this.owner) && types.asSuper(this.owner.type, other.owner) != null && types.isSameType(this.erasure(types), other.erasure(types))) {
                return true;
            }
            return (this.flags() & 0x400L) == 0L && other.isOverridableIn(origin) && this.isMemberOf(origin, types) && types.isSameType(this.erasure(types), other.erasure(types));
        }

        public MethodSymbol binaryImplementation(ClassSymbol origin, Types types) {
            TypeSymbol c = origin;
            while (c != null) {
                Scope.Entry e = ((Symbol)c).members().lookup(this.name);
                while (e.scope != null) {
                    if (e.sym.kind == 16 && ((MethodSymbol)e.sym).binaryOverrides(this, origin, types)) {
                        return (MethodSymbol)e.sym;
                    }
                    e = e.next();
                }
                c = types.supertype((Type)c.type).tsym;
            }
            return null;
        }

        @Override
        public boolean overrides(Symbol _other, TypeSymbol origin, Types types, boolean checkResult) {
            Type ot;
            Type mt;
            if (this.isConstructor() || _other.kind != 16) {
                return false;
            }
            if (this == _other) {
                return true;
            }
            MethodSymbol other = (MethodSymbol)_other;
            if (other.isOverridableIn((TypeSymbol)this.owner) && types.asSuper(this.owner.type, other.owner) != null && types.isSubSignature(mt = types.memberType(this.owner.type, this), ot = types.memberType(this.owner.type, other))) {
                if (!checkResult) {
                    return true;
                }
                if (types.returnTypeSubstitutable(mt, ot)) {
                    return true;
                }
            }
            if ((this.flags() & 0x400L) != 0L || (other.flags() & 0x400L) == 0L && (other.flags() & 0x80000000000L) == 0L || !other.isOverridableIn(origin) || !this.isMemberOf(origin, types)) {
                return false;
            }
            mt = types.memberType(origin.type, this);
            return types.isSubSignature(mt, ot = types.memberType(origin.type, other)) && (!checkResult || types.resultSubtype(mt, ot, types.noWarnings));
        }

        private boolean isOverridableIn(TypeSymbol origin) {
            switch ((int)(this.flags_field & 7L)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return !this.owner.isInterface() || (this.flags_field & 8L) == 0L;
                }
                case 4: {
                    return (origin.flags() & 0x200L) == 0L;
                }
                case 0: {
                    return this.packge() == origin.packge() && (origin.flags() & 0x200L) == 0L;
                }
            }
            return false;
        }

        @Override
        public boolean isInheritedIn(Symbol clazz, Types types) {
            switch ((int)(this.flags_field & 7L)) {
                case 1: {
                    return !this.owner.isInterface() || clazz == this.owner || (this.flags_field & 8L) == 0L;
                }
            }
            return super.isInheritedIn(clazz, types);
        }

        public MethodSymbol implementation(TypeSymbol origin, Types types, boolean checkResult) {
            return this.implementation(origin, types, checkResult, implementation_filter);
        }

        public MethodSymbol implementation(TypeSymbol origin, Types types, boolean checkResult, Filter<Symbol> implFilter) {
            MethodSymbol res = types.implementation(this, origin, checkResult, implFilter);
            if (res != null) {
                return res;
            }
            if (types.isDerivedRaw(origin.type) && !origin.isInterface()) {
                return this.implementation(types.supertype((Type)origin.type).tsym, types, checkResult);
            }
            return null;
        }

        public List<VarSymbol> params() {
            this.owner.complete();
            if (this.params == null) {
                List<Name> paramNames = this.savedParameterNames;
                this.savedParameterNames = null;
                if (paramNames == null || paramNames.size() != this.type.getParameterTypes().size()) {
                    paramNames = List.nil();
                }
                ListBuffer<VarSymbol> buf = new ListBuffer<VarSymbol>();
                List<Name> remaining = paramNames;
                int i = 0;
                for (Type t : this.type.getParameterTypes()) {
                    Name paramName;
                    if (remaining.isEmpty()) {
                        paramName = this.createArgName(i, paramNames);
                    } else {
                        paramName = (Name)remaining.head;
                        remaining = remaining.tail;
                        if (paramName.isEmpty()) {
                            paramName = this.createArgName(i, paramNames);
                        }
                    }
                    buf.append(new VarSymbol(0x200000000L, paramName, t, this));
                    ++i;
                }
                this.params = buf.toList();
            }
            return this.params;
        }

        private Name createArgName(int index, List<Name> exclude) {
            String prefix = "arg";
            Name argName;
            while (exclude.contains(argName = this.name.table.fromString(prefix + index))) {
                prefix = prefix + "$";
            }
            return argName;
        }

        @Override
        public Symbol asMemberOf(Type site, Types types) {
            return new MethodSymbol(this.flags_field, this.name, types.memberType(site, this), this.owner);
        }

        @Override
        public ElementKind getKind() {
            if (this.name == this.name.table.names.init) {
                return ElementKind.CONSTRUCTOR;
            }
            if (this.name == this.name.table.names.clinit) {
                return ElementKind.STATIC_INIT;
            }
            if ((this.flags() & 0x100000L) != 0L) {
                return this.isStatic() ? ElementKind.STATIC_INIT : ElementKind.INSTANCE_INIT;
            }
            return ElementKind.METHOD;
        }

        public boolean isStaticOrInstanceInit() {
            return this.getKind() == ElementKind.STATIC_INIT || this.getKind() == ElementKind.INSTANCE_INIT;
        }

        @Override
        public Attribute getDefaultValue() {
            return this.defaultValue;
        }

        public List<VarSymbol> getParameters() {
            return this.params();
        }

        @Override
        public boolean isVarArgs() {
            return (this.flags() & 0x400000000L) != 0L;
        }

        @Override
        public boolean isDefault() {
            return (this.flags() & 0x80000000000L) != 0L;
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> v, P p) {
            return v.visitExecutable(this, p);
        }

        @Override
        public <R, P> R accept(Visitor<R, P> v, P p) {
            return v.visitMethodSymbol(this, p);
        }

        @Override
        public Type getReceiverType() {
            return ((Type)this.asType()).getReceiverType();
        }

        @Override
        public Type getReturnType() {
            return ((Type)this.asType()).getReturnType();
        }

        public List<Type> getThrownTypes() {
            return ((Type)this.asType()).getThrownTypes();
        }
    }

    public static class VarSymbol
    extends Symbol
    implements VariableElement {
        public int pos = -1;
        public int adr = -1;
        private Object data;

        public VarSymbol(long flags, Name name, Type type, Symbol owner) {
            super(4, flags, name, type, owner);
        }

        @Override
        public VarSymbol clone(Symbol newOwner) {
            VarSymbol v = new VarSymbol(this.flags_field, this.name, this.type, newOwner){

                @Override
                public Symbol baseSymbol() {
                    return VarSymbol.this;
                }
            };
            v.pos = this.pos;
            v.adr = this.adr;
            v.data = this.data;
            return v;
        }

        @Override
        public String toString() {
            return this.name.toString();
        }

        @Override
        public Symbol asMemberOf(Type site, Types types) {
            return new VarSymbol(this.flags_field, this.name, types.memberType(site, this), this.owner);
        }

        @Override
        public ElementKind getKind() {
            long flags = this.flags();
            if ((flags & 0x200000000L) != 0L) {
                if (this.isExceptionParameter()) {
                    return ElementKind.EXCEPTION_PARAMETER;
                }
                return ElementKind.PARAMETER;
            }
            if ((flags & 0x4000L) != 0L) {
                return ElementKind.ENUM_CONSTANT;
            }
            if (this.owner.kind == 2 || this.owner.kind == 63) {
                return ElementKind.FIELD;
            }
            if (this.isResourceVariable()) {
                return ElementKind.RESOURCE_VARIABLE;
            }
            return ElementKind.LOCAL_VARIABLE;
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> v, P p) {
            return v.visitVariable(this, p);
        }

        @Override
        public Object getConstantValue() {
            return Constants.decode(this.getConstValue(), this.type);
        }

        public void setLazyConstValue(final Env<AttrContext> env, final Attr attr, final JCTree.JCVariableDecl variable) {
            this.setData(new Callable<Object>(){

                @Override
                public Object call() {
                    return attr.attribLazyConstantValue(env, variable, VarSymbol.this.type);
                }
            });
        }

        public boolean isExceptionParameter() {
            return this.data == ElementKind.EXCEPTION_PARAMETER;
        }

        public boolean isResourceVariable() {
            return this.data == ElementKind.RESOURCE_VARIABLE;
        }

        public Object getConstValue() {
            if (this.data == ElementKind.EXCEPTION_PARAMETER || this.data == ElementKind.RESOURCE_VARIABLE) {
                return null;
            }
            if (this.data instanceof Callable) {
                Callable eval = (Callable)this.data;
                this.data = null;
                try {
                    this.data = eval.call();
                }
                catch (Exception ex) {
                    throw new AssertionError((Object)ex);
                }
            }
            return this.data;
        }

        public void setData(Object data) {
            Assert.check(!(data instanceof Env), this);
            this.data = data;
        }

        @Override
        public <R, P> R accept(Visitor<R, P> v, P p) {
            return v.visitVarSymbol(this, p);
        }
    }

    public static class ClassSymbol
    extends TypeSymbol
    implements TypeElement {
        public Scope members_field = null;
        public Name fullname;
        public Name flatname;
        public JavaFileObject sourcefile;
        public JavaFileObject classfile;
        public List<ClassSymbol> trans_local;
        public Pool pool;

        public ClassSymbol(long flags, Name name, Type type, Symbol owner) {
            super(2, flags, name, type, owner);
            this.fullname = ClassSymbol.formFullName(name, owner);
            this.flatname = ClassSymbol.formFlatName(name, owner);
            this.sourcefile = null;
            this.classfile = null;
            this.pool = null;
        }

        public ClassSymbol(long flags, Name name, Symbol owner) {
            this(flags, name, new Type.ClassType(Type.noType, null, null), owner);
            this.type.tsym = this;
        }

        @Override
        public String toString() {
            return this.className();
        }

        @Override
        public long flags() {
            if (this.completer != null) {
                this.complete();
            }
            return this.flags_field;
        }

        @Override
        public Scope members() {
            if (this.completer != null) {
                this.complete();
            }
            return this.members_field;
        }

        @Override
        public List<Attribute.Compound> getRawAttributes() {
            if (this.completer != null) {
                this.complete();
            }
            return super.getRawAttributes();
        }

        @Override
        public List<Attribute.TypeCompound> getRawTypeAttributes() {
            if (this.completer != null) {
                this.complete();
            }
            return super.getRawTypeAttributes();
        }

        @Override
        public Type erasure(Types types) {
            if (this.erasure_field == null) {
                this.erasure_field = new Type.ClassType(types.erasure(this.type.getEnclosingType()), List.nil(), this);
            }
            return this.erasure_field;
        }

        public String className() {
            if (this.name.isEmpty()) {
                return Log.getLocalizedString("anonymous.class", this.flatname);
            }
            return this.fullname.toString();
        }

        @Override
        public Name getQualifiedName() {
            return this.fullname;
        }

        @Override
        public Name flatName() {
            return this.flatname;
        }

        @Override
        public boolean isSubClass(Symbol base, Types types) {
            if (this == base) {
                return true;
            }
            if ((base.flags() & 0x200L) != 0L) {
                Type t = this.type;
                while (t.hasTag(TypeTag.CLASS)) {
                    List<Type> is = types.interfaces(t);
                    while (is.nonEmpty()) {
                        if (((Type)is.head).tsym.isSubClass(base, types)) {
                            return true;
                        }
                        is = is.tail;
                    }
                    t = types.supertype(t);
                }
            } else {
                Type t = this.type;
                while (t.hasTag(TypeTag.CLASS)) {
                    if (t.tsym == base) {
                        return true;
                    }
                    t = types.supertype(t);
                }
            }
            return false;
        }

        @Override
        public void complete() throws CompletionFailure {
            try {
                super.complete();
            }
            catch (CompletionFailure ex) {
                this.flags_field |= 9L;
                this.type = new Type.ErrorType(this, Type.noType);
                throw ex;
            }
        }

        public List<Type> getInterfaces() {
            this.complete();
            if (this.type instanceof Type.ClassType) {
                Type.ClassType t = (Type.ClassType)this.type;
                if (t.interfaces_field == null) {
                    t.interfaces_field = List.nil();
                }
                if (t.all_interfaces_field != null) {
                    return Type.getModelTypes(t.all_interfaces_field);
                }
                return t.interfaces_field;
            }
            return List.nil();
        }

        @Override
        public Type getSuperclass() {
            this.complete();
            if (this.type instanceof Type.ClassType) {
                Type.ClassType t = (Type.ClassType)this.type;
                if (t.supertype_field == null) {
                    t.supertype_field = Type.noType;
                }
                return t.isInterface() ? Type.noType : t.supertype_field.getModelType();
            }
            return Type.noType;
        }

        private ClassSymbol getSuperClassToSearchForAnnotations() {
            Type sup = this.getSuperclass();
            if (!sup.hasTag(TypeTag.CLASS) || sup.isErroneous()) {
                return null;
            }
            return (ClassSymbol)sup.tsym;
        }

        @Override
        protected <A extends Annotation> A[] getInheritedAnnotations(Class<A> annoType) {
            ClassSymbol sup = this.getSuperClassToSearchForAnnotations();
            return sup == null ? super.getInheritedAnnotations(annoType) : sup.getAnnotationsByType(annoType);
        }

        @Override
        public ElementKind getKind() {
            long flags = this.flags();
            if ((flags & 0x2000L) != 0L) {
                return ElementKind.ANNOTATION_TYPE;
            }
            if ((flags & 0x200L) != 0L) {
                return ElementKind.INTERFACE;
            }
            if ((flags & 0x4000L) != 0L) {
                return ElementKind.ENUM;
            }
            return ElementKind.CLASS;
        }

        @Override
        public Set<Modifier> getModifiers() {
            long flags = this.flags();
            return Flags.asModifierSet(flags & 0xFFFFF7FFFFFFFFFFL);
        }

        @Override
        public NestingKind getNestingKind() {
            this.complete();
            if (this.owner.kind == 1) {
                return NestingKind.TOP_LEVEL;
            }
            if (this.name.isEmpty()) {
                return NestingKind.ANONYMOUS;
            }
            if (this.owner.kind == 16) {
                return NestingKind.LOCAL;
            }
            return NestingKind.MEMBER;
        }

        @Override
        protected <A extends Annotation> Attribute.Compound getAttribute(Class<A> annoType) {
            Attribute.Compound attrib = super.getAttribute(annoType);
            boolean inherited = annoType.isAnnotationPresent(Inherited.class);
            if (attrib != null || !inherited) {
                return attrib;
            }
            ClassSymbol superType = this.getSuperClassToSearchForAnnotations();
            return superType == null ? null : superType.getAttribute(annoType);
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> v, P p) {
            return v.visitType(this, p);
        }

        @Override
        public <R, P> R accept(Visitor<R, P> v, P p) {
            return v.visitClassSymbol(this, p);
        }

        public void markAbstractIfNeeded(Types types) {
            if (types.enter.getEnv(this) != null && (this.flags() & 0x4000L) != 0L && types.supertype((Type)this.type).tsym == types.syms.enumSym && (this.flags() & 0x410L) == 0L && types.firstUnimplementedAbstract(this) != null) {
                this.flags_field |= 0x400L;
            }
        }
    }

    public static class PackageSymbol
    extends TypeSymbol
    implements PackageElement {
        public Scope members_field = null;
        public Name fullname;
        public ClassSymbol package_info;

        public PackageSymbol(Name name, Type type, Symbol owner) {
            super(1, 0L, name, type, owner);
            this.fullname = PackageSymbol.formFullName(name, owner);
        }

        public PackageSymbol(Name name, Symbol owner) {
            this(name, null, owner);
            this.type = new Type.PackageType(this);
        }

        @Override
        public String toString() {
            return this.fullname.toString();
        }

        @Override
        public Name getQualifiedName() {
            return this.fullname;
        }

        @Override
        public boolean isUnnamed() {
            return this.name.isEmpty() && this.owner != null;
        }

        @Override
        public Scope members() {
            if (this.completer != null) {
                this.complete();
            }
            return this.members_field;
        }

        @Override
        public long flags() {
            if (this.completer != null) {
                this.complete();
            }
            return this.flags_field;
        }

        @Override
        public List<Attribute.Compound> getRawAttributes() {
            if (this.completer != null) {
                this.complete();
            }
            if (this.package_info != null && this.package_info.completer != null) {
                this.package_info.complete();
                this.mergeAttributes();
            }
            return super.getRawAttributes();
        }

        private void mergeAttributes() {
            if (this.metadata == null && this.package_info.metadata != null) {
                this.metadata = new SymbolMetadata(this);
                this.metadata.setAttributes(this.package_info.metadata);
            }
        }

        @Override
        public boolean exists() {
            return (this.flags_field & 0x800000L) != 0L;
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.PACKAGE;
        }

        @Override
        public Symbol getEnclosingElement() {
            return null;
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> v, P p) {
            return v.visitPackage(this, p);
        }

        @Override
        public <R, P> R accept(Visitor<R, P> v, P p) {
            return v.visitPackageSymbol(this, p);
        }
    }

    public static class TypeVariableSymbol
    extends TypeSymbol
    implements TypeParameterElement {
        public TypeVariableSymbol(long flags, Name name, Type type, Symbol owner) {
            super(2, flags, name, type, owner);
        }

        @Override
        public ElementKind getKind() {
            return ElementKind.TYPE_PARAMETER;
        }

        @Override
        public Symbol getGenericElement() {
            return this.owner;
        }

        public List<Type> getBounds() {
            Type.TypeVar t = (Type.TypeVar)this.type;
            Type bound = t.getUpperBound();
            if (!bound.isCompound()) {
                return List.of(bound);
            }
            Type.ClassType ct = (Type.ClassType)bound;
            if (!ct.tsym.erasure_field.isInterface()) {
                return ct.interfaces_field.prepend(ct.supertype_field);
            }
            return ct.interfaces_field;
        }

        @Override
        public List<Attribute.Compound> getAnnotationMirrors() {
            List<Attribute.TypeCompound> candidates = this.owner.getRawTypeAttributes();
            int index = this.owner.getTypeParameters().indexOf(this);
            List<Attribute.TypeCompound> res = List.nil();
            for (Attribute.TypeCompound a : candidates) {
                if (!this.isCurrentSymbolsAnnotation(a, index)) continue;
                res = res.prepend(a);
            }
            return res.reverse();
        }

        @Override
        public <A extends Annotation> Attribute.Compound getAttribute(Class<A> annoType) {
            String name = annoType.getName();
            List<Attribute.TypeCompound> candidates = this.owner.getRawTypeAttributes();
            int index = this.owner.getTypeParameters().indexOf(this);
            for (Attribute.TypeCompound anno : candidates) {
                if (!this.isCurrentSymbolsAnnotation(anno, index) || !name.contentEquals(anno.type.tsym.flatName())) continue;
                return anno;
            }
            return null;
        }

        boolean isCurrentSymbolsAnnotation(Attribute.TypeCompound anno, int index) {
            return (anno.position.type == TargetType.CLASS_TYPE_PARAMETER || anno.position.type == TargetType.METHOD_TYPE_PARAMETER) && anno.position.parameter_index == index;
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> v, P p) {
            return v.visitTypeParameter(this, p);
        }
    }

    public static abstract class TypeSymbol
    extends Symbol {
        public TypeSymbol(int kind, long flags, Name name, Type type, Symbol owner) {
            super(kind, flags, name, type, owner);
        }

        public static Name formFullName(Name name, Symbol owner) {
            if (owner == null) {
                return name;
            }
            if (owner.kind != 63 && ((owner.kind & 0x14) != 0 || owner.kind == 2 && owner.type.hasTag(TypeTag.TYPEVAR))) {
                return name;
            }
            Name prefix = owner.getQualifiedName();
            if (prefix == null || prefix == prefix.table.names.empty) {
                return name;
            }
            return prefix.append('.', name);
        }

        public static Name formFlatName(Name name, Symbol owner) {
            if (owner == null || (owner.kind & 0x14) != 0 || owner.kind == 2 && owner.type.hasTag(TypeTag.TYPEVAR)) {
                return name;
            }
            char sep = owner.kind == 2 ? (char)'$' : '.';
            Name prefix = owner.flatName();
            if (prefix == null || prefix == prefix.table.names.empty) {
                return name;
            }
            return prefix.append(sep, name);
        }

        public final boolean precedes(TypeSymbol that, Types types) {
            if (this == that) {
                return false;
            }
            if (this.type.hasTag(that.type.getTag())) {
                if (this.type.hasTag(TypeTag.CLASS)) {
                    return types.rank(that.type) < types.rank(this.type) || types.rank(that.type) == types.rank(this.type) && that.getQualifiedName().compareTo(this.getQualifiedName()) < 0;
                }
                if (this.type.hasTag(TypeTag.TYPEVAR)) {
                    return types.isSubtype(this.type, that.type);
                }
            }
            return this.type.hasTag(TypeTag.TYPEVAR);
        }

        @Override
        public java.util.List<Symbol> getEnclosedElements() {
            List<Symbol> list = List.nil();
            if (this.kind == 2 && this.type.hasTag(TypeTag.TYPEVAR)) {
                return list;
            }
            Scope.Entry e = this.members().elems;
            while (e != null) {
                if (e.sym != null && (e.sym.flags() & 0x1000L) == 0L && e.sym.owner == this) {
                    list = list.prepend(e.sym);
                }
                e = e.sibling;
            }
            return list;
        }

        @Override
        public <R, P> R accept(Visitor<R, P> v, P p) {
            return v.visitTypeSymbol(this, p);
        }
    }

    public static class DelegatedSymbol<T extends Symbol>
    extends Symbol {
        protected T other;

        public DelegatedSymbol(T other) {
            super(((Symbol)other).kind, ((Symbol)other).flags_field, ((Symbol)other).name, ((Symbol)other).type, ((Symbol)other).owner);
            this.other = other;
        }

        @Override
        public String toString() {
            return ((Symbol)this.other).toString();
        }

        @Override
        public Symbol location() {
            return ((Symbol)this.other).location();
        }

        @Override
        public Symbol location(Type site, Types types) {
            return ((Symbol)this.other).location(site, types);
        }

        @Override
        public Symbol baseSymbol() {
            return this.other;
        }

        @Override
        public Type erasure(Types types) {
            return ((Symbol)this.other).erasure(types);
        }

        @Override
        public Type externalType(Types types) {
            return ((Symbol)this.other).externalType(types);
        }

        @Override
        public boolean isLocal() {
            return ((Symbol)this.other).isLocal();
        }

        @Override
        public boolean isConstructor() {
            return ((Symbol)this.other).isConstructor();
        }

        @Override
        public Name getQualifiedName() {
            return ((Symbol)this.other).getQualifiedName();
        }

        @Override
        public Name flatName() {
            return ((Symbol)this.other).flatName();
        }

        @Override
        public Scope members() {
            return ((Symbol)this.other).members();
        }

        @Override
        public boolean isInner() {
            return ((Symbol)this.other).isInner();
        }

        @Override
        public boolean hasOuterInstance() {
            return ((Symbol)this.other).hasOuterInstance();
        }

        @Override
        public ClassSymbol enclClass() {
            return ((Symbol)this.other).enclClass();
        }

        @Override
        public ClassSymbol outermostClass() {
            return ((Symbol)this.other).outermostClass();
        }

        @Override
        public PackageSymbol packge() {
            return ((Symbol)this.other).packge();
        }

        @Override
        public boolean isSubClass(Symbol base, Types types) {
            return ((Symbol)this.other).isSubClass(base, types);
        }

        @Override
        public boolean isMemberOf(TypeSymbol clazz, Types types) {
            return ((Symbol)this.other).isMemberOf(clazz, types);
        }

        @Override
        public boolean isEnclosedBy(ClassSymbol clazz) {
            return ((Symbol)this.other).isEnclosedBy(clazz);
        }

        @Override
        public boolean isInheritedIn(Symbol clazz, Types types) {
            return ((Symbol)this.other).isInheritedIn(clazz, types);
        }

        @Override
        public Symbol asMemberOf(Type site, Types types) {
            return ((Symbol)this.other).asMemberOf(site, types);
        }

        @Override
        public void complete() throws CompletionFailure {
            ((Symbol)this.other).complete();
        }

        @Override
        public <R, P> R accept(ElementVisitor<R, P> v, P p) {
            return this.other.accept(v, p);
        }

        @Override
        public <R, P> R accept(Visitor<R, P> v, P p) {
            return v.visitSymbol((Symbol)this.other, p);
        }

        public T getUnderlyingSymbol() {
            return this.other;
        }
    }
}

