/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;

public class Convert {
    public static int string2int(String s, int radix) throws NumberFormatException {
        if (radix == 10) {
            return Integer.parseInt(s, radix);
        }
        char[] cs = s.toCharArray();
        int limit = Integer.MAX_VALUE / (radix / 2);
        int n = 0;
        for (int i = 0; i < cs.length; ++i) {
            int d = Character.digit(cs[i], radix);
            if (n < 0 || n > limit || n * radix > Integer.MAX_VALUE - d) {
                throw new NumberFormatException();
            }
            n = n * radix + d;
        }
        return n;
    }

    public static long string2long(String s, int radix) throws NumberFormatException {
        if (radix == 10) {
            return Long.parseLong(s, radix);
        }
        char[] cs = s.toCharArray();
        long limit = Long.MAX_VALUE / (long)(radix / 2);
        long n = 0L;
        for (int i = 0; i < cs.length; ++i) {
            int d = Character.digit(cs[i], radix);
            if (n < 0L || n > limit || n * (long)radix > Long.MAX_VALUE - (long)d) {
                throw new NumberFormatException();
            }
            n = n * (long)radix + (long)d;
        }
        return n;
    }

    public static int utf2chars(byte[] src, int sindex, char[] dst, int dindex, int len) {
        int i = sindex;
        int j = dindex;
        int limit = sindex + len;
        while (i < limit) {
            int b;
            if ((b = src[i++] & 0xFF) >= 224) {
                b = (b & 0xF) << 12;
                b |= (src[i++] & 0x3F) << 6;
                b |= src[i++] & 0x3F;
            } else if (b >= 192) {
                b = (b & 0x1F) << 6;
                b |= src[i++] & 0x3F;
            }
            dst[j++] = (char)b;
        }
        return j;
    }

    public static char[] utf2chars(byte[] src, int sindex, int len) {
        char[] dst = new char[len];
        int len1 = Convert.utf2chars(src, sindex, dst, 0, len);
        char[] result = new char[len1];
        System.arraycopy(dst, 0, result, 0, len1);
        return result;
    }

    public static char[] utf2chars(byte[] src) {
        return Convert.utf2chars(src, 0, src.length);
    }

    public static String utf2string(byte[] src, int sindex, int len) {
        char[] dst = new char[len];
        int len1 = Convert.utf2chars(src, sindex, dst, 0, len);
        return new String(dst, 0, len1);
    }

    public static String utf2string(byte[] src) {
        return Convert.utf2string(src, 0, src.length);
    }

    public static int chars2utf(char[] src, int sindex, byte[] dst, int dindex, int len) {
        int j = dindex;
        int limit = sindex + len;
        for (int i = sindex; i < limit; ++i) {
            char ch = src[i];
            if ('\u0001' <= ch && ch <= '\u007f') {
                dst[j++] = (byte)ch;
                continue;
            }
            if (ch <= '\u07ff') {
                dst[j++] = (byte)(0xC0 | ch >> 6);
                dst[j++] = (byte)(0x80 | ch & 0x3F);
                continue;
            }
            dst[j++] = (byte)(0xE0 | ch >> 12);
            dst[j++] = (byte)(0x80 | ch >> 6 & 0x3F);
            dst[j++] = (byte)(0x80 | ch & 0x3F);
        }
        return j;
    }

    public static byte[] chars2utf(char[] src, int sindex, int len) {
        byte[] dst = new byte[len * 3];
        int len1 = Convert.chars2utf(src, sindex, dst, 0, len);
        byte[] result = new byte[len1];
        System.arraycopy(dst, 0, result, 0, len1);
        return result;
    }

    public static byte[] chars2utf(char[] src) {
        return Convert.chars2utf(src, 0, src.length);
    }

    public static byte[] string2utf(String s) {
        return Convert.chars2utf(s.toCharArray());
    }

    public static String quote(String s) {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            buf.append(Convert.quote(s.charAt(i)));
        }
        return buf.toString();
    }

    public static String quote(char ch) {
        switch (ch) {
            case '\b': {
                return "\\b";
            }
            case '\f': {
                return "\\f";
            }
            case '\n': {
                return "\\n";
            }
            case '\r': {
                return "\\r";
            }
            case '\t': {
                return "\\t";
            }
            case '\'': {
                return "\\'";
            }
            case '\"': {
                return "\\\"";
            }
            case '\\': {
                return "\\\\";
            }
        }
        return Convert.isPrintableAscii(ch) ? String.valueOf(ch) : String.format("\\u%04x", ch);
    }

    private static boolean isPrintableAscii(char ch) {
        return ch >= ' ' && ch <= '~';
    }

    public static String escapeUnicode(String s) {
        int len = s.length();
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            if (ch > '\u00ff') {
                StringBuilder buf = new StringBuilder();
                buf.append(s.substring(0, i));
                while (i < len) {
                    ch = s.charAt(i);
                    if (ch > '\u00ff') {
                        buf.append("\\u");
                        buf.append(Character.forDigit((ch >> 12) % 16, 16));
                        buf.append(Character.forDigit((ch >> 8) % 16, 16));
                        buf.append(Character.forDigit((ch >> 4) % 16, 16));
                        buf.append(Character.forDigit(ch % 16, 16));
                    } else {
                        buf.append(ch);
                    }
                    ++i;
                }
                s = buf.toString();
                continue;
            }
            ++i;
        }
        return s;
    }

    public static Name shortName(Name classname) {
        return classname.subName(classname.lastIndexOf((byte)46) + 1, classname.getByteLength());
    }

    public static String shortName(String classname) {
        return classname.substring(classname.lastIndexOf(46) + 1);
    }

    public static Name packagePart(Name classname) {
        return classname.subName(0, classname.lastIndexOf((byte)46));
    }

    public static String packagePart(String classname) {
        int lastDot = classname.lastIndexOf(46);
        return lastDot < 0 ? "" : classname.substring(0, lastDot);
    }

    public static List<Name> enclosingCandidates(Name name) {
        int index;
        List<Name> names = List.nil();
        while ((index = name.lastIndexOf((byte)36)) > 0) {
            name = name.subName(0, index);
            names = names.prepend(name);
        }
        return names;
    }
}

