/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.mavenplugin;

import java.util.Arrays;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.checkerframework.mavenplugin.CommandLineExceutor;
import org.codehaus.plexus.util.cli.CommandLineException;
import org.codehaus.plexus.util.cli.CommandLineUtils;
import org.codehaus.plexus.util.cli.Commandline;
import org.codehaus.plexus.util.cli.StreamConsumer;

public class JavacIOExecutor
implements CommandLineExceutor {
    private final String pathToExecutable;

    public JavacIOExecutor(String pathToExecutable) {
        this.pathToExecutable = pathToExecutable;
    }

    public void executeCommandLine(Commandline cl, Log log, boolean failOnError) throws MojoExecutionException, MojoFailureException {
        int exitCode;
        CommandLineUtils.StringStreamConsumer out = new CommandLineUtils.StringStreamConsumer();
        log.debug((CharSequence)("command line: " + Arrays.toString(cl.getCommandline())));
        try {
            exitCode = CommandLineUtils.executeCommandLine((Commandline)cl, (StreamConsumer)out, (StreamConsumer)out);
        }
        catch (CommandLineException e) {
            throw new MojoExecutionException("Unable to execute the Checker Framework, executable: " + this.pathToExecutable + ", command line: " + Arrays.toString(cl.getCommandline()), (Exception)((Object)e));
        }
        String javacOutput = out.getOutput();
        if (exitCode != 0 && javacOutput.isEmpty()) {
            throw new MojoExecutionException("Exit code from the compiler was not zero (" + exitCode + "), but no output was reported");
        }
        if (exitCode == 0) {
            log.info((CharSequence)javacOutput);
        } else {
            if (failOnError) {
                log.error((CharSequence)javacOutput);
                throw new MojoFailureException(null, "Errors found by the Checker(s)", javacOutput);
            }
            log.warn((CharSequence)"Errors found by the Checker(s)");
            log.warn((CharSequence)javacOutput);
        }
    }
}

