/*
 * Copyright (c) 1996, 2023, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */
package java.io;

import org.checkerframework.framework.qual.AnnotatedFor;

@AnnotatedFor({ "nullness" })
public interface ObjectStreamConstants {

    static final short STREAM_MAGIC;

    static final short STREAM_VERSION;

    static final byte TC_BASE;

    static final byte TC_NULL;

    static final byte TC_REFERENCE;

    static final byte TC_CLASSDESC;

    static final byte TC_OBJECT;

    static final byte TC_STRING;

    static final byte TC_ARRAY;

    static final byte TC_CLASS;

    static final byte TC_BLOCKDATA;

    static final byte TC_ENDBLOCKDATA;

    static final byte TC_RESET;

    static final byte TC_BLOCKDATALONG;

    static final byte TC_EXCEPTION;

    static final byte TC_LONGSTRING;

    static final byte TC_PROXYCLASSDESC;

    static final byte TC_ENUM;

    static final byte TC_MAX;

    static final int baseWireHandle;

    static final byte SC_WRITE_METHOD;

    static final byte SC_BLOCK_DATA;

    static final byte SC_SERIALIZABLE;

    static final byte SC_EXTERNALIZABLE;

    static final byte SC_ENUM;

    static final SerializablePermission SUBSTITUTION_PERMISSION;

    static final SerializablePermission SUBCLASS_IMPLEMENTATION_PERMISSION;

    static final SerializablePermission SERIAL_FILTER_PERMISSION;

    public static final int PROTOCOL_VERSION_1;

    public static final int PROTOCOL_VERSION_2;
}
