package java.util;

import org.checkerframework.checker.nullness.qual.EnsuresNonNullIf;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.dataflow.qual.Pure;
import org.checkerframework.dataflow.qual.SideEffectFree;
import java.io.IOException;
import java.io.ObjectInputStream;
import sun.util.locale.provider.CalendarDataUtility;
import sun.util.calendar.BaseCalendar;
import sun.util.calendar.CalendarDate;
import sun.util.calendar.CalendarSystem;
import sun.util.calendar.CalendarUtils;
import sun.util.calendar.Era;
import sun.util.calendar.Gregorian;
import sun.util.calendar.LocalGregorianCalendar;
import sun.util.calendar.ZoneInfo;

class JapaneseImperialCalendar extends Calendar {

    public static final int BEFORE_MEIJI;

    public static final int MEIJI;

    public static final int TAISHO;

    public static final int SHOWA;

    public static final int HEISEI;

    @Override
    public String getCalendarType();

    @Override
    @Pure
    @EnsuresNonNullIf(expression = "#1", result = true)
    public boolean equals(@Nullable Object obj);

    @Override
    public int hashCode();

    @Override
    public void add(int field, int amount);

    @Override
    public void roll(int field, boolean up);

    @Override
    public void roll(int field, int amount);

    @Override
    public String getDisplayName(int field, int style, Locale locale);

    @Override
    public Map<String, Integer> getDisplayNames(int field, int style, Locale locale);

    public int getMinimum(int field);

    public int getMaximum(int field);

    public int getGreatestMinimum(int field);

    public int getLeastMaximum(int field);

    public int getActualMinimum(int field);

    public int getActualMaximum(int field);

    public Object clone();

    public TimeZone getTimeZone();

    public void setTimeZone(TimeZone zone);

    protected void computeFields();

    protected void computeTime();
}
