/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jstat;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import sun.jvmstat.monitor.MonitorException;
import sun.tools.jstat.Closure;

public class OptionFormat {
    protected String name;
    protected List<OptionFormat> children;

    public OptionFormat(String string) {
        this.name = string;
        this.children = new ArrayList<OptionFormat>();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof OptionFormat)) {
            return false;
        }
        OptionFormat optionFormat = (OptionFormat)object;
        return this.name.compareTo(optionFormat.name) == 0;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public void addSubFormat(OptionFormat optionFormat) {
        this.children.add(optionFormat);
    }

    public OptionFormat getSubFormat(int n) {
        return this.children.get(n);
    }

    public void insertSubFormat(int n, OptionFormat optionFormat) {
        this.children.add(n, optionFormat);
    }

    public String getName() {
        return this.name;
    }

    public void apply(Closure closure) throws MonitorException {
        Iterator<OptionFormat> iterator = this.children.iterator();
        while (iterator.hasNext()) {
            OptionFormat optionFormat = iterator.next();
            closure.visit(optionFormat, iterator.hasNext());
        }
        for (OptionFormat optionFormat : this.children) {
            optionFormat.apply(closure);
        }
    }

    public void printFormat() {
        this.printFormat(0);
    }

    public void printFormat(int n) {
        String string = "  ";
        StringBuilder stringBuilder = new StringBuilder("");
        for (int i = 0; i < n; ++i) {
            stringBuilder.append(string);
        }
        System.out.println(stringBuilder + this.name + " {");
        for (OptionFormat optionFormat : this.children) {
            optionFormat.printFormat(n + 1);
        }
        System.out.println(stringBuilder + "}");
    }
}

