/*
 * Decompiled with CFR 0.152.
 */
package sun.jvmstat.monitor;

import java.net.URI;
import java.net.URISyntaxException;
import sun.jvmstat.monitor.HostIdentifier;

public class VmIdentifier {
    private URI uri;

    private URI canonicalize(String string) throws URISyntaxException {
        if (string == null) {
            string = "local://0@localhost";
            return new URI(string);
        }
        URI uRI = new URI(string);
        if (uRI.isAbsolute()) {
            if (uRI.isOpaque()) {
                uRI = new URI(uRI.getScheme(), "//" + uRI.getSchemeSpecificPart(), uRI.getFragment());
            }
        } else if (!string.startsWith("//")) {
            uRI = uRI.getFragment() == null ? new URI("//" + uRI.getSchemeSpecificPart()) : new URI("//" + uRI.getSchemeSpecificPart() + "#" + uRI.getFragment());
        }
        return uRI;
    }

    private void validate() throws URISyntaxException {
        String string = this.getScheme();
        if (string != null && string.compareTo("file") == 0) {
            return;
        }
        if (this.getLocalVmId() == -1) {
            throw new URISyntaxException(this.uri.toString(), "Local vmid required");
        }
    }

    public VmIdentifier(String string) throws URISyntaxException {
        URI uRI;
        try {
            uRI = this.canonicalize(string);
        }
        catch (URISyntaxException uRISyntaxException) {
            if (string.startsWith("//")) {
                throw uRISyntaxException;
            }
            uRI = this.canonicalize("//" + string);
        }
        this.uri = uRI;
        this.validate();
    }

    public VmIdentifier(URI uRI) throws URISyntaxException {
        this.uri = uRI;
        this.validate();
    }

    public HostIdentifier getHostIdentifier() throws URISyntaxException {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.getScheme() != null) {
            stringBuffer.append(this.getScheme()).append(":");
        }
        stringBuffer.append("//").append(this.getHost());
        if (this.getPort() != -1) {
            stringBuffer.append(":").append(this.getPort());
        }
        if (this.getPath() != null) {
            stringBuffer.append(this.getPath());
        }
        return new HostIdentifier(stringBuffer.toString());
    }

    public String getScheme() {
        return this.uri.getScheme();
    }

    public String getSchemeSpecificPart() {
        return this.uri.getSchemeSpecificPart();
    }

    public String getUserInfo() {
        return this.uri.getUserInfo();
    }

    public String getHost() {
        return this.uri.getHost();
    }

    public int getPort() {
        return this.uri.getPort();
    }

    public String getAuthority() {
        return this.uri.getAuthority();
    }

    public String getPath() {
        return this.uri.getPath();
    }

    public String getQuery() {
        return this.uri.getQuery();
    }

    public String getFragment() {
        return this.uri.getFragment();
    }

    public int getLocalVmId() {
        int n = -1;
        try {
            n = this.uri.getUserInfo() == null ? Integer.parseInt(this.uri.getAuthority()) : Integer.parseInt(this.uri.getUserInfo());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return n;
    }

    public String getMode() {
        String string = this.getQuery();
        if (string != null) {
            String[] stringArray = string.split("\\+");
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].startsWith("mode=")) continue;
                int n = stringArray[i].indexOf(61);
                return stringArray[i].substring(n + 1);
            }
        }
        return "r";
    }

    public URI getURI() {
        return this.uri;
    }

    public int hashCode() {
        return this.uri.hashCode();
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof VmIdentifier)) {
            return false;
        }
        return this.uri.equals(((VmIdentifier)object).uri);
    }

    public String toString() {
        return this.uri.toString();
    }
}

