/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.i18nformatter;

import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TypeCastTree;
import com.sun.source.util.SimpleTreeVisitor;
import java.util.List;
import java.util.Map;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.NullType;
import javax.lang.model.type.PrimitiveType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleElementVisitor7;
import javax.lang.model.util.SimpleTypeVisitor7;
import org.checkerframework.checker.compilermsgs.qual.CompilerMessageKey;
import org.checkerframework.checker.formatter.FormatterTreeUtil;
import org.checkerframework.checker.i18nformatter.I18nFormatUtil;
import org.checkerframework.checker.i18nformatter.I18nFormatterAnnotatedTypeFactory;
import org.checkerframework.checker.i18nformatter.qual.I18nChecksFormat;
import org.checkerframework.checker.i18nformatter.qual.I18nConversionCategory;
import org.checkerframework.checker.i18nformatter.qual.I18nFormat;
import org.checkerframework.checker.i18nformatter.qual.I18nFormatFor;
import org.checkerframework.checker.i18nformatter.qual.I18nInvalidFormat;
import org.checkerframework.checker.i18nformatter.qual.I18nMakeFormat;
import org.checkerframework.checker.i18nformatter.qual.I18nValidFormat;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.dataflow.cfg.node.ArrayCreationNode;
import org.checkerframework.dataflow.cfg.node.FieldAccessNode;
import org.checkerframework.dataflow.cfg.node.MethodInvocationNode;
import org.checkerframework.dataflow.cfg.node.Node;
import org.checkerframework.dataflow.cfg.node.StringLiteralNode;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.framework.util.BaseContext;
import org.checkerframework.framework.util.FlowExpressionParseUtil;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.AnnotationUtils;
import org.checkerframework.javacutil.TreeUtils;

public class I18nFormatterTreeUtil {
    public final BaseTypeChecker checker;
    public final ProcessingEnvironment processingEnv;

    public I18nFormatterTreeUtil(BaseTypeChecker checker) {
        this.checker = checker;
        this.processingEnv = checker.getProcessingEnvironment();
    }

    public AnnotationMirror exceptionToInvalidFormatAnnotation(IllegalArgumentException ex) {
        return this.stringToInvalidFormatAnnotation(ex.getMessage());
    }

    AnnotationMirror stringToInvalidFormatAnnotation(String invalidFormatString) {
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, I18nInvalidFormat.class.getCanonicalName());
        builder.setValue((CharSequence)"value", invalidFormatString);
        return builder.build();
    }

    public String invalidFormatAnnotationToErrorMessage(AnnotationMirror anno) {
        return "\"" + AnnotationUtils.getElementValue(anno, "value", String.class, true) + "\"";
    }

    public AnnotationMirror categoriesToFormatAnnotation(I18nConversionCategory[] args) {
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, I18nFormat.class.getCanonicalName());
        builder.setValue((CharSequence)"value", args);
        return builder.build();
    }

    public I18nConversionCategory[] formatAnnotationToCategories(AnnotationMirror anno) {
        List<I18nConversionCategory> list = AnnotationUtils.getElementValueEnumArray(anno, "value", I18nConversionCategory.class, false);
        return list.toArray(new I18nConversionCategory[0]);
    }

    public boolean isHasFormatCall(MethodInvocationNode node, AnnotatedTypeFactory atypeFactory) {
        ExecutableElement method = node.getTarget().getMethod();
        AnnotationMirror anno = atypeFactory.getDeclAnnotation(method, I18nChecksFormat.class);
        return anno != null;
    }

    public boolean isIsFormatCall(MethodInvocationNode node, AnnotatedTypeFactory atypeFactory) {
        ExecutableElement method = node.getTarget().getMethod();
        AnnotationMirror anno = atypeFactory.getDeclAnnotation(method, I18nValidFormat.class);
        return anno != null;
    }

    public boolean isMakeFormatCall(MethodInvocationNode node, AnnotatedTypeFactory atypeFactory) {
        ExecutableElement method = node.getTarget().getMethod();
        AnnotationMirror anno = atypeFactory.getDeclAnnotation(method, I18nMakeFormat.class);
        return anno != null;
    }

    public final <E> void failure(FormatterTreeUtil.Result<E> res, @CompilerMessageKey String msg, Object ... args) {
        this.checker.report(Result.failure(msg, args), res.location);
    }

    public final <E> void warning(FormatterTreeUtil.Result<E> res, @CompilerMessageKey String msg, Object ... args) {
        this.checker.report(Result.warning(msg, args), res.location);
    }

    private I18nConversionCategory[] asFormatCallCategoriesLowLevel(MethodInvocationNode node) {
        Node vararg = node.getArgument(1);
        if (vararg instanceof ArrayCreationNode) {
            List<Node> convs = ((ArrayCreationNode)vararg).getInitializers();
            I18nConversionCategory[] res = new I18nConversionCategory[convs.size()];
            for (int i = 0; i < convs.size(); ++i) {
                Node conv = convs.get(i);
                if (!(conv instanceof FieldAccessNode) || this.typeMirrorToClass(((FieldAccessNode)conv).getType()) != I18nConversionCategory.class) {
                    return null;
                }
                res[i] = I18nConversionCategory.valueOf(((FieldAccessNode)conv).getFieldName());
            }
            return res;
        }
        return null;
    }

    public FormatterTreeUtil.Result<I18nConversionCategory[]> getHasFormatCallCategories(MethodInvocationNode node) {
        return new FormatterTreeUtil.Result<I18nConversionCategory[]>(this.asFormatCallCategoriesLowLevel(node), node.getTree());
    }

    public FormatterTreeUtil.Result<I18nConversionCategory[]> makeFormatCallCategories(MethodInvocationNode node, I18nFormatterAnnotatedTypeFactory atypeFactory) {
        String s2;
        Map<String, String> translations = atypeFactory.translations;
        Node firstParam = node.getArgument(0);
        FormatterTreeUtil.Result<Object> ret = new FormatterTreeUtil.Result<Object>(null, node.getTree());
        if (firstParam != null && firstParam instanceof StringLiteralNode && translations.containsKey(s2 = ((StringLiteralNode)firstParam).getValue())) {
            String value = translations.get(s2);
            ret = new FormatterTreeUtil.Result<I18nConversionCategory[]>(I18nFormatUtil.formatParameterCategories(value), node.getTree());
        }
        return ret;
    }

    public I18nFormatCall createFormatForCall(MethodInvocationTree tree, MethodInvocationNode node, I18nFormatterAnnotatedTypeFactory atypeFactory) {
        ExecutableElement method = TreeUtils.elementFromUse(tree);
        AnnotatedTypeMirror.AnnotatedExecutableType methodAnno = atypeFactory.getAnnotatedType(method);
        for (AnnotatedTypeMirror paramType : methodAnno.getParameterTypes()) {
            if (paramType.getAnnotation(I18nFormatFor.class) == null) continue;
            I18nFormatterTreeUtil i18nFormatterTreeUtil = atypeFactory.treeUtil;
            i18nFormatterTreeUtil.getClass();
            return i18nFormatterTreeUtil.new I18nFormatCall(tree, node, atypeFactory);
        }
        return null;
    }

    private final Class<? extends Object> typeMirrorToClass(TypeMirror type) {
        return type.accept(new SimpleTypeVisitor7<Class<? extends Object>, Class<Void>>(){

            @Override
            public Class<? extends Object> visitPrimitive(PrimitiveType t, Class<Void> v) {
                switch (t.getKind()) {
                    case BOOLEAN: {
                        return Boolean.class;
                    }
                    case BYTE: {
                        return Byte.class;
                    }
                    case CHAR: {
                        return Character.class;
                    }
                    case SHORT: {
                        return Short.class;
                    }
                    case INT: {
                        return Integer.class;
                    }
                    case LONG: {
                        return Long.class;
                    }
                    case FLOAT: {
                        return Float.class;
                    }
                    case DOUBLE: {
                        return Double.class;
                    }
                }
                return null;
            }

            @Override
            public Class<? extends Object> visitDeclared(DeclaredType dt, Class<Void> v) {
                return dt.asElement().accept(new SimpleElementVisitor7<Class<? extends Object>, Class<Void>>(){

                    @Override
                    public Class<? extends Object> visitType(TypeElement e, Class<Void> v) {
                        try {
                            return Class.forName(e.getQualifiedName().toString());
                        }
                        catch (ClassNotFoundException e1) {
                            return null;
                        }
                    }
                }, Void.TYPE);
            }
        }, Void.TYPE);
    }

    public class I18nFormatCall {
        private final ExpressionTree tree;
        private ExpressionTree formatArg;
        private final AnnotatedTypeFactory atypeFactory;
        private List<? extends ExpressionTree> args;
        private String invalidMessage;
        private AnnotatedTypeMirror formatAnno;

        public I18nFormatCall(MethodInvocationTree tree, MethodInvocationNode node, AnnotatedTypeFactory atypeFactory) {
            this.tree = tree;
            this.atypeFactory = atypeFactory;
            List<? extends ExpressionTree> theargs = tree.getArguments();
            this.args = null;
            ExecutableElement method = TreeUtils.elementFromUse(tree);
            AnnotatedTypeMirror.AnnotatedExecutableType methodAnno = atypeFactory.getAnnotatedType(method);
            this.initialCheck(theargs, method, node, methodAnno);
        }

        public String toString() {
            return this.tree.toString();
        }

        private void initialCheck(List<? extends ExpressionTree> theargs, ExecutableElement method, MethodInvocationNode node, AnnotatedTypeMirror.AnnotatedExecutableType methodAnno) {
            int paramIndex = -1;
            FlowExpressions.Receiver paramArg = null;
            int i = 0;
            for (AnnotatedTypeMirror paramType : methodAnno.getParameterTypes()) {
                if (paramType.getAnnotation(I18nFormatFor.class) != null) {
                    this.formatArg = theargs.get(i);
                    this.formatAnno = this.atypeFactory.getAnnotatedType(this.formatArg);
                    if (!I18nFormatterTreeUtil.this.typeMirrorToClass(paramType.getUnderlyingType()).equals(String.class)) {
                        return;
                    }
                    FlowExpressionParseUtil.FlowExpressionContext flowExprContext = FlowExpressionParseUtil.FlowExpressionContext.buildContextForMethodUse(node, (BaseContext)I18nFormatterTreeUtil.this.checker.getContext());
                    String formatforArg = AnnotationUtils.getElementValue(paramType.getAnnotation(I18nFormatFor.class), "value", String.class, false);
                    if (flowExprContext == null) break;
                    try {
                        paramArg = FlowExpressionParseUtil.parse(formatforArg, flowExprContext, this.atypeFactory.getPath(this.tree), true);
                        paramIndex = flowExprContext.arguments.indexOf(paramArg);
                    }
                    catch (FlowExpressionParseUtil.FlowExpressionParseException e) {
                        I18nFormatterTreeUtil.this.checker.report(Result.failure("i18nformat.invalid.formatfor", new Object[0]), this.tree);
                    }
                    break;
                }
                ++i;
            }
            if (paramIndex != -1) {
                VariableElement param = method.getParameters().get(paramIndex);
                this.args = param.asType().getKind().equals((Object)TypeKind.ARRAY) ? theargs.subList(paramIndex, theargs.size()) : theargs.subList(paramIndex, paramIndex + 1);
            }
        }

        public FormatterTreeUtil.Result<FormatType> getFormatType() {
            FormatType type;
            if (this.isValidFormatForInvocation()) {
                if (this.formatAnno.hasAnnotation(I18nFormat.class)) {
                    type = FormatType.I18NFORMAT;
                } else if (this.formatAnno.hasAnnotation(I18nFormatFor.class)) {
                    type = FormatType.I18NFORMATFOR;
                } else {
                    type = FormatType.I18NINVALID;
                    this.invalidMessage = "(is a @I18nFormat annotation missing?)";
                    AnnotationMirror inv = this.formatAnno.getAnnotation(I18nInvalidFormat.class);
                    if (inv != null) {
                        this.invalidMessage = AnnotationUtils.getElementValue(inv, "value", String.class, true);
                    }
                }
            } else {
                type = FormatType.I18NFORMATFOR;
            }
            return new FormatterTreeUtil.Result<FormatType>(type, this.formatArg);
        }

        public final String getInvalidError() {
            return this.invalidMessage;
        }

        public boolean isValidFormatForInvocation() {
            return this.args != null;
        }

        public final FormatterTreeUtil.Result<FormatterTreeUtil.InvocationType> getInvocationType() {
            FormatterTreeUtil.InvocationType type = FormatterTreeUtil.InvocationType.VARARG;
            if (this.args.size() == 1) {
                final ExpressionTree first = this.args.get(0);
                TypeMirror argType = this.atypeFactory.getAnnotatedType(first).getUnderlyingType();
                type = argType.accept(new SimpleTypeVisitor7<FormatterTreeUtil.InvocationType, Class<Void>>(){

                    @Override
                    protected FormatterTreeUtil.InvocationType defaultAction(TypeMirror e, Class<Void> p) {
                        return FormatterTreeUtil.InvocationType.VARARG;
                    }

                    @Override
                    public FormatterTreeUtil.InvocationType visitArray(ArrayType t, Class<Void> p) {
                        return first.accept(new SimpleTreeVisitor<FormatterTreeUtil.InvocationType, Class<Void>>(){

                            @Override
                            protected FormatterTreeUtil.InvocationType defaultAction(Tree node, Class<Void> p) {
                                return FormatterTreeUtil.InvocationType.ARRAY;
                            }

                            @Override
                            public FormatterTreeUtil.InvocationType visitTypeCast(TypeCastTree node, Class<Void> p) {
                                return I18nFormatCall.this.atypeFactory.getAnnotatedType(node.getExpression()).getUnderlyingType().getKind() == TypeKind.NULL ? FormatterTreeUtil.InvocationType.NULLARRAY : FormatterTreeUtil.InvocationType.ARRAY;
                            }
                        }, p);
                    }

                    @Override
                    public FormatterTreeUtil.InvocationType visitNull(NullType t, Class<Void> p) {
                        return FormatterTreeUtil.InvocationType.NULLARRAY;
                    }
                }, Void.TYPE);
            }
            ExpressionTree loc = ((MethodInvocationTree)this.tree).getMethodSelect();
            if (type != FormatterTreeUtil.InvocationType.VARARG && this.args.size() > 0) {
                loc = this.args.get(0);
            }
            return new FormatterTreeUtil.Result<FormatterTreeUtil.InvocationType>(type, loc);
        }

        public FormatterTreeUtil.Result<FormatType> getInvalidInvocationType() {
            return new FormatterTreeUtil.Result<FormatType>(FormatType.I18NFORMATFOR, this.formatArg);
        }

        public final I18nConversionCategory[] getFormatCategories() {
            AnnotationMirror anno = this.formatAnno.getAnnotation(I18nFormat.class);
            return I18nFormatterTreeUtil.this.formatAnnotationToCategories(anno);
        }

        public final FormatterTreeUtil.Result<TypeMirror>[] getParamTypes() {
            FormatterTreeUtil.Result[] res = new FormatterTreeUtil.Result[this.args.size()];
            for (int i = 0; i < res.length; ++i) {
                ExpressionTree arg = this.args.get(i);
                TypeMirror argType = this.atypeFactory.getAnnotatedType(arg).getUnderlyingType();
                res[i] = new FormatterTreeUtil.Result<TypeMirror>(argType, arg);
            }
            return res;
        }

        public boolean isValidParameter(I18nConversionCategory formatCat, TypeMirror paramType) {
            Class type = I18nFormatterTreeUtil.this.typeMirrorToClass(paramType);
            if (type == null) {
                return false;
            }
            for (Class<? extends Object> c : formatCat.types) {
                if (!c.isAssignableFrom(type)) continue;
                return true;
            }
            return false;
        }
    }

    public static enum FormatType {
        I18NINVALID,
        I18NFORMAT,
        I18NFORMATFOR;

    }
}

