/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.xjc.api.impl.s2j;

import com.sun.codemodel.internal.JClass;
import com.sun.codemodel.internal.JCodeModel;
import com.sun.tools.internal.xjc.Plugin;
import com.sun.tools.internal.xjc.api.ErrorListener;
import com.sun.tools.internal.xjc.api.Mapping;
import com.sun.tools.internal.xjc.api.S2JJAXBModel;
import com.sun.tools.internal.xjc.api.TypeAndAnnotation;
import com.sun.tools.internal.xjc.api.impl.s2j.BeanMappingImpl;
import com.sun.tools.internal.xjc.api.impl.s2j.ElementMappingImpl;
import com.sun.tools.internal.xjc.api.impl.s2j.TypeAndAnnotationImpl;
import com.sun.tools.internal.xjc.model.CClassInfo;
import com.sun.tools.internal.xjc.model.CElementInfo;
import com.sun.tools.internal.xjc.model.Model;
import com.sun.tools.internal.xjc.model.TypeUse;
import com.sun.tools.internal.xjc.outline.Outline;
import com.sun.tools.internal.xjc.outline.PackageOutline;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;

final class JAXBModelImpl
implements S2JJAXBModel {
    final Outline outline;
    private final Model model;
    private final Map<QName, Mapping> byXmlName = new HashMap<QName, Mapping>();

    JAXBModelImpl(Outline outline) {
        this.model = outline.getModel();
        this.outline = outline;
        for (CClassInfo ci : this.model.beans().values()) {
            if (!ci.isElement()) continue;
            this.byXmlName.put(ci.getElementName(), new BeanMappingImpl(this, ci));
        }
        for (CElementInfo ei : this.model.getElementMappings(null).values()) {
            this.byXmlName.put(ei.getElementName(), new ElementMappingImpl(this, ei));
        }
    }

    @Override
    public JCodeModel generateCode(Plugin[] extensions, ErrorListener errorListener) {
        return this.outline.getCodeModel();
    }

    @Override
    public List<JClass> getAllObjectFactories() {
        ArrayList<JClass> r = new ArrayList<JClass>();
        for (PackageOutline packageOutline : this.outline.getAllPackageContexts()) {
            r.add(packageOutline.objectFactory());
        }
        return r;
    }

    @Override
    public final Mapping get(QName elementName) {
        return this.byXmlName.get(elementName);
    }

    @Override
    public final Collection<? extends Mapping> getMappings() {
        return this.byXmlName.values();
    }

    @Override
    public TypeAndAnnotation getJavaType(QName xmlTypeName) {
        TypeUse use = this.model.typeUses().get(xmlTypeName);
        if (use == null) {
            return null;
        }
        return new TypeAndAnnotationImpl(this.outline, use);
    }

    @Override
    public final List<String> getClassList() {
        ArrayList<String> classList = new ArrayList<String>();
        for (PackageOutline packageOutline : this.outline.getAllPackageContexts()) {
            classList.add(packageOutline.objectFactory().fullName());
        }
        return classList;
    }
}

