/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.builders;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.ProgramElementDoc;
import com.sun.tools.doclets.internal.toolkit.Configuration;
import com.sun.tools.doclets.internal.toolkit.Content;
import com.sun.tools.doclets.internal.toolkit.MethodWriter;
import com.sun.tools.doclets.internal.toolkit.builders.AbstractMemberBuilder;
import com.sun.tools.doclets.internal.toolkit.builders.XMLNode;
import com.sun.tools.doclets.internal.toolkit.util.DocFinder;
import com.sun.tools.doclets.internal.toolkit.util.VisibleMemberMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class MethodBuilder
extends AbstractMemberBuilder {
    private int currentMethodIndex;
    private ClassDoc classDoc;
    private VisibleMemberMap visibleMemberMap;
    private MethodWriter writer;
    private List<ProgramElementDoc> methods;

    private MethodBuilder(Configuration configuration) {
        super(configuration);
    }

    public static MethodBuilder getInstance(Configuration configuration, ClassDoc classDoc, MethodWriter methodWriter) {
        MethodBuilder methodBuilder = new MethodBuilder(configuration);
        methodBuilder.classDoc = classDoc;
        methodBuilder.writer = methodWriter;
        methodBuilder.visibleMemberMap = new VisibleMemberMap(classDoc, 4, configuration.nodeprecated);
        methodBuilder.methods = new ArrayList<ProgramElementDoc>(methodBuilder.visibleMemberMap.getLeafClassMembers(configuration));
        if (configuration.getMemberComparator() != null) {
            Collections.sort(methodBuilder.methods, configuration.getMemberComparator());
        }
        return methodBuilder;
    }

    @Override
    public String getName() {
        return "MethodDetails";
    }

    public List<ProgramElementDoc> members(ClassDoc classDoc) {
        return this.visibleMemberMap.getMembersFor(classDoc);
    }

    public VisibleMemberMap getVisibleMemberMap() {
        return this.visibleMemberMap;
    }

    @Override
    public boolean hasMembersToDocument() {
        return this.methods.size() > 0;
    }

    public void buildMethodDoc(XMLNode xMLNode, Content content) {
        if (this.writer == null) {
            return;
        }
        int n = this.methods.size();
        if (n > 0) {
            Content content2 = this.writer.getMethodDetailsTreeHeader(this.classDoc, content);
            this.currentMethodIndex = 0;
            while (this.currentMethodIndex < n) {
                Content content3 = this.writer.getMethodDocTreeHeader((MethodDoc)this.methods.get(this.currentMethodIndex), content2);
                this.buildChildren(xMLNode, content3);
                content2.addContent(this.writer.getMethodDoc(content3, this.currentMethodIndex == n - 1));
                ++this.currentMethodIndex;
            }
            content.addContent(this.writer.getMethodDetails(content2));
        }
    }

    public void buildSignature(XMLNode xMLNode, Content content) {
        content.addContent(this.writer.getSignature((MethodDoc)this.methods.get(this.currentMethodIndex)));
    }

    public void buildDeprecationInfo(XMLNode xMLNode, Content content) {
        this.writer.addDeprecated((MethodDoc)this.methods.get(this.currentMethodIndex), content);
    }

    public void buildMethodComments(XMLNode xMLNode, Content content) {
        if (!this.configuration.nocomment) {
            MethodDoc methodDoc = (MethodDoc)this.methods.get(this.currentMethodIndex);
            if (methodDoc.inlineTags().length == 0) {
                DocFinder.Output output = DocFinder.search(new DocFinder.Input(methodDoc));
                methodDoc = output.inlineTags != null && output.inlineTags.length > 0 ? (MethodDoc)output.holder : methodDoc;
            }
            this.writer.addComments(methodDoc.containingClass(), methodDoc, content);
        }
    }

    public void buildTagInfo(XMLNode xMLNode, Content content) {
        this.writer.addTags((MethodDoc)this.methods.get(this.currentMethodIndex), content);
    }

    public MethodWriter getWriter() {
        return this.writer;
    }
}

