/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.apt.mirror.apt;

import com.sun.mirror.apt.Messager;
import com.sun.mirror.util.SourcePosition;
import com.sun.tools.apt.mirror.util.SourcePositionImpl;
import com.sun.tools.apt.util.Bark;
import com.sun.tools.javac.util.Context;
import javax.tools.JavaFileObject;

public class MessagerImpl
implements Messager {
    private final Bark bark;
    private static final Context.Key<MessagerImpl> messagerKey = new Context.Key();

    public static MessagerImpl instance(Context context) {
        MessagerImpl messagerImpl = context.get(messagerKey);
        if (messagerImpl == null) {
            messagerImpl = new MessagerImpl(context);
        }
        return messagerImpl;
    }

    private MessagerImpl(Context context) {
        context.put(messagerKey, this);
        this.bark = Bark.instance(context);
    }

    @Override
    public void printError(String string) {
        this.bark.aptError("Messager", string);
    }

    @Override
    public void printError(SourcePosition sourcePosition, String string) {
        if (sourcePosition instanceof SourcePositionImpl) {
            SourcePositionImpl sourcePositionImpl = (SourcePositionImpl)sourcePosition;
            JavaFileObject javaFileObject = this.bark.useSource(sourcePositionImpl.getSource());
            this.bark.aptError(sourcePositionImpl.getJavacPosition(), "Messager", string);
            this.bark.useSource(javaFileObject);
        } else {
            this.printError(string);
        }
    }

    @Override
    public void printWarning(String string) {
        this.bark.aptWarning("Messager", string);
    }

    @Override
    public void printWarning(SourcePosition sourcePosition, String string) {
        if (sourcePosition instanceof SourcePositionImpl) {
            SourcePositionImpl sourcePositionImpl = (SourcePositionImpl)sourcePosition;
            JavaFileObject javaFileObject = this.bark.useSource(sourcePositionImpl.getSource());
            this.bark.aptWarning(sourcePositionImpl.getJavacPosition(), "Messager", string);
            this.bark.useSource(javaFileObject);
        } else {
            this.printWarning(string);
        }
    }

    @Override
    public void printNotice(String string) {
        this.bark.aptNote("Messager", string);
    }

    @Override
    public void printNotice(SourcePosition sourcePosition, String string) {
        if (sourcePosition instanceof SourcePositionImpl) {
            SourcePositionImpl sourcePositionImpl = (SourcePositionImpl)sourcePosition;
            JavaFileObject javaFileObject = this.bark.useSource(sourcePositionImpl.getSource());
            this.bark.aptNote(sourcePositionImpl.getJavacPosition(), "Messager", string);
            this.bark.useSource(javaFileObject);
        } else {
            this.printNotice(string);
        }
    }
}

