/*
 * Decompiled with CFR 0.152.
 */
package scenelib.annotations.io.classfile;

import com.sun.tools.javac.main.CommandLine;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.checkerframework.org.objectweb.asm.ClassReader;
import org.plumelib.options.Option;
import org.plumelib.options.Options;
import scenelib.annotations.el.AScene;
import scenelib.annotations.io.IndexFileWriter;
import scenelib.annotations.io.classfile.ClassAnnotationSceneReader;

public class ClassFileReader {
    public static final String INDEX_UTILS_VERSION = "Annotation File Utilities v3.6.47";
    @Option(value="-b omit annotations from bridge (compiler-created) methods")
    public static boolean ignore_bridge_methods = false;
    @Option(value="-h print usage information and exit")
    public static boolean help = false;
    @Option(value="-v print version information and exit")
    public static boolean version = false;
    private static String linesep = System.getProperty("line.separator");
    static String usage = "extract-annotations [options] class1 class2 ..." + linesep + "Each argument is a class a.b.C (that is on your classpath) or a class file" + linesep + "a/b/C.class.  Extracts the annotations from each such argument and prints" + linesep + "them in index-file format to a.b.C.jaif .  Arguments beginning with a" + linesep + "single '@' are interpreted as argument files to be read and expanded into" + linesep + "the command line.  Options:";

    public static void main(String[] args) throws IOException {
        String[] file_args;
        Options options = new Options(usage, ClassFileReader.class);
        try {
            String[] cl_args = CommandLine.parse(args);
            file_args = options.parse(true, cl_args);
        }
        catch (IOException ex) {
            System.err.println(ex);
            System.err.println("(For non-argfile beginning with \"@\", use \"@@\" for initial \"@\".");
            System.err.println("Alternative for filenames: indicate directory, e.g. as './@file'.");
            System.err.println("Alternative for flags: use '=', as in '-o=@Deprecated'.)");
            file_args = null;
            System.exit(1);
        }
        if (version) {
            System.out.printf("extract-annotations (%s)", INDEX_UTILS_VERSION);
        }
        if (help) {
            options.printUsage();
        }
        if (version || help) {
            System.exit(-1);
        }
        if (file_args.length == 0) {
            System.out.println("No arguments given.");
            options.printUsage();
            System.exit(-1);
        }
        for (String arg : file_args) {
            if (ClassFileReader.checkClass(arg)) continue;
            System.exit(-1);
        }
        for (String origName : file_args) {
            System.out.println("reading: " + origName);
            String className = origName;
            if (origName.endsWith(".class")) {
                origName = origName.replace(".class", "");
            }
            AScene scene = new AScene();
            try {
                if (className.endsWith(".class")) {
                    ClassFileReader.read(scene, className);
                } else {
                    ClassFileReader.readFromClass(scene, className);
                }
                String outputFile = origName + ".jaif";
                System.out.println("printing results to : " + outputFile);
                IndexFileWriter.write(scene, outputFile);
            }
            catch (IOException e) {
                System.out.println("There was an error in reading class: " + origName);
                System.out.println("Did you ensure that this class is on your classpath?");
                return;
            }
            catch (Exception e) {
                System.out.println("Unknown error trying to extract annotations from: " + origName);
                System.out.println(e.getMessage());
                e.printStackTrace();
                System.out.println("Please submit a bug report at");
                System.out.println("  https://github.com/typetools/annotation-tools/issues");
                System.out.println("Be sure to include a copy of the output trace, instructions on how");
                System.out.println("to reproduce this error, and all input files.  Thanks!");
                return;
            }
        }
    }

    public static boolean checkClass(String arg) {
        if (!arg.contains(".class") && arg.contains("/")) {
            System.out.println("Error: bad class " + arg);
            System.out.println("Use a fully qualified class name such as java.lang.Object");
            System.out.println("or a filename such as .../path/to/MyClass.class");
            return false;
        }
        return true;
    }

    public static void read(AScene scene, String fileName) throws IOException {
        ClassFileReader.read(scene, new FileInputStream(fileName));
    }

    public static void readFromClass(AScene scene, String className) throws IOException {
        ClassFileReader.read(scene, new ClassReader(className));
    }

    public static void read(AScene scene, InputStream in) throws IOException {
        ClassFileReader.read(scene, new ClassReader(in));
    }

    public static void read(AScene scene, ClassReader cr) {
        ClassAnnotationSceneReader ca = new ClassAnnotationSceneReader(cr, scene, ignore_bridge_methods);
        cr.accept(ca, true);
    }
}

