/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.optional;

import com.sun.source.tree.BlockTree;
import com.sun.source.tree.ConditionalExpressionTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IfTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.basetype.BaseTypeValidator;
import org.checkerframework.common.basetype.BaseTypeVisitor;
import org.checkerframework.dataflow.analysis.FlowExpressions;
import org.checkerframework.framework.source.Result;
import org.checkerframework.framework.type.AnnotatedTypeFactory;
import org.checkerframework.framework.type.AnnotatedTypeMirror;
import org.checkerframework.javacutil.AnnotationProvider;
import org.checkerframework.javacutil.TreeUtils;
import org.checkerframework.javacutil.TypesUtils;

public class OptionalVisitor
extends BaseTypeVisitor<BaseAnnotatedTypeFactory> {
    private final TypeMirror collectionType;
    private final ExecutableElement get;
    private final ExecutableElement isPresent;
    private final ExecutableElement of;
    private final ExecutableElement ofNullable;
    private final ExecutableElement orElse;
    private final ExecutableElement orElseGet;
    private final ExecutableElement orElseThrow;

    public OptionalVisitor(BaseTypeChecker checker) {
        super(checker);
        this.collectionType = this.types.erasure(TypesUtils.typeFromClass(Collection.class, this.types, this.elements));
        ProcessingEnvironment env = checker.getProcessingEnvironment();
        this.get = TreeUtils.getMethod(Optional.class.getName(), "get", 0, env);
        this.isPresent = TreeUtils.getMethod(Optional.class.getName(), "isPresent", 0, env);
        this.of = TreeUtils.getMethod(Optional.class.getName(), "of", 1, env);
        this.ofNullable = TreeUtils.getMethod(Optional.class.getName(), "ofNullable", 1, env);
        this.orElse = TreeUtils.getMethod(Optional.class.getName(), "orElse", 1, env);
        this.orElseGet = TreeUtils.getMethod(Optional.class.getName(), "orElseGet", 1, env);
        this.orElseThrow = TreeUtils.getMethod(Optional.class.getName(), "orElseThrow", 1, env);
    }

    @Override
    protected BaseTypeValidator createTypeValidator() {
        return new OptionalTypeValidator(this.checker, this, this.atypeFactory);
    }

    private boolean isCallToGet(ExpressionTree expression) {
        ProcessingEnvironment env = this.checker.getProcessingEnvironment();
        return TreeUtils.isMethodInvocation(expression, this.get, env);
    }

    private boolean isCallToIsPresent(ExpressionTree expression) {
        ProcessingEnvironment env = this.checker.getProcessingEnvironment();
        return TreeUtils.isMethodInvocation(expression, this.isPresent, env);
    }

    private boolean isCallToOf(ExpressionTree expression) {
        ProcessingEnvironment env = this.checker.getProcessingEnvironment();
        return TreeUtils.isMethodInvocation(expression, this.of, env);
    }

    private boolean isOptionalCreation(MethodInvocationTree methInvok) {
        ProcessingEnvironment env = this.checker.getProcessingEnvironment();
        return TreeUtils.isMethodInvocation(methInvok, this.of, env) || TreeUtils.isMethodInvocation(methInvok, this.ofNullable, env);
    }

    private boolean isOptionalElimation(MethodInvocationTree methInvok) {
        ProcessingEnvironment env = this.checker.getProcessingEnvironment();
        return TreeUtils.isMethodInvocation(methInvok, this.get, env) || TreeUtils.isMethodInvocation(methInvok, this.orElse, env) || TreeUtils.isMethodInvocation(methInvok, this.orElseGet, env) || TreeUtils.isMethodInvocation(methInvok, this.orElseThrow, env);
    }

    @Override
    public Void visitConditionalExpression(ConditionalExpressionTree node, Void p) {
        this.handleTernaryIsPresentGet(node);
        return super.visitConditionalExpression(node, p);
    }

    public void handleTernaryIsPresentGet(ConditionalExpressionTree node) {
        ExpressionTree condExpr = TreeUtils.skipParens(node.getCondition());
        ExpressionTree trueExpr = TreeUtils.skipParens(node.getTrueExpression());
        ExpressionTree falseExpr = TreeUtils.skipParens(node.getFalseExpression());
        if (!this.isCallToIsPresent(condExpr)) {
            return;
        }
        ExpressionTree receiver = TreeUtils.getReceiverTree(condExpr);
        if (trueExpr.getKind() != Tree.Kind.METHOD_INVOCATION) {
            return;
        }
        ExpressionTree trueReceiver = TreeUtils.getReceiverTree(trueExpr);
        if (!this.isCallToGet(trueReceiver)) {
            return;
        }
        ExpressionTree getReceiver = TreeUtils.getReceiverTree(trueReceiver);
        if (this.sameExpression(receiver, getReceiver)) {
            ExecutableElement ele = TreeUtils.elementFromUse((MethodInvocationTree)trueExpr);
            this.checker.report(Result.warning("prefer.map.and.orelse", receiver, ele.getSimpleName(), falseExpr), node);
        }
    }

    private boolean sameExpression(ExpressionTree tree1, ExpressionTree tree2) {
        FlowExpressions.Receiver r1 = FlowExpressions.internalReprOf((AnnotationProvider)this.atypeFactory, tree1);
        FlowExpressions.Receiver r2 = FlowExpressions.internalReprOf((AnnotationProvider)this.atypeFactory, tree1);
        if (r1 != null && !r1.containsUnknown() && r2 != null && !r2.containsUnknown()) {
            return r1.equals(r2);
        }
        return tree1.toString().equals(tree2.toString());
    }

    @Override
    public Void visitIf(IfTree node, Void p) {
        this.handleConditionalStatementIsPresentGet(node);
        return (Void)super.visitIf(node, p);
    }

    public void handleConditionalStatementIsPresentGet(IfTree node) {
        ExpressionTree condExpr = TreeUtils.skipParens(node.getCondition());
        StatementTree thenStmt = OptionalVisitor.skipBlocks(node.getThenStatement());
        StatementTree elseStmt = OptionalVisitor.skipBlocks(node.getElseStatement());
        if (!(elseStmt == null || elseStmt.getKind() == Tree.Kind.BLOCK && ((BlockTree)elseStmt).getStatements().isEmpty())) {
            return;
        }
        if (!this.isCallToIsPresent(condExpr)) {
            return;
        }
        ExpressionTree receiver = TreeUtils.getReceiverTree(condExpr);
        if (thenStmt.getKind() != Tree.Kind.EXPRESSION_STATEMENT) {
            return;
        }
        ExpressionTree thenExpr = ((ExpressionStatementTree)thenStmt).getExpression();
        if (thenExpr.getKind() != Tree.Kind.METHOD_INVOCATION) {
            return;
        }
        MethodInvocationTree invok = (MethodInvocationTree)thenExpr;
        List<? extends ExpressionTree> args = invok.getArguments();
        if (args.size() != 1) {
            return;
        }
        ExpressionTree arg = TreeUtils.skipParens(args.get(0));
        if (!this.isCallToGet(arg)) {
            return;
        }
        ExpressionTree getReceiver = TreeUtils.getReceiverTree(arg);
        if (!receiver.toString().equals(getReceiver.toString())) {
            return;
        }
        ExpressionTree method = invok.getMethodSelect();
        String methodString = method.toString();
        int dotPos = methodString.lastIndexOf(".");
        if (dotPos != -1) {
            methodString = methodString.substring(0, dotPos) + "::" + methodString.substring(dotPos + 1);
        }
        this.checker.report(Result.warning("prefer.ifpresent", receiver, methodString), node);
    }

    @Override
    public Void visitMethodInvocation(MethodInvocationTree node, Void p) {
        this.handleCreationElimination(node);
        return super.visitMethodInvocation(node, p);
    }

    public void handleCreationElimination(MethodInvocationTree node) {
        if (!this.isOptionalElimation(node)) {
            return;
        }
        ExpressionTree receiver = TreeUtils.getReceiverTree(node);
        if (receiver.getKind() != Tree.Kind.METHOD_INVOCATION || !this.isOptionalCreation((MethodInvocationTree)receiver)) {
            return;
        }
        this.checker.report(Result.warning("introduce.eliminate", new Object[0]), node);
    }

    @Override
    public Void visitVariable(VariableTree node, Void p) {
        VariableElement ve = TreeUtils.elementFromDeclaration(node);
        TypeMirror tm = ve.asType();
        if (this.isOptionalType(tm)) {
            ElementKind ekind = TreeUtils.elementFromDeclaration(node).getKind();
            if (ekind.isField()) {
                this.checker.report(Result.warning("optional.field", new Object[0]), node);
            } else if (ekind == ElementKind.PARAMETER) {
                this.checker.report(Result.warning("optional.parameter", new Object[0]), node);
            }
        }
        return super.visitVariable(node, p);
    }

    private boolean isCollectionType(TypeMirror tm) {
        return tm.getKind() == TypeKind.DECLARED && this.types.isSubtype(tm, this.collectionType);
    }

    private boolean isOptionalType(TypeMirror tm) {
        return TypesUtils.isDeclaredOfName(tm, "java.util.Optional");
    }

    public static StatementTree skipBlocks(StatementTree tree) {
        if (tree == null) {
            return tree;
        }
        StatementTree s2 = tree;
        while (s2.getKind() == Tree.Kind.BLOCK) {
            List<? extends StatementTree> stmts = ((BlockTree)s2).getStatements();
            if (stmts.size() == 1) {
                s2 = stmts.get(0);
                continue;
            }
            return s2;
        }
        return s2;
    }

    private final class OptionalTypeValidator
    extends BaseTypeValidator {
        public OptionalTypeValidator(BaseTypeChecker checker, BaseTypeVisitor<?> visitor, AnnotatedTypeFactory atypeFactory) {
            super(checker, visitor, atypeFactory);
        }

        @Override
        public boolean isValid(AnnotatedTypeMirror type, Tree tree) {
            TypeMirror tm = type.getUnderlyingType();
            if (OptionalVisitor.this.isCollectionType(tm)) {
                TypeMirror typeArg;
                DeclaredType type1 = (DeclaredType)type.getUnderlyingType();
                List<? extends TypeMirror> typeArgs = type1.getTypeArguments();
                if (typeArgs.size() == 1 && OptionalVisitor.this.isOptionalType(typeArg = typeArgs.get(0))) {
                    this.checker.report(Result.warning("optional.as.element.type", new Object[0]), tree);
                }
            } else if (OptionalVisitor.this.isOptionalType(tm)) {
                List<? extends TypeMirror> typeArgs = ((DeclaredType)type.getUnderlyingType()).getTypeArguments();
                assert (typeArgs.size() == 1);
                TypeMirror typeArg = typeArgs.get(0);
                if (OptionalVisitor.this.isCollectionType(typeArg)) {
                    this.checker.report(Result.failure("optional.collection", new Object[0]), tree);
                }
            }
            return super.isValid(type, tree);
        }
    }
}

