/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.checker.index.searchindex;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.AnnotationMirror;
import org.checkerframework.checker.index.IndexUtil;
import org.checkerframework.checker.index.qual.NegativeIndexFor;
import org.checkerframework.checker.index.qual.SearchIndexBottom;
import org.checkerframework.checker.index.qual.SearchIndexFor;
import org.checkerframework.checker.index.qual.SearchIndexUnknown;
import org.checkerframework.common.basetype.BaseAnnotatedTypeFactory;
import org.checkerframework.common.basetype.BaseTypeChecker;
import org.checkerframework.common.value.ValueAnnotatedTypeFactory;
import org.checkerframework.common.value.ValueChecker;
import org.checkerframework.framework.type.QualifierHierarchy;
import org.checkerframework.framework.util.MultiGraphQualifierHierarchy;
import org.checkerframework.javacutil.AnnotationBuilder;
import org.checkerframework.javacutil.AnnotationUtils;

public class SearchIndexAnnotatedTypeFactory
extends BaseAnnotatedTypeFactory {
    public final AnnotationMirror UNKNOWN;
    public final AnnotationMirror BOTTOM;

    public SearchIndexAnnotatedTypeFactory(BaseTypeChecker checker) {
        super(checker);
        this.UNKNOWN = AnnotationBuilder.fromClass(this.elements, SearchIndexUnknown.class);
        this.BOTTOM = AnnotationBuilder.fromClass(this.elements, SearchIndexBottom.class);
        this.postInit();
    }

    ValueAnnotatedTypeFactory getValueAnnotatedTypeFactory() {
        return (ValueAnnotatedTypeFactory)this.getTypeFactoryOfSubchecker(ValueChecker.class);
    }

    @Override
    protected Set<Class<? extends Annotation>> createSupportedTypeQualifiers() {
        return new LinkedHashSet<Class<? extends Annotation>>(Arrays.asList(SearchIndexFor.class, SearchIndexBottom.class, SearchIndexUnknown.class, NegativeIndexFor.class));
    }

    @Override
    public QualifierHierarchy createQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
        return new SearchIndexQualifierHierarchy(factory);
    }

    AnnotationMirror createNegativeIndexFor(List<String> arrays) {
        if (arrays.size() == 0) {
            return this.UNKNOWN;
        }
        arrays = new ArrayList<String>(new HashSet<String>(arrays));
        Collections.sort(arrays);
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, NegativeIndexFor.class);
        builder.setValue((CharSequence)"value", arrays);
        return builder.build();
    }

    AnnotationMirror createSearchIndexFor(List<String> arrays) {
        if (arrays.size() == 0) {
            return this.UNKNOWN;
        }
        arrays = new ArrayList<String>(new HashSet<String>(arrays));
        Collections.sort(arrays);
        AnnotationBuilder builder = new AnnotationBuilder(this.processingEnv, SearchIndexFor.class);
        builder.setValue((CharSequence)"value", arrays);
        return builder.build();
    }

    private final class SearchIndexQualifierHierarchy
    extends MultiGraphQualifierHierarchy {
        public SearchIndexQualifierHierarchy(MultiGraphQualifierHierarchy.MultiGraphFactory factory) {
            super(factory);
        }

        @Override
        public AnnotationMirror greatestLowerBound(AnnotationMirror a1, AnnotationMirror a2) {
            if (AnnotationUtils.areSame(a1, SearchIndexAnnotatedTypeFactory.this.UNKNOWN)) {
                return a2;
            }
            if (AnnotationUtils.areSame(a2, SearchIndexAnnotatedTypeFactory.this.UNKNOWN)) {
                return a1;
            }
            if (AnnotationUtils.areSame(a1, SearchIndexAnnotatedTypeFactory.this.BOTTOM)) {
                return a1;
            }
            if (AnnotationUtils.areSame(a2, SearchIndexAnnotatedTypeFactory.this.BOTTOM)) {
                return a2;
            }
            if (this.isSubtype(a1, a2)) {
                return a1;
            }
            if (this.isSubtype(a2, a1)) {
                return a2;
            }
            HashSet<String> combinedArrays = new HashSet<String>(IndexUtil.getValueOfAnnotationWithStringArgument(a1));
            combinedArrays.addAll(IndexUtil.getValueOfAnnotationWithStringArgument(a2));
            if (AnnotationUtils.areSameByClass(a1, NegativeIndexFor.class) || AnnotationUtils.areSameByClass(a2, NegativeIndexFor.class)) {
                return SearchIndexAnnotatedTypeFactory.this.createNegativeIndexFor(Arrays.asList(combinedArrays.toArray(new String[0])));
            }
            return SearchIndexAnnotatedTypeFactory.this.createSearchIndexFor(Arrays.asList(combinedArrays.toArray(new String[0])));
        }

        @Override
        public AnnotationMirror leastUpperBound(AnnotationMirror a1, AnnotationMirror a2) {
            if (AnnotationUtils.areSame(a1, SearchIndexAnnotatedTypeFactory.this.UNKNOWN)) {
                return a1;
            }
            if (AnnotationUtils.areSame(a2, SearchIndexAnnotatedTypeFactory.this.UNKNOWN)) {
                return a2;
            }
            if (AnnotationUtils.areSame(a1, SearchIndexAnnotatedTypeFactory.this.BOTTOM)) {
                return a2;
            }
            if (AnnotationUtils.areSame(a2, SearchIndexAnnotatedTypeFactory.this.BOTTOM)) {
                return a1;
            }
            if (this.isSubtype(a1, a2)) {
                return a2;
            }
            if (this.isSubtype(a2, a1)) {
                return a1;
            }
            List<String> arrayIntersection = IndexUtil.getValueOfAnnotationWithStringArgument(a1);
            arrayIntersection.retainAll(IndexUtil.getValueOfAnnotationWithStringArgument(a2));
            if (arrayIntersection.size() == 0) {
                return SearchIndexAnnotatedTypeFactory.this.UNKNOWN;
            }
            if (AnnotationUtils.areSameByClass(a1, SearchIndexFor.class) || AnnotationUtils.areSameByClass(a2, SearchIndexFor.class)) {
                return SearchIndexAnnotatedTypeFactory.this.createSearchIndexFor(Arrays.asList(arrayIntersection.toArray(new String[0])));
            }
            return SearchIndexAnnotatedTypeFactory.this.createNegativeIndexFor(Arrays.asList(arrayIntersection.toArray(new String[0])));
        }

        @Override
        public boolean isSubtype(AnnotationMirror subAnno, AnnotationMirror superAnno) {
            if (AnnotationUtils.areSameByClass(superAnno, SearchIndexUnknown.class)) {
                return true;
            }
            if (AnnotationUtils.areSameByClass(subAnno, SearchIndexBottom.class)) {
                return true;
            }
            if (AnnotationUtils.areSameByClass(subAnno, SearchIndexUnknown.class)) {
                return false;
            }
            if (AnnotationUtils.areSameByClass(superAnno, SearchIndexBottom.class)) {
                return false;
            }
            List<String> superArrays = IndexUtil.getValueOfAnnotationWithStringArgument(superAnno);
            List<String> subArrays = IndexUtil.getValueOfAnnotationWithStringArgument(subAnno);
            return (AnnotationUtils.areSameByClass(subAnno, NegativeIndexFor.class) || AnnotationUtils.areSameByClass(superAnno, SearchIndexFor.class)) && subArrays.containsAll(superArrays);
        }
    }
}

