/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.internal.rngom.binary;

import com.sun.xml.internal.rngom.binary.AttributePattern;
import com.sun.xml.internal.rngom.binary.DataExceptPattern;
import com.sun.xml.internal.rngom.binary.DataPattern;
import com.sun.xml.internal.rngom.binary.ElementPattern;
import com.sun.xml.internal.rngom.binary.ErrorPattern;
import com.sun.xml.internal.rngom.binary.ListPattern;
import com.sun.xml.internal.rngom.binary.NotAllowedPattern;
import com.sun.xml.internal.rngom.binary.Pattern;
import com.sun.xml.internal.rngom.binary.PatternBuilder;
import com.sun.xml.internal.rngom.binary.PatternInterner;
import com.sun.xml.internal.rngom.binary.TextPattern;
import com.sun.xml.internal.rngom.binary.ValuePattern;
import com.sun.xml.internal.rngom.nc.NameClass;
import org.relaxng.datatype.Datatype;
import org.xml.sax.Locator;

public class SchemaPatternBuilder
extends PatternBuilder {
    private boolean idTypes;
    private final Pattern unexpandedNotAllowed = new NotAllowedPattern(){

        @Override
        boolean isNotAllowed() {
            return false;
        }

        @Override
        Pattern expand(SchemaPatternBuilder b) {
            return b.makeNotAllowed();
        }
    };
    private final TextPattern text = new TextPattern();
    private final PatternInterner schemaInterner = new PatternInterner();

    public boolean hasIdTypes() {
        return this.idTypes;
    }

    Pattern makeElement(NameClass nameClass, Pattern content, Locator loc) {
        ElementPattern p = new ElementPattern(nameClass, content, loc);
        return this.schemaInterner.intern(p);
    }

    Pattern makeAttribute(NameClass nameClass, Pattern value, Locator loc) {
        if (value == this.notAllowed) {
            return value;
        }
        AttributePattern p = new AttributePattern(nameClass, value, loc);
        return this.schemaInterner.intern(p);
    }

    Pattern makeData(Datatype dt) {
        this.noteDatatype(dt);
        DataPattern p = new DataPattern(dt);
        return this.schemaInterner.intern(p);
    }

    Pattern makeDataExcept(Datatype dt, Pattern except, Locator loc) {
        this.noteDatatype(dt);
        DataExceptPattern p = new DataExceptPattern(dt, except, loc);
        return this.schemaInterner.intern(p);
    }

    Pattern makeValue(Datatype dt, Object obj) {
        this.noteDatatype(dt);
        ValuePattern p = new ValuePattern(dt, obj);
        return this.schemaInterner.intern(p);
    }

    Pattern makeText() {
        return this.text;
    }

    @Override
    Pattern makeOneOrMore(Pattern p) {
        if (p == this.text) {
            return p;
        }
        return super.makeOneOrMore(p);
    }

    Pattern makeUnexpandedNotAllowed() {
        return this.unexpandedNotAllowed;
    }

    Pattern makeError() {
        ErrorPattern p = new ErrorPattern();
        return this.schemaInterner.intern(p);
    }

    @Override
    Pattern makeChoice(Pattern p1, Pattern p2) {
        if (p1 == this.notAllowed || p1 == p2) {
            return p2;
        }
        if (p2 == this.notAllowed) {
            return p1;
        }
        return super.makeChoice(p1, p2);
    }

    Pattern makeList(Pattern p, Locator loc) {
        if (p == this.notAllowed) {
            return p;
        }
        ListPattern p1 = new ListPattern(p, loc);
        return this.schemaInterner.intern(p1);
    }

    Pattern makeMixed(Pattern p) {
        return this.makeInterleave(this.text, p);
    }

    private void noteDatatype(Datatype dt) {
        if (dt.getIdType() != 0) {
            this.idTypes = true;
        }
    }
}

