/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.internal.jxc.apt;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.AnnotationProcessorFactory;
import com.sun.mirror.apt.Filer;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import com.sun.tools.internal.jxc.apt.ErrorReceiverImpl;
import com.sun.tools.internal.xjc.api.J2SJAXBModel;
import com.sun.tools.internal.xjc.api.Reference;
import com.sun.tools.internal.xjc.api.XJC;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.xml.bind.SchemaOutputResolver;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;

public class SchemaGenerator
implements AnnotationProcessorFactory {
    private final Map<String, File> schemaLocations = new HashMap<String, File>();
    private File episodeFile;

    public SchemaGenerator() {
    }

    public SchemaGenerator(Map<String, File> m3) {
        this.schemaLocations.putAll(m3);
    }

    public void setEpisodeFile(File episodeFile) {
        this.episodeFile = episodeFile;
    }

    @Override
    public Collection<String> supportedOptions() {
        return Collections.emptyList();
    }

    @Override
    public Collection<String> supportedAnnotationTypes() {
        return Arrays.asList("*");
    }

    @Override
    public AnnotationProcessor getProcessorFor(Set<AnnotationTypeDeclaration> atds, final AnnotationProcessorEnvironment env) {
        return new AnnotationProcessor(){
            final ErrorReceiverImpl errorListener;
            {
                this.errorListener = new ErrorReceiverImpl(env);
            }

            @Override
            public void process() {
                ArrayList<Reference> decls = new ArrayList<Reference>();
                for (TypeDeclaration d : env.getTypeDeclarations()) {
                    if (!(d instanceof ClassDeclaration)) continue;
                    decls.add(new Reference(d, env));
                }
                J2SJAXBModel model = XJC.createJavaCompiler().bind(decls, Collections.emptyMap(), null, env);
                if (model == null) {
                    return;
                }
                try {
                    model.generateSchema(new SchemaOutputResolver(){

                        public Result createOutput(String namespaceUri, String suggestedFileName) throws IOException {
                            OutputStream out;
                            File file;
                            if (SchemaGenerator.this.schemaLocations.containsKey(namespaceUri)) {
                                file = (File)SchemaGenerator.this.schemaLocations.get(namespaceUri);
                                if (file == null) {
                                    return null;
                                }
                                out = new FileOutputStream(file);
                            } else {
                                file = new File(suggestedFileName);
                                out = env.getFiler().createBinaryFile(Filer.Location.CLASS_TREE, "", file);
                                file = file.getAbsoluteFile();
                            }
                            StreamResult ss = new StreamResult(out);
                            env.getMessager().printNotice("Writing " + file);
                            ss.setSystemId(file.toURL().toExternalForm());
                            return ss;
                        }
                    }, this.errorListener);
                    if (SchemaGenerator.this.episodeFile != null) {
                        env.getMessager().printNotice("Writing " + SchemaGenerator.this.episodeFile);
                        model.generateEpisodeFile(new StreamResult(SchemaGenerator.this.episodeFile));
                    }
                }
                catch (IOException e) {
                    this.errorListener.error(e.getMessage(), e);
                }
            }
        };
    }
}

