/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.doclets.internal.toolkit.taglets;

import com.sun.javadoc.ClassDoc;
import com.sun.javadoc.ConstructorDoc;
import com.sun.javadoc.Doc;
import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.MethodDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.RootDoc;
import com.sun.javadoc.Tag;
import com.sun.tools.doclets.internal.toolkit.taglets.CodeTaglet;
import com.sun.tools.doclets.internal.toolkit.taglets.DocRootTaglet;
import com.sun.tools.doclets.internal.toolkit.taglets.ExpertTaglet;
import com.sun.tools.doclets.internal.toolkit.taglets.InheritDocTaglet;
import com.sun.tools.doclets.internal.toolkit.taglets.LegacyTaglet;
import com.sun.tools.doclets.internal.toolkit.taglets.LiteralTaglet;
import com.sun.tools.doclets.internal.toolkit.taglets.ParamTaglet;
import com.sun.tools.doclets.internal.toolkit.taglets.PropertyGetterTaglet;
import com.sun.tools.doclets.internal.toolkit.taglets.PropertySetterTaglet;
import com.sun.tools.doclets.internal.toolkit.taglets.ReturnTaglet;
import com.sun.tools.doclets.internal.toolkit.taglets.SeeTaglet;
import com.sun.tools.doclets.internal.toolkit.taglets.SimpleTaglet;
import com.sun.tools.doclets.internal.toolkit.taglets.Taglet;
import com.sun.tools.doclets.internal.toolkit.taglets.ThrowsTaglet;
import com.sun.tools.doclets.internal.toolkit.taglets.ValueTaglet;
import com.sun.tools.doclets.internal.toolkit.util.MessageRetriever;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;

public class TagletManager {
    public static final char SIMPLE_TAGLET_OPT_SEPERATOR = ':';
    public static final String ALT_SIMPLE_TAGLET_OPT_SEPERATOR = "-";
    private LinkedHashMap<String, Taglet> customTags;
    private Taglet[] packageTags;
    private Taglet[] typeTags;
    private Taglet[] fieldTags;
    private Taglet[] constructorTags;
    private Taglet[] methodTags;
    private Taglet[] overviewTags;
    private Taglet[] inlineTags;
    private Taglet[] serializedFormTags;
    private MessageRetriever message;
    private Set<String> standardTags;
    private Set<String> standardTagsLowercase;
    private Set<String> overridenStandardTags = new HashSet<String>();
    private Set<String> potentiallyConflictingTags = new HashSet<String>();
    private Set<String> unseenCustomTags;
    private boolean nosince;
    private boolean showversion;
    private boolean showauthor;

    public TagletManager(boolean bl, boolean bl2, boolean bl3, MessageRetriever messageRetriever) {
        this.standardTags = new HashSet<String>();
        this.standardTagsLowercase = new HashSet<String>();
        this.unseenCustomTags = new HashSet<String>();
        this.customTags = new LinkedHashMap();
        this.nosince = bl;
        this.showversion = bl2;
        this.showauthor = bl3;
        this.message = messageRetriever;
        this.initStandardTags();
        this.initStandardTagsLowercase();
    }

    public void addCustomTag(Taglet taglet) {
        if (taglet != null) {
            String string = taglet.getName();
            if (this.customTags.containsKey(string)) {
                this.customTags.remove(string);
            }
            this.customTags.put(string, taglet);
            this.checkTagName(string);
        }
    }

    public void addCustomTag(String string, String string2) {
        try {
            Object object;
            Class<?> clazz = null;
            String string3 = null;
            string3 = this.appendPath(System.getProperty("env.class.path"), string3);
            string3 = this.appendPath(System.getProperty("java.class.path"), string3);
            string3 = this.appendPath(string2, string3);
            URLClassLoader uRLClassLoader = new URLClassLoader(TagletManager.pathToURLs(string3));
            clazz = uRLClassLoader.loadClass(string);
            Method method = clazz.getMethod("register", Map.class);
            Object[] objectArray = this.customTags.values().toArray();
            Taglet taglet = objectArray != null && objectArray.length > 0 ? (Taglet)objectArray[objectArray.length - 1] : null;
            method.invoke(null, this.customTags);
            objectArray = this.customTags.values().toArray();
            Object object2 = object = objectArray != null && objectArray.length > 0 ? objectArray[objectArray.length - 1] : null;
            if (taglet != object) {
                this.message.notice("doclet.Notice_taglet_registered", string);
                if (object != null) {
                    this.checkTaglet(object);
                }
            }
        }
        catch (Exception exception) {
            this.message.error("doclet.Error_taglet_not_registered", exception.getClass().getName(), string);
        }
    }

    private String appendPath(String string, String string2) {
        if (string == null || string.length() == 0) {
            return string2 == null ? "." : string2;
        }
        if (string2 == null || string2.length() == 0) {
            return string;
        }
        return string + File.pathSeparator + string2;
    }

    private static URL[] pathToURLs(String string) {
        URL[] uRLArray;
        StringTokenizer stringTokenizer = new StringTokenizer(string, File.pathSeparator);
        URL[] uRLArray2 = new URL[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            uRLArray = TagletManager.fileToURL(new File(stringTokenizer.nextToken()));
            if (uRLArray == null) continue;
            uRLArray2[n++] = uRLArray;
        }
        if (uRLArray2.length != n) {
            uRLArray = new URL[n];
            System.arraycopy(uRLArray2, 0, uRLArray, 0, n);
            uRLArray2 = uRLArray;
        }
        return uRLArray2;
    }

    private static URL fileToURL(File file) {
        String string;
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            string = file.getAbsolutePath();
        }
        string = string.replace(File.separatorChar, '/');
        if (!string.startsWith("/")) {
            string = "/" + string;
        }
        if (!file.isFile()) {
            string = string + "/";
        }
        try {
            return new URL("file", "", string);
        }
        catch (MalformedURLException malformedURLException) {
            throw new IllegalArgumentException("file");
        }
    }

    public void addNewSimpleCustomTag(String string, String string2, String string3) {
        if (string == null || string3 == null) {
            return;
        }
        Taglet taglet = this.customTags.get(string);
        string3 = string3.toLowerCase();
        if (taglet == null || string2 != null) {
            this.customTags.remove(string);
            this.customTags.put(string, new SimpleTaglet(string, string2, string3));
            if (string3 != null && string3.indexOf(120) == -1) {
                this.checkTagName(string);
            }
        } else {
            this.customTags.remove(string);
            this.customTags.put(string, taglet);
        }
    }

    private void checkTagName(String string) {
        if (this.standardTags.contains(string)) {
            this.overridenStandardTags.add(string);
        } else {
            if (string.indexOf(46) == -1) {
                this.potentiallyConflictingTags.add(string);
            }
            this.unseenCustomTags.add(string);
        }
    }

    private void checkTaglet(Object object) {
        if (object instanceof Taglet) {
            this.checkTagName(((Taglet)object).getName());
        } else if (object instanceof com.sun.tools.doclets.Taglet) {
            com.sun.tools.doclets.Taglet taglet = (com.sun.tools.doclets.Taglet)object;
            this.customTags.remove(taglet.getName());
            this.customTags.put(taglet.getName(), new LegacyTaglet(taglet));
            this.checkTagName(taglet.getName());
        } else {
            throw new IllegalArgumentException("Given object is not a taglet.");
        }
    }

    public void seenCustomTag(String string) {
        this.unseenCustomTags.remove(string);
    }

    public void checkTags(Doc doc, Tag[] tagArray, boolean bl) {
        if (tagArray == null) {
            return;
        }
        for (int i = 0; i < tagArray.length; ++i) {
            String string = tagArray[i].name();
            if (string.length() > 0 && string.charAt(0) == '@') {
                string = string.substring(1, string.length());
            }
            if (!this.standardTags.contains(string) && !this.customTags.containsKey(string)) {
                if (this.standardTagsLowercase.contains(string.toLowerCase())) {
                    this.message.warning(tagArray[i].position(), "doclet.UnknownTagLowercase", tagArray[i].name());
                    continue;
                }
                this.message.warning(tagArray[i].position(), "doclet.UnknownTag", tagArray[i].name());
                continue;
            }
            Taglet taglet = this.customTags.get(string);
            if (taglet == null) continue;
            if (bl && !taglet.isInlineTag()) {
                this.printTagMisuseWarn(taglet, tagArray[i], "inline");
            }
            if (doc instanceof RootDoc && !taglet.inOverview()) {
                this.printTagMisuseWarn(taglet, tagArray[i], "overview");
                continue;
            }
            if (doc instanceof PackageDoc && !taglet.inPackage()) {
                this.printTagMisuseWarn(taglet, tagArray[i], "package");
                continue;
            }
            if (doc instanceof ClassDoc && !taglet.inType()) {
                this.printTagMisuseWarn(taglet, tagArray[i], "class");
                continue;
            }
            if (doc instanceof ConstructorDoc && !taglet.inConstructor()) {
                this.printTagMisuseWarn(taglet, tagArray[i], "constructor");
                continue;
            }
            if (doc instanceof FieldDoc && !taglet.inField()) {
                this.printTagMisuseWarn(taglet, tagArray[i], "field");
                continue;
            }
            if (!(doc instanceof MethodDoc) || taglet.inMethod()) continue;
            this.printTagMisuseWarn(taglet, tagArray[i], "method");
        }
    }

    private void printTagMisuseWarn(Taglet taglet, Tag tag, String string) {
        String[] stringArray;
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        if (taglet.inOverview()) {
            linkedHashSet.add("overview");
        }
        if (taglet.inPackage()) {
            linkedHashSet.add("package");
        }
        if (taglet.inType()) {
            linkedHashSet.add("class/interface");
        }
        if (taglet.inConstructor()) {
            linkedHashSet.add("constructor");
        }
        if (taglet.inField()) {
            linkedHashSet.add("field");
        }
        if (taglet.inMethod()) {
            linkedHashSet.add("method");
        }
        if (taglet.isInlineTag()) {
            linkedHashSet.add("inline text");
        }
        if ((stringArray = linkedHashSet.toArray(new String[0])) == null || stringArray.length == 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            if (i > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(stringArray[i]);
        }
        this.message.warning(tag.position(), "doclet.tag_misuse", "@" + taglet.getName(), string, stringBuffer.toString());
    }

    public Taglet[] getPackageCustomTags() {
        if (this.packageTags == null) {
            this.initCustomTagArrays();
        }
        return this.packageTags;
    }

    public Taglet[] getTypeCustomTags() {
        if (this.typeTags == null) {
            this.initCustomTagArrays();
        }
        return this.typeTags;
    }

    public Taglet[] getInlineCustomTags() {
        if (this.inlineTags == null) {
            this.initCustomTagArrays();
        }
        return this.inlineTags;
    }

    public Taglet[] getFieldCustomTags() {
        if (this.fieldTags == null) {
            this.initCustomTagArrays();
        }
        return this.fieldTags;
    }

    public Taglet[] getSerializedFormTags() {
        if (this.serializedFormTags == null) {
            this.initCustomTagArrays();
        }
        return this.serializedFormTags;
    }

    public Taglet[] getCustomTags(Doc doc) {
        if (doc instanceof ConstructorDoc) {
            return this.getConstructorCustomTags();
        }
        if (doc instanceof MethodDoc) {
            return this.getMethodCustomTags();
        }
        if (doc instanceof FieldDoc) {
            return this.getFieldCustomTags();
        }
        if (doc instanceof ClassDoc) {
            return this.getTypeCustomTags();
        }
        if (doc instanceof PackageDoc) {
            return this.getPackageCustomTags();
        }
        if (doc instanceof RootDoc) {
            return this.getOverviewCustomTags();
        }
        return null;
    }

    public Taglet[] getConstructorCustomTags() {
        if (this.constructorTags == null) {
            this.initCustomTagArrays();
        }
        return this.constructorTags;
    }

    public Taglet[] getMethodCustomTags() {
        if (this.methodTags == null) {
            this.initCustomTagArrays();
        }
        return this.methodTags;
    }

    public Taglet[] getOverviewCustomTags() {
        if (this.overviewTags == null) {
            this.initCustomTagArrays();
        }
        return this.overviewTags;
    }

    private void initCustomTagArrays() {
        Iterator<Taglet> iterator = this.customTags.values().iterator();
        ArrayList<Taglet> arrayList = new ArrayList<Taglet>(this.customTags.size());
        ArrayList<Taglet> arrayList2 = new ArrayList<Taglet>(this.customTags.size());
        ArrayList<Taglet> arrayList3 = new ArrayList<Taglet>(this.customTags.size());
        ArrayList<Taglet> arrayList4 = new ArrayList<Taglet>(this.customTags.size());
        ArrayList<Taglet> arrayList5 = new ArrayList<Taglet>(this.customTags.size());
        ArrayList<Taglet> arrayList6 = new ArrayList<Taglet>(this.customTags.size());
        ArrayList<Taglet> arrayList7 = new ArrayList<Taglet>(this.customTags.size());
        ArrayList<Taglet> arrayList8 = new ArrayList<Taglet>();
        while (iterator.hasNext()) {
            Taglet taglet = iterator.next();
            if (taglet.inPackage() && !taglet.isInlineTag()) {
                arrayList.add(taglet);
            }
            if (taglet.inType() && !taglet.isInlineTag()) {
                arrayList2.add(taglet);
            }
            if (taglet.inField() && !taglet.isInlineTag()) {
                arrayList3.add(taglet);
            }
            if (taglet.inConstructor() && !taglet.isInlineTag()) {
                arrayList4.add(taglet);
            }
            if (taglet.inMethod() && !taglet.isInlineTag()) {
                arrayList5.add(taglet);
            }
            if (taglet.isInlineTag()) {
                arrayList6.add(taglet);
            }
            if (!taglet.inOverview() || taglet.isInlineTag()) continue;
            arrayList7.add(taglet);
        }
        this.packageTags = arrayList.toArray(new Taglet[0]);
        this.typeTags = arrayList2.toArray(new Taglet[0]);
        this.fieldTags = arrayList3.toArray(new Taglet[0]);
        this.constructorTags = arrayList4.toArray(new Taglet[0]);
        this.methodTags = arrayList5.toArray(new Taglet[0]);
        this.overviewTags = arrayList7.toArray(new Taglet[0]);
        this.inlineTags = arrayList6.toArray(new Taglet[0]);
        arrayList8.add(this.customTags.get("serialData"));
        arrayList8.add(this.customTags.get("throws"));
        if (!this.nosince) {
            arrayList8.add(this.customTags.get("since"));
        }
        arrayList8.add(this.customTags.get("see"));
        this.serializedFormTags = arrayList8.toArray(new Taglet[0]);
    }

    private void initStandardTags() {
        Taglet taglet = new ParamTaglet();
        this.customTags.put(taglet.getName(), taglet);
        taglet = new ReturnTaglet();
        this.customTags.put(taglet.getName(), taglet);
        taglet = new ThrowsTaglet();
        this.customTags.put(taglet.getName(), taglet);
        taglet = new SimpleTaglet("exception", null, "mc");
        this.customTags.put(taglet.getName(), taglet);
        if (!this.nosince) {
            taglet = new SimpleTaglet("since", this.message.getText("doclet.Since", new Object[0]), "a");
            this.customTags.put(taglet.getName(), taglet);
        }
        if (this.showversion) {
            taglet = new SimpleTaglet("version", this.message.getText("doclet.Version", new Object[0]), "pto");
            this.customTags.put(taglet.getName(), taglet);
        }
        if (this.showauthor) {
            taglet = new SimpleTaglet("author", this.message.getText("doclet.Author", new Object[0]), "pto");
            this.customTags.put(taglet.getName(), taglet);
        }
        taglet = new PropertyGetterTaglet();
        this.customTags.put(taglet.getName(), taglet);
        taglet = new PropertySetterTaglet();
        this.customTags.put(taglet.getName(), taglet);
        taglet = new SimpleTaglet("propertyDescription", this.message.getText("doclet.PropertyDescription", new Object[0]), "fm");
        this.customTags.put(taglet.getName(), taglet);
        taglet = new SimpleTaglet("defaultValue", this.message.getText("doclet.DefaultValue", new Object[0]), "fm");
        this.customTags.put(taglet.getName(), taglet);
        taglet = new SimpleTaglet("serialData", this.message.getText("doclet.SerialData", new Object[0]), "x");
        this.customTags.put(taglet.getName(), taglet);
        taglet = new SimpleTaglet("factory", this.message.getText("doclet.Factory", new Object[0]), "m");
        this.customTags.put(taglet.getName(), taglet);
        taglet = new SeeTaglet();
        this.customTags.put(taglet.getName(), taglet);
        taglet = new DocRootTaglet();
        this.customTags.put(taglet.getName(), taglet);
        taglet = new InheritDocTaglet();
        this.customTags.put(taglet.getName(), taglet);
        taglet = new ValueTaglet();
        this.customTags.put(taglet.getName(), taglet);
        taglet = new LegacyTaglet(new LiteralTaglet());
        this.customTags.put(taglet.getName(), taglet);
        taglet = new LegacyTaglet(new CodeTaglet());
        this.customTags.put(taglet.getName(), taglet);
        taglet = new SimpleTaglet("treatAsPrivate", null, "fmt");
        this.customTags.put(taglet.getName(), taglet);
        taglet = new LegacyTaglet(new ExpertTaglet());
        this.customTags.put(taglet.getName(), taglet);
        this.standardTags.add("param");
        this.standardTags.add("return");
        this.standardTags.add("throws");
        this.standardTags.add("exception");
        this.standardTags.add("since");
        this.standardTags.add("version");
        this.standardTags.add("author");
        this.standardTags.add("propertyGetter");
        this.standardTags.add("propertySetter");
        this.standardTags.add("propertyDescription");
        this.standardTags.add("defaultValue");
        this.standardTags.add("see");
        this.standardTags.add("deprecated");
        this.standardTags.add("link");
        this.standardTags.add("linkplain");
        this.standardTags.add("inheritDoc");
        this.standardTags.add("docRoot");
        this.standardTags.add("value");
        this.standardTags.add("serial");
        this.standardTags.add("serialData");
        this.standardTags.add("serialField");
        this.standardTags.add("Text");
        this.standardTags.add("literal");
        this.standardTags.add("code");
        this.standardTags.add("treatAsPrivate");
        this.standardTags.add("expert");
    }

    private void initStandardTagsLowercase() {
        Iterator<String> iterator = this.standardTags.iterator();
        while (iterator.hasNext()) {
            this.standardTagsLowercase.add(iterator.next().toLowerCase());
        }
    }

    public boolean isKnownCustomTag(String string) {
        return this.customTags.containsKey(string);
    }

    public void printReport() {
        this.printReportHelper("doclet.Notice_taglet_conflict_warn", this.potentiallyConflictingTags);
        this.printReportHelper("doclet.Notice_taglet_overriden", this.overridenStandardTags);
        this.printReportHelper("doclet.Notice_taglet_unseen", this.unseenCustomTags);
    }

    private void printReportHelper(String string, Set<String> set) {
        if (set.size() > 0) {
            String[] stringArray = set.toArray(new String[0]);
            String string2 = " ";
            for (int i = 0; i < stringArray.length; ++i) {
                string2 = string2 + "@" + stringArray[i];
                if (i + 1 >= stringArray.length) continue;
                string2 = string2 + ", ";
            }
            this.message.notice(string, string2);
        }
    }

    public Taglet getTaglet(String string) {
        if (string.indexOf("@") == 0) {
            return this.customTags.get(string.substring(1));
        }
        return this.customTags.get(string);
    }
}

